#include <stdio.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include "draw.h"
#include "fonts.h"

extern graphics_data *data;
extern Sc dbase;
extern getcoor(),coor();
extern int showing;
int origin_x, origin_y;

#define NEWLINE(i) (i % 8) ? putc('\t',stderr) : putc('\n',stderr);

  
void
load_font(font)
char *font;

 {

  if ( data->font) XFreeFont(XtDisplay(data->w),data->font);

  if (  (data->font = XLoadQueryFont(XtDisplay(data->w),font)) == NULL)
    {
        int i;
	fprintf(stderr,"Cann't open %s font\n", font);
	fprintf(stderr,"Font names that are aviable: \n");
	for(i = 0; fontsnames[i] != NULL; ) {
		fprintf(stderr,"%s ",fontsnames[i]);
		i++;
		NEWLINE(i);
	}
	putc('\n',stderr);
	exit(0);
    }

 }

void
set_font()

 {
    XSetFont(XtDisplay(data->w),data->gc, (data->font)->fid);
    XSetFont(XtDisplay(data->w),data->xorgc, (data->font)->fid);

  }


init_data(w, font)
Widget w;
char *font;

 {
   int i;
   XGCValues values;
   Arg warg[5];

   data->key = -1;
   data->index = NULL;
   data->font = NULL;
   if ( font == NULL ) {
        data->fontname = NULL;
        load_font(FONT1);
   }
   else {
        data->fontname = (char *) malloc(strlen(font)+1);
        if ( data->fontname == NULL ) {
	  fprintf(stderr,"Cann't malloc font name\n");
	  exit(0);
        }
	strcpy(data->fontname,font);
        load_font(font);
   }

   XtSetArg(warg[0],XtNforeground,&data->foreground);
   XtSetArg(warg[1],XtNbackground,&data->background);
   XtGetValues(w,warg,2);

   values.foreground = data->foreground;
   values.background = data->background;
   values.function = GXxor;

   data->gc = XtGetGC(w, GCFunction | GCForeground | GCBackground, &values);

   values.foreground = data->background ^ data->foreground;
   values.function = GXxor;
   values.line_style = LineOnOffDash;

   data->xorgc = XtGetGC(w, GCFunction | GCForeground | GCBackground | GCLineStyle, &values);


   set_font(w);
}


start_rubber_band(w,client_data,event)
Widget w;
void *client_data;
XEvent *event;

 {
   nodeptr p;
  int i,go,k,x1,y1,x2,y2;
  nodeptr  q;
  llist   *t;
   
   if ( event->xbutton.button == Button3 )
        data->key = SEE_ATTR;

   if ( data->key == EDGE) 
    {
      data->loc.x2 = data->loc.x1 = event->xbutton.x;
      data->loc.y2 = data->loc.y1 = event->xbutton.y;
      draw_edge(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                              data->loc.x2,data->loc.y2);
    }
   else if ( data->key == NODE )
    {
      TEPtr q = data->entry =  ScLookup(dbase,data->value);
     
      if ( q == NULL )
        {
           data->key = -1;
           return;
        } 
      data->entry = q;  
      data->width = ((q->pnum-1) * HALF_WIDTH) + NODE_W;
      data->loc.x1 = event->xbutton.x;
      data->loc.y1 = event->xbutton.y;
      draw_node(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                data->width);
  
     }
    else if (data->key == MOVE )
     {
       p = gpDeleteNode(data->g,event->xbutton.x,event->xbutton.y);
                           
      if ( p != NULL ) {
         origin_x = p->name.x; origin_y = p->name.y;
         data->width = p->name.width;
         data->value = p->ports[0].name;
         draw_node(data->w,data->gc,p->name.x,p->name.y,
                   p->name.width);
         draw_node(data->w,data->xorgc,p->name.x,p->name.y,
                   p->name.width);
         draw_ports(data->w,data->gc,p,0,0,1);
         draw_ports(data->w,data->xorgc,p,0,0,1);

         for(i=0; i <= p->pnum; i++ )
           {
             go = 1;
             for(t=p->ports[i].other; t != NULL && go; t = t->next)
              {
                 q = t->key;    k = t->i;
                 x1 = p->name.x + p->ports[i].x + EDGE_X_OFF;
                 y1 = p->name.y + p->ports[i].y + EDGE_Y_OFF;
                 x2 = q->name.x + q->ports[k].x + EDGE_X_OFF;
                 y2 = q->name.y + q->ports[k].y + EDGE_Y_OFF;

                 draw_edge(data->w,data->gc,x1,y1,x2,y2);
                 draw_edge(data->w,data->xorgc,x1,y1,x2,y2);
                 if ( t->next == p->ports[i].other )
                      go = 0;
              }
          }  
         data->loc.x1 = p->name.x;
         data->loc.y1 = p->name.y;
         data->loc.x2 = event->xbutton.x;
         data->loc.y2 = event->xbutton.y;
       }/* end if */
      data->index = p;
      } /* end else */

 } /* end start */

 track_rubber_band(w,client_data,event)
Widget w;
void *client_data;
XEvent *event;   

 {

   if ( data->key == EDGE ) {
    draw_edge(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                             data->loc.x2,data->loc.y2);


     draw_edge(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                             event->xbutton.x,event->xbutton.y);
     
     data->loc.x2 = event->xbutton.x;
     data->loc.y2 = event->xbutton.y;
     
     }
    else if (data->key == NODE  ) {

       draw_node(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                 data->width);

       draw_node(data->w,data->xorgc,event->xbutton.x,event->xbutton.y,
                 data->width);
      
       data->loc.x1 = event->xbutton.x;
       data->loc.y1 = event->xbutton.y;

      }
    else if (data->key == MOVE )
     { 
     int x = event->xbutton.x-data->loc.x2;
     int y = event->xbutton.y-data->loc.y2;
     nodeptr p = data->index;

     if ( p != NULL ) {
        int i,k,go,x1,y1,x2,y2;
        nodeptr  q;
        llist   *t;

        draw_node(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                   p->name.width);
        draw_node(data->w,data->xorgc,data->loc.x1+x,data->loc.y1+y,
                   p->name.width);
        draw_ports(data->w,data->xorgc,p,0,0,1);
        draw_ports(data->w,data->xorgc,p,x,y,1);

        for(i=0; i <= p->pnum; i++ )
         {
             go = 1;
             for(t=p->ports[i].other; t != NULL && go; t = t->next)
              {
                 q = t->key;    k = t->i;
                 x1 = p->name.x + p->ports[i].x + EDGE_X_OFF;
                 y1 = p->name.y + p->ports[i].y + EDGE_Y_OFF;
                 x2 = q->name.x + q->ports[k].x + EDGE_X_OFF;
                 y2 = q->name.y + q->ports[k].y + EDGE_Y_OFF;

                 draw_edge(data->w,data->xorgc,x1,y1,x2,y2);
                 x1 += x; y1+= y;
                 draw_edge(data->w,data->xorgc,x1,y1,x2,y2);
                 if ( t->next == p->ports[i].other )
                      go = 0;
              }
          }  
       
        p->name.x += x;
        p->name.y += y;        
        data->loc.x1 += x;
        data->loc.y1 += y;
        data->loc.x2 = event->xbutton.x;
        data->loc.y2 = event->xbutton.y;

     } /* end if */
    }
      /* end else */

 } /* end track */

 end_rubber_band(w,client_data,event)
Widget w;
void *client_data;
XEvent *event;

 {
     nodeptr p; edgetype res;
     int x;
     int y;

      x = event->xbutton.x;
      y = event->xbutton.y;
   if (data->key == EDGE ) {
     draw_edge(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                             data->loc.x2,data->loc.y2);

     res = gpAddEdge(data->g,data->loc.x1,data->loc.y1,x,y);

     if ( res.x1 == 0 && res.y1 == 0 && res.y2 == 0 && res.x2 == 0 )
                          ;
     else
         draw_edge(data->w,data->gc,res.x1,res.y1, res.x2,res.y2);
    }
   else if (data->key == NODE ) {
     
     draw_node(data->w,data->xorgc,data->loc.x1,data->loc.y1,
               data->width);

     if ((p = gpDefineNode(data->g,x,y,data->value,data->width)) != NULL )
      {
        draw_node(data->w,data->gc,x,y,data->width);
        draw_ports(data->w,data->gc,p,0,0,1);
      }

   }
   else if ( data->key == MOVE ) 
     { 
     int x1 = x-data->loc.x2;
     int y1 = y-data->loc.y2;

     p = data->index;
     data->index = NULL;
     if ( p != NULL ) {
        int i,k,go,x2,y2,x3,y3;
        nodeptr  q;
        llist   *t;

        q = findnode(data->g,data->loc.x1+x1,data->loc.y1+y1,data->width,NODE_H);
        if ( q != NULL )
           {
             x1 =  origin_x - data->loc.x1;
             y1 =  origin_y - data->loc.y1;
           }

        draw_node(data->w,data->xorgc,data->loc.x1,data->loc.y1,
                  p->name.width);
        draw_node(data->w,data->gc,data->loc.x1+x1,data->loc.y1+y1,
                 p->name.width);
        draw_ports(data->w,data->xorgc,p,0,0,1);
        draw_ports(data->w,data->gc,p,x1,y1,1);

        for(i=0; i <= p->pnum; i++ )
         {
             go = 1;
             for(t=p->ports[i].other; t != NULL && go; t = t->next)
              {
                 q = t->key;    k = t->i;
                 x2 = p->name.x + p->ports[i].x + EDGE_X_OFF;
                 y2 = p->name.y + p->ports[i].y + EDGE_Y_OFF;
                 x3 = q->name.x + q->ports[k].x + EDGE_X_OFF;
                 y3 = q->name.y + q->ports[k].y + EDGE_Y_OFF;

                 draw_edge(data->w,data->xorgc,x2,y2,x3,y3);
                 x2 += x1; y2+= y1;
                 draw_edge(data->w,data->gc,x2,y2,x3,y3);
                 if ( t->next == p->ports[i].other )
                      go = 0;
              }
          }  

       p->name.x = data->loc.x1+x1;
       p->name.y = data->loc.y1+y1;   
         
       insert(data->g,p);
       } 
     }
   else if (data->key == D_NODE )
      {
         p = gpDeleteNode(data->g,x,y);
      
         if ( p != NULL ) {
           draw_node(data->w,data->gc,p->name.x,p->name.y,
                     p->name.width);
           draw_ports(data->w,data->gc,p,0,0,0);
           
           gpFreeNode(data->g,p);
          }
       }
    else if ( data->key == D_EDGE )
       {
         res = gpDeleteEdge(data->g,x,y);
     
         if ( res.x1 == 0 && res.y1 == 0 && res.x2 == 0 && res.y2 == 0 )
                  ;
         else
             draw_edge(data->w,data->gc,res.x1,res.y1,res.x2,res.y2);
        }
    else if ( data->key == SEE_ATTR )
     {
         p = Dfindnode(data->g,x,y);

        if ( p != NULL ) {
             te   *x;
             Position i,j;
      
             getcoor(data->w,&i,&j); 
             data->index = p;
             x = ScLookup(dbase,p->type);
             data->entry = x;
             PopupPrompt(data->w,i ,j,x);
        }
     }
 }


replace_node(temp,x)
nodeptr temp;
TEPtr   x;

 {

       nodeptr p;
      
       for(p=(data->g)->root; p != NULL; p = p->right )
         {
           if ( strcmp(p->type,temp->type) == 0 )
            {
              draw_node(data->w,data->gc,p->name.x,p->name.y,
                    p->name.width);

              draw_ports(data->w,data->gc,p,0,0,0);
              strcpy(p->ports[0].name,x->name);
              p->pnum = x->pnum;
              getports(x->ports,p);
              p->name.width = data->width;
              findcoor(p,data->width);
    
              draw_node(data->w,data->gc,p->name.x,p->name.y,
                   data->width);
             draw_ports(data->w,data->gc,p,0,0,1);
            }
           if ( p->right == (data->g)->root)
                return;
          }
  }


draw_edge(w,gc,x,y,x2,y2)
Widget w;
GC gc;
int x,y,x2,y2;
 
 {
   Display *dpy = XtDisplay(w);
   Window win = XtWindow(w);
   XDrawLine(dpy,win,gc,x,y,x2,y2);
 }

check_points(x,y,x2,y2)
int *x, *y, *x2, *y2;

 {
  int tmp;

  if (*x2 < *x) { tmp = *x; *x = *x2; *x2 = tmp; }
  if (*y2 < *y) {  tmp = *y; *y = *y2; *y2 = tmp; }
 }

draw_node(w,gc,x,y,width)
Widget w;
GC gc;
int x,y;
int width;
 {
  Display *dpy = XtDisplay(w);
  Window win = XtWindow(w);

  XDrawRectangle(dpy,win,gc,x,y,width,NODE_H);
}
recompute(g)
Graph g;

  {
    nodeptr p;
    llist *q;

    for(p = g->root; p != NULL; p = p->right)
     {
        p->name.width = ((p->pnum-1) * HALF_WIDTH) + NODE_W;
        p->name.height = NODE_H;
        coor(p,p->name.width);
      
        if ( p->right == g->root )
             return;
      }
  }
    
replace_name(p,name)
nodeptr p;
char *name;

  {           
    Display *dpy = XtDisplay(data->w);
    Window win = XtWindow(data->w);
    GC gc = data->gc;


   XDrawString(dpy,win,gc,p->name.x,p->name.y+NSTR_OFF,p->ports[0].name,
              strlen(p->ports[0].name));
   strcpy(p->ports[0].name,name);            
   XDrawString(dpy,win,gc,p->name.x,p->name.y+NSTR_OFF,p->ports[0].name,
              strlen(p->ports[0].name));
   }


draw_ports(w,gc,p,x,y,mode)
Widget w;
GC gc;
nodeptr p;
int x,y,mode;

 {
    Display *dpy = XtDisplay(w);
    Window win = XtWindow(w);
    XRectangle rect[MAXPORTS];
    edgetype res;
    nodeptr q;
    int i,j;
    llist *a, *b;

    for(i=0; i <= p->pnum; i++)
      {
       rect[i].x = (short) p->name.x + x + p->ports[i].x;
       rect[i].y = (short) p->name.y + y + p->ports[i].y;
       rect[i].width = EDGE_W;
       rect[i].height = EDGE_H;
     }

   XDrawRectangles(dpy,win,gc,rect,i);
   XDrawString(dpy,win,gc,p->name.x+x,p->name.y+y+NSTR_OFF,p->ports[0].name,
              strlen(p->ports[0].name));
   for(i=0; i <= p->pnum; i++)
     XFillRectangle(dpy,win,gc,rect[i].x,rect[i].y,EDGE_W,EDGE_H);
      
   for(i=1; i <= p->pnum; i++)
      XDrawString(dpy,win,gc,rect[i].x,rect[i].y+ESTR_OFF,p->ports[i].name,
                  strlen(p->ports[i].name));

   if ( mode == 1 ) 
        return;

   for(i=0; i <= p->pnum; i++ )
     while ( p->ports[i].other != NULL )
      {
        a = port_remove(&(p->ports[i].other));
        j = a->i;     q = a->key;

        res.x1 = q->ports[j].x + q->name.x + EDGE_X_OFF;
        res.y1 = q->ports[j].y + q->name.y + EDGE_Y_OFF;
        res.x2 = p->ports[i].x + p->name.x + EDGE_X_OFF;
        res.y2 = p->ports[i].y + p->name.y + EDGE_X_OFF;

        free( ( char *) a);
        b = keyremove(&(q->ports[j].other),p);
        free( ( char *) b);
        XDrawLine(dpy,win,gc,res.x1,res.y1,res.x2,res.y2);
      }
  }


       
refresh(g)
Graph g;
 {

    nodeptr p;

    for (p = (g ? g->root : NULL); p != NULL; p = p->right ) 
     {
       if ( p->right == g->root )
        {  
            fresh(p);
            return;
         }
       else
           fresh(p);
      }
  }

fresh(p)
nodeptr p;
 {
 
     llist  *q, *a;
     int     i,j,go;
     int     x1,y1,x2,y2;
     nodeptr temp;


    draw_node(data->w,data->gc,p->name.x,p->name.y,p->name.width);
    draw_ports(data->w,data->gc,p,0,0,1);

    for ( i=0; i <= p->pnum; i++ )
     {
       go = 1;
       for(q = p->ports[i].other; q != NULL && go; q = q->next)
        {
         if(q->drow == 0 ) 
           {
              j = q->i;
              temp = q->key;
              a = port_find(&temp->ports[j].other,p);
              if ( a != NULL ) 
                   a->drow = 1;
              else
                   return;
              x1 = temp->ports[j].x + temp->name.x + EDGE_X_OFF;
              y1 = temp->ports[j].y + temp->name.y + EDGE_Y_OFF;
              x2 = p->ports[i].x + p->name.x + EDGE_X_OFF;
              y2 = p->ports[i].y + p->name.y + EDGE_Y_OFF;
              draw_edge(data->w,data->gc,x1,y1,x2,y2);
           }
          else
               q->drow = 0;
         
          if ( q->next == p->ports[i].other )
               go = 0;
         }
       }

 }
    
