/* 
 * compose.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#define assert(B) if (!(B)) {printf("assert: B"); exit(1);}
#define MAX_FILES 20
#define MAX_PROTOCOL 20
#define MAX_SIZE 25
#define BUF_SIZE 80
typedef struct protocol {
  int id;
  int instance;
  char *name;
  char *getproc;
  char *path;
  int numfiles;
  char *files[MAX_FILES + 1];
  int numdown;
  char *down[MAX_PROTOCOL + 1];
}        PROTOCOL;

static PROTOCOL p[200];
static num_prot;
static last_driver;
FILE *m_file;
FILE *h_file;
FILE *c_file;
#define strsame(A,B) (!(strcmp((A),(B))))

char *PNAME();
char *GETPROC();
char *PROTOCOLNAME();
int ID();
char *FILENAME();
char *xerox();
char *join();
char *make_define();

int cur;
int done = 0;
int debug = 0;
int nerrors = 0;
int line = 0;


main()
{
  parse();
  gen();
  exit(0);
}

gen()
{
  unlink("protocols.sed");
  unlink("protocols.h");
  unlink("protocols.c");
  m_file = fopen("protocols.sed", "w");
  if (m_file == NULL) {
    fprintf(stderr, "Can't open required file \"protocols.sed\"\n");
  }
  h_file = fopen("protocols.h", "w");
  if (h_file == NULL) {
    fprintf(stderr, "Can't open required file \"protocols.h\"\n");
  }
  c_file = fopen("protocols.c", "w");
  if (c_file == NULL) {
    fprintf(stderr, "Can't open required file \"protocols.c\"\n");
  }
  if (m_file == NULL || h_file == NULL || c_file == NULL) {
    exit (1);
  }

  gen_sed(m_file);
  fclose(m_file);
  gen_defs(h_file);
  fclose(h_file);
  gen_code(c_file);
  fclose(c_file);


}

char *suffix(s)
char *s;
{
  return strsame(&s[strlen(s) - 2], "_s") ? "S" : "c";
}

char *paths[] = {
  "./",
  "./?/",
  "../protocols/",
  "../protocols/?/",
  "../drivers/*/",
  0
};

#include <sys/types.h>
#ifdef sun
#include <dirent.h>
#define DIRENT dirent
#else
#include <sys/dir.h>
#define DIRENT direct
#endif
#include <sys/stat.h>

isnotarealfile(s)
char *s;
{
  struct stat buf;
  if (lstat(s, &buf) < 0) return 1;
  return (buf.st_mode & S_IFLNK) == S_IFLNK;
}

char *strsave(s)
char *s;
{
  char *t, *malloc();
  t = malloc(strlen(s)+1);
  strcpy(t, s);
  return t;
}

char *findpath(protocol, s)
char *protocol, *s;
{
  char *t, *where;
  DIR *directory;
  struct DIRENT *dd, *readdir();
  char buffer[128], dir[128], *index();
  int i;
  for (i = 0; (t = paths[i]); i++) {
    if (where = index(t, '*')) {
      *where = '\0';
      directory = opendir(t);
      while ((dd = readdir(directory)) != NULL) {
	sprintf(dir, "%s%s/", t, dd->d_name);
	sprintf(buffer, "%s%s.%s", dir, s, suffix(s));
	if (access(buffer, 4) == 0) {
	  *where = '*';
	  closedir(directory);
	  return strsave(dir);
	}
      }
      *where = '*';
      closedir(directory);
    } else if (where = index(t, '?')) {
      *where = '\0';
      sprintf(dir, "%s%s/", t, protocol);
      sprintf(buffer, "%s%s.%s", dir, s, suffix(s));
      if (access(buffer, 4) == 0) {
	*where = '?';
	return strsave(dir);
      }
      *where = '?';
    } else {
      sprintf(buffer, "%s%s.%s", t, s, suffix(s));
      if (access(buffer, 4) == 0) {
	return strsave(t);
      }
    }
  }
  fprintf(stderr, "compose: Can't find %s.%s\n", s, suffix(s));
  nerrors++;
}

gen_sed(fptr)
    FILE *fptr;
{
  char *ptr;
  int i, j;


  for (i = 0; i < num_prot; i++) {
    p[i].path = findpath(p[i].name, p[i].numfiles ? p[i].files[0] : p[i].name);
  }
  if (nerrors) exit(1);
  for (i = 0; i < num_prot; i++) {
    for (j = 0; j < p[i].numdown; j++) {
      int di = find_index(p[i].down[j]);
      if (di == -1) {
	fprintf(stderr,
	  "compose: Undefined Protl \"%s\" referenced by \"%s\"\n",
	  p[i].down[j],
	  p[i].name);
	nerrors++;
      }
    }
  }
  if (nerrors) exit(1);

  fprintf(fptr, "/^PROTOCOL/s/^.*$/PROTOCOLS = ");
  for (i = 0; i < num_prot; i++) {
    fprintf(fptr, "%s", p[i].name);
#if 0
    if (p[i].numfiles) {
      fprintf(fptr, "=");
      fprintf(fptr, "%s", p[i].files[0]);
      for (j = 1; j < p[i].numfiles; j++) {
	fprintf(fptr, ",");
	fprintf(fptr, "%s", p[i].files[j]);
      }
      fprintf(fptr, " ");
    } else {
      fprintf(fptr, " ");
    }
#else
    fprintf(fptr, " ");
#endif
    if (i + 1 == last_driver)
      fprintf(fptr, "@ ");
  }
  fprintf(fptr, "/\n");
  fprintf(fptr, "/^# PCDEFINITIONS BEGIN HERE/,/^# PCDEFINITIONS END HERE/c\\\n");
  fprintf(fptr, "# PCDEFINITIONS BEGIN HERE\\\n");
  fprintf(fptr, "# Don't edit these lines, compose uses them\\\n");
  fprintf(fptr, "PCDOTOS = ");
  for (i = 0; i < num_prot; i++) {
    if (p[i].instance != 0) continue;
    if (p[i].numfiles) {
      for (j = 0; j < p[i].numfiles; j++) {
	fprintf(fptr, "%s${HOW}/%s.o \\\\\\\n", p[i].path, p[i].files[j]);
      }
    } else {
      fprintf(fptr, "%s${HOW}/%s.o \\\\\\\n", p[i].path, p[i].name);
    }
  }
  fprintf(fptr, "\\\n");
  fprintf(fptr, "PCDOTHS = ");
  for (i = 0; i < num_prot; i++) {
    if (p[i].instance != 0) continue;
    fprintf(fptr, "%s.h ", p[i].name);
  }
  fprintf(fptr, "\\\n");
  fprintf(fptr, "PCDOTCS = ");
  for (i = 0; i < num_prot; i++) {
    if (p[i].instance != 0) continue;
    if (p[i].numfiles) {
      for (j = 0; j < p[i].numfiles; j++) {
	if (suffix(p[i].files[j])[0] == 'c') {
	  fprintf(fptr, "%s%s.c \\\\\\\n", p[i].path, p[i].files[j]);
	}
      }
    } else {
      if (suffix(p[i].name)[0] == 'c') {
	fprintf(fptr, "%s%s.c \\\\\\\n", p[i].path, p[i].name);
      }
    }
  }
  fprintf(fptr, "\\\n");
  fprintf(fptr, "PCDOTSS = ");
  for (i = 0; i < num_prot; i++) {
    if (p[i].instance != 0) continue;
    if (p[i].numfiles) {
      for (j = 0; j < p[i].numfiles; j++) {
	if (suffix(p[i].files[j])[0] == 'S') {
	  fprintf(fptr, "%s%s.S ", p[i].path, p[i].files[j]);
	}
      }
    } else {
      if (suffix(p[i].name)[0] == 'S') {
	fprintf(fptr, "%s%s.S ", p[i].path, p[i].name);
      }
    }
  }
  fprintf(fptr, "\\\n");
  fprintf(fptr, "# PCDEFINITIONS END HERE\n");


  fprintf(fptr, "/^# PCRULES BEGIN HERE/,/^# PCRULES END HERE/c\\\n");
  fprintf(fptr, "# PCRULES BEGIN HERE\\\n");
  fprintf(fptr, "# Don't edit these lines, compose uses them\\\n");
  for (i = 0; i < num_prot; i++) {
    if (p[i].instance != 0) continue;
    if (p[i].numfiles) {
      for (j = 0; j < p[i].numfiles; j++) {
	fprintf(fptr, "%s${HOW}/%s.o:\t%s%s.%s\\\n", p[i].path, p[i].files[j],
	  p[i].path, p[i].files[j], suffix(p[i].files[j]));
	fprintf(fptr, "@${C%sO} %s%s %s${HOW}/%s %s\\\n", 
	  *suffix(p[i].files[j]) == 'c' ? "C" : "S", p[i].path, p[i].files[j],
	  p[i].path, p[i].files[j],
	  *suffix(p[i].files[j]) == 'c' ? "$(CFLAGS)" : "$(CPPFLAGS)");
      }
    } else {
      fprintf(fptr, "%s${HOW}/%s.o:\t%s%s.%s\\\n", p[i].path, p[i].name, p[i].path,
	p[i].name, suffix(p[i].name));
      fprintf(fptr, "@${C%sO} %s%s %s${HOW}/%s %s\\\n",
	*suffix(p[i].name) == 'c' ? "C" : "S", p[i].path, p[i].name,
	p[i].path, p[i].name,
	*suffix(p[i].name) == 'c' ? "$(CFLAGS)" : "$(CPPFLAGS)");
    }
  }
  fprintf(fptr, "# PCRULES END HERE\n");



  for (i = 0; i < num_prot; i++) {
    char linkname[50], realname[128];
    if (p[i].instance != 0) continue;

    sprintf(linkname, "%s.h", p[i].name);

    if (strsame(p[i].name, "eth")) {
      sprintf(realname, "../protocols/ethernet.h");
    } else {
      sprintf(realname, "%s%s.h", p[i].path, p[i].numfiles ? p[i].files[0] : p[i].name);
    }
      
    if (!strsame(p[i].path, ".") && 
	isnotarealfile(linkname) &&
	access(realname, 4) == 0) {
      unlink(linkname);
      symlink(realname, linkname);
    }
  }
}

find_index(name)
char *name;
{
  int i;
  for (i = 0; i < num_prot; i++) {
    if (*name == *p[i].name && strsame(name, p[i].name)) return i;
  }
  return -1;
}

gen_code(fptr)
    FILE *fptr;
{
  char *ptr;
  int i;
  int j;

  fprintf(fptr, "#include \"upi.h\"\n");
  fprintf(fptr, "#include \"protocols.h\"\n");
  fprintf(fptr, "XObj protl_tab[%d+1];\n", num_prot);
  fprintf(fptr, "char *protocol_names[%d+1];\n", num_prot);
  fprintf(fptr, "unsigned int protl_id_tab[%d+1];\n", num_prot);
  fprintf(fptr, "build_pgraph()\n");
  fprintf(fptr, "{\n");

  for (i = 0; i < num_prot; i++) {
    ptr = make_define(p[i].name);
    fprintf(fptr, "\n /* building protocol %s */\n", ptr);
    fprintf(fptr, "protl_tab[%d] = x_createprotocol(%d,\"%s\",%d,%d,%d,%d,",
	    i,
	    p[i].numdown,
	    p[i].name,
	    p[i].id,
	    p[i].instance,
	    1,
	    (i >= last_driver ? 0 : 1));
    if (p[i].getproc == 0) {
      fprintf(fptr, "%s_getproc);\n", p[i].name);
    } else {
      fprintf(fptr, "%s);\n", p[i].getproc);
    }
    fprintf(fptr, "protl_tab[%d]->numdown = %d;\n", i, p[i].numdown);
    for (j = 0; j < p[i].numdown; j++) {
      int di = find_index(p[i].down[j]);
      fprintf(fptr, "protl_tab[%d]->down[%d] = protl_tab[%d];\n", i, j, di);
      fprintf(fptr, "(protl_tab[%d]->rcnt)++;\n", di);
    }
    fprintf(fptr, "protl_id_tab[%d] = %d;\n", i, p[i].id);
    fprintf(fptr, "protocol_names[%d] = \"%s\";\n", i, p[i].name);
    fprintf(fptr, "x_instantiateprotl(protl_tab[%d]);\n", i);
    fprintf(fptr, "protl_tab[%d]->index = %d;\n", i, i);

    fprintf(fptr, "\n");
  }

  fprintf(fptr, "}\n");

}

gen_defs(fptr)
    FILE *fptr;
{
  int i;
  char *ptr;

#ifdef DOGET_S
  fprintf(fptr, "#define get_protl(s) ( (s > 0) && (s < %d)) ? protl_tab[s] : 0)\n", num_prot);
  fprintf(fptr, "#define get_protl_name(s) ( (s > 0) && (s < %d)) ? protl_name_tab[s] : 0)\n", num_prot);
  fprintf(fptr, "#define get_protl_id(s) ( (s > 0) && (s < %d)) ? protl_id_tab[s] : 0)\n", num_prot);
#endif
  for (i = 0; i < num_prot; i++) {
    ptr = make_define(p[i].name);
#ifdef DODEFINES
    fprintf(fptr, "#define %s   %d\n", ptr, i);
#endif
    fprintf(fptr, "extern int trace%sp;\n", p[i].name);
    if (p[i].getproc) {
      fprintf(fptr, "extern int %s();\n", p[i].getproc);
    } else {
      fprintf(fptr, "extern int %s_getproc();\n", p[i].name);
    }
  }
  fprintf(fptr, "#define FIRSTUSERPROTOCOL   %d\n", i);
}

char *
     make_define(cptr)
    char *cptr;
{
  char buf[200];
  int i;

  for (i = 0; i < strlen(cptr); i++) {
    if (islower(cptr[i])) {
      buf[i] = toupper(cptr[i]);
    } else {
      buf[i] = cptr[i];
    }
  }
  buf[i] = '\0';
  return (xerox(buf));
}




parse()
{
  if (debug)
    printf("\n>parse\n");
  cur = getchar();
  S();
}

/*
 * S -> ( EDGE | AMPERSAND ) , S | EPSILON
 */

S()
{
  int i, j;
  int instance;

  if (debug)
    printf("\n>S\n");
  num_prot = 0;
  last_driver = -1;
  skip_blanks();
  while (!done) {
    if (cur == '@') {
      force_char('@');
      skip_blanks();
      force_char(';');
      last_driver = num_prot;
    } else {
      bzero(&(p[num_prot]), sizeof(PROTOCOL));
      EDGE(&(p[num_prot]));
      if (debug)
	printf("\n");
      p[num_prot].path = "";
      for (j = num_prot - 1; j >= 0; j--) {
	if (p[num_prot].numfiles && p[j].numfiles) {
	  if (file_comp(num_prot, j)) {
	    p[num_prot].instance = p[j].instance + 1;
	    break;
	  }
	}
	if (p[num_prot].numfiles && !p[j].numfiles) {
	  if (file_name_comp(num_prot, j)) {
	    p[num_prot].instance = p[j].instance + 1;
	    break;
	  }
	}
	if (!p[num_prot].numfiles && p[j].numfiles) {
	  if (file_name_comp(j, num_prot)) {
	    p[num_prot].instance = p[j].instance + 1;
	    break;
	  }
	}
      }
      num_prot++;
    }
    skip_blanks();
  }
}

file_name_comp(i, j)
    int i, j;
{
  int k;

  if (p[i].numfiles != 1)
    return 0;
  if (p[j].numfiles)
    return 0;
  if (!strsame(p[i].files[0], p[j].name)) {
    return (0);
  }
  return (1);
}


file_comp(i, j)
    int i, j;
{
  int k;

  if (!p[i].numfiles)
    return 0;
  if (!p[j].numfiles)
    return 0;
  if (p[j].numfiles != p[i].numfiles)
    return 0;
  for (k = 0; k < p[i].numfiles; k++) {
    if (!strsame(p[i].files[k], p[j].files[k])) {
      return (0);
    }
  }
  return (1);
}

/*
 * NUMBER 		-> [0..9]*
 */
NUMBER()
{
  int i = 0;

  if (debug)
    printf("\n>NUMBER\n");

  while (isdigit(cur)) {
    i = i * 10 + cur - '0';
    get();
  }
  return i;
}

/*
 * EDGE -> PNAME " " (GETPROC ") " (FILES " ") (ID " ") (PROTOCOLS " ") "."
 */
EDGE(p)
    PROTOCOL *p;
{
  if (debug)
    printf("\n>EDGE\n");
  p->name = PNAME();
  if (cur == ';') {
    force_char(';');
    return;
  }
  force_char(' ');
  skip_blanks();
  if (cur == 'g') {
    p->getproc = GETPROC();
    if (cur == ';') {
      force_char(';');
      return;
    }
    force_char(' ');
    skip_blanks();
  }
  if (cur == 'f') {
    FILES(p);
    if (cur == ';') {
      force_char(';');
      return;
    }
    force_char(' ');
    skip_blanks();
  }
  if (cur == 'i') {
    p->id = ID();
    if (cur == ';') {
      force_char(';');
      return;
    }
    force_char(' ');
    skip_blanks();
  }
  if (cur == 'p') {
    PROTOCOLS(p);
    skip_blanks();
  }
  force_char(';');
}

/*
 * GETPROC -> "getproc=" PROTOCOLNAME
 */

char *
     GETPROC()
{
  if (debug)
    printf("\n>PNAME\n");
  force_string("getproc=");
  return (PROTOCOLNAME());
}


/*
 * PNAME -> "name=" PROTOCOLNAME
 */

char *
     PNAME()
{
  if (debug)
    printf("\n>PNAME\n");
  force_string("name=");
  return (PROTOCOLNAME());
}


/*
 * FILES -> "files=" FILELIST
 */
FILES(p)
    PROTOCOL *p;
{
  if (debug)
    printf("\n>FILE\n");
  force_string("files=");
  FILELIST(p);
}


/*
 * FILELIST -> FILENAME | FILENAME "," FILELIST
 */
FILELIST(p)
    PROTOCOL *p;
{
  if (debug)
    printf("\n>FILELIST\n");
  p->numfiles = 0;
  p->files[0] = FILENAME();
  while (cur == ',') {
    get();
    p->numfiles++;
    p->files[p->numfiles] = FILENAME();
  }
  p->numfiles++;
}

/*
 * PROTOCOLNAME -> [a-z_0..9]*
 */
char *
     PROTOCOLNAME()
{
  int len = 0;
  char buf[BUF_SIZE];

  if (debug)
    printf("\n>PROTOCOLNAME\n");
  while (islower(cur) || isupper(cur) || isdigit(cur) || (cur == '_')) {
    buf[len++] = cur;
    get();
  }
  buf[len] = 0;
  return (xerox(buf));
}

/*
 * ID -> "id=" NUMBER
 */

ID()
{
  if (debug)
    printf("\n>ID\n");
  force_string("id=");
  return (NUMBER());
}

/*
 * PROTOCOLS --> "protocols=" PROTOCOLLIST
 */

PROTOCOLS(p)
    PROTOCOL *p;
{
  if (debug)
    printf("\n>PROTOCOLS\n");
  force_string("protocols=");
  PROTOCOLLIST(p);
}

/*
 * PROTOCOLIST -> PROTOCOLNAME "," PROTOCOLLIST
 */
PROTOCOLLIST(p)
    PROTOCOL *p;
{
  if (debug)
    printf("\n>PROTOCOLLIST\n");
  p->numdown = 0;
  p->down[0] = PROTOCOLNAME();
  while (cur == ',') {
    get();
    p->numdown++;
    p->down[p->numdown] = PROTOCOLNAME();
  }
  p->numdown++;
}


/*
 * FILENAME -> [./A-Za-z_0..9]*
 */
char *
     FILENAME()
{
  int len = 0;
  char buf[BUF_SIZE];

  if (debug)
    printf("\n>FILENAME\n");
  while (islower(cur) || isupper(cur) || isdigit(cur) || (cur == '_') ||
	 (cur == '/') || (cur == '\.')) {
    buf[len++] = cur;
    get();
  }
  buf[len] = 0;
  return (xerox(buf));
}



force_char(ch)
    char ch;
{
  if (cur == ch) {
    get();
  } else {
    fprintf(stderr, "syntax error: expecting %c got %c\n", ch, cur);
    exit(1);
  }
}


force_string(str)
    char *str;
{
  char *temp;

  temp = str;
  while (cur == *temp) {
    get();
    temp++;
  }
  if (*temp != 0) {
    fprintf(stderr, "syntax error: expecting %s\n", str);
    exit(1);
  }
}

skip_blanks()
{
  while ((cur == ' ') || (cur == '	') || (cur == '\t'))
    get();
}

get()
{
  if (done)
    return;
  cur = getchar();
  if (debug)
    putchar(cur);
  if (cur == EOF) {
    done = 1;
    cur = 0;
  }
  if (cur == '\n') {
    cur = ' ';
    if (debug)
      putchar(cur);
  }
}


echo_cur()
{
  if (!done) {
    putchar(cur);
  }
}

echo_line()
{
  if (done)
    return;

  cur = getchar();
  if (cur == EOF) {
    done = 1;
    cur = 0;
    return;
  }
  while (cur != '\n') {
    putchar(cur);
    cur = getchar();
  }
  putchar(cur);
}

syntax_error(str)
    char *str;
{
  fprintf(stderr, "syntax error: production %s\n", str);
  exit(1);
}

char *
     xerox(str)
    char *str;
{
  char *temp;
  int len;

  assert(str);
  len = strlen(str) + 2;
  temp = (char *) malloc(len);
  strcpy(temp, str);
  return (temp);
}
char *
     join(str1, str2)
    char *str1;
    char *str2;
{
  char *temp;
  int len;

  if (!str1)
    return (str2);
  if (!str2)
    return (str1);

  len = strlen(str1) + strlen(str2) + 2;
  temp = (char *) malloc(len);
  strcpy(temp, str1);
  strcat(temp, str2);
  return (temp);
}



comp(a, b)
    char *a, *b;
{
  int size1, size2;
  int min;

  /*
   * printf(">comp a = %s b = %s\n",a,b);
   */

  size1 = strlen(a);
  size2 = strlen(b);

  if (size1 > size2)
    min = size2;
  else
    min = size1;

  if (strncmp(a, b, min) == 0) {
    /*
     * printf("<comp returns 1\n",a,b);
     */
    return (1);
  }
  /*
   * printf("<comp returns 0\n",a,b);
   */
  return (0);
}

print_protocol(p)
    PROTOCOL *p;
{
  int i;

  printf("name = %s\n", p->name);
  if (p->getproc)
    printf("getproc = %s\n", p->getproc);
  printf("id = %d\n", p->id);
  printf("instance = %d\n", p->instance);
  printf("numfiles = %d\n", p->numfiles);
  for (i = 0; i < p->numfiles; i++) {
    printf("file[%d] = %s\n", i, p->files[i]);
  }
  printf("numdown = %d\n", p->numdown);
  for (i = 0; i < p->numdown; i++) {
    printf("down[%d] = %s\n", i, p->down[i]);
  }
}
