/*
 * testnfs.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 *****************************************************************************
 *
 * Test NFS: Invokes different routines in library for mount, open, read, etc
 *
 * This test can be run as a client of any server running the NFS protocol
 *
 * Boot parameters (all optional)
 *
 *	-cHostname:  boot as an NFS client of Hostname (default is
 *		     SITE_SERVER_NAME)
 *
 *	-uUID:	     Create and access files using UID (default is
 *		     SITE_DEFAULT_UID)
 *
 *	-gGID:	     Create and access files using GID (default is
 *		     SITE_DEFAULT_GID)
 *
 *	-dDirectory: Directory to mount and in which to create and read files.
 *		     The client machine must be authorized by the server
 *		     to mount this directory
 *
 *	-fFilename:  Filename (relative to the directory) to read
 *
 *****************************************************************************/

#include "xkernel.h"
#include "nfs/xnfs.h"
#include "ip.h"
#include "nfslib.h"
#include <sys/stat.h>


/* default definition of files and directories to work with */

#define DIRMOUNT  "/usr/tmp"
#define FILEREAD  "nfs_test_read"
#define FILECREA  "nfs_test_create"  	/* time of day is appended */
#define DIRCREA   "nfs_test_dir"	/* time of day is appended */

static char dirname[256], fileToRead[256];

static int uid = SITE_DEFAULT_UID;	/* uid used for remote access */
static int gid = SITE_DEFAULT_GID;	/* gid used for remote access */


/* 
 * default NFS server 
 */
char *SERVERNAME;


static int null()
{
}


int strtoi(s)
    char *s;
{
    int i = 0;

    while(1) {
	if (*s < '0' || *s > '9') return i;
	i *= 10;
	i += (*s - '0');
	s++;
    }
}


client()
{
  int	null();
  int	p , s, i, len, creamode, ret_val;
  unsigned  pnumber;
  char *space = "        ";
  char *bufw = "BUFFER TO BE WRITTEN IN TO file TEST1";
  char fileread[256], filecrea[256], dircrea[256], buf[80];
  Part	whom[3];
  NFS_FILE *fd, *fdw;
  struct stat bufstat;
  struct dirents dirarr;
  struct create bufcrea;
  UnixTime currentTime;

  printf("I am the client, talking to %s\n", SERVERNAME);
  p = xcreateprotl(null, null, null);


  xgettime(&currentTime);
  sprintf(fileread, "%s/%s", dirname, fileToRead);
  sprintf(filecrea, "%s/%s.%d", dirname, FILECREA, currentTime.sec);
  sprintf(dircrea, "%s/%s.%d", dirname, DIRCREA, currentTime.sec);

  nfs_init(uid, gid);

  printf("Mount %s\n",dirname);

  if (nfs_mount(SERVERNAME, dirname) == 0)
  	printf("mount succeeded\n\n");
  else
    	printf("ERROR, in mount\n\n");

  strcat(dirname, "/.");
  printf("Remote ls %s\n",dirname);
  if (nfs_readdir(dirname,0, NFS_MAXDATA, &dirarr) == 0) {
        printf("entries %d\n",dirarr.nentries);
        for (i = 0; i < dirarr.nentries ; i++) {
                printf("%s \n",dirarr.entries[i].name);
   		} 
        printf("\n");
  	printf("readdir succeeded\n\n");
  }
  else
    	printf("ERROR, in readdir\n\n");


  printf("Mkdir %s\n",dircrea);

  if (nfs_mkdir(dircrea, 0700)==0)
    	printf("mkdir succeeded\n\n");
  else
    	printf("ERROR, in mkdir \n\n");

  printf("Create file %s\n",filecrea);

  if ((fdw = nfs_create(filecrea, 0700)) != NULL)
    	printf("create succeeded \n\n");
  else
    	printf("ERROR, in create \n\n");

  printf("Remote ls %s\n",dirname);
  if (nfs_readdir(dirname,0, NFS_MAXDATA, &dirarr) == 0) {
        printf("entries %d\n",dirarr.nentries);
        for (i = 0; i < dirarr.nentries ; i++) {
                printf("%s \n",dirarr.entries[i].name);
   		} 
        printf("\n");
  	printf("readdir succeeded\n\n");
  }
  else
    	printf("ERROR, in readdir\n\n");

  printf("Open file %s\n",fileread);

  if ((fd = nfs_fopen(fileread)) != NULL)
    	printf("open succeeded \n\n");
  else
    	printf("ERROR, in open \n\n");

  printf("Getattr from %s\n", fileread);

  if (nfs_getattr(fileread, &bufcrea)==0)  {
  	printf(" mode  =%o\n",bufcrea.mode & 0x00001ff);
  	printf(" uid   =%d\n",bufcrea.uid);
  	printf(" gid   =%d\n",bufcrea.gid);
  	printf(" size  =%d\n",bufcrea.size);
  	printf(" atime =%d\n",bufcrea.atime.tv_sec);
  	printf(" mtime =%d\n",bufcrea.mtime.tv_sec);
    	printf("getattr succeeded \n\n");
        }
  else
    	printf("ERROR, in getattr \n\n");

  printf("Write to %s\n",filecrea);

  if (fdw != NULL) {
     	if ((nfs_write(fdw->file, bufw, strlen(bufw))) != -1)
       		printf("write succeeded buf:%s \n\n",bufw);
     	else
       		printf("ERROR, in write to \n \n");
   }

  if (fd != NULL) {
  	printf("Fstat file %s\n", fileread);

  	if (nfs_fstat(fd->file, &bufstat)==0)  {
   		printf(" dev  = %d\n", bufstat.st_dev);
   		printf(" ino  = %d\n", bufstat.st_ino);
   		printf(" mode = %o\n", bufstat.st_mode & 0x0000fff);
   		printf(" nlink= %d\n", bufstat.st_nlink);
   		printf(" uid  = %d\n", bufstat.st_uid);
   		printf(" gid  = %d\n", bufstat.st_gid);
   		printf(" rdev = %d\n", bufstat.st_rdev);
   		printf(" size = %d\n", bufstat.st_size);
   		printf(" atime= %d\n", bufstat.st_atime);
   		printf(" mtime= %d\n", bufstat.st_mtime);
   		printf(" ctime= %d\n", bufstat.st_ctime);
    		printf("fstat succeeded \n\n");
       		}
  	else
    		printf("ERROR, in fstat \n\n");
}

  bzero(buf, sizeof(buf));

  if (fd != NULL) {
    	printf("Fread file %s\n", fileread);

  	if ((nfs_fread(&buf, sizeof(buf)-1, 1, fd)) >= 0)  {
	    buf[sizeof(buf)-1] = '\0';
	    printf("Fread data buf: %s\n", buf);
	}
	else
	  printf("ERROR, in fread\n\n");
    }

  if (fd) {
      printf("Close file %s\n",fileread);
      nfs_fclose(fd);
      printf("Close succeeded \n\n");
  }
  if (fdw) {
      printf("Close file %s\n",filecrea);
      nfs_fclose(fdw);
      printf("Close succeeded \n\n");
  }

  printf("You have 30 seconds to check files(dirs) created remotely.\n");
  for (i=0; i < 30; i++) {
    xpause(1000);
    if (i%5 == 0) printf("%d",i);
    else printf(".");
  }
  printf("\n\n");

  printf("Rmdir %s\n",dircrea);

  if (nfs_rmdir(dircrea)==0)
  	printf("rmdir succeeded \n\n");
  else
  	printf("ERROR, in rmdir \n\n");


  printf("Remove file %s\n",filecrea);

  if (nfs_remove(filecrea)==0)
  	printf("remove succeeded \n\n");
  else
    	printf("ERROR, in  remove \n\n");
}


user(argc, argv)
int argc;
char **argv;
{
    IPhost ipaddr, nametoip();
  
    printf("nfs test\n");
    SERVERNAME = SITE_SERVER_NAME;
    strcpy(dirname, DIRMOUNT);
    strcpy(fileToRead, FILEREAD);
    while (argc > 1) {
	if (! strncmp(argv[1], "-c", 2)) {
	    SERVERNAME = &argv[1][2];
	} else if (! strncmp(argv[1], "-u", 2)) {
	    uid = strtoi(&argv[1][2]);
	} else if (! strncmp(argv[1], "-g", 2)) {
	    gid = strtoi(&argv[1][2]);
	} else if (! strncmp(argv[1], "-d", 2)) {
	    strcpy(dirname, &argv[1][2]);
	} else if (! strncmp(argv[1], "-f", 2)) {
	    strcpy(fileToRead, &argv[1][2]);
	} else {
	    printf("Unrecognized argument %s\n", argv[1]);
	    return;
	}
	argc--;
	argv++;
    }
    client();
}

