/*
 * sunrpcusers.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 *****************************************************************************
 * This program tests the sunRPC protocol by making a call to the rusers
 * program on a server and printing the results.  This server can be any
 * machine running the rusers program.
 *
 * Boot parameters: 
 *	
 *	-cHostname:  boot as client of Hostname (default is SITE_SERVER_NAME)
 *
 *****************************************************************************/

#include <rpc/rpc.h>
#include <rpc/xdr.h>
#include "sunrpcusers.h"
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"


#define MAXBUF  8192

/* 
 * default server and client 
 */
IPhost client_host = SITE_CLIENT_IP;   
IPhost server_host = SITE_SERVER_IP;
   
static  Protl    IP, SUNRPC;

XDR 		xdrr, xdrs;
char 		rbuf[MAXBUF], sbuf[MAXBUF];
int		null();
char		*SERVERNAME,*CLIENTNAME;
SUNRPCaddr	SERVER, CLIENTE;
PMAP_ARGS 	pargs;
utmpidlearr 	ua;
int numb = 0;

/*****************************************************************************/

client()
{
  int	null();
  int	p , s, i, len;
  unsigned  pnumber;
  char *request;
  char *reply;
  Part	whom[3];
  int   ret_val;

  printf("I am the client, talking to %s\n", SERVERNAME);
  p = xcreateprotl(null, null, null);

/* Set values to open a SUNRPC session caling the portmapper */
  CLIENTE.host.port = 0;
  SERVER.prog = PMAP_PROG;
  SERVER.vers = PMAP_VERS;
  SERVER.proc = PMAPPROC_GETPORT;
  SERVER.host.port = PMAP_PORT;
  init_partlist(whom, 2, SUNRPCaddr);
  set_part(whom, 0, CLIENTE);
  set_part(whom, 1, SERVER);  
      if ((s = xopen(p, SUNRPC, whom)) == 0) {
        printf("cant open SUNRPC session\n");
        return;
      }

 /* Request to the portmapper for the port of this <prog, vers> */
  pargs.prog = RUSERSPROG;
  pargs.vers = RUSERSVERS_IDLE;
  pargs.prot = 17;

 /* encode arguments */
  XDR_SETPOS(&xdrs, 0);
  xdr_pmap(&xdrs, &pargs);

  len = sizeof(unsigned);
  ret_val = xpush(s, sbuf, XDR_GETPOS(&xdrs), &rbuf, &len);

 /* decode the arguments */
  XDR_SETPOS(&xdrr, 0);
  xdr_int(&xdrr, &pnumber); 

  printf("Port mapper assigned port %d for rusers \n",pnumber);

 /* Now open session to that port to talk to the RUSERS program */
  CLIENTE.host.port = 0;
  SERVER.prog = RUSERSPROG;
  SERVER.vers = RUSERSVERS_ORIG;
  SERVER.proc = RUSERSPROC_NAMES;
  SERVER.host.port = pnumber;
  init_partlist(whom, 2, SUNRPCaddr);
  set_part(whom, 0, CLIENTE);
  set_part(whom, 1, SERVER);  
 
      if ((s = xopen(p, SUNRPC, whom)) == 0) {
        printf("cant open SUNRPC session\n");
        return;
      }

    /* No need to send arguments */
      printf("\nremote execution rusers to %s\n", SERVERNAME);
      XDR_SETPOS(&xdrs, 0);

      len = MAXBUF;
      ret_val = xpush(s, sbuf, XDR_GETPOS(&xdrs), &rbuf, &len);
      if (ret_val < 0) {
        printf("Error On Getting ret_val\n");
      }
      XDR_SETPOS(&xdrr, 0);
      if (!xdr_utmpidlearr(&xdrr, &ua))   
        printf("Error on Arguments XDR failed \n");
      else {
        printf("Total number of users: %d \n",ua.utmpidlearr_len); 
        printf("line     Name     Host              time\n");
        numb = 0;
        while (numb < ua.utmpidlearr_len) {
           printf("%s %s %s %d\n",(ua.utmpidlearr_val)[numb].ui_utmp.ut_line, 
      				   (ua.utmpidlearr_val)[numb].ui_utmp.ut_name, 
      				   (ua.utmpidlearr_val)[numb].ui_utmp.ut_host, 
      				   (ua.utmpidlearr_val)[numb].ui_utmp.ut_time);
           numb++;
           }
      }
   return;
}


/*****************************************************************************
 * set all stuff for work on top of SUNRPC, fires process for client and server
 */
user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();

  xdrmem_create(&xdrs, sbuf, MAXBUF, XDR_ENCODE);
  xdrmem_create(&xdrr, rbuf, MAXBUF, XDR_DECODE);

  printf("sunrpc rusers_names test\n");
  IP = xgetprotlbyname("ip");
  SUNRPC = xgetprotlbyname("sun_rpc");
  SERVER.host.host = server_host;
  SERVER.prot =17;                  /* UDP hard coded */
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host.host = ipaddr;
    } else if (!strncmp(argv[1], "-c", 2)) {
      client_host = ipaddr;
      CLIENTE.host.host = client_host;
      CLIENTE.host.port = 0;
      SERVERNAME = &argv[1][2];
      SERVER.host.host = nametoip(SERVERNAME);
      if (SERVER.host.host.a == 0 && SERVER.host.host.b == 0 &&
	  SERVER.host.host.c == 0 && SERVER.host.host.d == 0) {
	  printf("Can not find IP entry for host %s\n", SERVERNAME);
	  return;
      }
    }
    SERVERNAME = malloc(24);
    iptoname(SERVER.host.host, SERVERNAME);
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, client_host)) {
    client();
  }
}

/*****************************************************************************/
null(s,m,length)
int s, length;
char *m;
{
}

bool_t
xdr_utmp(xdrs, objp)
	XDR *xdrs;
	utmp *objp;
{
 	/*printf("in utmp\n");*/
	if (!xdr_string(xdrs, &objp->ut_line, MAXUTLEN)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->ut_name, MAXUTLEN)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->ut_host, MAXUTLEN)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ut_time)) {
		return (FALSE);
	}
/* 	printf("leaving utmp OK\n");*/
	return (TRUE);
}


bool_t
xdr_utmpidle(xdrs, objp)
	XDR *xdrs;
	utmpidle *objp;
{
	if (!xdr_utmp(xdrs, &objp->ui_utmp)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->ui_idle)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr_utmparr(xdrs, objp)
	XDR *xdrs;
	utmparr *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->utmparr_val, (u_int *)&objp->utmparr_len, MAXUSERS, sizeof(utmp), xdr_utmp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_utmpidlearr(xdrs, objp)
	XDR *xdrs;
	utmpidlearr *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->utmpidlearr_val, (u_int *)&objp->utmpidlearr_len, MAXUSERS, sizeof(utmpidle), xdr_utmpidle)) {
		return (FALSE);
	}
	return (TRUE);
}


