/* 
 * ms_screen.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ms_screen_h
#define ms_screen_h

#define min(A,B) ((A) < (B) ? (A) : (B))
#define max(A,B) ((A) > (B) ? (A) : (B))

#define FRAMEBUFFER 		FBUFFER
#define FRAMEBUFFERSIZE 	FBUFFERSIZE
#define WIDTHINPIXELS		1152
#define HEIGHTINPIXELS		900

#define NCOLS			2

#define WIDTHINBYTES		(WIDTHINPIXELS / 8)
#define screen ((unsigned char *) FRAMEBUFFER)

#define FONTWIDTH		8
#define FONTHEIGHT		16
#define HEIGHTINCHARS		(HEIGHTINPIXELS / FONTHEIGHT)
#define WIDTHINCHARS		WIDTHINBYTES
#define ADDR(R,C) (screen + (R) * FONTHEIGHT * widthInBytes + (C) * FONTWIDTH / 8)

typedef unsigned short scrtype;

#define SCRSHIFT	4
#define SCRMASK		0xf
#define SCRSIZE		16
#define LADDR(R) ((scrtype *) (screen + (R) * widthInBytes))
#define WIDTHINSCRTYPES (WIDTHINPIXELS / SCRSIZE)

/*********************************************************
* Exported macros, functions, and typedefs
**********************************************************/

extern	int	Ms_putchar();
extern	int	Ms_InitScreen();

#endif
