/* 
 * ms_process.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ms_process_h
#define ms_process_h

#ifndef ms_memory_h
#include "ms_memory.h"
#endif

#ifndef ms_exception_h
#include "ms_exception.h"
#endif

#ifndef ms_inline_h
#include "ms_inline.h"
#endif

/* Disable/enable ALL interrupts */
#define DISABLE ;asm("andb #0xfe, 0xfe0a000")	/* V_INTERRUPT_REG */
#define ENABLE  ;asm("orb  #0x01, 0xfe0a000")


#define PDTOKSTACK(pd) \
     ((unsigned)(KERNEL_LIMIT - ((pd - ProcessDescriptors) * PROCESSMAXSTACK)))
#define KTOUSTACK(kstack) (kstack - MAXKERNELSTACK - PAGE_SIZE)
#define UTOKSTACK(ustack) (ustack + MAXKERNELSTACK + PAGE_SIZE)
#define PDTOUSTACK(pd) KTOUSTACK(PDTOKSTACK(pd))

/*********************************************************
* Exported macros, functions, and typedefs
**********************************************************/

extern	int	Ms_AllocatePds();
extern	int	Ms_DestroyProcess();
extern	int	Ms_CreateProcess();
extern	int	Ms_InitPd();
extern	int	Ms_CheckOutRQ();
extern	int	Ms_P();
extern	int	Ms_Switch();
extern	int	Ms_Delay();
extern	int	Ms_ActivateReadyqHead();
extern	int	Ms_Addready();
extern	int	Ms_RemoveReady();
extern	int	Ms_Idle();
extern	int	Ms_Kabort();
/* extern	int	Ms_Splx();	an inline function */

#define	Ms_InitPd(pd)	pd->ps.stackBase.u = 0;

typedef struct {
  union {
    Unspec		x[17];	/* 8 data + 8 address registers + usp */
				/* Supervisory stack ptr stored as a7 */
    struct {
      Unspec d0, d1, d2, d3, d4, d5, d6, d7;
      Unspec a0, a1, a2, a3, a4, a5, a6, a7, usp;
    } r;
  } regs;
  Unspec fregs[16];		/* floating point registers */
  Unspec fstate[1];		/* floating point state */
  VirtualAddress stackBase, stackLimit;
} Ms_ProcessorState;

#endif

