h28244
s 00610/00000/00000
d D 1.1 91/01/10 11:11:37 llp 1 0
c date and time created 91/01/10 11:11:37 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * ms_screen.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "assert.h"
#include "debug.h"
#include "ms_memory.h"
#include "ms_romvec.h"
#include "ms_screen.h"

int riouserom = 0;
int riousescreen = 1;
int riousemem = 0;

/*********************************************************
* Machine specific (Ms_) routines; called from printf.c
*********************************************************/

Ms_putchar(c)
char c;
{
  if (riouserom) {
    (*romp->v_putchar)(c);
  } else if (riousescreen) {
    screen_putchar(c);
  } else {
    mem_putchar(c);
  }
}

static int whichcol;
static unsigned char *screenend = 
	  (unsigned char *)FRAMEBUFFER+(WIDTHINBYTES*HEIGHTINPIXELS);
static int widthInPixels = WIDTHINPIXELS;
static int heightInPixels = HEIGHTINPIXELS;
static int widthInBytes = WIDTHINBYTES;
static int widthInChars = WIDTHINCHARS;
static int heightInChars = HEIGHTINCHARS;
static int widthInScrTypes = WIDTHINSCRTYPES;
static int row = 0, col = 0;
static unsigned char *current = screen;
#ifdef REALLYDOCURSOR
static int cursorstate = 0;
#else
#define cursor(x)
#endif

Ms_InitScreen()
{
  int fbtype, scrsize;
#undef DEBUGSCREEN
#ifdef DEBUGSCREEN
  extern int riouserom;
  int save = riouserom;
  riouserom = 1;
#endif
  /*
   * Read the rom to find out what type the frame buffer is
   */
  fbtype = *romp->v_fbtype;
#ifdef DEBUGSCREEN
  printf("Frame buffer type = %d\n", fbtype);
#endif
  /*
   * These constants come from /usr/include/sun/fbio.h
   */
  TRACE1(fixme, 1, "Frame buffer type = %d\n", fbtype);
  assert(fbtype == 2 /* SUN2BW */ || fbtype == 6 /* SUN3COLOR */ ||
	 fbtype == 8 /* SUN4COLOR */);
  /*
   * Read the eeprom to find out how big the frame buffer is
   */
  scrsize = ((struct eeprom *)V_EEPROM)->diag.eed_scrsize;
#ifdef DEBUGSCREEN
  printf("Screen size = %x\n", scrsize);
#endif
  switch (scrsize & 0xff) {
    case EED_SCR_1152X900:
      widthInPixels = 1152;
      heightInPixels = 900;
      break;
    case EED_SCR_1024X1024:
      widthInPixels = 1024;
      heightInPixels = 1024;
      break;
    case EED_SCR_1600X1280:
      widthInPixels = 1600;
      heightInPixels = 1280;
      break;
    case EED_SCR_1440X1440:
      widthInPixels = 1440;
      heightInPixels = 1440;
      break;
    case EED_SCR_640X480:
      widthInPixels = 640;
      heightInPixels = 480;
      break;
    default:
      printf("Screen size = %x, assuming 1152x900\n", scrsize);
      widthInPixels = 1152;
      heightInPixels = 900;
      break;
  }
  /*
   * Need to update all the static size variables
   */
  widthInBytes = widthInPixels / 8;
  heightInChars = heightInPixels / FONTHEIGHT;
  widthInChars = widthInBytes;
  assert (widthInPixels % SCRSIZE == 0);
  widthInScrTypes = widthInPixels / SCRSIZE;
  screenend = (unsigned char *)FRAMEBUFFER+(widthInBytes*heightInPixels);
#ifdef DEBUGSCREEN
  riouserom = save;
  {
    int x;
    for (x = 0; x < 1000000; x++) ;
  }
#endif
  bzero((char *)screen, screenend-screen);
  cursor(1);
}

/*********************************************************
* Internal routines: deal with the screen
*********************************************************/

screen_puts(buffer)
register char *buffer;
{
  cursor(0);
  while (*buffer) screen_putchar(*buffer++);
  cursor(1);
}

screen_goto(r, c)
int r, c;
{
  cursor(0);
  c /= 8;
  r /= 16;
  col = min(widthInChars-1, max(0, c));
  row = min(heightInChars-1, max(0, r));
  cursor(1);
}

struct bits {
  unsigned char b[16];
} screen14rasters[128] = {
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e },
  { 0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e,0xfc,0x7e },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x24,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x12,0x12,0x12,0x7f,0x24,0x24,0xfe,0x48,0x48,0x48,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x54,0x50,0x30,0x18,0x14,0x54,0x54,0x38,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x64,0x94,0x98,0x68,0x10,0x10,0x2c,0x32,0x52,0x4c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x30,0x48,0x48,0x30,0x20,0x52,0x8c,0x88,0x98,0x66,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x10,0x08,0x04,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x08,0x10,0x20,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x54,0x38,0x38,0x54,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xfe,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x08,0x10,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x20,0x20,0x40,0x40,0x80,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x18,0x28,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x02,0x04,0x08,0x10,0x20,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x02,0x1c,0x02,0x02,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x0c,0x14,0x24,0x44,0x84,0xfe,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x02,0x02,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x40,0x40,0x7c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x42,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x3e,0x02,0x02,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x08,0x10,0x20,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x02,0x04,0x08,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x42,0x4e,0x52,0x52,0x4c,0x40,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x18,0x18,0x24,0x24,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x44,0x44,0x44,0x78,0x44,0x42,0x42,0x42,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x40,0x40,0x40,0x40,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x44,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x40,0x40,0x4e,0x42,0x42,0x46,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x44,0x48,0x50,0x60,0x70,0x58,0x4c,0x46,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x82,0xc6,0xc6,0xaa,0xaa,0x92,0x92,0x82,0x82,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x62,0x62,0x52,0x52,0x4a,0x4a,0x46,0x46,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x42,0x42,0x42,0x42,0x7c,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x10,0x08,0x06,0x00 },
  { 0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x48,0x44,0x44,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x20,0x18,0x04,0x02,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x42,0x24,0x24,0x24,0x18,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x82,0x82,0x92,0x54,0x54,0x54,0x28,0x28,0x28,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x82,0x44,0x44,0x28,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x02,0x02,0x04,0x08,0x10,0x20,0x40,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00 },
  { 0x00,0x80,0x40,0x40,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x3c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00 },
  { 0x00,0x00,0x00,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x38,0x44,0x04,0x3c,0x44,0x44,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x40,0x40,0x5c,0x62,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x40,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x46,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x7e,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x12,0x10,0x10,0x7c,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x46,0x3a,0x02,0x42,0x3c,0x00 },
  { 0x00,0x00,0x40,0x40,0x40,0x5c,0x62,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x00,0x1c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x38,0x00 },
  { 0x00,0x00,0x40,0x40,0x40,0x44,0x48,0x50,0x70,0x48,0x44,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0xec,0x92,0x92,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x62,0x5c,0x40,0x40,0x40,0x40 },
  { 0x00,0x00,0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x46,0x3a,0x02,0x02,0x02,0x02 },
  { 0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x3c,0x02,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x10,0x7c,0x10,0x10,0x10,0x10,0x12,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x46,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x82,0x82,0x92,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x22,0x24,0x14,0x14,0x08,0x08,0x10,0x50,0x20 },
  { 0x00,0x00,0x00,0x00,0x00,0x7e,0x04,0x08,0x10,0x20,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x10,0x10,0x10,0x10,0x10,0x60,0x10,0x10,0x10,0x10,0x10,0x0e,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00 },
  { 0x00,0x70,0x08,0x08,0x08,0x08,0x08,0x06,0x08,0x08,0x08,0x08,0x08,0x70,0x00,0x00 },
  { 0x00,0x00,0x00,0x32,0x5a,0x4c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 }
};
struct {
    int width, height;
    struct bits *glyphs;
} screen14 = {
    8, 16, screen14rasters
};

screen_putchar(c)
int c;
{
  int i;
  cursor(0);
  current = ADDR(row, col);
  switch (c) {
    case '\b':
      col = max(0, col - 1);
      break;
    case '\n':
    case '\r':
      col = whichcol * widthInBytes / NCOLS;
#ifdef USESCROLLING
      if (row >= heightInChars - 1) {
	row = heightInChars - 1;
	bcopy((char *)ADDR(1, 0), (char *)ADDR(0, 0), row * FONTHEIGHT * widthInBytes);
	bzero((char *)ADDR(row, 0), widthInBytes * FONTHEIGHT);
      } else {
	row += 1;
      }
#else
      row++;
      if (row >= heightInChars) {
	row = 0;
	whichcol = (whichcol + 1) % NCOLS;
        col = whichcol * widthInBytes / NCOLS;
      }
      for (i = 0; i < FONTHEIGHT * min(3, heightInChars - row); i++) {
	bzero((char *)ADDR(row, col) + i * widthInBytes, widthInBytes / NCOLS);
      }
#endif
      break;
    case '\f':
      row = 0; col = 0; whichcol = 0;
      bzero((char *)screen, screenend-screen);
      break;
    default:
      {
	register unsigned char *glyph = screen14.glyphs[c].b;
	register unsigned char *dest = current;
	register unsigned char *theend = glyph + 16;
	for (; glyph < theend; glyph++, dest += widthInBytes) {
	  *dest = *glyph;
	}
	col = min(widthInBytes-1, col+1);
      }
      break;
  }
  cursor(1);
}

screen_putbigchar(c, size)
int c, size;
{
  switch (c) {
    case '\b':
      col = max(0, col - size);
      break;
    case '\n':
    case '\r':
      col = whichcol * widthInBytes / NCOLS;
#ifdef USESCROLLING
      if (row >= heightInChars - size) {
	row = heightInChars - size;
	bcopy((char *)ADDR(size, 0), (char *)ADDR(0, 0),
	  row * FONTHEIGHT * size * widthInBytes);
	bzero((char *)ADDR(row, 0), widthInBytes * FONTHEIGHT * size);
      } else {
	row += size;
      }
#else
      row += size;
      if (row >= heightInChars) {
	row = 0;
	whichcol = (whichcol + 1) % NCOLS;
	col = whichcol * widthInBytes / NCOLS;
      }
      {
	int i;
	for (i = 0; i < FONTHEIGHT * size * min(3, heightInChars - row); i++) {
	  bzero((char *)ADDR(row, col) + i * widthInBytes, widthInBytes / NCOLS);
	}
      }
#endif
      break;
    case '\f':
      row = 0; col = 0; whichcol = 0;
      bzero((char *)screen, screenend-screen);
      break;
    default:
      {
	int lx, bx = col * FONTWIDTH, by = row * FONTHEIGHT;
	register unsigned char *glyph = screen14.glyphs[c].b;
	register unsigned char *theend = glyph + 16;
	register unsigned int mask;
	register int on;
	cursor(0);

	for (; glyph < theend; glyph++) {
	  lx = bx;
	  for (mask = 0x80; mask; mask >>= 1) {
	    on = (*glyph & mask) ? 1 : 0;
	    screen_blt(lx, by, lx+size, by+size, on);
	    lx += size;
	  }
	  by += size;
	}
	col = min(widthInBytes-size, col+size);
	cursor(1);
      }
      break;
  }
}

#ifdef REALLYDOCURSOR
docursor(how)
int how;
{
  if (cursorstate != how) {
    register unsigned char *c;
    register int i;
    for (c = ADDR(row, col), i = 0; i < 16; i++, c += widthInBytes) { 
      *c ^= 0xff;
    }
    cursorstate = how;
  }
}
#endif

#define BITOP(NAME, OP) \
NAME (addr, c, n) \
register scrtype *addr; \
register int c, n; \
{ \
  register scrtype mask, nmask; \
   \
  if (addr > LADDR(heightInPixels)) return; \
  if (c > widthInPixels) return; \
  if (c + n > widthInPixels) n = widthInPixels - c; \
  addr += (c >> SCRSHIFT); \
  c &= SCRMASK; \
  /* first part word */ \
  mask = -1; \
  mask >>= c; \
  if (c + n > SCRSIZE) { \
    *addr++ OP mask; \
    n -= (SCRSIZE - c); \
    mask = -1; \
  } \
  /* middle full words */ \
  while (n > SCRSIZE) { \
    mask = (-1); \
    *addr++ OP mask; \
    n -= SCRSIZE; \
  } \
  /* final part word */ \
  nmask = mask; \
  nmask >>= n; \
  mask ^= nmask; \
  *addr OP mask; \
}

BITOP(bitsxor, ^=)
BITOP(bitsor, |=)
BITOP(bitsand, &= ~)

static int xm1[] = { 1, 0, 1, 0,-1, 0,-1, 0 };
static int ym1[] = { 0, 1, 0,-1, 0, 1, 0,-1 };
static int xm2[] = { 1, 1, 1, 1,-1,-1,-1,-1 };
static int ym2[] = { 1, 1,-1,-1, 1, 1,-1,-1 };

/* Bresenham algorithm to draw a line from (x1,y1) to (x2,y2) */

#define scr_wdot(x, y, c) \
    (*(screen + (y) * widthInBytes + (x) / 8) ^= (0x80 >> ((x) % 8)))

/*ARGSUSED*/
void 
absline(x1,y1,x2,y2,colour)
{
	int m,deltax,deltay,e,cx,savedx,t;

	m=0;
	deltax=x2-x1;
	if ( deltax<0 ) {
		m=4;
		deltax = -deltax;
	}
	deltay=y2-y1;
	if (deltay<0 ) {
		m += 2;
		deltay = -deltay;
	}
	if ( deltax - deltay < 0 ) {
		m++;
		t=deltax;
		deltax=deltay;
		deltay=t;
	}

	deltay *= 2; /* OK, use a shift if you really want speed */
	e = deltay-deltax;
	savedx = deltax;
	deltax *= 2;

	for ( cx=savedx+1 ; cx >= 1 ; cx-- ) {
		scr_wdot(x1,y1,colour);
		if ( e > 0 ) {
			x1 += xm2[m];
			y1 += ym2[m];
			e += deltay-deltax;
		}
		else {
			x1 += xm1[m];
			y1 += ym1[m];
			e += deltay;
		}
	}
}

/* Draw a line using xor */
screen_line(x1, y1, x2, y2)
{
  register scrtype *addr, *limit;
  if (x1 == x2) {
    /* vertical */
    if (y1 > y2) {
      int y = y1;
      y1 = y2;
      y2 = y;
    }
    for (addr = LADDR(y1), limit = LADDR(y2); addr <= limit; addr += widthInScrTypes) {
      bitsxor(addr, x1, 1);
    }
  } else if (y1 == y2) {
    /* horizontal */
    if (x1 > x2) {
      int x = x1;
      x1 = x2;
      x2 = x;
    }
    bitsxor(LADDR(y1), x1, x2 - x1 + 1);
  } else {
    absline(x1, y1, x2, y2, 0);
  }
}

static int (*ops[])() = { bitsand, bitsor, bitsxor } ;

screen_blt(x1, y1, x2, y2, on)
{
  register scrtype *addr, *limit;
  register int width;
  register int (*op)();
  op = ops[on];
  if (y1 > y2) {
    int y = y1;
    y1 = y2;
    y2 = y;
  }
  if (x1 > x2) {
    int x = x1;
    x1 = x2;
    x2 = x;
  }
  if (x1 < 0) x1 = 0;
  if (y1 < 0) y1 = 0;
  if (x2 >= widthInPixels) x2 = widthInPixels - 1;
  if (y2 >= heightInPixels) y2 = heightInPixels - 1;
  width = x2 - x1 + 1;
  for (addr = LADDR(y1), limit = LADDR(y2); addr <= limit; addr += widthInScrTypes) {
    op(addr, x1, width);
  }
}

screen_getsize(x, y)
int *x, *y;
{
  *x = widthInPixels;
  *y = heightInPixels;
}

screen_bitblt(x1, y1, x2, y2, wx, wy)
{
  register unsigned char *fromaddr, *fromlimit, *toaddr;
  register int width;
  if (x1 < x2) return;
  if (y1 != y2) return;
  if (x1 % 8 != 0) return;
  if (x2 % 8 != 0) return;
  if (wx % 8 != 0) return;
  fromaddr = screen + y1 * widthInBytes + x1 / 8;
  fromlimit = screen + (y1 + wy) * widthInBytes + x1 / 8;
  toaddr = screen + y1 * widthInBytes + x2 / 8;
  width = wx / 8;
  while (fromaddr <= fromlimit) {
    bcopy((char *)fromaddr, (char *)toaddr, width);
    fromaddr += widthInBytes;
    toaddr += widthInBytes;
  }
}

static char buffer[200], *nextMemLoc = buffer;

mem_putchar(c)
int c;
{
  *nextMemLoc = c;
  nextMemLoc++;
  if (nextMemLoc >= (char *)buffer+200) nextMemLoc--;
  if (c == '\n') {
    register char *b;
    for (b = buffer; b < nextMemLoc; b++) {
      screen_putchar(*b);
    }
    nextMemLoc = buffer;
  }
}


E 1
