h05823
s 00118/00000/00000
d D 1.1 91/01/10 11:11:26 llp 1 0
c date and time created 91/01/10 11:11:26 by llp
e
u
U
f e 0
t
T
I 1
#ifdef undef
|
| ms_interrupt.h
|
| x-kernel v3.1	12/10/90
|
| Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
|
|
| Interrupt service routine that calls a machine-independent
| C routine to handle the interrupt.  The routine does four things:
|
|	1)  Save d0, d1, a0, and a1.  This is needed
|	      because C functions destroy those registers.
|	2)  Call the interrupt handler.
|	3)  Restore the registers.
|	4)  Cause a process switch if necessary.
|
| The parameter to the macro should be the name of the function to
| handle the interrupt (prefixed with an _), and an additional label
| for the resulting routine (traditionally _Asm_func).
|
#endif

#undef	INDICATEHIT
#undef	INDICATERETURN
#undef	SAVEREGS
#undef	SAVEDREGSIZE
#undef	RESTOREREGS

#ifndef NDEBUG
#ifdef __STDC__
#define INDICATEHIT	addql	\#1,_GotHit
#define INDICATERETURN	subql	\#1,_GotHit
#else
#define INDICATEHIT	addql	#1,_GotHit
#define INDICATERETURN	subql	#1,_GotHit
#endif
#else
#define INDICATEHIT
#define INDICATERETURN
#endif

#undef SAVEEMALL
#ifdef SAVEEMALL
#ifdef __STDC__
#define SAVEREGS	moveml	\#0xffff,sp@-
#define SAVEDREGSIZE	64
#define RESTOREREGS	moveml	sp@+,\#0xffff
#else
#define SAVEREGS	moveml	#0xffff,sp@-
#define SAVEDREGSIZE	64
#define RESTOREREGS	moveml	sp@+,#0xffff
#endif
#else
#ifdef __STDC__
#define SAVEREGS	moveml	\#0xc0c0,sp@-
#define SAVEDREGSIZE	16
#define	RESTOREREGS	moveml	sp@+,\#0x0303
#else
#define SAVEREGS	moveml	#0xc0c0,sp@-
#define SAVEDREGSIZE	16
#define	RESTOREREGS	moveml	sp@+,#0x0303
#endif
#endif

#ifdef HANDLER
#ifdef DEBUGINTR
	.data1
7:	.asciz	"Returning from interrupt (%d) (%X)\012"
8:	.asciz	"Took an interrupt (%d) (%X) (%X)\012"
	.text
#endif
	.globl	ASMHANDLER
ASMHANDLER:
	SAVEREGS
#ifdef DEBUGINTR
	moveq	#0, d1
	movw	sr, d1
	movl	d1, sp@-
	movw	sp@(SAVEDREGSIZE+4), d1	| Take status register
	movl	d1, sp@-
	movl	_GotHit, sp@-
	pea	8b
	jbsr	_printf
	addl	#16, sp
#endif
	INDICATEHIT			| Indicate the hit
	clrw	_DoSwitch
	jbsr	HANDLER
	INDICATERETURN
#ifdef DEBUGINTR
	moveq	#0, d1
	movw	sr, d1
	movl	d1, sp@-
	movl	_GotHit, sp@-
	pea	7b
	jbsr	_printf
	addl	#12, sp
#endif
	movw	sp@(SAVEDREGSIZE), d1	| Take status register
	andw	#0x2000,d1		| Supervisor
	bnes	1f			| Just return
	tstw	_DoSwitch
	beq	1f
	orw	#0x0700,sr		| Disable interrupts
	movl	_Active, sp@-
	jbsr	_Ms_Addready
	addqw	#4, sp
	RESTOREREGS
	jmp     _Switch
	trap	#14
1:
	RESTOREREGS			| Restore registers
	rte				| Return
#endif
#undef	HANDLER
#undef	ASMHANDLER
E 1
