h56149
s 00998/00000/00000
d D 1.1 91/01/10 11:12:08 llp 1 0
c date and time created 91/01/10 11:12:08 by llp
e
u
U
f e 0
t
T
I 1
# 
# Makefile
#
# x-kernel v3.1	12/10/90
#
# Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
#


#
#   Configuration options: 
#
#	MYXKN		kernel name, when installed
#	DESTS		hosts to which the finished kernel is copied
#	MACHINE		always "sun3" for building standalone kernels
#	HOWTOCOMPILE	either DEBUG or OPTIMIZE
#
MYXKN = xkernel
DESTS = benguiat lubalin
HOWTOCOMPILE = OPTIMIZE
MACHINE = sun3


#
# Some libraries
#
CLIB = /r/bas/usr/lib/libc.a
GNULIB = /r/bas/usr/local/lib/gcc-gnulib


#
# This line is generated by compose; do not edit by hand
#
PROTOCOLS = eth @ arp ip icmp udp dns 


OPTIMIZECFLAGS = -O
OPTIMIZECPPFLAGS = -DNDEBUG -DMSGOPT
DEBUGCFLAGS = -g
DEBUGCPPFLAGS = -DMSGOPT	# use optimized msgs even when debugging

HOW = $(HOWTOCOMPILE)$(MACHINE)

CPPFLAGS = -DMC68000 -DMC68010 -DMC68020 -DENET10MEG -DSUN2 -DSUN3 \
	-I. -I../mi -I../${MACHINE} -I../share -I../protocols \
	-I../lib/shared \
	 $($(HOWTOCOMPILE)CPPFLAGS) \
	

CFLAGS =  $($(HOWTOCOMPILE)CFLAGS) $(CPPFLAGS)
CCO = ../bin/CCO_${MACHINE}${ARCH}
CSO = ../bin/CSO_${MACHINE}${ARCH}
CCS = ../bin/CCS_${MACHINE}
LD = ../bin/LD_${MACHINE}${ARCH}
# PCDEFINITIONS BEGIN HERE
# Don't edit these lines, compose uses them
PCDOTOS = ../drivers/ie/${HOW}/ethProtl.o \
../drivers/ie/${HOW}/intelEth.o \
../drivers/ie/${HOW}/intelEthCmd.o \
../drivers/ie/${HOW}/intelEthI_s.o \
../drivers/ie/${HOW}/intelEthRcv.o \
../drivers/ie/${HOW}/intelEthXmit.o \
../protocols/${HOW}/arp.o \
../protocols/${HOW}/ip.o \
../protocols/${HOW}/icmp.o \
../protocols/${HOW}/udp.o \
../protocols/${HOW}/dns.o \

PCDOTHS = eth.h arp.h ip.h icmp.h udp.h dns.h 
PCDOTCS = ../drivers/ie/ethProtl.c \
../drivers/ie/intelEth.c \
../drivers/ie/intelEthCmd.c \
../drivers/ie/intelEthRcv.c \
../drivers/ie/intelEthXmit.c \
../protocols/arp.c \
../protocols/ip.c \
../protocols/icmp.c \
../protocols/udp.c \
../protocols/dns.c \

PCDOTSS = ../drivers/ie/intelEthI_s.S 
# PCDEFINITIONS END HERE

#
#  Locore.o must be the first file in this list
MSOBJ = \
	../${MACHINE}/${HOW}/Locore.o \
	../${MACHINE}/${HOW}/ms_exception.o \
	../${MACHINE}/${HOW}/ms_exception_s.o \
	../${MACHINE}/${HOW}/ms_clock.o \
	../${MACHINE}/${HOW}/ms_clock_s.o \
	../${MACHINE}/${HOW}/ms_process.o \
	../${MACHINE}/${HOW}/ms_process_s.o \
	../${MACHINE}/${HOW}/ms_screen.o \
	../${MACHINE}/${HOW}/ms_memory.o \
	../${MACHINE}/${HOW}/ms_memory_s.o \
	../${MACHINE}/${HOW}/ms_trap.o \
	../${MACHINE}/${HOW}/ms_trap_s.o \
	../${MACHINE}/${HOW}/ms_misc.o \
	../${MACHINE}/${HOW}/ms_misc_s.o \
	../${MACHINE}/${HOW}/ms_romvec.o

MIOBJ = \
	../mi/${HOW}/init.o \
	../mi/${HOW}/printf.o \
	../mi/${HOW}/process.o \
	../mi/${HOW}/memory.o \
	../mi/${HOW}/clock.o \
	../mi/${HOW}/trap.o \
	../mi/${HOW}/profile.o

SHAREOBJ = \
	../share/${HOW}/alloc.o \
	../share/${HOW}/debug.o \
	../share/${HOW}/event.o \
	../share/${HOW}/idmap.o \
	../share/${HOW}/message.o \
	../share/${HOW}/nmessage.o \
	../share/${HOW}/upi.o

#
#  These files must appear in this order.  The user initialization code in
#  init.c depends on it!!!
USEROBJ = \
	../${MACHINE}/${HOW}/z_u_begin.o \
	${HOW}/z_u_body.o \
	../${MACHINE}/${HOW}/z_u_end.o

PRIVOBJ = \
	${HOW}/localinit.o \
	${HOW}/protocols.o


OBJ =	\
	${MSOBJ} \
	${MIOBJ} \
	${SHAREOBJ} \
	${PRIVOBJ} \
	${PCDOTOS} \
	${USEROBJ}

SHARESRC = \
	../share/alloc.c \
	../share/debug.c \
	../share/event.c \
	../share/idmap.c \
	../share/message.c \
	../share/nmessage.c \
	../share/upi.c

MSSRCS = \
	../${MACHINE}/Locore.S \
	../${MACHINE}/ms_exception_s.S \
	../${MACHINE}/ms_memory_s.S \
	../${MACHINE}/ms_process_s.S \
	../${MACHINE}/ms_misc_s.S \
	../${MACHINE}/ms_trap_s.S

MSSRC = \
	../${MACHINE}/ms_exception.c \
	../${MACHINE}/ms_clock.c \
	../${MACHINE}/ms_process.c \
	../${MACHINE}/ms_screen.c \
	../${MACHINE}/ms_memory.c \
	../${MACHINE}/ms_trap.c \
	../${MACHINE}/ms_misc.c \
	../${MACHINE}/ms_romvec.c

MISRC = \
	../mi/init.c \
	../mi/printf.c \
	../mi/process.c \
	../mi/memory.c \
	../mi/clock.c \
	../mi/trap.c \
	../mi/profile.c

PRIVSRC = \
	localinit.c \
	protocols.c

SRC = \
	${SHARESRC} \
	${MSSRC} \
	${MISRC} \
	${PRIVSRC} \
	${PCDOTCS}

MSINC = \
	../${MACHINE}/ms_exception.h \
	../${MACHINE}/ms_interrupt.h \
	../${MACHINE}/ms_clock.h \
	../${MACHINE}/ms_memory.h \
	../${MACHINE}/ms_process.h \
	../${MACHINE}/ms_romvec.h 

MSINC = \
	../mi/unixtime.h \
	../mi/process.h \
	../mi/memory.h \
	../mi/trap.h 

SHAREINC = \
	../share/debug.h \
	../share/system.h \
	../share/upi.h

INC = \
	${MSINC} \
	${MIINC} \
	${SHAREINC} \
	${PCDOTHS}


all:	install

# PCRULES BEGIN HERE
# Don't edit these lines, compose uses them
../drivers/ie/${HOW}/ethProtl.o:	../drivers/ie/ethProtl.c
	@${CCO} ../drivers/ie/ethProtl ../drivers/ie/${HOW}/ethProtl $(CFLAGS)
../drivers/ie/${HOW}/intelEth.o:	../drivers/ie/intelEth.c
	@${CCO} ../drivers/ie/intelEth ../drivers/ie/${HOW}/intelEth $(CFLAGS)
../drivers/ie/${HOW}/intelEthCmd.o:	../drivers/ie/intelEthCmd.c
	@${CCO} ../drivers/ie/intelEthCmd ../drivers/ie/${HOW}/intelEthCmd $(CFLAGS)
../drivers/ie/${HOW}/intelEthI_s.o:	../drivers/ie/intelEthI_s.S
	@${CSO} ../drivers/ie/intelEthI_s ../drivers/ie/${HOW}/intelEthI_s $(CPPFLAGS)
../drivers/ie/${HOW}/intelEthRcv.o:	../drivers/ie/intelEthRcv.c
	@${CCO} ../drivers/ie/intelEthRcv ../drivers/ie/${HOW}/intelEthRcv $(CFLAGS)
../drivers/ie/${HOW}/intelEthXmit.o:	../drivers/ie/intelEthXmit.c
	@${CCO} ../drivers/ie/intelEthXmit ../drivers/ie/${HOW}/intelEthXmit $(CFLAGS)
../protocols/${HOW}/arp.o:	../protocols/arp.c
	@${CCO} ../protocols/arp ../protocols/${HOW}/arp $(CFLAGS)
../protocols/${HOW}/ip.o:	../protocols/ip.c
	@${CCO} ../protocols/ip ../protocols/${HOW}/ip $(CFLAGS)
../protocols/${HOW}/icmp.o:	../protocols/icmp.c
	@${CCO} ../protocols/icmp ../protocols/${HOW}/icmp $(CFLAGS)
../protocols/${HOW}/udp.o:	../protocols/udp.c
	@${CCO} ../protocols/udp ../protocols/${HOW}/udp $(CFLAGS)
../protocols/${HOW}/dns.o:	../protocols/dns.c
	@${CCO} ../protocols/dns ../protocols/${HOW}/dns $(CFLAGS)
# PCRULES END HERE

../${MACHINE}/${HOW}/ms_exception.o:	../${MACHINE}/ms_exception.c
	@$(CCO) ../${MACHINE}/ms_exception ../${MACHINE}/${HOW}/ms_exception $(CFLAGS)

../${MACHINE}/${HOW}/ms_clock.o:	../${MACHINE}/ms_clock.c
	@$(CCO) ../${MACHINE}/ms_clock ../${MACHINE}/${HOW}/ms_clock $(CFLAGS)

../${MACHINE}/${HOW}/ms_misc.o:	../${MACHINE}/ms_misc.c
	@$(CCO) ../${MACHINE}/ms_misc ../${MACHINE}/${HOW}/ms_misc $(CFLAGS)

../${MACHINE}/${HOW}/ms_process.o:	../${MACHINE}/ms_process.c
	@$(CCO) ../${MACHINE}/ms_process ../${MACHINE}/${HOW}/ms_process $(CFLAGS)

../${MACHINE}/${HOW}/ms_screen.o:	../${MACHINE}/ms_screen.c
	@$(CCO) ../${MACHINE}/ms_screen ../${MACHINE}/${HOW}/ms_screen $(CFLAGS)

../${MACHINE}/${HOW}/ms_memory.o:	../${MACHINE}/ms_memory.c
	@$(CCO) ../${MACHINE}/ms_memory ../${MACHINE}/${HOW}/ms_memory $(CFLAGS)

../${MACHINE}/${HOW}/ms_romvec.o:	../${MACHINE}/ms_romvec.c
	@$(CCO) ../${MACHINE}/ms_romvec ../${MACHINE}/${HOW}/ms_romvec $(CFLAGS)

../${MACHINE}/${HOW}/ms_trap.o:	../${MACHINE}/ms_trap.c
	@$(CCO) ../${MACHINE}/ms_trap ../${MACHINE}/${HOW}/ms_trap $(CFLAGS)

../${MACHINE}/${HOW}/ms_misc_s.o:	../${MACHINE}/ms_misc_s.S
	@$(CSO) ../${MACHINE}/ms_misc_s ../${MACHINE}/${HOW}/ms_misc_s $(CPPFLAGS)

../${MACHINE}/${HOW}/ms_trap_s.o:	../${MACHINE}/ms_trap_s.S
	@$(CSO) ../${MACHINE}/ms_trap_s ../${MACHINE}/${HOW}/ms_trap_s $(CPPFLAGS)

../${MACHINE}/${HOW}/ms_exception_s.o:	../${MACHINE}/ms_exception_s.S
	@$(CSO) ../${MACHINE}/ms_exception_s ../${MACHINE}/${HOW}/ms_exception_s $(CPPFLAGS)

../${MACHINE}/${HOW}/ms_memory_s.o:	../${MACHINE}/ms_memory_s.S
	@$(CSO) ../${MACHINE}/ms_memory_s ../${MACHINE}/${HOW}/ms_memory_s $(CPPFLAGS)

../${MACHINE}/${HOW}/ms_process_s.o:	../${MACHINE}/ms_process_s.S
	@$(CSO) ../${MACHINE}/ms_process_s ../${MACHINE}/${HOW}/ms_process_s $(CPPFLAGS)

../${MACHINE}/${HOW}/ms_clock_s.o:	../${MACHINE}/ms_clock_s.S
	@$(CSO) ../${MACHINE}/ms_clock_s ../${MACHINE}/${HOW}/ms_clock_s $(CPPFLAGS)

../${MACHINE}/${HOW}/Locore.o:	../${MACHINE}/Locore.S
	@$(CSO) ../${MACHINE}/Locore ../${MACHINE}/${HOW}/Locore $(CPPFLAGS)

../mi/${HOW}/clock.o:	../mi/clock.c
	@$(CCO) ../mi/clock ../mi/${HOW}/clock $(CFLAGS)

../mi/${HOW}/profile.o:	../mi/profile.c
	@$(CCO) ../mi/profile ../mi/${HOW}/profile $(CFLAGS)

../mi/${HOW}/trap.o:	../mi/trap.c
	@$(CCO) ../mi/trap ../mi/${HOW}/trap $(CFLAGS)

../mi/${HOW}/init.o:	../mi/init.c
	@$(CCO) ../mi/init ../mi/${HOW}/init $(CFLAGS)

../mi/${HOW}/printf.o:	../mi/printf.c
	@$(CCO) ../mi/printf ../mi/${HOW}/printf $(CFLAGS)

../mi/${HOW}/process.o:	../mi/process.c
	@$(CCO) ../mi/process ../mi/${HOW}/process $(CFLAGS)

../mi/${HOW}/memory.o:	../mi/memory.c
	@$(CCO) ../mi/memory ../mi/${HOW}/memory $(CFLAGS)

../${MACHINE}/${HOW}/z_u_begin.o:	../${MACHINE}/z_u_begin.S
	@$(CSO) ../${MACHINE}/z_u_begin ../${MACHINE}/${HOW}/z_u_begin $(CPPFLAGS)
../${MACHINE}/${HOW}/z_u_end.o:	../${MACHINE}/z_u_end.S
	@$(CSO) ../${MACHINE}/z_u_end ../${MACHINE}/${HOW}/z_u_end $(CPPFLAGS)

OTHERSCCS = Makefile ms_consts.c \
	../lib/consts.awk ../lib/cscope.awk ../lib/number.awk \
	../lib/prop.awk ../lib/sizes.awk

.SCCS_GET:;
.S.o:;	@${CSO} $* `dirname $*`/${HOW}/`basename $*` $(CPPFLAGS)

.c.o:;	@${CCO} $* `dirname $*`/${HOW}/`basename $*` $(CFLAGS)

.c.s:;	@${CCS} $* $(CFLAGS)

.c.xx:;	@echo cc -E $*.c; \
	cc -E $(CPPFLAGS) $*.c > $*.xx

install:	xkernel
	installboot $(MYXKN) $(DESTS)

xkernel:	$(OBJ)
	@echo linking xkernel ...
	@${LD} -N -T 0f004000 -o xkernel $(OBJ) $(GNULIB) $(CLIB)

compose: graph.comp
	../bin/compose_${MACHINE}${ARCH} <graph.comp
	cp -p Makefile Makefile.bak
	sed -f protocols.sed <Makefile | sed -e '/^@/s/^/	/' >Maketemp
	cp Maketemp Makefile
	rm Maketemp protocols.sed

User/user:	User/*.c ../${MACHINE}/ms_consts.h
	cd User ; make user MACHINE=${MACHINE} CLIB=${CLIB}

${HOW}/z_u_body.o:	User/user
	rm -f ${HOW}/z_u_body.o
	cp User/user ${HOW}/z_u_body.o
	../bin/fixDoto_${MACHINE}${ARCH} ${HOW}/z_u_body.o

${HOW}/localinit.o:	localinit.c
	@${CCO} localinit ${HOW}/localinit ${CFLAGS}

${HOW}/protocols.o:	protocols.c
	@${CCO} protocols ${HOW}/protocols ${CFLAGS}

dotodirs:
	-if [ ! -d ../share/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../share/DEBUG$(MACHINE) ; fi;
	-if [ ! -d ../share/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../share/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d ../mi/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../mi/DEBUG$(MACHINE) ; fi;
	-if [ ! -d ../mi/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../mi/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d ../${MACHINE}/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../${MACHINE}/DEBUG$(MACHINE) ; fi
	-if [ ! -d ../${MACHINE}/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../${MACHINE}/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d ../protocols/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../protocols/DEBUG$(MACHINE) ; fi
	-if [ ! -d ../protocols/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../protocols/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d DEBUG$(MACHINE) ] ; then umask 2; mkdir DEBUG$(MACHINE) ; fi
	-if [ ! -d OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir OPTIMIZE$(MACHINE) ; fi
	-for dir in $(PRIVOBJ) $(PCDOTOS) ; do \
	    XX=`echo $$dir | sed -e '/\//s,/[^/]*$$,,'` ; \
	    if [ ! -d $$XX ] ; then umask 2 ; mkdir $$XX ; fi ; \
	 done


setup:	dotodirs
	cp ../mi/localinit.c . ; chmod +w localinit.c
	-if [ ! -d User ] ; then mkdir User ; fi
	cp ../sun3/User/Makefile User/Makefile

src source sources:
	@echo $(SRC)

obj:
	@echo $(OBJ)

includes include:
	@echo $(INC)

othersccs:
	@echo $(OTHERSCCS)

lint:
	@echo "Running lint"
	@lint -hbxuzn ${CPPFLAGS} ${SRC} | \
		egrep -v 'possible pointer alignment problem|questionable conversion of function pointer'

map:	xkernel
	nm -n xkernel | ../bin/loadmap > map

tags:	../${MACHINE}/ms_consts.h $(SRC) $(INC)
	@ctags -tw $(SRC) $(INC) ../${MACHINE}/ms_consts.h

cleanjunk:
	@echo Removing dotss ...
	@rm -f  *.c2 *.ccom *.cpp *.bak *.ckp *.ss all.* cscope.dep \
	    cscope.out cscope.tsort routines.sizes routines.list \
	    allnames.dep ${ASM}

clean:	cleanjunk
	@echo Removing dotos ...
	@rm -f $(OBJ)
	cd User; make clean

G = xkernel
GREP = egrep
grep:
	-@$(GREP) -n -e "$G" ../${MACHINE}/ms_consts.h $(INC) $(SRC) ../lib/xkernel.il

depend:	${SRC} ${SUNSRCS}
	@rm -f makedepsed
	@-for name in $(SRC) $(SUNSRCS) ; do \
	    xxx=`basename $$name .c`; \
	    yyy=`dirname $$name`; \
	    echo "s+^$$xxx.o:+$$yyy/\$${HOW}/$$xxx.o:+" >> makedepsed ; \
	 done
	@cc -M $(CFLAGS) $(SRC) | sed -f makedepsed > makedep
	@rm -f makedepsed
	@echo '$$r makedep' > eddep
	@echo '/^# DO NOT DELETE THIS LINE/+1,$$d' >>eddep
	@echo '$$r makedep' >>eddep
	@echo 'w' >>eddep
	@cp Makefile Makefile.bak
	@ex - Makefile < eddep
	@rm eddep makedep

../share/${HOW}/debug.o:	../share/debug.c
	@${CCO} ../share/debug ../share/${HOW}/debug $(CFLAGS)
../share/${HOW}/idmap.o:	../share/idmap.c
	@${CCO} ../share/idmap ../share/${HOW}/idmap $(CFLAGS)
../share/${HOW}/event.o:	../share/event.c
	@${CCO} ../share/event ../share/${HOW}/event $(CFLAGS)
../share/${HOW}/message.o:	../share/message.c
	@${CCO} ../share/message ../share/${HOW}/message $(CFLAGS)
../share/${HOW}/nmessage.o:	../share/nmessage.c
	@${CCO} ../share/nmessage ../share/${HOW}/nmessage $(CFLAGS)
../share/${HOW}/alloc.o:	../share/alloc.c
	@${CCO} ../share/alloc ../share/${HOW}/alloc $(CFLAGS)
../share/${HOW}/upi.o:	../share/upi.c
	@${CCO} ../share/upi ../share/${HOW}/upi $(CFLAGS)

# DO NOT DELETE THIS LINE -- make depend uses it
../share/${HOW}/alloc.o: ../share/alloc.c
../share/${HOW}/alloc.o: ../share/assert.h
../share/${HOW}/alloc.o: ../mi/process.h
../share/${HOW}/alloc.o: ../share/system.h
../share/${HOW}/alloc.o: ../share/debug.h
../share/${HOW}/alloc.o: ../mi/memory.h
../share/${HOW}/alloc.o: ../sun3/ms_memory.h
../share/${HOW}/alloc.o: ../sun3/ms_inline.h
../share/${HOW}/alloc.o: ../sun3/ms_process.h
../share/${HOW}/alloc.o: ../sun3/ms_exception.h
../share/${HOW}/alloc.o: ../share/upi.h
../share/${HOW}/alloc.o: ../share/idmap.h
../share/${HOW}/alloc.o: ../share/message.h
../share/${HOW}/alloc.o: ../share/nmessage.h
../share/${HOW}/debug.o: ../share/debug.c
../share/${HOW}/debug.o: ../share/debug.h
../share/${HOW}/debug.o: ../mi/process.h
../share/${HOW}/debug.o: ../share/system.h
../share/${HOW}/debug.o: ../share/debug.h
../share/${HOW}/debug.o: ../mi/memory.h
../share/${HOW}/debug.o: ../sun3/ms_memory.h
../share/${HOW}/debug.o: ../sun3/ms_inline.h
../share/${HOW}/debug.o: ../sun3/ms_process.h
../share/${HOW}/debug.o: ../sun3/ms_exception.h
../share/${HOW}/debug.o: ../share/upi.h
../share/${HOW}/debug.o: ../share/idmap.h
../share/${HOW}/debug.o: ../share/message.h
../share/${HOW}/debug.o: ../share/nmessage.h
../share/${HOW}/debug.o: ../share/assert.h
../share/${HOW}/event.o: ../share/event.c
../share/${HOW}/event.o: ../share/debug.h
../share/${HOW}/event.o: ../share/upi.h
../share/${HOW}/event.o: ../share/idmap.h
../share/${HOW}/event.o: ../share/message.h
../share/${HOW}/event.o: ../share/nmessage.h
../share/${HOW}/event.o: ../share/assert.h
../share/${HOW}/event.o: ../share/system.h
../share/${HOW}/event.o: ../share/debug.h
../share/${HOW}/event.o: ../mi/process.h
../share/${HOW}/event.o: ../mi/memory.h
../share/${HOW}/event.o: ../sun3/ms_memory.h
../share/${HOW}/event.o: ../sun3/ms_inline.h
../share/${HOW}/event.o: ../sun3/ms_process.h
../share/${HOW}/event.o: ../sun3/ms_exception.h
../share/${HOW}/idmap.o: ../share/idmap.c
../share/${HOW}/idmap.o: ../share/idmap.h
../share/${HOW}/idmap.o: ../share/idmap_internal.h
../share/${HOW}/idmap.o: ../share/upi.h
../share/${HOW}/idmap.o: ../share/message.h
../share/${HOW}/idmap.o: ../share/nmessage.h
../share/${HOW}/idmap.o: ../share/assert.h
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_templ.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/idmap.o: ../share/idmap_init.c
../share/${HOW}/message.o: ../share/message.c
../share/${HOW}/message.o: ../share/system.h
../share/${HOW}/message.o: ../share/debug.h
../share/${HOW}/message.o: ../share/message.h
../share/${HOW}/message.o: ../share/nmessage.h
../share/${HOW}/message.o: ../share/assert.h
../share/${HOW}/message.o: ../share/meta.h
../share/${HOW}/nmessage.o: ../share/nmessage.c
../share/${HOW}/nmessage.o: ../share/system.h
../share/${HOW}/nmessage.o: ../share/debug.h
../share/${HOW}/nmessage.o: ../share/nmessage.h
../share/${HOW}/nmessage.o: ../share/assert.h
../share/${HOW}/nmessage.o: ../share/assert.h
../share/${HOW}/upi.o: ../share/upi.c
../share/${HOW}/upi.o: /usr/include/varargs.h
../share/${HOW}/upi.o: ../share/upi.h
../share/${HOW}/upi.o: ../share/idmap.h
../share/${HOW}/upi.o: ../share/message.h
../share/${HOW}/upi.o: ../share/nmessage.h
../share/${HOW}/upi.o: ../share/assert.h
../share/${HOW}/upi.o: ../share/system.h
../share/${HOW}/upi.o: ../share/debug.h
../share/${HOW}/upi.o: ../mi/process.h
../share/${HOW}/upi.o: ../mi/memory.h
../share/${HOW}/upi.o: ../sun3/ms_memory.h
../share/${HOW}/upi.o: ../sun3/ms_inline.h
../share/${HOW}/upi.o: ../sun3/ms_process.h
../share/${HOW}/upi.o: ../sun3/ms_exception.h
../share/${HOW}/upi.o: ../mi/memory.h
../sun3/${HOW}/ms_exception.o: ../sun3/ms_exception.c
../sun3/${HOW}/ms_exception.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_exception.o: ../share/system.h
../sun3/${HOW}/ms_exception.o: ../share/debug.h
../sun3/${HOW}/ms_exception.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_exception.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_exception.o: ../share/system.h
../sun3/${HOW}/ms_exception.o: ../mi/process.h
../sun3/${HOW}/ms_exception.o: ../mi/memory.h
../sun3/${HOW}/ms_exception.o: ../sun3/ms_process.h
../sun3/${HOW}/ms_exception.o: ../share/upi.h
../sun3/${HOW}/ms_exception.o: ../share/idmap.h
../sun3/${HOW}/ms_exception.o: ../share/message.h
../sun3/${HOW}/ms_exception.o: ../share/nmessage.h
../sun3/${HOW}/ms_exception.o: ../share/assert.h
../sun3/${HOW}/ms_exception.o: ../mi/memory.h
../sun3/${HOW}/ms_clock.o: ../sun3/ms_clock.c
../sun3/${HOW}/ms_clock.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_clock.o: ../share/system.h
../sun3/${HOW}/ms_clock.o: ../share/debug.h
../sun3/${HOW}/ms_clock.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_clock.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_clock.o: ../sun3/ms_clock.h
../sun3/${HOW}/ms_clock.o: ../mi/unixtime.h
../sun3/${HOW}/ms_clock.o: ../share/upi.h
../sun3/${HOW}/ms_clock.o: ../share/idmap.h
../sun3/${HOW}/ms_clock.o: ../share/message.h
../sun3/${HOW}/ms_clock.o: ../share/nmessage.h
../sun3/${HOW}/ms_clock.o: ../share/assert.h
../sun3/${HOW}/ms_clock.o: ../mi/clock.h
../sun3/${HOW}/ms_process.o: ../sun3/ms_process.c
../sun3/${HOW}/ms_process.o: ../mi/process.h
../sun3/${HOW}/ms_process.o: ../share/system.h
../sun3/${HOW}/ms_process.o: ../share/debug.h
../sun3/${HOW}/ms_process.o: ../mi/memory.h
../sun3/${HOW}/ms_process.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_process.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_process.o: ../sun3/ms_process.h
../sun3/${HOW}/ms_process.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_process.o: ../share/upi.h
../sun3/${HOW}/ms_process.o: ../share/idmap.h
../sun3/${HOW}/ms_process.o: ../share/message.h
../sun3/${HOW}/ms_process.o: ../share/nmessage.h
../sun3/${HOW}/ms_process.o: ../share/assert.h
../sun3/${HOW}/ms_process.o: ../mi/memory.h
../sun3/${HOW}/ms_process.o: ../share/assert.h
../sun3/${HOW}/ms_screen.o: ../sun3/ms_screen.c
../sun3/${HOW}/ms_screen.o: ../share/assert.h
../sun3/${HOW}/ms_screen.o: ../share/debug.h
../sun3/${HOW}/ms_screen.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_screen.o: ../share/system.h
../sun3/${HOW}/ms_screen.o: ../share/debug.h
../sun3/${HOW}/ms_screen.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_screen.o: ../sun3/ms_romvec.h
../sun3/${HOW}/ms_screen.o: ../sun3/ms_screen.h
../sun3/${HOW}/ms_memory.o: ../sun3/ms_memory.c
../sun3/${HOW}/ms_memory.o: ../mi/process.h
../sun3/${HOW}/ms_memory.o: ../share/system.h
../sun3/${HOW}/ms_memory.o: ../share/debug.h
../sun3/${HOW}/ms_memory.o: ../mi/memory.h
../sun3/${HOW}/ms_memory.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_memory.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_memory.o: ../sun3/ms_process.h
../sun3/${HOW}/ms_memory.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_memory.o: ../share/upi.h
../sun3/${HOW}/ms_memory.o: ../share/idmap.h
../sun3/${HOW}/ms_memory.o: ../share/message.h
../sun3/${HOW}/ms_memory.o: ../share/nmessage.h
../sun3/${HOW}/ms_memory.o: ../share/assert.h
../sun3/${HOW}/ms_memory.o: ../mi/memory.h
../sun3/${HOW}/ms_memory.o: ../share/assert.h
../sun3/${HOW}/ms_trap.o: ../sun3/ms_trap.c
../sun3/${HOW}/ms_trap.o: ../mi/process.h
../sun3/${HOW}/ms_trap.o: ../share/system.h
../sun3/${HOW}/ms_trap.o: ../share/debug.h
../sun3/${HOW}/ms_trap.o: ../mi/memory.h
../sun3/${HOW}/ms_trap.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_trap.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_trap.o: ../sun3/ms_process.h
../sun3/${HOW}/ms_trap.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_trap.o: ../share/upi.h
../sun3/${HOW}/ms_trap.o: ../share/idmap.h
../sun3/${HOW}/ms_trap.o: ../share/message.h
../sun3/${HOW}/ms_trap.o: ../share/nmessage.h
../sun3/${HOW}/ms_trap.o: ../share/assert.h
../sun3/${HOW}/ms_trap.o: ../mi/memory.h
../sun3/${HOW}/ms_misc.o: ../sun3/ms_misc.c
../sun3/${HOW}/ms_misc.o: ../mi/process.h
../sun3/${HOW}/ms_misc.o: ../share/system.h
../sun3/${HOW}/ms_misc.o: ../share/debug.h
../sun3/${HOW}/ms_misc.o: ../mi/memory.h
../sun3/${HOW}/ms_misc.o: ../sun3/ms_memory.h
../sun3/${HOW}/ms_misc.o: ../sun3/ms_inline.h
../sun3/${HOW}/ms_misc.o: ../sun3/ms_process.h
../sun3/${HOW}/ms_misc.o: ../sun3/ms_exception.h
../sun3/${HOW}/ms_misc.o: ../share/upi.h
../sun3/${HOW}/ms_misc.o: ../share/idmap.h
../sun3/${HOW}/ms_misc.o: ../share/message.h
../sun3/${HOW}/ms_misc.o: ../share/nmessage.h
../sun3/${HOW}/ms_misc.o: ../share/assert.h
../sun3/${HOW}/ms_misc.o: ../mi/memory.h
../sun3/${HOW}/ms_romvec.o: ../sun3/ms_romvec.c
../sun3/${HOW}/ms_romvec.o: ../sun3/ms_romvec.h
../mi/${HOW}/init.o: ../mi/init.c
../mi/${HOW}/init.o: ../mi/process.h
../mi/${HOW}/init.o: ../share/system.h
../mi/${HOW}/init.o: ../share/debug.h
../mi/${HOW}/init.o: ../mi/memory.h
../mi/${HOW}/init.o: ../sun3/ms_memory.h
../mi/${HOW}/init.o: ../sun3/ms_inline.h
../mi/${HOW}/init.o: ../sun3/ms_process.h
../mi/${HOW}/init.o: ../sun3/ms_exception.h
../mi/${HOW}/init.o: ../share/upi.h
../mi/${HOW}/init.o: ../share/idmap.h
../mi/${HOW}/init.o: ../share/message.h
../mi/${HOW}/init.o: ../share/nmessage.h
../mi/${HOW}/init.o: ../share/assert.h
../mi/${HOW}/init.o: ../mi/memory.h
../mi/${HOW}/init.o: ../mi/trap.h
../mi/${HOW}/init.o: ../mi/clock.h
../mi/${HOW}/init.o: ../sun3/ms_romvec.h
../mi/${HOW}/init.o: ../sun3/ms_exception.h
../mi/${HOW}/printf.o: ../mi/printf.c
../mi/${HOW}/printf.o: ../sun3/ms_screen.h
../mi/${HOW}/process.o: ../mi/process.c
../mi/${HOW}/process.o: ../mi/process.h
../mi/${HOW}/process.o: ../share/system.h
../mi/${HOW}/process.o: ../share/debug.h
../mi/${HOW}/process.o: ../mi/memory.h
../mi/${HOW}/process.o: ../sun3/ms_memory.h
../mi/${HOW}/process.o: ../sun3/ms_inline.h
../mi/${HOW}/process.o: ../sun3/ms_process.h
../mi/${HOW}/process.o: ../sun3/ms_exception.h
../mi/${HOW}/process.o: ../share/upi.h
../mi/${HOW}/process.o: ../share/idmap.h
../mi/${HOW}/process.o: ../share/message.h
../mi/${HOW}/process.o: ../share/nmessage.h
../mi/${HOW}/process.o: ../share/assert.h
../mi/${HOW}/process.o: ../mi/memory.h
../mi/${HOW}/memory.o: ../mi/memory.c
../mi/${HOW}/memory.o: ../mi/process.h
../mi/${HOW}/memory.o: ../share/system.h
../mi/${HOW}/memory.o: ../share/debug.h
../mi/${HOW}/memory.o: ../mi/memory.h
../mi/${HOW}/memory.o: ../sun3/ms_memory.h
../mi/${HOW}/memory.o: ../sun3/ms_inline.h
../mi/${HOW}/memory.o: ../sun3/ms_process.h
../mi/${HOW}/memory.o: ../sun3/ms_exception.h
../mi/${HOW}/memory.o: ../share/upi.h
../mi/${HOW}/memory.o: ../share/idmap.h
../mi/${HOW}/memory.o: ../share/message.h
../mi/${HOW}/memory.o: ../share/nmessage.h
../mi/${HOW}/memory.o: ../share/assert.h
../mi/${HOW}/memory.o: ../mi/memory.h
../mi/${HOW}/clock.o: ../mi/clock.c
../mi/${HOW}/trap.o: ../mi/trap.c
../mi/${HOW}/trap.o: ../share/xkernel.h
../mi/${HOW}/trap.o: ../share/upi.h
../mi/${HOW}/trap.o: ../share/idmap.h
../mi/${HOW}/trap.o: ../share/message.h
../mi/${HOW}/trap.o: ../share/nmessage.h
../mi/${HOW}/trap.o: ../share/assert.h
../mi/${HOW}/trap.o: ../share/system.h
../mi/${HOW}/trap.o: ../share/debug.h
../mi/${HOW}/trap.o: ../share/debug.h
../mi/${HOW}/trap.o: ../mi/process.h
../mi/${HOW}/trap.o: ../mi/memory.h
../mi/${HOW}/trap.o: ../sun3/ms_memory.h
../mi/${HOW}/trap.o: ../sun3/ms_inline.h
../mi/${HOW}/trap.o: ../sun3/ms_process.h
../mi/${HOW}/trap.o: ../sun3/ms_exception.h
../mi/${HOW}/trap.o: ../share/assert.h
../mi/${HOW}/trap.o: ../protocols/site.h
../mi/${HOW}/trap.o: ../mi/unixtime.h
../mi/${HOW}/trap.o: ../mi/clock.h
../mi/${HOW}/trap.o: ../share/meta.h
../mi/${HOW}/trap.o: ../mi/memory.h
../mi/${HOW}/trap.o: ../sun3/ms_trap.h
../mi/${HOW}/trap.o: ../sun3/ms_consts.h
../mi/${HOW}/profile.o: ../mi/profile.c
../mi/${HOW}/profile.o: ../mi/process.h
../mi/${HOW}/profile.o: ../share/system.h
../mi/${HOW}/profile.o: ../share/debug.h
../mi/${HOW}/profile.o: ../mi/memory.h
../mi/${HOW}/profile.o: ../sun3/ms_memory.h
../mi/${HOW}/profile.o: ../sun3/ms_inline.h
../mi/${HOW}/profile.o: ../sun3/ms_process.h
../mi/${HOW}/profile.o: ../sun3/ms_exception.h
../mi/${HOW}/profile.o: ../share/upi.h
../mi/${HOW}/profile.o: ../share/idmap.h
../mi/${HOW}/profile.o: ../share/message.h
../mi/${HOW}/profile.o: ../share/nmessage.h
../mi/${HOW}/profile.o: ../share/assert.h
../mi/${HOW}/profile.o: ../mi/memory.h
../mi/${HOW}/profile.o: ../mi/trap.h
./${HOW}/localinit.o: localinit.c
./${HOW}/localinit.o: ../share/debug.h
./${HOW}/localinit.o: ./protocols.h
./${HOW}/protocols.o: protocols.c
./${HOW}/protocols.o: ../share/upi.h
./${HOW}/protocols.o: ../share/idmap.h
./${HOW}/protocols.o: ../share/message.h
./${HOW}/protocols.o: ../share/nmessage.h
./${HOW}/protocols.o: ../share/assert.h
./${HOW}/protocols.o: ./protocols.h
../drivers/ie/${HOW}/ethProtl.o: ../drivers/ie/ethProtl.c
../drivers/ie/${HOW}/ethProtl.o: ../share/xkernel.h
../drivers/ie/${HOW}/ethProtl.o: ../share/upi.h
../drivers/ie/${HOW}/ethProtl.o: ../share/idmap.h
../drivers/ie/${HOW}/ethProtl.o: ../share/message.h
../drivers/ie/${HOW}/ethProtl.o: ../share/nmessage.h
../drivers/ie/${HOW}/ethProtl.o: ../share/assert.h
../drivers/ie/${HOW}/ethProtl.o: ../share/system.h
../drivers/ie/${HOW}/ethProtl.o: ../share/debug.h
../drivers/ie/${HOW}/ethProtl.o: ../share/debug.h
../drivers/ie/${HOW}/ethProtl.o: ../mi/process.h
../drivers/ie/${HOW}/ethProtl.o: ../mi/memory.h
../drivers/ie/${HOW}/ethProtl.o: ../sun3/ms_memory.h
../drivers/ie/${HOW}/ethProtl.o: ../sun3/ms_inline.h
../drivers/ie/${HOW}/ethProtl.o: ../sun3/ms_process.h
../drivers/ie/${HOW}/ethProtl.o: ../sun3/ms_exception.h
../drivers/ie/${HOW}/ethProtl.o: ../share/assert.h
../drivers/ie/${HOW}/ethProtl.o: ../protocols/site.h
../drivers/ie/${HOW}/ethProtl.o: ../mi/unixtime.h
../drivers/ie/${HOW}/ethProtl.o: ../mi/clock.h
../drivers/ie/${HOW}/ethProtl.o: ../protocols/ethernet.h
../drivers/ie/${HOW}/ethProtl.o: ../protocols/ethernet_internal.h
../drivers/ie/${HOW}/intelEth.o: ../drivers/ie/intelEth.c
../drivers/ie/${HOW}/intelEth.o: ../share/xkernel.h
../drivers/ie/${HOW}/intelEth.o: ../share/upi.h
../drivers/ie/${HOW}/intelEth.o: ../share/idmap.h
../drivers/ie/${HOW}/intelEth.o: ../share/message.h
../drivers/ie/${HOW}/intelEth.o: ../share/nmessage.h
../drivers/ie/${HOW}/intelEth.o: ../share/assert.h
../drivers/ie/${HOW}/intelEth.o: ../share/system.h
../drivers/ie/${HOW}/intelEth.o: ../share/debug.h
../drivers/ie/${HOW}/intelEth.o: ../share/debug.h
../drivers/ie/${HOW}/intelEth.o: ../mi/process.h
../drivers/ie/${HOW}/intelEth.o: ../mi/memory.h
../drivers/ie/${HOW}/intelEth.o: ../sun3/ms_memory.h
../drivers/ie/${HOW}/intelEth.o: ../sun3/ms_inline.h
../drivers/ie/${HOW}/intelEth.o: ../sun3/ms_process.h
../drivers/ie/${HOW}/intelEth.o: ../sun3/ms_exception.h
../drivers/ie/${HOW}/intelEth.o: ../share/assert.h
../drivers/ie/${HOW}/intelEth.o: ../protocols/site.h
../drivers/ie/${HOW}/intelEth.o: ../mi/unixtime.h
../drivers/ie/${HOW}/intelEth.o: ../mi/clock.h
../drivers/ie/${HOW}/intelEth.o: ./eth.h
../drivers/ie/${HOW}/intelEth.o: ../drivers/ie/intelEthType.h
../drivers/ie/${HOW}/intelEth.o: ../drivers/ie/intelEthRcv.h
../drivers/ie/${HOW}/intelEth.o: ../drivers/ie/intelEthCmd.h
../drivers/ie/${HOW}/intelEth.o: ../drivers/ie/intelEth.h
../drivers/ie/${HOW}/intelEthCmd.o: ../drivers/ie/intelEthCmd.c
../drivers/ie/${HOW}/intelEthCmd.o: ../share/xkernel.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/upi.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/idmap.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/message.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/nmessage.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/system.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthCmd.o: ../mi/process.h
../drivers/ie/${HOW}/intelEthCmd.o: ../mi/memory.h
../drivers/ie/${HOW}/intelEthCmd.o: ../sun3/ms_memory.h
../drivers/ie/${HOW}/intelEthCmd.o: ../sun3/ms_inline.h
../drivers/ie/${HOW}/intelEthCmd.o: ../sun3/ms_process.h
../drivers/ie/${HOW}/intelEthCmd.o: ../sun3/ms_exception.h
../drivers/ie/${HOW}/intelEthCmd.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthCmd.o: ../protocols/site.h
../drivers/ie/${HOW}/intelEthCmd.o: ../mi/unixtime.h
../drivers/ie/${HOW}/intelEthCmd.o: ../mi/clock.h
../drivers/ie/${HOW}/intelEthCmd.o: ./eth.h
../drivers/ie/${HOW}/intelEthCmd.o: ../drivers/ie/intelEthType.h
../drivers/ie/${HOW}/intelEthCmd.o: ../drivers/ie/intelEthRcv.h
../drivers/ie/${HOW}/intelEthCmd.o: ../drivers/ie/intelEthCmd.h
../drivers/ie/${HOW}/intelEthCmd.o: ../drivers/ie/intelEth.h
../drivers/ie/${HOW}/intelEthRcv.o: ../drivers/ie/intelEthRcv.c
../drivers/ie/${HOW}/intelEthRcv.o: ../share/xkernel.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/upi.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/idmap.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/message.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/nmessage.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/system.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthRcv.o: ../mi/process.h
../drivers/ie/${HOW}/intelEthRcv.o: ../mi/memory.h
../drivers/ie/${HOW}/intelEthRcv.o: ../sun3/ms_memory.h
../drivers/ie/${HOW}/intelEthRcv.o: ../sun3/ms_inline.h
../drivers/ie/${HOW}/intelEthRcv.o: ../sun3/ms_process.h
../drivers/ie/${HOW}/intelEthRcv.o: ../sun3/ms_exception.h
../drivers/ie/${HOW}/intelEthRcv.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthRcv.o: ../protocols/site.h
../drivers/ie/${HOW}/intelEthRcv.o: ../mi/unixtime.h
../drivers/ie/${HOW}/intelEthRcv.o: ../mi/clock.h
../drivers/ie/${HOW}/intelEthRcv.o: ./eth.h
../drivers/ie/${HOW}/intelEthRcv.o: ../drivers/ie/intelEthType.h
../drivers/ie/${HOW}/intelEthRcv.o: ../drivers/ie/intelEthRcv.h
../drivers/ie/${HOW}/intelEthRcv.o: ../drivers/ie/intelEthCmd.h
../drivers/ie/${HOW}/intelEthRcv.o: ../drivers/ie/intelEth.h
../drivers/ie/${HOW}/intelEthXmit.o: ../drivers/ie/intelEthXmit.c
../drivers/ie/${HOW}/intelEthXmit.o: ../share/xkernel.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/upi.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/idmap.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/message.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/nmessage.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/system.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/debug.h
../drivers/ie/${HOW}/intelEthXmit.o: ../mi/process.h
../drivers/ie/${HOW}/intelEthXmit.o: ../mi/memory.h
../drivers/ie/${HOW}/intelEthXmit.o: ../sun3/ms_memory.h
../drivers/ie/${HOW}/intelEthXmit.o: ../sun3/ms_inline.h
../drivers/ie/${HOW}/intelEthXmit.o: ../sun3/ms_process.h
../drivers/ie/${HOW}/intelEthXmit.o: ../sun3/ms_exception.h
../drivers/ie/${HOW}/intelEthXmit.o: ../share/assert.h
../drivers/ie/${HOW}/intelEthXmit.o: ../protocols/site.h
../drivers/ie/${HOW}/intelEthXmit.o: ../mi/unixtime.h
../drivers/ie/${HOW}/intelEthXmit.o: ../mi/clock.h
../drivers/ie/${HOW}/intelEthXmit.o: ./eth.h
../drivers/ie/${HOW}/intelEthXmit.o: ../drivers/ie/intelEthType.h
../drivers/ie/${HOW}/intelEthXmit.o: ../drivers/ie/intelEthRcv.h
../drivers/ie/${HOW}/intelEthXmit.o: ../drivers/ie/intelEthCmd.h
../drivers/ie/${HOW}/intelEthXmit.o: ../drivers/ie/intelEth.h
../protocols/${HOW}/arp.o: ../protocols/arp.c
../protocols/${HOW}/arp.o: ../share/xkernel.h
../protocols/${HOW}/arp.o: ../share/upi.h
../protocols/${HOW}/arp.o: ../share/idmap.h
../protocols/${HOW}/arp.o: ../share/message.h
../protocols/${HOW}/arp.o: ../share/nmessage.h
../protocols/${HOW}/arp.o: ../share/assert.h
../protocols/${HOW}/arp.o: ../share/system.h
../protocols/${HOW}/arp.o: ../share/debug.h
../protocols/${HOW}/arp.o: ../share/debug.h
../protocols/${HOW}/arp.o: ../mi/process.h
../protocols/${HOW}/arp.o: ../mi/memory.h
../protocols/${HOW}/arp.o: ../sun3/ms_memory.h
../protocols/${HOW}/arp.o: ../sun3/ms_inline.h
../protocols/${HOW}/arp.o: ../sun3/ms_process.h
../protocols/${HOW}/arp.o: ../sun3/ms_exception.h
../protocols/${HOW}/arp.o: ../share/assert.h
../protocols/${HOW}/arp.o: ../protocols/site.h
../protocols/${HOW}/arp.o: ../mi/unixtime.h
../protocols/${HOW}/arp.o: ../mi/clock.h
../protocols/${HOW}/arp.o: ./eth.h
../protocols/${HOW}/arp.o: ../protocols/ip.h
../protocols/${HOW}/arp.o: ../protocols/arp.h
../protocols/${HOW}/arp.o: ../protocols/arp_internal.h
../protocols/${HOW}/ip.o: ../protocols/ip.c
../protocols/${HOW}/ip.o: ../share/xkernel.h
../protocols/${HOW}/ip.o: ../share/upi.h
../protocols/${HOW}/ip.o: ../share/idmap.h
../protocols/${HOW}/ip.o: ../share/message.h
../protocols/${HOW}/ip.o: ../share/nmessage.h
../protocols/${HOW}/ip.o: ../share/assert.h
../protocols/${HOW}/ip.o: ../share/system.h
../protocols/${HOW}/ip.o: ../share/debug.h
../protocols/${HOW}/ip.o: ../share/debug.h
../protocols/${HOW}/ip.o: ../mi/process.h
../protocols/${HOW}/ip.o: ../mi/memory.h
../protocols/${HOW}/ip.o: ../sun3/ms_memory.h
../protocols/${HOW}/ip.o: ../sun3/ms_inline.h
../protocols/${HOW}/ip.o: ../sun3/ms_process.h
../protocols/${HOW}/ip.o: ../sun3/ms_exception.h
../protocols/${HOW}/ip.o: ../share/assert.h
../protocols/${HOW}/ip.o: ../protocols/site.h
../protocols/${HOW}/ip.o: ../mi/unixtime.h
../protocols/${HOW}/ip.o: ../mi/clock.h
../protocols/${HOW}/ip.o: ./eth.h
../protocols/${HOW}/ip.o: ../protocols/ip.h
../protocols/${HOW}/ip.o: ../protocols/ip_internal.h
../protocols/${HOW}/ip.o: ../protocols/icmp.h
../protocols/${HOW}/ip.o: ../protocols/arp.h
../protocols/${HOW}/icmp.o: ../protocols/icmp.c
../protocols/${HOW}/icmp.o: ../share/xkernel.h
../protocols/${HOW}/icmp.o: ../share/upi.h
../protocols/${HOW}/icmp.o: ../share/idmap.h
../protocols/${HOW}/icmp.o: ../share/message.h
../protocols/${HOW}/icmp.o: ../share/nmessage.h
../protocols/${HOW}/icmp.o: ../share/assert.h
../protocols/${HOW}/icmp.o: ../share/system.h
../protocols/${HOW}/icmp.o: ../share/debug.h
../protocols/${HOW}/icmp.o: ../share/debug.h
../protocols/${HOW}/icmp.o: ../mi/process.h
../protocols/${HOW}/icmp.o: ../mi/memory.h
../protocols/${HOW}/icmp.o: ../sun3/ms_memory.h
../protocols/${HOW}/icmp.o: ../sun3/ms_inline.h
../protocols/${HOW}/icmp.o: ../sun3/ms_process.h
../protocols/${HOW}/icmp.o: ../sun3/ms_exception.h
../protocols/${HOW}/icmp.o: ../share/assert.h
../protocols/${HOW}/icmp.o: ../protocols/site.h
../protocols/${HOW}/icmp.o: ../mi/unixtime.h
../protocols/${HOW}/icmp.o: ../mi/clock.h
../protocols/${HOW}/icmp.o: ../protocols/ip.h
../protocols/${HOW}/icmp.o: ../protocols/ip_internal.h
../protocols/${HOW}/icmp.o: ../protocols/icmp.h
../protocols/${HOW}/icmp.o: ../protocols/icmp_internal.h
../protocols/${HOW}/udp.o: ../protocols/udp.c
../protocols/${HOW}/udp.o: ../share/xkernel.h
../protocols/${HOW}/udp.o: ../share/upi.h
../protocols/${HOW}/udp.o: ../share/idmap.h
../protocols/${HOW}/udp.o: ../share/message.h
../protocols/${HOW}/udp.o: ../share/nmessage.h
../protocols/${HOW}/udp.o: ../share/assert.h
../protocols/${HOW}/udp.o: ../share/system.h
../protocols/${HOW}/udp.o: ../share/debug.h
../protocols/${HOW}/udp.o: ../share/debug.h
../protocols/${HOW}/udp.o: ../mi/process.h
../protocols/${HOW}/udp.o: ../mi/memory.h
../protocols/${HOW}/udp.o: ../sun3/ms_memory.h
../protocols/${HOW}/udp.o: ../sun3/ms_inline.h
../protocols/${HOW}/udp.o: ../sun3/ms_process.h
../protocols/${HOW}/udp.o: ../sun3/ms_exception.h
../protocols/${HOW}/udp.o: ../share/assert.h
../protocols/${HOW}/udp.o: ../protocols/site.h
../protocols/${HOW}/udp.o: ../mi/unixtime.h
../protocols/${HOW}/udp.o: ../mi/clock.h
../protocols/${HOW}/udp.o: ../protocols/ip.h
../protocols/${HOW}/udp.o: ../protocols/udp.h
../protocols/${HOW}/udp.o: ../protocols/udp_internal.h
../protocols/${HOW}/dns.o: ../protocols/dns.c
../protocols/${HOW}/dns.o: ../share/xkernel.h
../protocols/${HOW}/dns.o: ../share/upi.h
../protocols/${HOW}/dns.o: ../share/idmap.h
../protocols/${HOW}/dns.o: ../share/message.h
../protocols/${HOW}/dns.o: ../share/nmessage.h
../protocols/${HOW}/dns.o: ../share/assert.h
../protocols/${HOW}/dns.o: ../share/system.h
../protocols/${HOW}/dns.o: ../share/debug.h
../protocols/${HOW}/dns.o: ../share/debug.h
../protocols/${HOW}/dns.o: ../mi/process.h
../protocols/${HOW}/dns.o: ../mi/memory.h
../protocols/${HOW}/dns.o: ../sun3/ms_memory.h
../protocols/${HOW}/dns.o: ../sun3/ms_inline.h
../protocols/${HOW}/dns.o: ../sun3/ms_process.h
../protocols/${HOW}/dns.o: ../sun3/ms_exception.h
../protocols/${HOW}/dns.o: ../share/assert.h
../protocols/${HOW}/dns.o: ../protocols/site.h
../protocols/${HOW}/dns.o: ../mi/unixtime.h
../protocols/${HOW}/dns.o: ../mi/clock.h
../protocols/${HOW}/dns.o: ../protocols/ip.h
../protocols/${HOW}/dns.o: ../protocols/udp.h
../protocols/${HOW}/dns.o: ../protocols/dns.h
../protocols/${HOW}/dns.o: ../protocols/dns_internal.h
../protocols/${HOW}/dns.o: ../mi/unixtime.h
E 1
