/*
 * testsim.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "dns.h"

static Protl IP, ETH, DNS;

user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr;
  ETHhost eaddr;
  struct resolve_result r;
  int sz;

  printf("simulated x-kernel booted successfully\n\n");
  IP = xgetprotlbyname("ip");
  ETH = xgetprotlbyname("eth");
  DNS = xgetprotlbyname("dns");

  if (xcontrolprotl(ETH, GETMYADDR, &eaddr, 6) != 6) {
    printf("Cannot get my own ethernet address\n");
    return;
  } else {
    printf("Simulated Ethernet Address = %x.%x.%x\n",
      eaddr.high,eaddr.mid,eaddr.low);
  }

  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, 
		    sizeof(IPhost)) != sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("Simulated IP Address = %d.%d.%d.%d\n",
      ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
    sprintf((char* )&r, "%d.%d.%d.%d",ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }
}
