/* 
 * cache.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#define DEFININGCACHE
#include "upi.h"

#define STRUCT cache_elem
#define CACHE_CREATE cache_create
#define CACHE_LOOKUP cache_lookup
#define CACHE_DELETE cache_delete
#define CACHE_INSERT cache_insert
#define CACHE_CLOSE cache_close
#define CACHE_SIZE cache_size
#define CACHE_FLUSH cache_flush

#define KEYSIZE 8
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); }

#define HIT 1
#define MISS 0
#define SPILL 0 

#include "cachetemplate.c"
