h45228
s 00118/00130/00196
d D 1.2 91/01/10 11:22:32 llp 2 1
c Prepared for 3.1 Distribution
e
s 00326/00000/00000
d D 1.1 89/10/24 13:46:41 norm 1 0
c date and time created 89/10/24 13:46:41 by norm
e
u
U
f e 0
t
T
I 1
/* 
D 2
 * %W%  %G%
E 2
I 2
 * upi.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */
I 2

E 2
#ifndef upi_h
#define upi_h

#ifdef	XSIMUL
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <signal.h>

#define NROM 30
extern char *rom[NROM];

#else
#ifndef _TYPES_
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;
#endif
#endif

I 2
#ifndef idmap_h
#include "idmap.h"
#endif

E 2
#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE  0
#endif

#ifndef NULL
#define NULL  0
#endif

D 2
typedef	int(*PFI) ();
typedef struct session *(*PFS)();
E 2
I 2
typedef	int(*Pfi) ();
typedef struct session *(*Pfs)();
E 2

D 2
/* idmapper stuff */

#ifndef DEFININGIDMAPPER
struct map2_elem {
  int     int_id;
  struct  map2_elem *next_elem;
  char    ext_id[2];
};

struct map4_elem {
  int     int_id;
  struct  map4_elem *next_elem;
  char    ext_id[4];
};

struct map6_elem {
  int     int_id;
  struct  map6_elem *next_elem;
  char    ext_id[6];
};

struct map_elem {
  int     int_id;
  struct  map_elem *next_elem;
  char    ext_id[8];
};

struct map10_elem {
  int     int_id;
  struct  map10_elem *next_elem;
  char    ext_id[10];
};

struct map12_elem {
  int     int_id;
  struct  map12_elem *next_elem;
  char    ext_id[12];
};

struct map16_elem {
  int     int_id;
  struct  map16_elem *next_elem;
  char    ext_id[16];
};

typedef struct map2_elem *BIND2, **MAP2;
typedef struct map4_elem *BIND4, **MAP4;
typedef struct map6_elem *BIND6, **MAP6;
typedef struct map_elem *BIND, **MAP;
typedef struct map10_elem *BIND10, **MAP10;
typedef struct map12_elem *BIND12, **MAP12;
typedef struct map16_elem *BIND16, **MAP16;
typedef struct map24_elem *BIND24, **MAP24;
typedef struct map28_elem *BIND28, **MAP28;
typedef struct map32_elem *BIND32, **MAP32;
#endif

E 2
/* uniform protocol interface stuff */

#define	INIT		 0
#define	OPEN		 1
#define	OPENENABLE	 2
#define	OPENDONE	 3
#define	OPENDISABLE	 4
#define	DEMUX		 5
#define	CLOSE		 6
#define CLOSEDONE	 7
#define	PUSH		 8
#define	POP		 9
#define	CONTROLSESSN     10
#define	CONTROLPROTL     11
#define	INSTANTIATEPROTL 13
#define	CLOSEPROTL	 14
#define	NUMOPS		 15
#define NUMPROT		 200

D 2
typedef enum {Protocol,Session} xobj_type;
E 2
I 2
typedef enum {Protocol,Session} XObjType;
E 2

/* default number of down protocols or sessions */
#define STD_DOWN 5

typedef	struct	xobj	{
D 2
  xobj_type type;
E 2
I 2
  XObjType type;
E 2
  char *name;
  struct xobj *myprotl;
  int    index;
  int   *mutex;
  unsigned int protocolid;
  unsigned int instance;
  char	*state;
  char  *meta;
D 2
  struct map_elem *binding;
E 2
I 2
  struct mapelement *binding;
E 2
  int   rcnt;
  int 	kernel;
  int 	device;
  struct _Aspace *as;
D 2
  PFI	init;
  PFI 	close;
  PFI   closedone;
  PFI	open;
  PFI	opendone;
  PFI	openenable;
  PFI	opendisable;
  PFI 	demux;
  PFI 	pop;
  PFI 	push;
  PFI 	control; 
  PFI   instantiateprotl;
  PFI   getproc;
E 2
I 2
  Pfi	init;
  Pfi 	close;
  Pfi   closedone;
  Pfi	open;
  Pfi	opendone;
  Pfi	openenable;
  Pfi	opendisable;
  Pfi 	demux;
  Pfi 	pop;
  Pfi 	push;
  Pfi 	control; 
  Pfi   instantiateprotl;
  Pfi   getproc;
E 2
  struct xobj *up;
  int numdown;
  struct xobj *down[STD_DOWN];
D 2
} *XOBJ;
E 2
I 2
} *XObj;
E 2

typedef struct xobj_extid {
	int id;
	int instance;
D 2
} XOBJ_EXTID;
E 2
I 2
} XObj_EXTID;
E 2

D 2
#define ERR_XOBJ ((XOBJ) -1)
#define ERR_PROTL ((PROTL) -1)
typedef XOBJ SESSN;
typedef unsigned int PROTL;
extern XOBJ x_createxobj();
extern XOBJ x_createprotocol();
extern XOBJ x_createsessn();
extern XOBJ x_getprotlbyname();
extern XOBJ protl_tab[];
E 2
I 2
#define ERR_XOBJ ((XObj) -1)
#define ERR_PROTL ((Protl) -1)
typedef XObj Sessn;
typedef unsigned int Protl;
extern XObj x_createxobj();
extern XObj x_createprotocol();
extern XObj x_createSessn();
extern XObj x_getprotlbyname();
extern XObj protl_tab[];
E 2
extern char *protocol_names[];
extern unsigned int protl_id_tab[];
extern int noop();
D 2
extern XOBJ x_createuserprotl();
E 2
I 2
extern XObj x_createuserprotl();
E 2

/* object macros */
#define x_save_session(M,N) {(M) = (N); ((N) ? (N)->rcnt++) : 0); }
#define x_save_protocol(M,N) {(M) = (N); ((N) ? (N)->rcnt++) : 0); }
D 2
#define x_tonew(s) (((unsigned)(s) < 0x1000) ? protl_tab[s] : (XOBJ) s)
E 2
I 2
#define x_tonew(s) (((unsigned)(s) < 0x1000) ? protl_tab[s] : (XObj) s)
E 2
#define x_toold(s) (((unsigned)(s) < 0x1000) ? (s) : (s)->index)
#define x_is_session(s) ((s)->type == Session)
#define x_is_protocol(s) ((s)->type == Protocol)
#define x_is_kernel(s) ((s)->kernel)
#define x_is_device(s) ((s)->device)
#define x_myprotl(s) ((s)->myprotl)

#define x_controlsessn(O,op,buf,len) x_control(O,op,buf,len)

#define x_controlprotl(O,op,buf,len) (x_is_session(O) ? x_control(x_myprotl(O),op,buf,len) : x_control(O,op,buf,len))

/* session (don't need self) */
#define ST_INITIALIZING		((char *) 1)
#define ST_BROKEN		((char *) 2)

#include "message.h"

/* event stuff */

typedef int EVENT;
#define	EV_REMOVE	0
#define	EV_ONCE		1
#define	EV_REPEAT	2
#define EV_CREATEPROCESS	0x100

/* participant stuff */

typedef struct {
  char *address;
  int   length;
D 2
} PART;
E 2
I 2
} Part;
E 2

I 2
#define init_partlist(L, N, TYPE) { \
  int xxxxx_i; \
  for (xxxxx_i = 0; xxxxx_i < (N); xxxxx_i++) { \
    (L)[xxxxx_i].length = sizeof(TYPE); \
  } \
  (L)[(N)].address=(char *)0; \
  (L)[(N)].length=0; \
}

#define set_part(L, WHICH, VALUE) { \
  assert((L)[(WHICH)].length == sizeof(VALUE)); \
  (L)[(WHICH)].address = (char *)&(VALUE); \
}

#define get_part(L, WHICH, TYPE) ( \
  assert((L)[(WHICH)].length == sizeof(TYPE)), \
  (*(TYPE *) (L)[(WHICH)].address))

/* get_num_part is used to determine how many participants are in a
     participant list, in cases such as PSYNC where there can be more
     than 2 participants.  072390 cliff hathaway
*/
#define get_num_part(L,NUMPARTS) { \
  for ((NUMPARTS) = 0; (L)[(NUMPARTS)].length != 0; (NUMPARTS)++);\
}

#define valid_part(L, WHICH) \
  ((L)[(WHICH)].length != 0)

E 2
/* error stuff */

#define	MAP_FULL		1
#define	INCONSISTENT_BIND	2
#define	CANNOT_RESOLVE		3
#define	CANNOT_UNBIND		4
#define	INVALID_TYPE		5
#define	INVALID_OPCODE		6
#define	BUFFER_TOO_SMALL	7
#define	INVALID_EV_CODE		8
#define	EVENT_NOT_REGISTERED	9
#define	INVALID_OPEN		10
#define	ALREADY_OPEN		11
#define	BAD_ADDR		12

D 2
#define	ERR_XOBJ	((XOBJ) -1)
#define	ERR_SESSN	((SESSN) -1)
#define	ERR_MSG		((MSG) -1)
#define	ERR_PROTL	((PROTL) -1)
#define	ERR_BIND	((BIND) -1)
E 2
I 2
#define	ERR_XOBJ	((XObj) -1)
#define	ERR_SESSN	((Sessn) -1)
#define	ERR_MSG		((Msg) -1)
#define	ERR_PROTL	((Protl) -1)
#define	ERR_BIND	((Bind) -1)
E 2

extern	int x_errno;
extern char *protocol_names[];

#if !defined(ntohl) && !defined(vax)
/*
 * Macros for number representation conversion.
 */
#define	ntohl(x)	(x)
#define	ntohs(x)	(x)
#define	htonl(x)	(x)
#define	htons(x)	(x)
#endif

/* protocol and session operations */

D 2
extern	SESSN x_open(/*hlp, llp, participants*/);
E 2
I 2
extern	Sessn x_open(/*hlp, llp, participants*/);
E 2
extern	int   x_openenable(/*hlp, llp, participants*/);
D 2
extern	SESSN x_opendone(/*hlp, llp, participants*/);
E 2
I 2
extern	Sessn x_opendone(/*hlp, llp, participants*/);
E 2
extern	int   x_opendisable(/*hlp, llp, participants*/);
extern	int   x_demux(/*s, msg*/);
extern	int   x_close(/*s*/);
extern	int   x_closedone(/*s*/);
extern	int   x_push(/*s, msg, returnmsg*/);
extern	int   x_pop(/*s, deliverys, msg*/);
extern	int   x_control(/*s, opcode, buf, buflen*/);

/* internal session operations */

D 2
extern	SESSN x_createsession(/*hlp, llp*/);
E 2
I 2
extern	Sessn x_createsession(/*hlp, llp, state, binding, numdown, downs*/);
E 2
extern	int   x_destroysession(/*s*/);

/* event manager operation */
/* Note that the units of time are milliseconds */

extern	EVENT event_register(/*r, arg, interval, code*/);
extern 	int   event_remove(/*r, arg*/);
extern  int   event_removeevent(/*ev*/);

D 2
/* id mapper operations */
E 2
I 2
/* control operation definitions */
E 2

D 2
extern	struct map_elem ** map_create(/*size*/);
extern	struct map_elem *map_bind(/*table, extern, intern*/);
extern	struct map2_elem ** map2_create(/*size*/);
extern	struct map2_elem *map2_bind(/*table, extern, intern*/);
extern	struct map4_elem ** map4_create(/*size*/);
extern	struct map4_elem *map4_bind(/*table, extern, intern*/);
extern	struct map6_elem ** map6_create(/*size*/);
extern	struct map6_elem *map6_bind(/*table, extern, intern*/);
extern	struct map10_elem ** map10_create(/*size*/);
extern	struct map10_elem *map10_bind(/*table, extern, intern*/);
extern	struct map12_elem ** map12_create(/*size*/);
extern	struct map12_elem *map12_bind(/*table, extern, intern*/);
extern	struct map16_elem ** map16_create(/*size*/);
extern	struct map16_elem *map16_bind(/*table, extern, intern*/);
extern	struct map24_elem ** map24_create(/*size*/);
extern	struct map24_elem *map24_bind(/*table, extern, intern*/);
extern	struct map28_elem ** map28_create(/*size*/);
extern	struct map28_elem *map28_bind(/*table, extern, intern*/);
extern	struct map32_elem ** map32_create(/*size*/);
extern	struct map32_elem *map32_bind(/*table, extern, intern*/);
extern	int   map_resolve(/*table, extern*/);
extern	int   map_unbindbinding(/*table, binding*/);
extern	int   map_unbind(/*table, extern, intern*/);
extern	int   map_close(/*table*/);
E 2
I 2
#define	GETMYADDR	0	/* standard control operations        */
#define GETPEERADDR	1	/* common to all protocols            */
#define GETALLADDRS	2
#define GETMAXPACKET	3
#define GETOPTPACKET	4
#define GETPROTO	5
#define SETPROTO	6
#define SETDEBUG	7
#define	RESOLVE		8
#define	RRESOLVE	9
#define FREERESOURCES	10
E 2

D 2
/* standard control operations */
#define	MYADDR		0x0
#define PEERADDR	0x1
#define MAXPACKET	0x2
#define GETIPINTERFACES	0x3
#define GETIPADDRS	0x4
#define	LASTSTANDARDOP	0x10
E 2
I 2
#define	ARP_CTL		1	/* like a protocol number; used to    */
#define	BLAST_CTL	2	/* partition opcode space	      */
#define	ETH_CTL		3
#define	IP_CTL		4
#define	SCR_CTL		5
#define	VCHAN_CTL	6
#define	PSYNC_CTL	7
#define	SS_CTL		8
#define	SUNRPC_CTL	9
#define	NFS_CTL		10
#define	TCP_CTL		11

#define	TMP0_CTL	100	/* for use by new/tmp protocols until */
#define	TMP1_CTL	101	/* a standard CTL number is assigned  */
#define	TMP2_CTL	102
#define	TMP3_CTL	103
#define	TMP4_CTL	104

#define	MAXOPS		100	/* maximum number of ops per protocol */

/* Check the length of a control argument */
#define checkLen(A, B) { \
  if ((A) < (B)) { \
    x_errno = BUFFER_TOO_SMALL; \
    return -1; \
  } \
}
E 2

/* Discover the existence of a protocol */
extern int    x_probeprotl(/*stringname*/);

extern char *malloc();

#define FREE(X) (free(X), (X) = 0)

#if !defined(XSIMUL) && defined(NDEBUG)
#define x_demux(DS, M) ((DS)->up->kernel ?  \
	(((DS)->up->demux)((DS)->up,(DS), (M))) :  \
	callUserDemux((DS)->up->as,(DS)->up->demux,(DS),(M)))

#define x_push(S, M, RM) (((S)->push)((S), (M), (RM)))
#define x_pop(S, DS, M) (((S)->pop)((S), (DS), (M)))
#endif

#endif
E 1
