h48572
s 00008/00003/00143
d D 1.2 91/01/10 11:22:26 llp 2 1
c Prepared for 3.1 Distribution
e
s 00146/00000/00000
d D 1.1 89/10/24 13:46:37 norm 1 0
c date and time created 89/10/24 13:46:37 by norm
e
u
U
f e 0
t
T
I 1
D 2
/*
 * %W%  %G%
E 2
I 2
/* 
 * nmessage.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */
I 2

E 2
#ifndef assert_h
#include "assert.h"
#endif

extern void free();

typedef struct {
  int ref;
  char *ptr;
  void (*xfree)();
}      REF;

#define nmsg_makeref(M,B) { \
  (M) = (REF *) malloc(sizeof(REF)); \
  (M)->ref = 1; \
  (M)->ptr = (B); \
  (M)->xfree = free; \
}

#define nmsg_makespecialref(M,B,F) { \
  (M) = (REF *) malloc(sizeof(REF)); \
  (M)->ref = 1; \
  (M)->ptr = (B); \
D 2
  (M)->xfree = (F); \
E 2
I 2
  (M)->xfree = (void(*))(F); \
E 2
}

typedef enum {
  NM_Contig, NM_Single, NM_Pair
}    NMTAG;


typedef struct nmsg {
  NMTAG tag:16;
  unsigned short ref;
  int len;
  int off;
  union {
    struct {
      char *data;
      REF *ref;
    }      contig;
    struct nmsg *single;
    struct {
      struct nmsg *l, *r;
    }      pair;
  }     body;
}   *NMSG;

/***************************************************************
/* Message Operations
/***************************************************************/

#ifdef NDEBUG
#define nmsg_makecontig(M, N, B, R) { \
  (M) = ((NMSG)malloc((unsigned)(sizeof(struct nmsg)))); \
  (M)->tag = NM_Contig; \
  (M)->ref = 1; \
  (M)->off = 0; \
  (M)->len = (N); \
  (R)->ref++; \
  (M)->body.contig.data = (B); \
  (M)->body.contig.ref = (R); \
}
#define nmsg_createcontig(M, N) { \
  (M) = ((NMSG)malloc((unsigned)(sizeof(struct nmsg)))); \
  (M)->tag = NM_Contig; \
  (M)->ref = 1; \
  (M)->off = 0; \
  (M)->len = (N); \
  (M)->body.contig.data = (char *)malloc(N); \
  (M)->body.contig.ref = (REF *) malloc(sizeof(REF)); \
  (M)->body.contig.ref->ref = 1; \
  (M)->body.contig.ref->ptr = (M)->body.contig.data; \
  (M)->body.contig.ref->xfree = free; \
}
#define nmsg_clonecontig(r, m) { \
  nmsg_createcontig(r, (m)->len); \
  bcopy((m)->body.contig.data, (r)->body.contig.data, (r)->len); \
}
#else
extern NMSG nmsg_fcreatecontig(), nmsg_fclonecontig(), nmsg_fmakecontig();

#define nmsg_createcontig(M, N) ((M) = nmsg_fcreatecontig(N))
#define nmsg_makecontig(M, N, B, R) ((M) = nmsg_fmakecontig(N,B,R))
#define nmsg_clonecontig(r, m) ((r) = nmsg_fclonecontig(m))
#endif

#define nmsg_contigtodata(r) ((r)->body.contig.data)
#define nmsg_contigtodataoff(r) ((r)->body.contig.data+((r)->off))
#define nmsg_iscontig(m) ((m)->tag == NM_Contig ? 1 : 0)


#define nmsg_len(m) ((m) ? (m)->len : 0)
#define nmsg_save(r, m) { (r) = (m); if (r) (r)->ref++; }
#define nmsg_free(m) { if ((m) && ((--((m)->ref)) == 0)) nmsg_free_it(m); }

#define nmsg_peekptr(M, L, B) \
  ((M)->tag == NM_Contig ? nmsg_contigtodataoff((M)) : \
   ((M)->tag == NM_Single && \
    (M)->body.single->tag == NM_Contig) ? \
      (nmsg_contigtodataoff((M)->body.single)+(M)->off): \
   ((M)->tag == NM_Pair && \
    (M)->body.pair.l->tag == NM_Contig && \
    (M)->body.pair.l->len - (M)->off >= (L)) ? \
      (nmsg_contigtodataoff((M)->body.pair.l)+(M)->off): \
   (nmsg_peek((M), 0, (L), (B)), (B)))

extern void nmsg_peek( /* nmsg, offset, length, buffer */ );
extern NMSG nmsg_join( /* nmsg1, nmsg2 */ );
extern NMSG nmsg_truncateleft( /* nmsg, where */ );
extern NMSG nmsg_truncateright( /* nmsg, where */ );
extern void nmsg_display( /* nmsg, level */ );

/***************************************************************
/* Boundary Routines: Used only at kernel/user or
/*		      device/kernel boundary
/***************************************************************/

#define nmsg_externalize(m, b) { \
  nmsg_peek(m, 0, nmsg_len(m), b); \
  nmsg_free(m); \
}

extern NMSG nmsg_internalize( /* data, length */ );

/***************************************************************
/* Hidden Routines: Used only by message operations;
/*		    not intended for use by protocols
/***************************************************************/

#define NMCREATESINGLE(M) { \
  (M) = ((NMSG)malloc(sizeof(struct nmsg))); \
  (M)->tag = NM_Single; \
  (M)->ref = 1; \
  (M)->off = 0; \
}

#define NMCREATEPAIR(M) { \
  (M) = ((NMSG)malloc(sizeof(struct nmsg))); \
  (M)->tag = NM_Pair; \
  (M)->ref = 1; \
  (M)->off = 0; \
}
E 1
