h02891
s 00020/00015/00246
d D 1.5 91/01/10 11:19:54 llp 5 4
c Prepared for 3.1 Distribution
e
s 00001/00001/00260
d D 1.4 89/12/28 13:16:38 norm 4 3
c Fixed an ambiguous assignment
e
s 00002/00002/00259
d D 1.3 89/12/13 14:17:41 llp 3 2
c Cleaned up for distribution
e
s 00002/00002/00259
d D 1.2 89/11/07 10:21:11 norm 2 1
c Fixed a bug in make_allstack
e
s 00261/00000/00000
d D 1.1 89/10/24 13:46:35 norm 1 0
c date and time created 89/10/24 13:46:35 by norm
e
u
U
f e 0
t
T
I 1
D 5
/*
 * %W%  %G%
E 5
I 5
/* 
 * message.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 5
 */
I 5

E 5
#include "nmessage.h"
typedef enum {
  MSG_CREATE, MSG_PUSH, MSG_POP, MSG_TOP
}    MSG_STACK_OP;

typedef struct stack_stack {
  REF ref;
  int size;
  MSG_STACK_OP last_op;
  char *base;
  char stack[8];
}           STACK_HDR, *STACK;

typedef struct msg {
  int top;
  STACK stack;
  NMSG data;
D 5
}   MSG;
E 5
I 5
}   Msg;
E 5

/* default stack size */
#define MSG_SSIZE 128

D 5
MSG msgf_overwrite();
MSG msg_truncateright();
MSG msg_truncateleft();
MSG msgf_make_exist();
MSG msgf_make_new();
MSG msgf_make_allstack();
E 5
I 5
Msg msgf_overwrite();
Msg msg_truncateright();
Msg msg_truncateleft();
Msg msgf_make_exist();
Msg msgf_make_new();
Msg msgf_make_allstack();
E 5
char *msgf_push();
int msgf_pop();
char *msgf_top();
D 5
MSG msgf_clone_stack();
E 5
I 5
Msg msgf_clone_stack();
E 5
void msgf_break();
D 5
MSG msgf_join();
E 5
I 5
Msg msgf_join();
E 5
char *msg_top_underflow();
char *msg_push_overflow();
D 5
extern MSG NULL_MSG;
E 5
I 5
extern Msg NULL_MSG;
E 5


/* are two messages identical in the strictest sense */
/* note this is not the same as having the same data */
D 3
#define msg_equal(m,n) (((m).top == (n).top) && ((m).stack == (n).stack) && (m).data == (n).data))
E 3
I 3
#define msg_equal(m,n) (((m).top == (n).top) && ((m).stack == (n).stack) && ((m).data == (n).data))
E 3

#define msg_isnull(m) ((m).stack == (STACK)0)
D 3
#define msg_clear(m) {(m).stack = (STACK)0;(m).top =0; (m).data =(NMSG)0;}
E 3
I 3
D 4
#define msg_clear(m) {(m).stack = (STACK)0;(m).top =-1; (m).data =(NMSG)0;}
E 4
I 4
#define msg_clear(m) {(m).stack = (STACK)0;(m).top = (-1); (m).data =(NMSG)0;}
E 4
E 3

/* save a copy of a message */
#define msg_save(m1,m2) { \
  (m1) = (m2); \
  if ((m1).stack) ((m1).stack->ref.ref)++;  \
  if ((m1).data)  nmsg_save((m1).data,(m2).data); \
}

/* return maximum stack size */
#define msg_max_stack(m) ((m).stack->size)

/* return stack size */
#define msg_stack_len(m) ((m).top + 1)

/* return data size */
#define msg_data_len(m) (nmsg_len((m).data))

/* return length of message */
#define msg_len(m) (msg_stack_len(m) + msg_data_len(m))

/* copy message into buffer */
#define msg_externalize(m,b) { \
	msg_peek(m,0,msg_len(m),b); \
	msg_free(m); \
}


#ifdef MSGOPT
/* lots of fast macros */

#define msg_chopright(NEW,M,WHERE) { \
  int MTRslen; \
D 5
  MSG MTRtemp; \
E 5
I 5
  Msg MTRtemp; \
E 5
  MTRslen = msg_stack_len(M); \
  if ((msg_data_len(M) == 0) && (msg_len(M) > WHERE)) { \
    if ((M).stack->ref.ref == 1) { \
      (NEW) = (M); \
    } else { \
      msg_clone_stack(MTRtemp,M); \
      msg_free(M); \
      (NEW) = (MTRtemp); \
    } \
    (NEW).stack->size = (NEW).stack->size - (MTRslen - WHERE);\
    (NEW).stack->base = (NEW).stack->base - (MTRslen - WHERE);\
    (NEW).top = (NEW).top - (MTRslen - WHERE);\
    } else { \
    NEW = msg_truncateright(M,WHERE); \
    } \
}


#define msg_overwrite(NEW,M) { \
  if ((M).stack->ref.ref == 1) { \
    (NEW) = (M); \
  } else {  \
    (NEW) = msgf_overwrite(M); \
  } \
}

#define msg_make_exist(M, S, D, L, R) { \
  (M).top = -1; \
  (M).stack = (STACK)malloc(sizeof(STACK_HDR)+(S)-8); \
  (M).stack->ref.ref = 1; \
  (M).stack->ref.ptr = (char *)(M).stack; \
  (M).stack->ref.xfree = free; \
  (M).stack->last_op = MSG_CREATE; \
  (M).stack->size = (S); \
  (M).stack->base = (M).stack->stack + (S) -1; \
  nmsg_makecontig((M).data,(L),(D),(R)); \
}
#define msg_make_new(M, S, D, L) { \
  REF *MMNr; \
  (M).top = -1; \
  (M).stack = (STACK)malloc(sizeof(STACK_HDR)+(S)-8); \
  (M).stack->ref.ref = 1; \
  (M).stack->ref.ptr = (char *)(M).stack; \
  (M).stack->ref.xfree = free; \
  (M).stack->last_op = MSG_CREATE; \
  (M).stack->size = (S); \
  (M).stack->base = (M).stack->stack + (S) -1; \
  nmsg_makeref(MMNr,(D)); \
  MMNr->ref--; \
  nmsg_makecontig((M).data,(L),(D),MMNr); \
}

#define msg_make_allstack(M, S, D, L) { \
  (M).top = -1; \
D 2
  (M).stack = (STACK)malloc(sizeof(STACK_HDR)+(S)-8+(L)); \
E 2
I 2
  (M).stack = (STACK)malloc(sizeof(STACK_HDR)+(S)-8+(((L)+3)&~0x3)); \
E 2
  (M).stack->ref.ref = 1; \
  (M).stack->ref.ptr = (char *)(M).stack; \
  (M).stack->ref.xfree = free; \
  (M).stack->last_op = MSG_CREATE; \
D 2
  (M).stack->size = (S)+(L); \
E 2
I 2
  (M).stack->size = (S)+(((L)+3)&~0x3); \
E 2
  (M).stack->base = (M).stack->stack + (S)+(L) -1; \
  if ((L) != 0) bcopy((D),msg_push((M),(L)),(L)); \
  (M).data = 0; \
 }

/* free a message */
#define msg_free(m) { \
  if ((m).data) nmsg_free((m).data); \
  if (((m).stack) && (--((m).stack->ref.ref) == 0)) { \
    (m).stack->ref.xfree((m).stack->ref.ptr); \
    msg_clear(m); \
  } \
}

/* make room for a header on a message */
#define msg_push(m,len) ((((m).top = (m).top + (len)) < (m).stack->size) ? (m).stack->base - (m).top  : msg_push_overflow(&(m),(len)))

/* pop header off stack */
#define msg_pop(m,len)   ((((m).top = (m).top - (len)) >= -1) ? 0 :  msg_pop_underflow(&(m),(len)))

/* get top of stack */
#define msg_top(m,len)  (((m).top - (len) >= -1) ?  (m).stack->base - (m).top : msg_top_underflow(&(m),(len)))

#define msg_clone_stack(m,new)  { \
  (new).top  = (m).top; \
  nmsg_save((new).data,(m).data); \
  (new).stack = (STACK) malloc(sizeof(STACK_HDR)+ (m).stack->size - 8); \
  bcopy((m).stack,(new).stack,sizeof(STACK_HDR)+ (m).stack->size-8);\
  (new).stack->ref.ref = 1; \
D 5
  (new).stack->ref.ptr = (char *)(m).stack; \
E 5
I 5
  (new).stack->ref.ptr = (char *)(new).stack; \
E 5
  (new).stack->ref.xfree = free; \
}

#define msg_break(M, R, WHERE, SIZE) { \
  NMSG HHHH; \
  if ((WHERE) < msg_stack_len(M)) { \
    msg_real_break(&(M),&(R),(WHERE),(SIZE)); \
  } else { \
    if ((SIZE) == 0) { \
      msg_make_allstack((R),(M).stack->size,0,0); \
    } else { \
      msg_make_allstack((R),(SIZE),0,0); \
    } \
    HHHH = (M).data; \
    nmsg_break(&((M).data),&HHHH,(WHERE)- msg_stack_len(M)); \
    (R).data = HHHH; \
  } \
}

#define msg_join(NEW,M1,M2) { \
D 5
  MSG TTTT; \
E 5
I 5
  Msg TTTT; \
E 5
  if (msg_isnull(M1)) { \
    (NEW) = (M2); \
  } else if (msg_isnull(M2)) { \
    (NEW) = (M1); \
  } else if (msg_stack_len(M2) != 0) { \
    msg_real_join(&(NEW),(M1),(M2)); \
  } else { \
    msg_save(TTTT,(M1)); \
    nmsg_save((M2).data,(M2).data); \
    (TTTT).data = nmsg_join((TTTT).data,(M2).data); \
    msg_free(M1); \
    msg_free(M2); \
    (NEW) = TTTT; \
  } \
}

#define msg_peek(m,offset,len,b) { \
  if ((offset)+(len)  <= msg_stack_len(m)) { \
    bcopy(msg_top((m),msg_stack_len(m))+(offset),(b),(len)); \
  } else { \
    msgf_peek((m),(offset),(len),(b)); \
  } \
}

#else

/* lots of slow procedure calls for debugging */

#define msg_chopright(NEW,M,WHERE) (NEW) = msg_truncateright(M,WHERE)

#define msg_peek(m,offset,len,b) (msgf_peek(m,offset,len,b))

#define msg_make_exist(M, S, D, L, R) { \
  (M) = msgf_make_exist(S,D,L,R); \
}

#define msg_make_new(M, S, D, L) { \
  (M) = msgf_make_new(S,D,L); \
}

#define msg_make_allstack(M, S, D, L) { \
  (M) = msgf_make_allstack(S,D,L); \
}

#define msg_free(m) { msgf_free(m); msg_clear(m);}

#define msg_push(m,len)  (msgf_push(&(m),len))

#define msg_pop(m,len)  (msgf_pop(&(m),len))

#define msg_top(m,len)  (msgf_top(&(m),len))

#define msg_clone_stack(m,new)  { \
  (new) = msgf_clone_stack(m); \
}

#define msg_break(M, R, WHERE, SIZE) { \
  msgf_break(&(M),&(R),WHERE,SIZE); \
}

#define msg_join(NEW,M1,M2) { \
  (NEW) = msgf_join(M1,M2); \
}

#define msg_overwrite(NEW,M) { \
    NEW = msgf_overwrite(M); \
}

#endif
E 1
