h52179
s 00002/00002/00229
d D 1.2 91/01/10 12:09:07 llp 2 1
c Prepared for 3.1 Distribution
e
s 00231/00000/00000
d D 1.1 90/11/16 13:07:48 menze 1 0
c date and time created 90/11/16 13:07:48 by menze
e
u
U
f e 0
t
T
I 1
/*
 * tcp_internal.h
 *
 * Derived from:
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *	@(#)tcp.h	7.3 (Berkeley) 12/7/87
 *
 * Modified for x-kernel v3.1	12/10/90
D 2
 * Modifications Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Modifications Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

/**************************************************************************

tcp_internal.h

**************************************************************************/
#include "upi.h"
#include "sb.h"
#include "ip.h"
D 2
#include "tcp_x.h"
E 2
I 2
#include "tcp.h"
E 2

#ifndef ENDIAN
/*
 * Definitions for byte order,
 * according to byte significance from low address to high.
 */
#define	LITTLE	1234		/* least-significant byte first (vax) */
#define	BIG	4321		/* most-significant byte first */
#define	PDP	3412		/* LSB first in word, MSW first in long (pdp) */
#ifdef vax
#define	ENDIAN	LITTLE
#else
#define	ENDIAN	BIG		/* byte order on mc68000, tahoe, most others */
#endif
#endif ENDIAN

typedef char *		caddr_t;
typedef u_long 		n_time;
#undef KPROF
#define PR_SLOWHZ	2
#define PR_FASTHZ	5
#define KERNEL
#define BSD 43
#define TCP_COMPAT_42
#ifndef MIN
#define MIN(A,B) ((A) <= (B) ? (A) : (B))
#endif
#ifndef MAX
#define MAX(A,B) ((A) >= (B) ? (A) : (B))
#endif
#define splnet() spl7()

struct tcpstate {
  struct inpcb *inpcb;
  struct tcpcb *tcpcb;
  caddr_t	waiting;
  caddr_t	lock;
  struct sb    *snd;
  struct sb    *rcv;
  int closed;
};

#define sotoinpcb(S) (((struct tcpstate *)((S)->state))->inpcb)
#define sototcpst(S) ((struct tcpstate *)(S)->state)
#define tcpcbtoso(tp) (tp->t_inpcb->inp_session)
extern int tracetcpp;

/*
 * The arguments to usrreq are:
 *	(*protosw[].pr_usrreq)(up, req, m, nam, opt);
 * where up is a (struct socket *), req is one of these requests,
 * m is a optional mbuf chain containing a message,
 * nam is an optional mbuf chain containing an address,
 * and opt is a pointer to a socketopt structure or nil.
 * The protocol is responsible for disposal of the mbuf chain m,
 * the caller is responsible for any space held by nam and opt.
 * A non-zero return from usrreq gives an
 * UNIX error number which should be passed to higher level software.
 */
#define	PRU_ATTACH		0	/* attach protocol to up */
#define	PRU_DETACH		1	/* detach protocol from up */
#define	PRU_BIND		2	/* bind socket to address */
#define	PRU_LISTEN		3	/* listen for connection */
#define	PRU_CONNECT		4	/* establish connection to peer */
#define	PRU_ACCEPT		5	/* accept connection from peer */
#define	PRU_DISCONNECT		6	/* disconnect from peer */
#define	PRU_SHUTDOWN		7	/* won't send any more data */
#define	PRU_RCVD		8	/* have taken data; more room now */
#define	PRU_SEND		9	/* send this data */
#define	PRU_ABORT		10	/* abort (fast DISCONNECT, DETATCH) */
#define	PRU_CONTROL		11	/* control operations on protocol */
#define	PRU_SENSE		12	/* return status into m */
#define	PRU_RCVOOB		13	/* retrieve out of band data */
#define	PRU_SENDOOB		14	/* send out of band data */
#define	PRU_SOCKADDR		15	/* fetch socket's address */
#define	PRU_PEERADDR		16	/* fetch peer's address */
#define	PRU_CONNECT2		17	/* connect two sockets */
/* begin for protocols internal use */
#define	PRU_FASTTIMO		18	/* 200ms timeout */
#define	PRU_SLOWTIMO		19	/* 500ms timeout */
#define	PRU_PROTORCV		20	/* receive from below */
#define	PRU_PROTOSEND		21	/* send to below */

#define	PRU_NREQ		21

extern char *prurequests[];

struct in_addr {
	u_long s_addr;
};

/*
 * Subset of the inpcb defined in /usr/include/netinet/in_pcb.h
 */
struct inpcb {
	struct	inpcb *inp_next,*inp_prev;
	struct	inpcb *inp_head;
	caddr_t	inp_ppcb;		/* pointer to per-protocol pcb */
	struct in_addr inp_laddr, inp_raddr;
	u_short	inp_lport, inp_rport;
	XObj	inp_session;
};

#define RCV 0
#define SND 1

#include <sys/errno.h>

typedef	u_long	tcp_seq;
/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
	u_short	th_sport;		/* source port */
	u_short	th_dport;		/* destination port */
	tcp_seq	th_seq;			/* sequence number */
	tcp_seq	th_ack;			/* acknowledgement number */
#if ENDIAN == LITTLE
	u_char	th_x2:4,		/* (unused) */
		th_off:4;		/* data offset */
#endif
#if ENDIAN == BIG
	u_char	th_off:4,		/* data offset */
		th_x2:4;		/* (unused) */
#endif
	u_char	th_flags;
#define	TH_FIN	0x01
#define	TH_SYN	0x02
#define	TH_RST	0x04
#define	TH_PUSH	0x08
#define	TH_ACK	0x10
#define	TH_URG	0x20
	u_short	th_win;			/* window */
	u_short	th_sum;			/* checksum */
	u_short	th_urp;			/* urgent pointer */
};

#define	TCPOPT_EOL	0
#define	TCPOPT_NOP	1
#define	TCPOPT_MAXSEG	2

/*
 * Default maximum segment size for TCP.
 * With an IP MSS of 576, this is 536,
 * but 512 is probably more convenient.
 */
#ifdef	lint
#define	TCP_MSS	536
#else
#ifndef IP_MSS
#define	IP_MSS	576
#endif
#define	TCP_MSS	MIN(512, IP_MSS - sizeof (struct tcpiphdr))
#endif

/*
 * User-settable options (used with setsockopt).
 */
#define	TCP_NODELAY	0x01	/* don't delay send to coalesce packets */
#define	TCP_MAXSEG	0x02	/* set maximum segment size */


/*
 * X-Kernel defines
 */

/*====================  #8 10 lines added 070390 cliff ===================*/

typedef struct pstate  {
  IPaddr            myaddr;
  Map            activemap;
  Map           passivemap;
}  PSTATE;

/* cc complains about HDR, may not use this struct for tcp.  cliff 070590
typedef struct sstate  {
  HDR              hdr;
  IPhost         dhost;
  XObj          down_s;
}  SSTATE;          
*/

/* not using this after all cliff 070590 
typedef TCPPort  PassiveId;
*/

typedef struct {
      unsigned short localport;
      unsigned short remoteport;
      IPhost         remoteaddr;
} TCP_EXID;

#define PADDING 0x42424242
#define FROM_ENABLE	-1
#define TCPRCVWIN	(TCP_BUFFER_SPACE)
#define panic(s) Kabort(s)
extern u_char tcp_protocolnum;
extern char *tcpstates[];

#include "insque.h"
E 1
