h02995
s 00218/00000/00000
d D 1.1 91/01/10 12:12:49 llp 1 0
c date and time created 91/01/10 12:12:49 by llp
e
u
U
f e 0
t
T
I 1
/*
 * xrpc_print.c  -- debugging support for Sun RPC
 *
 *	contributed by Rice University 7/11/90
 */
 
/*
 * only include all this stuff if NOT compiling an OPTIMIZED kernel.
 * compilation of an optimized kernel is denoted by compiling with
 * the -DNDEBUG flag.  -mjk
 */

#ifndef NDEBUG  

#define UNIX
#include "xrpc.h"
#include "upi.h"
#include "debug.h"
#include "system.h"
#include "process.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "sun_rpc_internal.h"
#define NL() printf("\n")

/* rpc_print - print an rpc header */

/* print out message type */
static ptype(t)
enum msg_type t;
{
  if (t == CALL) { 
    printf("CALL");
  } else if (t == REPLY) {
    printf("REPLY");
  } else {
    printf("ptype: Invalid type\n");
  }
}

/* print out reply status */ 
static prstat(t)
enum reply_stat t;
{
  if (t == MSG_ACCEPTED) { 
    printf("MSG_ACCEPTED");
  } else if (t == MSG_DENIED) {
    printf("MSG_DENIED");
  } else {
    printf("prstat: Invalid reply status\n");
  }
}

/* print out accept status */ 
static pastat(t)
enum accept_stat t;
{
  switch (t) {
    case SUCCESS:
      printf("SUCCESS");
      break;
    case PROG_UNAVAIL:
      printf("PROG_UNAVAIL");
      break;
    case PROG_MISMATCH:
      printf("PROG_MISMATCH");
      break;
    case PROC_UNAVAIL:
      printf("PROC_UNAVAIL");
      break;
    case GARBAGE_ARGS:
      printf("GARBAGE_ARGS");
      break;
    case SYSTEM_ERR:
      printf("SYSTEM_ERR");
      break;
    default:
      printf("pastat: invalide accept status");
      break;
  }
}

/* print out reject status */ 
static prejstat(t)
enum reject_stat t;
{
  if (t == RPC_MISMATCH) { 
    printf("RPC_MISMATCH");
  } else if (t == AUTH_ERROR) {
    printf("AUTH_ERROR");
  } else {
    printf("prejstat: Invalid reject status\n");
  }
}

/* print accepted_reply */
static pareply(t)
struct accepted_reply t;
{
  printf("ar_verf = opaque \n"); 
  printf("accept_stat = ");
  pastat(t.ar_stat);
  NL();

  if (t.ar_stat == PROG_MISMATCH) {
    printf("low = %d high = %d \n",t.ar_vers.low,t.ar_vers.high);
  }
} 

/* print  rejected reply */
static prejreply(t)
struct rejected_reply t;
{
  printf("rejected_stat  ="); 
  prejstat(t.rj_stat);
  NL();

  if (t.rj_stat == RPC_MISMATCH) {
    printf("low = %d high = %d \n",t.rj_vers.low,t.rj_vers.high);
  } else  if (t.rj_stat == AUTH_ERROR) {
    printf("RJ_why  ="); 
    pauthstat(t.rj_why);
    NL();
 }
}
/* print reply body*/
static preply(t)
struct reply_body t;
{
  printf("rejected_stat  ="); 
  prstat(t.rp_stat);
  NL();

  if (t.rp_stat == MSG_ACCEPTED) {
    pareply(t.rp_acpt);
  } else if (t.rp_stat == MSG_DENIED) {
    prejreply(t.rp_rjct);
  }
}

/* print call body*/
static pcall(t)
struct call_body t;
{
  printf("rpcvers = %d \n",t.cb_rpcvers);
  printf("prog = %d \n",t.cb_prog);
  printf("vers = %d \n",t.cb_vers);
  printf("proc = %d \n",t.cb_proc);
  printf("cred = opaque \n");
  printf("verf = opaque \n");
}

/* print rpc header */
prpchdr(t)
struct rpc_msg t;
{
  printf("rm_xid = %s\n",inet_ntoa(t.rm_xid));
  printf("direction = ");
  ptype(t.rm_direction);
  NL();
  if (t.rm_direction == CALL) {
    pcall(t.rm_call);
  } else if (t.rm_direction == REPLY) {
    preply(t.rm_reply);
  }
}

/* print authentication stuff */

/* print auth status */
pauthstat(t)
enum auth_stat t;
{
  switch(t) {
    case AUTH_OK:
      printf("OK");
      break;
    case AUTH_BADCRED:
      printf("BADCRED");
      break;
    case AUTH_REJECTEDCRED:
      printf("REJECTCRED");
      break;
    case AUTH_BADVERF:
      printf("BADVERF");
      break;
    case AUTH_REJECTEDVERF:
      printf("REJECTVERF");
      break;
    case AUTH_INVALIDRESP:
      printf("INVALIDRESP");
      break;
    case AUTH_FAILED:
      printf("AUTH_FAILED");
      break;
    default:
      printf("pauthstat: invalid auth status\n");
      break;
  }
  printf(" ( %d )",  (int) t);
}
pudpaddr(addr)
UDPaddr addr;
{
  printf("UDP port = %d host = %s\n",addr.port,inet_ntoa(addr.host));
}
prpcaddr(addr)
SUNRPCaddr addr;
{
  printf("prog = %d \n",addr.prog);
  printf("vers = %d \n",addr.vers);
  printf("proc = %d \n",addr.proc);
  printf("prot = %d \n",addr.prot);
  pudpaddr(addr.host);
}

#endif NDEBUG 
E 1
