h08173
s 01167/00000/00000
d D 1.1 91/01/10 12:12:41 llp 1 0
c date and time created 91/01/10 12:12:41 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * sun_rpc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xrpc.h"
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "sun_rpc_internal.h"

#define IMAGINARY 0x43232322
#define flush_msg(m) {if (!msg_isnull(m)) msg_free(m); msg_clear(m);}

/* global data for RPC; need data structure for assigned/free port nums */

int tracesun_rpcp=0;
static  u_char  protocolnum=17;
static  Map  activemap, passivemap;
static  IPaddr  myipaddr; 
static  char    generic[] = "************************";
static clean_hdr();
static put_port();
static err_push();
static translate_error();
static auth_free();
struct opaque_auth  auth_dummy = {0,0,0};
static Msg null_msg = {0,0,0};
Msg decode_hdr(),encode_hdr();
int rpc_timeout();

Msg rec_push();
unsigned long get_xid();
u_short get_port();

static XObj SELF=0;
#define UDP SELF->down[0]
#define SUNRPC SELF
#define MIN(A,B) ((A > B) ? B : A)

static rpc_instantiateprotl(self) 
     XObj self;
{
  TRACE0(sun_rpcp, 1, "SUNRPC instanciateprotl");
  
  if (SELF) {
    Kabort("SUN RPC: can't instantiate twice");
  }
  SELF = self;
  return 0;
}



static rpc_init(self)
     XObj self;
{
  
  TRACE0(sun_rpcp, 1, "SUNRPC init");
  
  /* No openenables downward can be done yet.  Wait until we */
  /* have the specs on a server, which we get in our */
  /* own openenable routine.  Create a map. */
  
  /* created both maps of keylen 32*/
  activemap = map_create(100,32);
  passivemap = map_create(20,32);
  x_controlprotl(UDP, GETMYADDR, &myipaddr, IPADLEN);
  
  return(0);
}


static XObj rpc_open(self,hlp, p)
     XObj   self;
     XObj   hlp;
     Part    *p;             /* p[0]=SUNRPC address of client 
				p[1]=SUNRPC address of server */
{
  XObj   s;
  SUNRPC_STATE *state;
  SUNRPC_EXTID ext_id;
  SUNRPCaddr client, server;
  struct rpc_msg *hdr;
  Part part[3];
  
  
  TRACE0(sun_rpcp, 3, "SUNRPC open");
  s = (XObj) NULL;
  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(sun_rpcp,9,"error: 1");
    return(ERR_XOBJ);
  }
  
  hdr = (struct rpc_msg *) malloc(sizeof(struct rpc_msg)); 
  bzero(hdr,sizeof(struct rpc_msg));
  state = (SUNRPC_STATE *) malloc(sizeof(SUNRPC_STATE));
  bzero(state,sizeof(SUNRPC_STATE));
  
  
  client = get_part(p, 0, SUNRPCaddr);
  server = get_part(p, 1, SUNRPCaddr);
  state->rpchdr = hdr;
  
  /* for the moment we only support UDP (hard coded) */
  if (server.prot != 17) {
    printf("rpc: rpc only supports UDP!\n");
    x_errno = BAD_ADDR;
    TRACE0(sun_rpcp,9,"error: 1");
    return(ERR_XOBJ);
  }
  
  if (client.host.port == 0) {
    state->direction = CALL;
    client.host.port = get_port();
    client.host.host = myipaddr.host;
    
    /* default time outs */
    state->tout.tv_usec = 0; 
    state->tout.tv_sec = 6; 
    state->wait.tv_usec = 0; 
    state->wait.tv_sec = 1; 
    
  } else {
    state->direction = REPLY;
  }
  
  /* now know who participants really are */
  state->client = client.host;
  state->server = server;
  
  /* EXT_ID = client address + server address */
  
  ext_id.server = server;
  ext_id.client = client.host;
  ext_id.direction = state->direction;

#ifndef NDEBUG
  IFTRACE(sun_rpcp,7) {
    printf("SUNRPC open\n");
    pudpaddr(client.host);
    prpcaddr(server);
  }
#endif
  
  /* check for duplicate session */
  if ((s=(XObj)map_resolve(activemap, (char *)&ext_id)) != ERR_XOBJ) {
    TRACE1(sun_rpcp, 3, "SUNRPC found open session=%x", s);
    s = ERR_XOBJ;
    x_errno = ALREADY_OPEN;
    TRACE0(sun_rpcp,9,"error: 1");
    return(s);
  } 
  
  /* create session and bind to address */
  s = x_createsession(hlp, SUNRPC,1);
  s->binding = (Bind) map_bind(activemap, (char *)&ext_id, (int)s);
  
  /* Set up the RPC header template */
  state->cred = auth_dummy;
  state->verf = auth_dummy;
  hdr->rm_xid = 0;
  hdr->rm_direction = state->direction; 
  if (state->direction == CALL) {
    hdr->rm_call.cb_rpcvers = CUR_RPC_VERS;
    hdr->rm_call.cb_prog = server.prog;
    hdr->rm_call.cb_vers = server.vers;
    hdr->rm_call.cb_proc = server.proc;
    hdr->rm_call.cb_cred = auth_dummy;
    hdr->rm_call.cb_verf = auth_dummy;
  } else {
    /* error replies will be handled in DEMUX */
    hdr->rm_reply.rp_stat = MSG_ACCEPTED;
    hdr->rm_reply.rp_acpt.ar_verf = auth_dummy;
    hdr->rm_reply.rp_acpt.ar_stat = SUCCESS;
  }
  
  /* open UDP session */
  if (state->direction == CALL) {
    init_partlist(part,1, UDPaddr);
    init_partlist(part,2, UDPaddr);
    set_part(part, 0, client.host);
    set_part(part, 1, server.host);
    if ((s->down[0] = x_open(SUNRPC, UDP, part)) == ERR_XOBJ) {
      printf("rpc_open: cannot open UDP session (x_errno=%d)\n",x_errno);
      free(state);
      free(hdr);
      x_destroysession(s);
      s = ERR_XOBJ;
      TRACE0(sun_rpcp,9,"error: 1");
      return(s);
    }
    s->down[0]->up = s;
  }
  
  /* initialize  session */
  s->rcnt = 1;
  s->state = (char *) state;
  InitSemaphore(&state->reply_sem, 0);
  
  TRACE1(sun_rpcp, 3, "SUNRPC open returns %x", s);
  return(s);
}


static rpc_openenable(self,hlp, p)
     XObj   self;
     XObj   hlp;
     Part    *p;
{
  SUNRPC_EXTID ext_id;
  SUNRPC_STATE  *state;
  SUNRPCaddr     server;
  Part    part[2];
  UDPaddr local;
  
  TRACE0(sun_rpcp, 3, "SUNRPC open enable");
  
  /* Only servers call openenable */
  server = get_part(p, 0, SUNRPCaddr);
  
  /* server's EXT_ID = SUNRPCaddr+"******" */
  ext_id.server = server;
  bcopy(generic, &ext_id.client, UDPADLEN);
  bcopy(generic, &ext_id.direction, 4);
  
#ifndef NDEBUG
  IFTRACE(sun_rpcp,7) {
    printf("rpc_openenable:\n");
    prpcaddr(server);
  }
#endif
  
  /* bind EXT_ID to high level protocol */
  if ((map_bind(passivemap, (char *) &ext_id, hlp) == (Bind) ERR_BIND)) {
    x_errno = ALREADY_OPEN;
    TRACE0(sun_rpcp,9,"error: 1");
    return(-1);
  }
  
  /* Now openenable downward to UDP */
  init_partlist(part, 1, UDPaddr);
  set_part(part, 0, server.host);
  TRACE0(sun_rpcp, 7, "SUNRPC openenable bound ");
  return (x_openenable(SUNRPC, UDP, part));
}


static rpc_closesessn(s)
     XObj   s;
{
  SUNRPC_STATE *rpc_state;
  
  TRACE1(sun_rpcp, 1, "SUNRPC close of session %x", s);
  
  if (!s) return(0); 
  
  /* decrement refcount */  
  s->rcnt = s->rcnt - 1;
  
  TRACE1(sun_rpcp,9,"rpc_close: ref count = %d\n",s->rcnt);
  if (s->rcnt <= 0) {
    /* free binding */
    if (s->binding != 0) {
      map_unbindbinding(activemap, (Bind) s->binding);
    } else {
      TRACE0(sun_rpcp,3,"rpc_close: binding is zero!");
    }
    
    TRACE0(sun_rpcp, 9, ">>rpc_close 1");
    /* free rpc state */
    if (s->state) {
      rpc_state = (SUNRPC_STATE *) s->state;
      
      if (rpc_state->direction == CALL)
	{
	  put_port(rpc_state->client.port);  
	}
      s->down[0]->up = s->down[0]->myprotl;
      if (s->down[0])
        x_close(s->down[0]);
      TRACE0(sun_rpcp, 9, ">>rpc_close 4");
      if (rpc_state->rpchdr != 0) free(rpc_state->rpchdr);
      TRACE0(sun_rpcp, 9, ">>rpc_close 6");
      if (rpc_state->errhdr != 0) free(rpc_state->errhdr);
      TRACE0(sun_rpcp, 9, ">>rpc_close 7");
      flush_msg(rpc_state->rtstmsg);
      TRACE0(sun_rpcp, 9, ">>rpc_close 8");
      flush_msg(rpc_state->ctstmsg);
      TRACE0(sun_rpcp, 9, ">>rpc_close 10");
      auth_free(&(rpc_state->cred));
      TRACE0(sun_rpcp, 9, ">>rpc_close 11");
      auth_free(&(rpc_state->verf));
      TRACE0(sun_rpcp, 9, ">>rpc_close 12");
    }
    
    x_destroysession(s);
    TRACE0(sun_rpcp, 9, ">>rpc_close 13");
  }
  return(0);
}

static rpc_push(s, msg,reply_ptr)
     XObj   s;
     Msg     msg;
     Msg *reply_ptr;
{
  int    wait, ttout;
  SUNRPC_STATE   *rpc_state;
  struct rpc_msg *hdr;
  Msg results;
  int dummy;
  enum clnt_stat answer;
  int udp_results;
  int i;
  
  
  TRACE0(sun_rpcp, 3, "in rpc_push");
  
  rpc_state = (SUNRPC_STATE *) s->state;
  
  hdr = rpc_state->rpchdr;
  if (rpc_state->direction == CALL) {
    /* set up authentication */
    rpc_state->xid = get_xid();
    hdr->rm_call.cb_verf = rpc_state->verf;
    hdr->rm_call.cb_cred = rpc_state->cred;
  } else {
    hdr->rm_reply.rp_acpt.ar_verf = rpc_state->verf;
  }
  hdr->rm_xid = rpc_state->xid;
  
  
  if (msg_isnull(msg)) {
    msg_make_allstack(msg,256,0,0);
  }
  
#ifndef NDEBUG
  IFTRACE(sun_rpcp,7) {
    printf("rpc_push: \n");
    prpchdr(*hdr);
  }
#endif
  
  TRACE0(sun_rpcp, 3, "in rpc_push going to encode header ");
  if (msg_isnull(msg = encode_hdr(hdr,msg))) {
    TRACE0(sun_rpcp, 3, "rpc_push: can't encode header");
    TRACE0(sun_rpcp,9,"error: 1");
    return(-1);
  }
  
  TRACE0(sun_rpcp, 3, "in rpc_push already encode header ");
  
  if (rpc_state->direction == CALL) {
    /* clear reply message */
    flush_msg(rpc_state->rtstmsg);
    /* set up retry message */
    flush_msg(rpc_state->ctstmsg);
    msg_save(rpc_state->ctstmsg,msg);
  }
  
  /* push message to udp */
  udp_results = x_push(s->down[0],msg,(Msg *)0);
  
  if (udp_results == 0) {
    if (rpc_state->direction == CALL) {
      
      /* Setup timeout stuff  */
      wait = rpc_state->wait.tv_sec * 1000;
      wait =  wait + rpc_state->wait.tv_usec;
      ttout = rpc_state->tout.tv_sec * 1000;
      ttout = ttout + rpc_state->tout.tv_usec;
      rpc_state->tries = ttout / wait;
      rpc_state->old_tries = rpc_state->tries;
      TRACE2(sun_rpcp, 5, "rpc_push waiting %d msecs %d times for reply",
	     wait, rpc_state->tries); 
      
      /* register timeout */
      event_register(rpc_timeout, (int)s, wait, EV_REPEAT|EV_CREATEPROCESS);
      
      /* default result */
      rpc_state->error.re_status = RPC_TIMEDOUT;
      
      /* wait for answer */
      P(&rpc_state->reply_sem);
      if (msg_isnull(rpc_state->rtstmsg)) {
        return(-1);
      } else {
        *reply_ptr = rpc_state->rtstmsg;
	msg_clear(rpc_state->rtstmsg);
	TRACE0(sun_rpcp, 1, "SUNRPC SUCCESS");
	return(0);
      }
    } else {
      return(0);
    }
  } else {
    return(-1);
  }
}


static rpc_demux(self,s, dg)
     XObj   self;
     XObj   s;
     Msg     dg;
{
  static int first=0;
  struct  rpc_msg hdr;
  SUNRPC_STATE *rpc_state;
  Part    part[3];
  XObj   rpc_s;
  XObj    hlp;
  SUNRPC_EXTID ext_id;
  Msg     data;
  SUNRPCaddr client, server, backserver;
  int    len;
  struct rpc_msg *r_hdr;
  int dummy;
  XObj old_rpc_s;
  
  /* Decode header */
  bzero(&hdr,sizeof(struct rpc_msg));
  if (msg_isnull(data = decode_hdr(&hdr,dg))) {
    TRACE0(sun_rpcp, 3, "rpc_demux: can't decode header!");
    TRACE0(sun_rpcp, 9, "error 1");
    msg_free(dg);
    return(0);
  }
  msg_clear(dg);
  
#ifndef NDEBUG
  IFTRACE(sun_rpcp,5) {
    printf("rpc_demux hdr: \n");
    prpchdr(hdr);
  }
#endif
  
  /* create hdr for errors */
  r_hdr = (struct rpc_msg *) malloc(sizeof(struct rpc_msg));
  bzero(r_hdr,sizeof(struct rpc_msg));
  r_hdr->rm_xid = hdr.rm_xid;
  r_hdr->rm_direction  = REPLY;
  
  
  /* Look into header for info about who to send the msg to */
  if (hdr.rm_direction == CALL) {
    
    /* check if RPC version is valid */
    if ((hdr.rm_call.cb_rpcvers > RPC_VERS_HIGH) || 
        (hdr.rm_call.cb_rpcvers < RPC_VERS_LOW)) {
      r_hdr->rm_reply.rp_stat  = MSG_DENIED;
      r_hdr->rm_reply.rp_rjct.rj_stat = RPC_MISMATCH;
      r_hdr->rm_reply.rp_rjct.rj_vers.high =  RPC_VERS_HIGH;
      r_hdr->rm_reply.rp_rjct.rj_vers.low =  RPC_VERS_LOW;
      err_push(s,r_hdr);
      free(r_hdr);
      clean_hdr(&hdr);
      msg_free(data);
      return(0);
    }
    
    /* flesh out server address */
    server.prog = hdr.rm_call.cb_prog;
    server.vers = hdr.rm_call.cb_vers;
    server.proc = hdr.rm_call.cb_proc;
    server.prot = 17;
    x_controlsessn(s, GETMYADDR, (char *)&server.host, UDPADLEN);
    x_controlsessn(s, GETPEERADDR, (char *)&client.host, UDPADLEN);
    ext_id.server = server;
    ext_id.client = client.host;
    ext_id.direction = REPLY;

#ifndef NDEBUG
    IFTRACE(sun_rpcp,7) {
      printf("rpc_demux: ext_id  =\n");
      prpcaddr(ext_id.server);
      pudpaddr(ext_id.client);
    }
#endif

    rpc_s = (XObj) map_resolve(activemap, (char *) &ext_id);
  } else {
    /* find client session */
    if (x_is_protocol(s->up)) {
      /* punt */
      free(r_hdr);
      clean_hdr(&hdr);
      TRACE0(sun_rpcp, 9, "error 3");
      msg_free(data);
      return(0);
    }
    rpc_s = s->up;
  } 
  
  TRACE1(sun_rpcp,7,"rpc_demux: rpc_s = %d",rpc_s);
  
  if (hdr.rm_direction == REPLY) {
    if (rpc_s == ERR_XOBJ) {
      /* punt */
      free(r_hdr);
      clean_hdr(&hdr);
      TRACE0(sun_rpcp, 9, "error 3");
      msg_free(data);
      return(0);
    }
    TRACE1(sun_rpcp, 3, "SUNRPC found client session %x", rpc_s);
    
    rpc_state = (SUNRPC_STATE *) rpc_s->state;
    
    if (rpc_state->xid != hdr.rm_xid) {
      /* old transaction */
      free(r_hdr);
      clean_hdr(&hdr);
      TRACE0(sun_rpcp, 0, "rpc_demux: transaction id mismatch");
      msg_free(data);
      return(0);
    }
    
    /* extract error information from header and put into state */
    translate_error(&hdr,&rpc_state->error);
    
    if (hdr.rm_reply.rp_stat == MSG_ACCEPTED) {
      auth_free(&(rpc_state->verf));
      rpc_state->verf = hdr.acpted_rply.ar_verf;
      hdr.acpted_rply.ar_verf = auth_dummy;
    } 
    
    /* Deposit incoming reply message in the client's */
    /* state info and then unblock the client. */
    flush_msg(rpc_state->rtstmsg);
    
    TRACE1(sun_rpcp,7,"rpc_demux after decode: msg_len= %d\n",msg_len(data));
    
    if (rpc_state->error.re_status == RPC_SUCCESS) {
      rpc_state->rtstmsg = data; 
    } else {
      TRACE0(sun_rpcp, 0, "SUNRPC CALL FAILED");
      msg_clear(rpc_state->rtstmsg); 
      msg_free(data);
    }
    /* remove timeout */
    event_register(rpc_timeout, (int)rpc_s, 0, EV_REMOVE);
    /* Setup timeout stuff  (incase someone reuses session)*/
    rpc_state->tries = rpc_state->old_tries;
    V(&rpc_state->reply_sem);
    free(r_hdr);
    return(0);
    
  } else if (hdr.rm_direction == CALL) {
    if (rpc_s != ERR_XOBJ) {
      /* punt must be retrie */
      TRACE0(sun_rpcp, 9, "error 4");
      free(r_hdr);
      clean_hdr(&hdr);
      msg_free(data);
      return(0);
    }
    TRACE0(sun_rpcp, 3, "SUNRPC looking for server");
    
    /* server ext_id = SUNRPCaddr + "******" */
    bcopy(generic, &ext_id.client, UDPADLEN);
    bcopy(generic, &ext_id.direction, 4);
    hlp = (XObj)map_resolve(passivemap, (char *) &ext_id);
    if (hlp == (XObj) -1) {
      /* punt cant find server session */
      /* will not even try to find out why! */
      TRACE0(sun_rpcp, 9, "error 5");
      r_hdr->rm_reply.rp_stat  = MSG_ACCEPTED;
      r_hdr->rm_reply.rp_acpt.ar_stat = PROC_UNAVAIL;
      err_push(s,r_hdr);
      clean_hdr(&hdr);
      free(r_hdr);
      msg_free(data);
      return(0);
    }
    
    TRACE0(sun_rpcp, 3, "SUNRPC found server ");
    init_partlist(part, 2, SUNRPCaddr);
    set_part(part, 0 ,client);
    set_part(part, 1 ,server);
    if ((rpc_s=x_opendone(hlp, SUNRPC, part))
	== ERR_XOBJ) {
      /* punt */
      TRACE0(sun_rpcp, 9, "error 6");
      r_hdr->rm_reply.rp_stat  = MSG_ACCEPTED;
      r_hdr->rm_reply.rp_acpt.ar_stat = GARBAGE_ARGS;
      err_push(s,r_hdr);
      clean_hdr(&hdr);
      free(r_hdr);
      msg_free(data);
      return(0);
    }
    
    rpc_state = (SUNRPC_STATE *) rpc_s->state;
    rpc_s->down[0] = s;
    rpc_state->xid = hdr.rm_xid;
    auth_free(&(rpc_state->verf));
    auth_free(&(rpc_state->cred));
    rpc_state->verf = hdr.rm_call.cb_verf;
    rpc_state->cred = hdr.rm_call.cb_cred;
    hdr.rm_call.cb_cred = auth_dummy;
    hdr.rm_call.cb_verf = auth_dummy;
    
    if (rpc_state->errhdr) free(rpc_state->errhdr);
    rpc_state->errhdr = r_hdr;
    x_pop(rpc_s,s, data); 
    x_close(rpc_s);
    return(0);
  }
  
  /* Drop call messages for which we can't find a server */
  /* that has done an openenable, or for call messages  */
  /* to an already open session (i.e. a duplicate call   */
  /* the server is already servicing), or for reply messages */
  /* for which we can't find a waiting caller. */
  
  TRACE0(sun_rpcp, 3, "SUNRPC demux dropping the message");
  free(r_hdr);
  clean_hdr(&hdr);
  msg_free(data);
  return(0);
}

static clean_hdr(hdr) 
     struct rpc_msg *hdr;
{
  if (hdr->rm_direction == CALL) {
    auth_free(&(hdr->rm_call.cb_verf));
    auth_free(&(hdr->rm_call.cb_cred));
  } else if (hdr->rm_reply.rp_stat == MSG_ACCEPTED) {
    auth_free(&(hdr->acpted_rply.ar_verf));
  } 
}


static rpc_pop(self,s, dg)
     XObj   self;
     XObj   s;
     Msg     dg;
{
  SUNRPC_STATE *rpc_state;
  
  TRACE0(sun_rpcp, 3, "SUNRPC_pop");
  
  /* x_pop is only done for call messages received by server */
  
  return(x_demux(self,dg));
}

/* RPC requires many control opcodes  
   Those begining with RPC may be used
   by either client or server. Those
   begining with SVC are only defined for
   server. Thouse begining with CLNT are
   only defined for client.
   */
static rpc_controlprotl(self,opcode, buf, len)
     XObj	self;
     int     opcode;
     char    *buf;
     int     len;
{
  switch (opcode) {
    
  case GETMYADDR:
    return(x_controlprotl(UDP, GETMYADDR, buf, len));
    break;
    
  case SUNRPC_GETPORT:
    checkLen(len, sizeof(short));
    {u_short port;
     port = (u_short) get_port();
     bcopy(&port,buf,sizeof(short));
     return(0);
   }
    break;
    
  default:
    x_errno = INVALID_OPCODE;
    return(-1);
  } 
}

static rpc_controlsessn(s, opcode, buf, len)
     XObj   s;
     int     opcode;
     char    *buf;
     int     len;
{
  SUNRPC_STATE *rpc_state;
  struct rpc_msg *hdr;
  int i,j,k;
  
  TRACE1(sun_rpcp, 3, "in rpc_control with session=%x\n", s); 
  
  rpc_state = (SUNRPC_STATE *) s->state;
  
  switch (opcode) {
    
    /* copy high level protocol to  buf */
    /* wild hack to help server demux figure */
    /* out who he is. */
  case SUNRPC_SVCGETHLP: 
    checkLen( len, sizeof(s->up));
    bcopy(&s->up,buf,sizeof(s->up));
    return(0);
    break;
    
    /* copy argument's xdr byte string to buf */
    /* copy RPC error status structure to buf */
  case SUNRPC_CLNTGETERROR: 
    checkLen( len, sizeof(struct rpc_err));
    bcopy(&rpc_state->error,buf, sizeof(struct rpc_err));
    return(0);
    break;
    
    /* copy callers UDP address to buf */
  case SUNRPC_SVCGETCALLER:
    return(x_controlsessn(s->down[0], GETPEERADDR, buf, len));
    break;
    
    /* copy servers RPC address to buf */
  case SUNRPC_SVCGETSERVER:
    checkLen( len, SUNRPCADLEN);

#ifndef NDEBUG
    IFTRACE(sun_rpcp, 9) {
      prpcaddr(rpc_state->server);
    }
#endif

    bcopy(&rpc_state->server,buf,SUNRPCADLEN);
    return(0);
    break;
    
    /* set ttout the clients timeout value */ 
  case SUNRPC_CLNTSETTOUT:
    checkLen( len, TIMEVALLEN);
    bcopy(buf,&rpc_state->tout,TIMEVALLEN);
    return(0);
    break;
    
    /* copy ttout to buf */
  case SUNRPC_CLNTGETTOUT:
    checkLen( len, TIMEVALLEN);
    bcopy(&rpc_state->tout,buf,TIMEVALLEN);
    return(0);
    break;
    
    /* set clients wait value */
  case SUNRPC_CLNTSETWAIT:
    checkLen( len, TIMEVALLEN);
    bcopy(buf,&rpc_state->wait,TIMEVALLEN);
    return(0);
    break;
    
    /* copy wait to buf */
  case SUNRPC_CLNTGETWAIT:
    checkLen( len, TIMEVALLEN);
    bcopy(&rpc_state->wait,buf,TIMEVALLEN);
    return(0);
    break;
    
    /* get authentication credentials type*/
  case SUNRPC_GETCREDTYPE:
    checkLen( len, sizeof(int));
    bcopy(&rpc_state->cred.oa_flavor,buf,sizeof(int));
    return(0);
    break;
    
    /* get authentication credentials */
  case SUNRPC_GETCRED:
    checkLen( len, rpc_state->cred.oa_length); 
    bcopy(&rpc_state->cred.oa_base,buf,rpc_state->cred.oa_length);
    return(0);
    break;
    
    /* set authentication credentials type*/
  case SUNRPC_SETCREDTYPE:
    checkLen( len, sizeof(int));
    auth_free(&(rpc_state->cred));
    bcopy(buf,&rpc_state->cred.oa_flavor,sizeof(int));
    return(0);
    break;
    
    /* set authentication credentials data*/
  case SUNRPC_SETCRED:
    if (rpc_state->cred.oa_base != 0) {
      auth_free(&(rpc_state->cred));
    }
    rpc_state->cred.oa_length = len;
    rpc_state->cred.oa_base = (caddr_t) malloc(len+2);
    bcopy(buf,rpc_state->cred.oa_base,len);
    {
      char *mname, *str_save();
      struct authunix_parms *au_ptr;
      
      /* copy over the string, so we can possibly avoid user/kernel
       * boundary problems at levels below rpc.  Dave 4-22 */
      au_ptr = (struct authunix_parms *) rpc_state->cred.oa_base;
      assert(au_ptr != NULL);
      mname = au_ptr->aup_machname;  /*existing machname-user ptr? */
    }
    
    return(0);
    break;
    
    /* get authentication verification type */
  case SUNRPC_GETVERFTYPE:
    checkLen( len, sizeof(int));
    bcopy(&rpc_state->verf.oa_flavor,buf,sizeof(int));
    return(0);
    break;
    
    /* get authentication verification */
  case SUNRPC_GETVERF:
    checkLen( len, rpc_state->verf.oa_length); 
    bcopy(&rpc_state->verf.oa_base,buf,rpc_state->verf.oa_length);
    return(0);
    break;
    
    
    /* set authentication verification type*/
  case SUNRPC_SETVERFTYPE:
    checkLen( len, sizeof(int));
    auth_free(&(rpc_state->verf));
    bcopy(buf,&rpc_state->verf.oa_flavor,sizeof(int));
    return(0);
    break;
    
    /* set authentication verification data*/
  case SUNRPC_SETVERF:
    if (rpc_state->verf.oa_base != 0) {
      auth_free(&(rpc_state->verf));
    }
    rpc_state->verf.oa_length = len;
    rpc_state->verf.oa_base = (caddr_t) malloc(len+2);
    bcopy(buf,&rpc_state->verf.oa_base,len);
    return(0);
    break;
    
    /* cause an authentication error message to be sent. */
  case SUNRPC_SVCAUTHERR:
    {
      checkLen(len , sizeof(enum auth_stat)) ;
      hdr = rpc_state->errhdr;
      hdr->rm_reply.rp_stat = MSG_DENIED;
      hdr->rm_reply.rp_rjct.rj_stat = AUTH_ERROR;
      bcopy(buf,hdr->rm_reply.rp_rjct.rj_why,sizeof (enum auth_stat));
      err_push(s->down[0],hdr);
      return(0);
      break;
    }
    
    /* cause a garbage arguments error message to be sent. */
  case SUNRPC_SVCGARBAGEARGS:
    {
      hdr = rpc_state->errhdr;
      hdr->rm_reply.rp_stat = MSG_ACCEPTED;
      hdr->rm_reply.rp_acpt.ar_stat = GARBAGE_ARGS;
      hdr->rm_reply.rp_acpt.ar_verf = rpc_state->verf;
      err_push(s->down[0],hdr);
      return(0);
      break;
    }
    
    /* cause a system error message to be sent. */
  case SUNRPC_SVCSYSTEMERR:
    {
      hdr = rpc_state->errhdr;
      hdr->rm_reply.rp_stat = MSG_ACCEPTED;
      hdr->rm_reply.rp_acpt.ar_stat = SYSTEM_ERR;
      hdr->rm_reply.rp_acpt.ar_verf = rpc_state->verf;
      err_push(s->down[0],hdr);
      return(0);
      break;
    }

  default:
    x_errno = INVALID_OPCODE;
    return(-1);
  }
  return(-1);
}


static rpc_timeout(s)
     XObj   s;
{
  SUNRPC_STATE *rpc_state;
  Msg msg;
  
  rpc_state = (SUNRPC_STATE *) s->state;
  TRACE2(sun_rpcp, 1, "SUNRPC timeout s=%x, s->state=%x", s, rpc_state);
  
  /*
    if (msg_isnull(rpc_state->rtstmsg)) {
    TRACE2(sun_rpcp, 1, "SUNRPC timeout s=%x, s->state=%x", s, rpc_state);
    event_register(rpc_timeout, (int)s, 0, EV_REMOVE);
    return(0);
    }
    don't know what this is good for; seems to prevent retries.
    Peter, 12-18  */
  
  /* I don't want xserver to ever timout! - mjk */
  
  /* commenting out this entire check - should never quit trying
     to reconnect after a timeout...
     
     rpc_state->tries = rpc_state->tries - 1;
     if (rpc_state->tries < 0) {
     event_register(rpc_timeout, (int)s, 0, EV_REMOVE);
     * wake up rpc_push for the bad news *
     V(&rpc_state->reply_sem);
     TRACE0(sun_rpcp, 1, "SUNRPC timeout: quitting");
     * Setup timeout stuff  (incase someone reuses session) *
     rpc_state->tries = rpc_state->old_tries;
     return(0);
     }
     
     */
  
  TRACE0(sun_rpcp, 0, "SUNRPC timeout: trying again");
  
  msg_save(msg,rpc_state->ctstmsg);
  return(x_push(s->down[0],msg,(Msg *)0));
}

#define XDRHDRSIZE 150 
static Msg encode_hdr ( hdr,msg) 
     struct rpc_msg *hdr;
     Msg msg;
{
  static int first = 1;
  static XDR xdrs;
  static char raw[XDRHDRSIZE]; /*=0;*/
  static int raw_len;
  
#ifndef NDEBUG
  IFTRACE(sun_rpcp,7) {
    printf("encode_hdr:\n");
    prpchdr(*hdr);
  }
#endif

  if (first) {
    xdrmem_create(&xdrs,raw,XDRHDRSIZE,XDR_ENCODE);
    first = 0;
  }
  
  XDR_SETPOS(&xdrs,0);
  
  /* new stream for each message */
  if (hdr->rm_direction == CALL) { 
    if (!xdr_callmsg(&xdrs,hdr)) {
      return(null_msg);
    }
  } else {
    if (!xdr_replymsg(&xdrs,hdr)) {
      return(null_msg);
    }
  }
  raw_len = (int) XDR_GETPOS(&xdrs);
  bcopy(raw,msg_push(msg,raw_len),raw_len);
  return(msg);
}

static Msg decode_hdr ( hdr,msg) 
     struct rpc_msg *hdr;
     Msg msg;
{
  static int first=1;
  static char *buf;
  int len;
  int end;
  static int cur_len;
  static XDR xdrs; /* = 0; */
  
  len = msg_stack_len(msg);
  xdrmem_create(&xdrs,msg_top(msg,MIN(XDRHDRSIZE,len)),MIN(XDRHDRSIZE,len),
		XDR_DECODE);
  if (!xdr_callmsg(&xdrs,hdr)) {
    XDR_SETPOS(&xdrs,0);
    if (!xdr_replymsg(&xdrs,hdr)) {
      free(buf);
      return(null_msg);
    }
  }
  end = (int) XDR_GETPOS(&xdrs);
  TRACE2(sun_rpcp, 7,"decode hdr: len=%d poping=%d bytes \n",msg_len(msg),end);
  msg_pop(msg,end);
  return(msg);
}


static unsigned long get_xid()
{
  static unsigned long curxid=1;
  
  return(curxid++);
}


static u_short ports[128] = { 0, /* ... */ };
static int top_port=127;

static u_short get_port()
{
  static u_short first=1; 
  int i;
  
  if (first) {
    first=0;
    for (i=0;i<128;i++) ports[i]=112+i;
    top_port=127;
  }
  if (top_port < 0) 
    printf("sun_rpc: Out of Ports!\n");
  
  return(ports[top_port--]);
}

static put_port(port)
     u_short port;
{
  ports[++top_port] = port;
}


/* push error message directly to udp session */
static err_push(s, hdr)
     XObj   s;
     struct rpc_msg   *hdr;
{
  Msg   msg;
  
  TRACE0(sun_rpcp, 3, "in err_push");
  
  msg_make_allstack(msg,256,0,0);
  if (msg_isnull(msg = encode_hdr(hdr,msg))) {
    TRACE0(sun_rpcp, 3, "err_push: can't encode header");
  }
  
#ifndef NDEBUG 
  IFTRACE(sun_rpcp,7) {
    printf("err_push: \n");
    prpchdr(*hdr);
  }
#endif
  
  x_push(s, msg,(Msg *)0);
}


static translate_error(hdr,err)
     struct rpc_msg *hdr;
     struct rpc_err *err;
{
  err->re_status = RPC_SUCCESS;
  if (hdr->rm_direction == CALL) {
    TRACE0(sun_rpcp,3,"translate_error: call msg cant be error!");
    return;
  }
  if (hdr->rm_reply.rp_stat == MSG_ACCEPTED) {
    switch(hdr->rm_reply.rp_acpt.ar_stat)   {
    case SUCCESS:
      err->re_status = RPC_SUCCESS;
      break;
    case PROG_UNAVAIL:
      err->re_status = RPC_PROGUNAVAIL;
      break;
    case PROG_MISMATCH:
      err->re_status = RPC_PROGVERSMISMATCH;
      err->re_vers.low = hdr->rm_reply.rp_acpt.ar_vers.low; 
      err->re_vers.high = hdr->rm_reply.rp_acpt.ar_vers.high; 
      break;
    case PROC_UNAVAIL:
      err->re_status = RPC_PROCUNAVAIL;
      break;
    case GARBAGE_ARGS:
      err->re_status = RPC_CANTDECODEARGS;
      break;
    case SYSTEM_ERR:
      err->re_status = RPC_SYSTEMERROR;
      break;
    default:
      TRACE0(sun_rpcp,3,"translate_error: invalid accept status\n");
      err->re_status = RPC_SYSTEMERROR;
      break;
    }
  } else {
    if (hdr->rm_reply.rp_rjct.rj_stat = RPC_MISMATCH) {
      err->re_status = RPC_VERSMISMATCH;
      err->re_vers.low = hdr->rm_reply.rp_rjct.rj_vers.low; 
      err->re_vers.high = hdr->rm_reply.rp_rjct.rj_vers.high; 
    } else if (hdr->rm_reply.rp_rjct.rj_stat = AUTH_ERROR) {
      err->re_status = RPC_AUTHERROR;
      err->re_why = hdr->rm_reply.rp_rjct.rj_why; 
    } else {
      TRACE0(sun_rpcp,3,"translate_error: invalid reject status\n");
      err->re_status = RPC_SYSTEMERROR;
    }
  }
}


static auth_free(auth)
     struct opaque_auth *auth;
{
  switch (auth->oa_flavor) {
  case 0: 
    *auth = auth_dummy;
    return;
  default:
    if (auth->oa_base) free(auth->oa_base);
    *auth = auth_dummy;
    return;
  }
}


char *str_save(s)
     char *s;
{
  char *cptr;
  
  cptr = (char *) malloc ( strlen(s) +1);
  strcpy(cptr, s);
  return(cptr);
}


sun_rpc_getproc(p,type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = rpc_instantiateprotl;
    p->init = rpc_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = rpc_controlprotl;
  } else {
    p->push = rpc_push;
    p->pop = rpc_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = rpc_controlsessn;
    p->close = rpc_closesessn;
  }
  p->open = (Pfi) rpc_open;
  p->openenable = rpc_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = rpc_demux;
  p->getproc = sun_rpc_getproc;
}


E 1
