/* 
 * spc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 *
 * Contains:
 *	spc_init
 *	spc_demux
 *	spc_push
 *	dump_hdr
 *
 *
 * Contains dummies:
 *	spc_opendone		- This work gets done in spc_srvr_demux.
 *	spc_pop			- There isn't an spc_pop; instead popping code
 *					gets called directly by demux code.
 *	spc_close		- not implemented (yet)
 *	spc_controlprotl	- not implemented yet
 *	spc_controlsessn	- not implemented yet
 *
 *
 * Does NOT contain:
 *	spc_open		- It's in spc_clnt, since only clients call it.
 *	spc_openenable		- It's in spc_srvr, since only servers call it.
 */

#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"
#include "spc.h"
#include "spc_internal.h"

int tracespcp=0;

extern XObj spc_open();
extern int spc_openenable();

/*
 * global data for SPC
 */

unsigned char	Spc_protl_num;	
IPhost		Local_host;
unsigned	Local_boot_id =	BOGUS_BOOT_ID;

Map		Clnt_map;		/* srvr_host+srvrId => sessn */
Map		Clnt_chan_map;		/* chan+remote_host => cstate */
Map		Srvr_chan_map;		/* chan+remote_host => cstate */
Map		Srvr_map;		/* srvrId => sessn */
Map		Avail_chan_map;		/* remote_host => cstate list*/

int spc_miss=0;

XObj SPC_SELF=0;
XObj IP=0;

static spc_instantiateprotl(self)
     XObj self;
{
  TRACE0(spcp,1,"spc instantiateprotl");
  SPC_SELF = self;
  IP = x_getprotlbyname("ip");
  Spc_protl_num = 45;	
}


/*
 * SPC_INIT
 */
static spc_init(self)
     XObj self;
{
  IPaddr	localIpAddr;
  Part	vip_participants[ 2 ];
  
  TRACE0(spcp,4,"spc_init");
  /* create the maps used by SPC */
  Clnt_map = map_create( CLNT_MAP_SZ, sizeof(CLNT_KEY));
  Clnt_chan_map = map_create( CLNT_CHAN_MAP_SZ, sizeof(CHAN_KEY));
  Srvr_chan_map = map_create( SRVR_CHAN_MAP_SZ, sizeof(CHAN_KEY));
  Srvr_map = map_create( SRVR_MAP_SZ, sizeof(SRVR_KEY));
  Avail_chan_map = map_create( AVAIL_CHAN_MAP_SZ, 4 );
  
  /* get id (IPhost) of local host */
  x_controlprotl( IP, GETMYADDR, (char*) &Local_host, IPADLEN );
  
  /* tell IP that SPC is willing to accept msgs (this is for servers) */
  localIpAddr.host = Local_host;
  localIpAddr.protocolnum = Spc_protl_num;
  vip_participants[0].address = (char*) &localIpAddr;
  vip_participants[0].length = sizeof( IPaddr );
  vip_participants[1].address = NULL;
  vip_participants[1].length = 0;
  x_openenable( SPC_SELF, SPC_SELF->down[0], vip_participants );
  
  return( SUCCESS );
} /* end spc_init */


/*
 * SPC_PUSH
 *
 * Determine whether this is a client sessn or a server sessn,
 * and invoke the corresponding version of push.
 */

spc_push( sessn, higher_level_msg, reply_msg_ptr )
     XObj	sessn;
     Msg		higher_level_msg;
     Msg*	reply_msg_ptr;
{
  TRACE0(spcp,4,"spc_push");
  
  if( ((SPCstate*) sessn->state)->is_clnt ){
    if( reply_msg_ptr == (Msg*) NULL ){
      return( ERR );
    }else{
      return(spc_clnt_push( sessn, higher_level_msg, reply_msg_ptr ));
    }
  }else{
    return( spc_srvr_push( sessn, higher_level_msg ) );
  }
} /* end spc_push */


/*
 * SPC_DEMUX
 *
 * Determine whether this msg is for a server, or a client,
 * and invoke the corresponding version of demux.
 */

spc_demux( self, ip_sessn, spc_msg )
     XObj	self;
     XObj	ip_sessn;
     Msg	spc_msg;
{
  SPChdr*	hdr_ptr;
  
  TRACE0(spcp,3,"received a message in spc_demux\n");
  hdr_ptr = (SPChdr*) msg_top( spc_msg, SPC_HDR_SZ );
  if( hdr_ptr->flags & FOR_SRVR ){
    return( spc_srvr_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
  }else{
    return( spc_clnt_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
  }
} /* end spc_demux */


/*
 * SPC_CLOSE
 *
 * This closes a sessn; what about channels?
 */

spc_close( sessn )
     XObj	sessn;
{
  TRACE1(spcp,1,"spc_close: session %x", sessn );
  
  if( --(sessn->rcnt) == 0 ){
    /* no-one refers to this sessn, so tear it down */
    map_unbindbinding( Clnt_map, sessn->binding );
    x_destroysession( sessn );
  }
  return( SUCCESS );
} /* end spc_close */


/*
 * SPC_CONTROLPROTL
 *
 *
 */

spc_controlprotl(self, opcode, buf_ptr, buf_len )
     XObj 	self;
     int	opcode;
     char*	buf_ptr;
     int	buf_len;
{
} /* end spc_controlsessn */


/*
 * SPC_CONTROLSESSN
 *
 * NOT IMPLEMENTED (YET).
 */

spc_controlsessn( sessn, opcode, buf_ptr, buf_len )
     XObj	sessn;
     int	opcode;
     char*	buf_ptr;
     int	buf_len;
{
} /* end spc_controlprotl */


/*
 * SPC_POP
 */

spc_pop( spc_sessn, down_s, spc_msg )
     XObj	spc_sessn;
     XObj    down_s;
     Msg	spc_msg;
{
}


/*
 * SPC_OPENDONE
 */
spc_opendone( sessn, participants )
     XObj	sessn;
     Part*	participants;
{
}


/*
 * DUMP_HDR
 */

void dump_hdr( hdr_ptr, trace_level )
     SPChdr*	hdr_ptr;
     int	trace_level;
{
  TRACE5(spcp,trace_level,
	 "seq_num=%d   chan=%d   flags=%x   srvrId=%d   data1_sz=%d",
	 hdr_ptr->seq_num, hdr_ptr->chan, hdr_ptr->flags,
	 hdr_ptr->srvrId, hdr_ptr->data1_sz );
}

/* fill in a protocol or session object with correct stuff */

spc_getproc(p,type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = spc_instantiateprotl;
    p->init = spc_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = spc_controlprotl;
  } else {
    p->push = spc_push;
    p->pop = spc_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = spc_close;
    p->control = spc_controlsessn;
  }
  p->demux = spc_demux;
  p->open = (Pfi) spc_open;
  p->openenable = spc_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->getproc = spc_getproc;
}
