/*
 * icmp_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ip_h
#include "ip.h"
#endif


typedef struct icmp_hdr {
	u_char	icmp_type;	
	u_char	icmp_code;	
	short	icmp_cksum;
} ICMPHeader;

typedef struct common_prefix {
	u_short   icmp_id;
	u_short   icmp_seqnum;
	/* ignoring data part */
} ICMPPrefix, ICMPEcho, ICMPInfoReq, ICMPInfoReply;

typedef struct offending_dg {
	IPheader	icmp_dest;
	char		icmp_bits[48]; /* includes 40 octets for options */
} ICMPBadMsg;


typedef struct common_format {
  ICMPHeader    hdr;
  u_long	icmp_zero;
  ICMPBadMsg	icmp_badmsg;
} ICMPUnreach, ICMPSourceQuench, ICMPTimeout;


typedef struct redirect {
  ICMPHeader    hdr;
  IPhost	icmp_gw;
  ICMPBadMsg	icmp_badmsg;
} ICMPRedirect;

typedef struct bad_param {
  ICMPHeader    hdr;
  u_char	icmp_pointer;
  u_char	icmp_zero[3];
  ICMPBadMsg	icmp_badmsg;
} ICMPSyntaxError;

typedef struct timestamps {
  ICMPHeader    hdr;
  ICMPPrefix	icmp_prefix;
  u_long	icmp_originate;
  u_long	icmp_receive;
  u_long	icmp_transmit;
} ICMPTimeStamp;

typedef struct icmpstate {
  Sessn down_s;
} ICMPState;

