/*
 * dns_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#define NEW(m) (m *)malloc(sizeof(m))

/* TYPE values	*/
/* QTYPE values	*/
#define	A	1			/* host address */
#define NS	2			/* an authoritative name server */
#define MD	3			/* a mail destination (obsolete) */
#define MF	4			/* a mail forwarder (obsolete) */
#define CNAME	5			/* the canonical name for an alias */
#define SOA	6			/* start of a zone of authority */
#define MB	7			/* mailbox domain name */
#define MG	8			/* mail group member */
#define MR	9			/* mail rename domain name */
#define NUL	10			/* null RR */
#define WKS	11			/* a well known service */
#define PTR	12			/* a domain name pointer */
#define HINFO	13			/* host information */
#define	MINFO	14			/* mailbox information */
#define MX	15			/* mail exchange */
#define TXT	16			/* text strings */
/* end of TYPE	*/
#define AXFR	252			/* request entire zone */
#define MAILB	253			/* request mailbox RRs */
#define MAILA	254			/* request mail agent RRs */
#define ALL	255			/* request all RRs */

/* CLASS value	*/
/* QCLASS	*/
#define IN	1			/* Internet */
#define CS	2			/* CSNet */
#define CH	3			/* CHAOS */
#define HS	4			/* Hesiod */
/* end of CLASS	*/
#define ANY	255			/* Obvious */

#define RCODEM 	0xf			
#define RZM	0x70
#define RRAM	0x80
#define RRDM	0x100
#define RTCM	0x200
#define RAAM	0x400
#define ROPCM	0x7800
#define RQRM	0x8000

/* OPCODE	*/
#define	QUERY	0
#define IQUERY	0x800
#define STATUS	0x1000

/* RCODE	*/
#define NOERR	0
#define FMTERR	1
#define SVRFAIL	2
#define NMERR	3
#define NOTIMP	4
#define	REFUSED	5

/* local error code	*/
#define RTIMEOUT 6

/* basic internal structure of names */
typedef struct Iname {
  unsigned size;
  unsigned char *name;
  unsigned char *base;
} Iname;

/* internal domain name format	*/
typedef struct rdname {
  Iname name;
  unsigned short type;
  unsigned short class;
} Name;

/* internal structure of resource record	*/
typedef struct ResRecord {
  Name name;
  int ttl;	
  unsigned short dlen;
  unsigned char *data;
  struct ResRecord *next;
} ResRecord;

/* name servers to query */
typedef struct rns {
  int zoneq;		/* the label match count from the root	*/
  Iname name;		/* a name string			*/
  int addrfound;	/* see if IPaddr are found		*/
  IPaddr addr;
  struct rns *next;
} RNS;

/* message header format	*/
typedef struct rheader {
  unsigned short id;
  union {
    struct {
      unsigned short qr:1,
		     opcode:4,
		     aa:1,
		     tc:1,
		     rd:1,
		     ra:1,
		     z:3,
		     rcode:4;
    } flags;
    unsigned short all;
  } flags;
  unsigned short qdcnt;
  unsigned short ancnt;
  unsigned short nscnt;
  unsigned short arcnt;
} RHEADER;
#define RHDRLEN sizeof(RHEADER)

typedef struct rstate {
  RHEADER hdr;
  Name name;
  RNS *list;
  int result;
  Semaphore s;
  struct rstate *next;
  unsigned char *msgbuf;
} RSTATE;

/* flags for result	*/
#define DNS_RESOLVED 0
#define DNS_QUERYING 1
#define DNS_TIMEOUT 2

#define DNS_TIME 10000	/* 10 sec to timeout for a pending query	*/
#define SECOND	1000

/* eventually, every message will be translated into internal form	*/

#define CAP(m) (((m)>96 && (m)<123)?((m)-32):(m))

typedef struct {
  unsigned short id;
  unsigned short spad;
  unsigned long  lpad;
} PendingKey;

typedef struct pstate {
  Map		pending;
  UDPaddr	clntaddr;
  UDPaddr	srvraddr;
  Semaphore	pending_s;
  int		current_id;
  RNS		*sbelt;
}	PSTATE;


