h40939
s 00007/00002/00423
d D 1.3 91/02/11 18:15:57 menze 3 2
c trace statements added
e
s 00016/00016/00409
d D 1.2 91/01/10 11:45:25 llp 2 1
c Prepared for 3.1 Distribution
e
s 00425/00000/00000
d D 1.1 90/11/16 10:53:32 menze 1 0
c date and time created 90/11/16 10:53:32 by menze
e
u
U
f e 0
t
T
I 1
/*
 * vsize.c	
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "arp.h"
#include "blast.h"
#include "vsize.h"
#include "vsize_internal.h"

int tracevsizep;

/* These macros map between BLAST and ETH protocol ID's.  Since the ETH
 * protocol ("type") field is just two bytes, protocols which use VSIZE
 * must have blast protocol numbers which are less than 0xffff - 0x500,
 * and such that this value is not a reserved ETH type.
 */
#define BLASTTOETH(X) (((X) & 0xffff) + 0x500)
#define ETHTOBLAST(X) ((X) - 0x500)

static XObj VSIZE_SELF, IP, ETH, ARP;

typedef union {
    IPhost	ip;
    ETHhost	eth;
} IPorETH;    


vsize_init(self)
    XObj self;
{
    PSTATE	*pstate;
    
    TRACE0(vsizep, 1, "VSIZE init");

    assert(x_is_protocol(self));
    if (VSIZE_SELF) {
	Kabort("vsize_init: can not open two VSIZE protocols !");
    }
    VSIZE_SELF = self;
    ETH = x_getprotlbyname("eth");
    ARP = x_getprotlbyname("arp");
    IP = x_getprotlbyname("ip");
    
    IFTRACE(vsizep,1) x_printxobj(self);
    
    pstate = (PSTATE *) malloc(sizeof(PSTATE));
    self->state = (char *)pstate;
D 2
    if (x_controlprotl(self->down[1], MAXPACKET, (char *)&pstate->cutoff, 4)
E 2
I 2
    if (x_controlprotl(self->down[1], GETMAXPACKET, (char *)&pstate->cutoff, 4)
E 2
	< 0) {
	TRACE0(vsizep, 1, "Can't get ethernet maxpacket");
	return -1;
    }
D 2
    if (x_controlprotl(IP, MYADDR, (char *)&pstate->myIPhost, sizeof(IPhost))
E 2
I 2
    if (x_controlprotl(IP, GETMYADDR,(char *)&pstate->myIPhost, sizeof(IPhost))
E 2
	< 0) {
	TRACE0(vsizep, 1, "Can't get ip addr");
	return -1;
    }
D 2
    if (x_controlprotl(ETH, MYADDR, (char *)&pstate->myETHhost,
E 2
I 2
    if (x_controlprotl(ETH, GETMYADDR, (char *)&pstate->myETHhost,
E 2
		       sizeof(ETHhost))	< 0) {
	TRACE0(vsizep, 1, "Can't get ETH addr");
	return -1;
    }
    pstate->active_map = map_create(10, sizeof(ActiveID));
    pstate->passive_map = map_create(10, sizeof(PassiveID));
    return(0);
}


XObj
vsize_open(self, hlp, p)
    XObj	self;
    XObj	hlp;
    Part	*p;
{
    XObj		s;
    VSIZE_STATE		*vs;
    Part  		part[3];
    ActiveID 		active_id;
    unsigned int 	blast_protocol;
    BLASTaddr		local_BLASTaddr, remote_BLASTaddr;
    ETHaddr		local_ETHaddr, remote_ETHaddr;
    IPorETH		iporeth;
    PSTATE		*pstate;
    
    TRACE0(vsizep, 3, "VSIZE open");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    pstate = (PSTATE *) self->state;
    if (!p) {
	TRACE0(vsizep, 1, "Bad participant set");
	x_errno = BAD_ADDR;
	return ERR_XOBJ;
    }
    local_BLASTaddr = get_part(p, 0, BLASTaddr);
    remote_BLASTaddr = get_part(p, 1, BLASTaddr);
    blast_protocol = remote_BLASTaddr.prot;
    TRACE5(vsizep, 4, "Remote BLAST address is %d @ %d.%d.%d.%d",
	   blast_protocol, remote_BLASTaddr.host.a, remote_BLASTaddr.host.b,
	   remote_BLASTaddr.host.c, remote_BLASTaddr.host.d);
    TRACE5(vsizep, 4, "Local BLAST address is %d @ %d.%d.%d.%d",
	   blast_protocol, local_BLASTaddr.host.a, local_BLASTaddr.host.b,
	   local_BLASTaddr.host.c, local_BLASTaddr.host.d);
    active_id.protocolnum = remote_BLASTaddr.prot;
    active_id.host = remote_BLASTaddr.host;
    if ((s=(XObj)map_resolve(pstate->active_map, (char *)& active_id)) != ERR_XOBJ) {
	TRACE0(vsizep, 4, "found an existing one");
	s->rcnt++;
	if (s->state == ST_INITIALIZING) {
	    /* it is being created */
	    P((Semaphore *)s->mutex);
	}
	if (s->state == ST_BROKEN) {
	    /* it could not be created */
	    x_close(s);
	    x_errno = BAD_ADDR;
	    return ERR_XOBJ;
	}
    } else {
	TRACE0(vsizep, 4, "creating a new one");
	s = x_createsession(hlp, self, 4);
	s->binding = map_bind(pstate->active_map, (char *)&active_id, (int)s);
	vs = (VSIZE_STATE *)malloc(sizeof(VSIZE_STATE));
	vs->remote_IPhost = remote_BLASTaddr.host;
	vs->peerBLASTaddr = remote_BLASTaddr;
	vs->myBLASTaddr = local_BLASTaddr;

	/* Opening a large-packet session.  Note that the new session's
	 * up field is made to point to this vip session (not the protocol)
	 */
	TRACE0(vsizep, 4, "Opening a large-packet session");
	vs->long_s = x_open(self, self->down[0], p);
	if (vs->long_s == ERR_XOBJ) {
	    TRACE0(vsizep, 4,
		   "vsize_open: could not open large-packet session");
	    return ERR_XOBJ;
	}
	vs->long_s->up = s; 
	
	/* Opening a short-packet session.  Note that the new session's
	 * up field is made to point to this vip session (not the protocol)
	 */
	local_ETHaddr.host = pstate->myETHhost;
	local_ETHaddr.type = remote_ETHaddr.type = BLASTTOETH(blast_protocol);
	iporeth.ip = remote_BLASTaddr.host;
	if (x_controlprotl(ARP, RESOLVE, (char *)&iporeth, sizeof(iporeth))
	    < 0) {
	    TRACE0(vsizep, 2, "VSIZE_open: could not resolve remote ETH addr");
	    x_close(vs->long_s);
	    return ERR_XOBJ;
	}
	remote_ETHaddr.host = iporeth.eth;
	init_partlist(part, 2, ETHaddr);
	set_part(part, 0, local_ETHaddr);
	set_part(part, 1, remote_ETHaddr);
	TRACE0(vsizep, 4, "Opening a short packet session");
	vs->short_s = x_open(self, self->down[1], part);
	if (vs->short_s == ERR_XOBJ) {
	    TRACE0(vsizep, 2, "vsize_open: could not open short pckt session");
	    x_close(vs->long_s);
	    return ERR_XOBJ;
	}
	vs->short_s->up = s;

	s->state = (char *) vs;
    }
    TRACE1(vsizep, 3, "VSIZE open returns %x", s);
    return(s);
}


vsize_controlsessn(s, opcode, buf, len)
    XObj s;
    int opcode, len;
    char *buf;
{
    register 	VSIZE_STATE *vs;
    PSTATE	*pstate;
    
    TRACE0(vsizep, 3, "VSIZE controlsessn");
    assert(x_is_session(s));
    pstate = (PSTATE *) s->myprotl->state;
    if (s <= (XObj)0) {
	x_errno = BAD_ADDR;
	return(-1);
    }
    vs = (VSIZE_STATE *) s->state;
    switch (opcode) {
D 2
      case PEERADDR:
E 2
I 2
      case GETPEERADDR:
E 2
	checkLen(len, sizeof(BLASTaddr));
	*(BLASTaddr *)buf = vs->peerBLASTaddr;
	return sizeof(BLASTaddr);

D 2
      case MYADDR:
E 2
I 2
      case GETMYADDR:
E 2
	checkLen(len, sizeof(BLASTaddr));	
	*(BLASTaddr *)buf = vs->myBLASTaddr;
	return sizeof(BLASTaddr);

      default:
	/* All other opcodes are forwarded to the long-pckt session */
	return x_controlsessn(vs->long_s, opcode, buf, len);
    }
}


vsize_controlprotl(self,opcode, buf, len)
    XObj self;
    int opcode, len;
    char *buf;
{
    assert(x_is_protocol(self));
    /* All opcodes are forwarded to the long-pckt protocol */
    return ip_controlprotl(self->down[0], opcode, buf, len);
}


vsize_openenable(self,hlp, p)
    XObj	self;
    XObj	hlp;
    Part	*p;
{
    BLASTaddr 	local_BLASTaddr;
    ETHaddr 	local_ETHaddr;
    PassiveID	passive_id;
    Part	part[2];
    PSTATE	*pstate;
    
    TRACE0(vsizep, 3, "VSIZE open enable");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    pstate = (PSTATE *) self->state;
    local_BLASTaddr = get_part(p, 0, BLASTaddr);
    TRACE1(vsizep, 5, "BLAST prototocol %d", local_BLASTaddr.prot);
    passive_id = local_BLASTaddr.prot;
    TRACE1(vsizep, 7, "Map: %x", pstate->passive_map);
    TRACE1(vsizep, 7, "Binding key: %d", passive_id);
    if (map_bind(pstate->passive_map, (char *)&passive_id, (int) hlp) == ERR_BIND) {
	x_errno = ALREADY_OPEN;
	return(-1);
    }
    if (x_openenable(self, self->down[0], p) < 0) {
	TRACE0(vsizep, 3, "Can't openenable long-packet protocol");
	x_errno = ALREADY_OPEN;
	return(-1);
    }
    local_ETHaddr.host = pstate->myETHhost;
    local_ETHaddr.type = BLASTTOETH(local_BLASTaddr.prot);
    init_partlist(part, 1, ETHaddr);
    set_part(part, 0, local_ETHaddr);
    if (x_openenable(self, self->down[1], part) < 0) {
	TRACE0(vsizep, 3, "Can't openenable short-packet protocol");
	x_opendisable(self,self->down[0], p);
	x_errno = ALREADY_OPEN;
	return(-1);
    }
    return(0);
}

vsize_close(s)
XObj	s;
{
    register VSIZE_STATE *vs;
    PSTATE	*pstate;

    TRACE1(vsizep, 3, "VSIZE close of session %x", s);
    assert(x_is_session(s));
    pstate = (PSTATE *) s->myprotl->state;
    if (--s->rcnt > 0)
      return(0);
    
    map_unbindbinding(pstate->active_map, s->binding);
    if (s->state > ST_BROKEN) {
	vs = (VSIZE_STATE *) s->state;
	x_close(vs->short_s);
	x_close(vs->long_s);
    }
    x_destroysession(s);
    return(0);
}


/*ARGSUSED*/
vsize_push(s, msg,rmsg_ptr)
XObj	s;
D 2
MSG	msg;
MSG	*rmsg_ptr;
E 2
I 2
Msg	msg;
Msg	*rmsg_ptr;
E 2
{
    register VSIZE_STATE *vs = (VSIZE_STATE *)s->state;
    PSTATE	*pstate;

  TRACE0(vsizep, 3, "in vsize push");
  assert(msg.stack->ref.ref > 0);
  pstate = (PSTATE *) s->myprotl->state;

  if (msg_len(msg) <= pstate->cutoff && vs->short_s) {
    TRACE0(vsizep, 7, "vsize_push: pushing to short session");
D 2
    x_push(vs->short_s, msg,(MSG *)0);
E 2
I 2
    x_push(vs->short_s, msg,(Msg *)0);
E 2
  } else {
    TRACE0(vsizep, 7, "vsize_push: pushing to long session");
D 2
    x_push(vs->long_s, msg,(MSG *)0);
E 2
I 2
    x_push(vs->long_s, msg,(Msg *)0);
E 2
  }
}


vsize_demux(self, s, dg)
XObj	self, s;
D 2
MSG	dg;
E 2
I 2
Msg	dg;
E 2
{
  XObj 		t, hlp;
  unsigned int 	blast_protocol;
  u_short 	eth_protocol;
  Part 		part[3];
  BLASTaddr 	remote_BLASTaddr;
  BLASTaddr 	local_BLASTaddr;
  PassiveID	passive_id;
  PSTATE	*pstate;
  union {
    IPhost ip;
    ETHhost eth;
  } iporeth;

  TRACE0(vsizep, 3, "In VSIZE demux");
  assert(x_is_session(s));
  t = self;
  if (!x_is_session(t)) {
    pstate = (PSTATE *) self->state;
    /*
     * check for open enables
     */
    if (s->myprotl == self->down[1]) {
	TRACE0(vsizep, 7, "undersession is from short-pckt protocol");
D 2
	(void)x_controlsessn(s, ETH_GET_TYPE, (char *)&eth_protocol, sizeof(u_short));
E 2
I 2
	(void)x_controlsessn(s, GETPROTO, (char *)&eth_protocol, sizeof(u_short));
E 2
	blast_protocol = ETHTOBLAST(eth_protocol);
D 2
	x_controlsessn(s, PEERADDR, (char *)&iporeth.eth, sizeof iporeth.eth);
E 2
I 2
	x_controlsessn(s, GETPEERADDR, (char *)&iporeth.eth, sizeof iporeth.eth);
E 2
D 3
	x_controlprotl(ARP, RRESOLVE, (char *)&iporeth.eth,
		       sizeof iporeth.eth);
E 3
I 3
	if (x_controlprotl(ARP, RRESOLVE, (char *)&iporeth.eth,
			   sizeof iporeth.eth) < 0) {
	    TRACE0(vsizep, 3,
		   "could not reverse-resolve eth address, dropping msg");
	    msg_free(dg);
	    return -1;
	}
E 3
	remote_BLASTaddr.host = iporeth.ip;
    } else if (s->myprotl == self->down[0]) {
      TRACE0(vsizep, 7, "undersession is from long-pckt protocol");
      (void)x_controlsessn(s, GETPROTO, (char *)&blast_protocol, sizeof(int));
      eth_protocol = BLASTTOETH(blast_protocol);
D 2
      x_controlsessn(s, PEERADDR, (char *)&remote_BLASTaddr,
E 2
I 2
      x_controlsessn(s, GETPEERADDR, (char *)&remote_BLASTaddr,
E 2
		     sizeof(BLASTaddr));
    } else {
      Kabort("Impossible lower level session in vsize demux");
    }
    /*
     * At this point, 'blast_protocol', 'remote_BLASTaddr.host', and
     * 'ethprotocol' all have the appropriate values.
     */
    passive_id = blast_protocol;
    TRACE1(vsizep,5, "Peer ID addr: %s", inet_ntoa(remote_BLASTaddr.host));
    TRACE1(vsizep, 7, "Map: %x", pstate->passive_map);
    TRACE1(vsizep, 7, "Resolving key: %d", passive_id);
    if ((hlp = (XObj) map_resolve(pstate->passive_map, (char *)&passive_id))
	== ERR_XOBJ) {
      TRACE0(vsizep, 3,
	     "vsize_demux: No appropriate openenable, dropping the message");
      msg_free(dg);
      return -1;
    } else {
      TRACE0(vsizep, 3, "Found openenable");
      local_BLASTaddr.host = pstate->myIPhost;
      remote_BLASTaddr.prot = local_BLASTaddr.prot = blast_protocol;
      init_partlist(part, 2, BLASTaddr);
      set_part(part, 0, local_BLASTaddr);
      set_part(part, 1, remote_BLASTaddr);
      TRACE0(vsizep, 3, "Calling open done");
      t = x_opendone(hlp, self, part);
      if (t ==  ERR_XOBJ) {
 	  TRACE0(vsizep, 3, "vsize open fails.");
 	  return -1;
      }
      TRACE1(vsizep, 3, "Open done returns session %x, popping to it", t);
      assert(x_is_session(((VSIZE_STATE *)t->state)->short_s->up));
      assert(x_is_session(((VSIZE_STATE *)t->state)->long_s->up));
      s->up = t;
    }
  }
  return x_demux(t, dg);
}

/*ARGSUSED*/
vsize_pop(s, ds, dg)
XObj	s, ds;
D 2
MSG	dg;
E 2
I 2
Msg	dg;
E 2
{
  Kabort("VSIZE pop called");
}



vsize_getproc(p,type)
XObj p;
D 2
XobjType type;
E 2
I 2
XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = vsize_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = vsize_controlprotl;
  } else {
    p->push = vsize_push;
    p->pop = vsize_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = vsize_close;
    p->control = vsize_controlsessn;
  }
  p->open = (Pfi) vsize_open;
  p->openenable = vsize_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = vsize_demux;
  p->getproc = vsize_getproc;
}
E 1
