h53145
s 00579/00000/00000
d D 1.1 91/01/10 11:48:44 llp 1 0
c date and time created 91/01/10 11:48:44 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * unixudp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * Synchronization problems: if you close() before you remove a socket
 * from the select vector, select can return with an error.  But if you
 * remove the socket from the select vector first, data arriving on that
 * socket interrupts the close, resulting in an 'unknown interrupt' in
 * machine.dispatch.  We choose to ignore unknown interrupts for now.
 */

#include <errno.h>

#include "xkernel.h"
#include "ip.h"
#include "unixudp.h"
#include "unixudp_i.h"

int traceudpp;

extern char *inet_ntoa();

#define IPBROADCASTIFY(ipa){\
  (ipa).d = 0;\
  if(!(((ipa).a) & 192)) {\
    (ipa).c = 0;\
    if(!(((ipa).a) & 128)) (ipa).b = 0;\
  }\
}
#define IMAGINARY 0x42424242
extern int errno;
extern int SignalsPossible;

/************************************************************************/
/* IMPORTS FROM MACHINE.C--have someone clean this interface up someday */

/* don't know how many sockets we should allow for */
#define NUMSOCKETSICANUSE 30

struct	int_vector {
  Pfi	handler;
/* device is now given by the index
  int	device;
*/
};

/***************** END IMPORTS FROM MACHINE.C *******************/


/* global data for UDP; need data structure for assigned/free port nums */

static	Map	map;
static  Map     lport2sock;
static  IPhost  myipaddr;
#define swap_hdr(hdr) { \
  (hdr)->udp_sport = ntohs((hdr)->udp_sport); \
  (hdr)->udp_dport = ntohs((hdr)->udp_dport); \
  (hdr)->udp_ulen  = ntohs((hdr)->udp_ulen); \
}
static  u_short socket2localport[NUMSOCKETSICANUSE];
static  int     socketreferences[NUMSOCKETSICANUSE];

int readudp2demux();
XObj UDP;
#define IP (UDP->down[0])

udp_init(self)
XObj self;
{
  UDP = self;
  map           = map_create(100, 8);
  lport2sock    = map_create(NUMSOCKETSICANUSE+1, 8);
  TRACE0(udpp, 1, "UNIXUDP init");
  x_controlprotl(IP, GETMYADDR, (char *)&myipaddr, 4);
  return 0;
}

#define ERREXIT(err,freesessn,freesoc) {\
  x_errno = err;\
  freesessn;\
  s = ERR_SESSN;\
  freesoc;\
  goto quit;\
}
/*
 * IF there is an existing session for this connection,
 *   THEN return it
 * ELSE
 *   build a new session
 *   IF there is an existing SOCKET for this connection,
 *   THEN point the new session to the socket
 *   ELSE build a new socket and point the session to it.
 */
Sessn udp_open(self, hlp, p)
XObj	self, hlp;
Part	*p;
{
  Sessn	  s;
  register UDPaddr *local_addr, *remote_addr;
  UDP_EXID ex_id;
  int soc;

  assert(self == UDP);
  TRACE0(udpp, 3, "UDP open");
  if (!p) {
    TRACE0(udpp, 1, "unixudp_open: No participants!");
    ERREXIT(BAD_ADDR, /**/, /**/);
  }

  /* ex_id = localport+remoteport+remotehostaddr */
  local_addr = (UDPaddr *) p[0].address;
  remote_addr = (UDPaddr *) p[1].address;

  ex_id.int_id.real.localport = local_addr->port;
  ex_id.int_id.real.remoteport = remote_addr->port;
  ex_id.ip_addr.real = remote_addr->host;

  TRACE3(udpp, 3, "in unixudp_open (my port = %d), to <%s,%d>",
	 ntohs(ex_id.int_id.real.localport),
	 inet_ntoa(*(struct in_addr *)&ex_id.ip_addr.imaginary),
	 ntohs(ex_id.int_id.real.remoteport));

  if ((s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    s->rcnt++;
  } else {
    struct udpstate *u_state;

    s = x_createsession(hlp, UDP, 1);
    s->binding = map_bind(map, (char *)&ex_id, (int)s);
    s->state   = malloc(sizeof(struct udpstate));
    s->rcnt    = 1;

    u_state    = (struct udpstate *)s->state;
    u_state->ex_id = ex_id;

    /* Check this UDP port number
     * for an existing socket.  Ex out the remoteport+remotehostaddr
     * Part of the ex_id, and try again in another map.
     */
    ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
    ex_id.ip_addr.imaginary = IMAGINARY;
    if ((soc = map_resolve(lport2sock, (char *)&ex_id)) != -1) {
      u_state->sock = soc;
      socketreferences[soc]++;
    } else {
      /* Oh boy!  We must create a new socket! */
      struct sockaddr_in addr;
      int	           on = 1;
      int                socx;
    
      addr.sin_family = AF_INET;
      addr.sin_addr.s_addr = INADDR_ANY;
      addr.sin_port = local_addr->port;

      TRACE1(udpp, 5, "unixudp opening lport %d", ntohs(addr.sin_port));

      if ((socx = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror("unixudp_open");
	ERREXIT(INVALID_OPEN, x_destroysession(s), /**/);
      }
      TRACE1(udpp, 5, "Unixudp receives socket %d", socx);
      map_bind(lport2sock, (char *)&ex_id, socx);

      setsockopt(socx, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));
#ifdef SO_BROADCAST
      setsockopt(socx, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof (on));
#endif

      /* Having created the socket, tie it into the simulator */
      if (socx>=NUMSOCKETSICANUSE) {
	TRACE0(udpp,1,"unixudp_open: socket out of range!");
	ERREXIT(INVALID_OPEN, x_destroysession(s), close(socx));
      }
      /* fill the ivector slot */
      u_state->sock = socx; /* remember the socket in the session */
      socketreferences[socx] = 1;
      socket2localport[socx] = local_addr->port;
      installSignalHandler(socx, readudp2demux);

      if (bind(socx, (struct sockaddr *)&addr, sizeof(addr))) {
	int retry;
	TRACE0(udpp, 1, "unixudp_openenable: Waiting for unix bind\n");
	for(retry=2;retry<60;retry++){
	  sleep(1);
	  if(bind(socx, (struct sockaddr *)&addr, sizeof(addr)) != -1) goto BINDOK;
	  if (retry == 4) printf("Delaying on bind to port %d\n",
	    ntohs(addr.sin_port));
	}
	perror("unixudp open bind");
	cancelSignalHandler(socx);
	ERREXIT(INVALID_OPEN, x_destroysession(s), close(socx));
      }
  BINDOK:
      if (fcntl(socx,F_SETFL,(FASYNC | FNDELAY)) < 0){
	perror("fcntl async");
	cancelSignalHandler(socx);
	ERREXIT(INVALID_OPEN, x_destroysession(s), close(socx));
      }
      if (fcntl(socx,F_SETOWN,getpid()) < 0){
	perror("fcntl setown");
	cancelSignalHandler(socx);
	ERREXIT(INVALID_OPEN, x_destroysession(s), close(socx));
      }
      SignalsPossible = 1;
    }
  }
 quit:
  TRACE1(udpp, 3, "UNIXUDP open returns %x", s);
  return s;
}

udp_openenable(self, hlp, p)
XObj	self;
XObj	hlp;
Part	*p;
{
  UDP_EXID ex_id;	 /* ex_id = port */
  UDPaddr *localaddr; 
  int      soc, on=1;
  struct sockaddr_in addr;

  assert(self == UDP);
  TRACE0(udpp, 3, "UNIXUDP open enable");
  localaddr = (UDPaddr *) p[0].address;
  ex_id.int_id.real.localport = localaddr->port;
  ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
  ex_id.ip_addr.imaginary = IMAGINARY;

  /* if someone in MAP has bound the port, they own incoming messages */
  if (map_bind(map, (char *)&ex_id, (int)hlp) == ERR_BIND) {
    x_errno = ALREADY_OPEN;
    return -1;
  }
  if ((soc = map_resolve(lport2sock, (char *)&ex_id)) != -1) {
    socketreferences[soc]++;
  } else {
    /* Oh boy!  We must create a new socket! */
    
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = localaddr->port;

    TRACE1(udpp, 5, "unixudp openenable for lport %d", ntohs(addr.sin_port));

    if ((soc = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
      perror("unixudp openenable socket");
      return -1;
    }
    setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));
#ifdef SO_BROADCAST
    setsockopt(soc, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof (on));
#endif

    /* Having created the socket, tie it into the simulator */
    TRACE1(udpp, 5, "unixudp receives socket %d", soc);
    map_bind(lport2sock, (char *)&ex_id, soc);
    if (soc>=NUMSOCKETSICANUSE) {
      TRACE0(udpp,1,"unixudp open: socket descriptor out of range!");
      close(soc);
      return -1;
    }

    /* fill the ivector slot */
    socketreferences[soc] = 1;
    socket2localport[soc] = localaddr->port;
    installSignalHandler(soc, readudp2demux);

    if (bind(soc, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
      int retry;
      TRACE0(udpp, 1, "unixudp_openenable: Waiting for unix bind\n");
      for(retry=2;retry<60;retry++){
	sleep(1);
	if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) != -1) goto BINDOK;
	if (retry == 4) printf("Delaying on bind to port %d\n",
	  ntohs(addr.sin_port));
      }
      perror("unixudp openenable bind");
      cancelSignalHandler(soc);
      close(soc);
      return -1;
    }
  BINDOK:
    if (fcntl(soc,F_SETFL,(FASYNC | FNDELAY)) < 0){
      perror("unixudp openenable fcntl async");
      cancelSignalHandler(soc);
      close(soc);
      return -1;
    }
    if (fcntl(soc,F_SETOWN,getpid()) < 0){
      perror("unixudp openenable fcntl setown");
      cancelSignalHandler(soc);
      close(soc);
      return -1;
    }
    SignalsPossible = 1;
  }
  return 0;
}

udp_close(s)
Sessn	s;
{
  register struct udpstate *udp_state;

  TRACE2(udpp, 3, "UNIXUDP close of session %x (refcount %d)", s, s->rcnt);
  if (--s->rcnt > 0) return 0;

  map_unbindbinding(map, s->binding);
  if (udp_state = (struct udpstate *) s->state) {
    /* Sean O'Malley reports: there is a bug here: */
    /* Norm is trying to fix it. 18 May 89 */
    UDP_EXID ex_id;
    ex_id.int_id.real.localport = socket2localport[udp_state->sock];
    ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
    ex_id.ip_addr.imaginary = IMAGINARY;
    map_unbind(lport2sock, (char *)&ex_id, udp_state->sock);
    socket2localport[udp_state->sock] = 0;
    if(!--socketreferences[udp_state->sock]) {
      cancelSignalHandler(udp_state->sock);
      close(udp_state->sock);
    }
  }
  x_destroysession(s);
  return 0;
}

/*ARGSUSED*/
udp_push(s, msg, rmsg)
Sessn	s;
Msg	msg, *rmsg;
{
  char buffer[UDPMAX];
  int len = msg_len(msg);

  TRACE1(udpp, 3, "in unixudp push, len %d",len);
  msg_externalize(msg, buffer);
  write_udp(s, buffer, len);
  return 0;
}

write_udp(s, buf, len)
Sessn s;
char *buf;
int len;
{
  struct sockaddr_in addr;
  struct  udpstate  *udp_state;

  udp_state = (struct udpstate *) s->state;

  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = udp_state->ex_id.ip_addr.imaginary;
  addr.sin_port = udp_state->ex_id.int_id.real.remoteport;

  TRACE4(udpp, 1, "unixudp writing %d bytes on socket %d to <%s,%d>", len,
	 udp_state->sock,inet_ntoa(addr.sin_addr),ntohs(addr.sin_port));

  if(sendto(udp_state->sock, buf, len, 0, (struct sockaddr *)&addr,
    sizeof(struct sockaddr))!=len)
    perror("sendto");
}

udp_demux(self, s, dg)
XObj	self;
Sessn	s;
Msg	dg;
{
  UDP_EXID *hdr, ex_id;
  Part    Part[3];
  XObj	  hlp;
  Sessn   udp_s;
  IPhost  peeripaddr;
  UDPaddr  udpaddr0, udpaddr1;

  assert(self == 0);
  hdr = (UDP_EXID *) msg_top(dg, sizeof(UDP_EXID));

  ex_id = *hdr;
  peeripaddr = ex_id.ip_addr.real;

  TRACE4(udpp, 3, "in unixudp demux with %d bytes for port %d from <%s,%d>",
	 msg_len(dg), ntohs(hdr->int_id.real.remoteport),
	 inet_ntoa(*(struct in_addr *)&hdr->ip_addr.imaginary),
	 ntohs(hdr->int_id.real.localport));

  /* look for an existing session receiving from this source */
  if ((udp_s=(Sessn)map_resolve(map, (char *)&ex_id)) != ERR_SESSN) {
    TRACE1(udpp, 3, "Popping to existing session %#x", udp_s);
    return x_pop(udp_s, s, dg);
  }

  /* try to find an openenable */
  ex_id.int_id.real.remoteport = (u_short)IMAGINARY;
  ex_id.ip_addr.imaginary = IMAGINARY;
  if ((hlp = (XObj)map_resolve(map, (char *)&ex_id)) != ERR_XOBJ) {
    TRACE1(udpp, 3, "Found an open enable for prot %d", hlp);
    udpaddr0.port = hdr->int_id.real.localport;
    udpaddr0.host = myipaddr;
    Part[0].address = (char *) &udpaddr0;
    Part[0].length = UDPADLEN;
    udpaddr1.port = hdr->int_id.real.remoteport;
    udpaddr1.host = peeripaddr;
    Part[1].address = (char *) &udpaddr1;
    Part[1].length = UDPADLEN;

    Part[2].address = 0; Part[2].length = 0;

    TRACE1(udpp, 3, "Calling open done for prot %d", hlp);
    if((udp_s = x_opendone(hlp, UDP, Part)) == ERR_SESSN) {
      TRACE0(udpp, 1, "unixudp demux call to open_done failed!");
      return -1;
    }
    TRACE1(udpp, 3, "Open done returns session %x, popping to it", udp_s);    
    return x_pop(udp_s, s, dg);
  }
  TRACE0(udpp, 3, "...dropping the message");
  return 0;
}

/*ARGSUSED*/
udp_pop(s, delivery_s, dg)
Sessn	s, delivery_s;
Msg	dg;
{
  msg_pop(dg, sizeof(UDP_EXID));
  TRACE1(udpp, 3, "UNIXUDP pop, length = %d", msg_len(dg));
  return x_demux(s, dg);
}

/*********************************************
  Generic UDP Device
*********************************************/
read_udp(soc,msg,len,from,size)
int   soc;
char *msg;
int   len;
struct sockaddr_in *from;
int *size;
{
  int	n;

  *size = sizeof(struct sockaddr_in);
  if ((n = recvfrom(soc, msg, len, 0, (struct sockaddr *)from, size)) < 0) return -1;

  TRACE4(udpp,1, "X:receiving %d bytes (%s) from unixudp:<%s,%d>",n,msg,
	 inet_ntoa(from->sin_addr),ntohs(from->sin_port));
  return n;
}


/* "incoming wounded" handler
 * rather than simulating a udp header here, we simply construct
 * the localport+remoteport+remoteaddr required to find the session
 */
readudp2demux(index)
int index;
{
  Msg msg;
  static char buf[UDPDLEN+sizeof(UDP_EXID)];
  int buflen, fromlen;
  struct sockaddr_in from;
  UDP_EXID *foo;

  while((buflen= read_udp((index),buf+sizeof(UDP_EXID),UDPDLEN,&from,&fromlen))
	!= -1){
    foo = (UDP_EXID *) buf;
    foo->int_id.real.localport = socket2localport[index];
    foo->int_id.real.remoteport = from.sin_port;
    foo->ip_addr.imaginary = from.sin_addr.s_addr;
    if((*(u_long *)&myipaddr != from.sin_addr.s_addr)||
       (socket2localport[index] != from.sin_port)){
      msg_make_allstack(msg, 16, buf, buflen+sizeof(UDP_EXID));
      CreateProcess(udp_demux, 0, 5, 2 + (sizeof(Msg)+3) / 4, NULL, NULL, msg);
    } else {
      TRACE0(udpp, 3, "Discarding packet we sent to ourself");
    }
  }
  return 0;
}

/*
 * control_sessn and control_protl operations added by Sean O'Malley 7/14/88
 */

udp_controlsessn(s, opcode, buf, len)
Sessn s;
int opcode, len;
char *buf;
{
  struct udpstate *state;
 
  if ((int)s <= 0) {
    x_errno = BAD_ADDR;
    return -1;
  } else {
    state = (struct udpstate *)s->state;
    switch (opcode) {
      case GETMYADDR:
	if (len < UDPADLEN) {
	  x_errno = BUFFER_TOO_SMALL;
	  return -1;
	}
	((UDPaddr *)buf)->host = myipaddr;
	((UDPaddr *)buf)->port = state->ex_id.int_id.real.localport;
	return UDPADLEN;
      case GETPEERADDR:
	if (len<UDPADLEN) {
	  x_errno = BUFFER_TOO_SMALL;
	  return -1;
	}
	((UDPaddr *)buf)->port = state->ex_id.int_id.real.remoteport;
	((UDPaddr *)buf)->host = state->ex_id.ip_addr.real;
	return UDPADLEN;
      case GETMAXPACKET:
	if (len < sizeof(int)) {
	  x_errno = BUFFER_TOO_SMALL;
	  return -1;
	}
	*(int *)buf = UDPMAX;
	return sizeof(int);
      default:
	x_errno = INVALID_OPCODE;
	return -1;
    }
  }
}

udp_controlprotl(self, opcode, buf, len)
XObj self;
int opcode, len;
char *buf;
{
  assert(self == UDP);
  switch (opcode) {
    case GETMAXPACKET:
      if (len < sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      *(int *)buf = UDPMAX;
      return sizeof(int);
    default:
      x_errno = INVALID_OPCODE;
      return -1;
  }
}

udp_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = udp_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = udp_controlprotl;
  } else {
    p->push = udp_push;
    p->pop = udp_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = udp_controlsessn;
    p->close = udp_close;
  }
  p->open = (Pfi) udp_open;
  p->openenable = udp_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = udp_demux;
  p->getproc = udp_getproc;
}
E 1
