h00391
s 00239/00000/00000
d D 1.1 91/01/10 11:48:31 llp 1 0
c date and time created 91/01/10 11:48:31 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * psync_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
#define BROADCAST   1
#define LOGGING 1
*/
#define FREE_STABLE_MESSAGE 1

#define PSYNCMAX    512
#define PSYNCHLEN1  sizeof(PSYNCheader1)
#define PSYNCHLEN2  sizeof(PSYNCheader2)
#define PSYNCHLEN3  sizeof(PSYNCheader3)
#define PSYNCDLEN   PSYNCMAX-PSYNCHLEN1

#define MAX_ORPHANS 50 /*(2*MAX_PART)*/
#define ORPHAN_SIZE MAX_ORPHANS/2
typedef unsigned    part_mask;  /* must have >= MAX_PART bits */
#define MAX_CONV    101 /* max conversations at the same time   */
#define MAX_NODES   1500 /* max no. of nodes per conversation    */
#define FIRST       1   /*        message types         */
#define REGULAR     2   /*                              */  
#define RETRANSMIT  3   /*                              */  
#define REPLY       4   /*                              */  
#define RESTART     5   /*                              */
#define NUM_NODES   4000
#define LOOP        1
#define NOLOOP      0
#define MAXSIZE     50  /* max message size             */

/**********LOGGING INFO***********/

/**** Various states psync can be in ****/
#ifdef LOGGING

#define ALIVE 1
#define BACKWARD_ERROR_RECOVERY 2
#define FORWARD_ERROR_RECOVERY 3

#define MYLOGADDR   1234
#define NUM_LOG_NODES 50
#define STORE_LOG_NODES 300
#define P_LOGADDR   1
#define NUMLOGS     3   /* number of different logs in  */
#define LOG_INTERVAL 10000

#endif LOGGING

/* addition to upi.h error stuff */
#define UPDATE_FAILED   13

struct exmid {              /* for binding purposes */
    int mid;
    int mbz;            /* must be zero     */
    };

struct cnv_id {
    IPhost host;
    unsigned int id;
    };

/*
 * The convention we are going by is if a function
 * is returning something that is going to be added to the tree or is in
 * some other way permanent, it can return a pointer.  But if it is 
 * returning something that is just used and then discarded (or, as it
 * currently stands, just wasted as uncollected garbage), then a structure
 * should be returned so the so the stack/automatic variables will reclaim
 * the space without user intervention.  Dave 2-5 
 */

typedef struct {
	MID arr[MAX_PART];
	unsigned char num_arr;
} MID_ARRAY_STR;

typedef struct node {
    MID mid;            /*message id*/
    char recvd;         /*whether received*/
    unsigned char num_prev, num_next;  /* number of parents and children */
    part_mask outstanding_stable_part_mask;  
				    /* bit[i] is on if , for stability,
				     * we need to receive a message from
				     * participant i */
    int sender;       /*sender's id*/
    Msg message;            /*message structure*/
    struct node *prev[MAX_PART];    /*list of parents*/
    struct node *next[MAX_PART];    /*list of children*/
    } Node;

typedef struct rcv_msg {
   Node *n;
   struct rcv_msg *next;
} outstanding_receive; 

typedef struct psyncheadr1 {
    char type;
    struct cnv_id cid;
    MID mid;
    int sender;
    unsigned char numpart;           /* no. of participants  */
    PSYNCaddr part_list[MAX_PART];
    unsigned short len;
    } PSYNCheader1;

typedef struct psyncheadr2 {
    char type;
    struct cnv_id cid;
    MID mid;
    int sender;
    MID_ARRAY_STR depend;  /* included num_arr */
    unsigned short len;
    } PSYNCheader2;

typedef struct psyncheadr3 {
    char type;
    struct cnv_id cid;
    PSYNCaddr pid;
    } PSYNCheader3;

typedef struct {
    int node_id;
    } REVheader;

#ifdef LOGGING

typedef struct nd_str {
  Node *nd;
  struct nd_str *next;
} Nd_str;

typedef struct {
  int is_fslog;
  Nd_str log_node[STORE_LOG_NODES];
  Nd_str *fnd; 
  Nd_str *lnd; 
} Log_info;

typedef struct {
  struct cnv_id conv_id;
  XObj sessn;
  unsigned char numpart;
  PSYNCaddr part_list[MAX_PART];
  PSYNCaddr me;
  int rec_sessn;
  int rec_opcode;
} Static_log;

typedef struct {
  part_mask required_part_mask;
  int loopback;
  int mid;
} FS_dynamiclog;

typedef struct {
  MID mid;
  int sender;
  MID_ARRAY_STR depend;
  int msglen;
  char msg[MAXSIZE];
} VS_dynamiclog;

typedef struct {
  int cid;
  int num_sessn;
} P_log;

typedef struct {
  int s;
  int logid;
} Logmap;

#endif LOGGING

typedef struct  {
    char    first_msg;  /* set for first mesg   */
    unsigned char num_leaves, num_orphans;
    part_mask required_part_mask; /* bit i is on if participant i is down */
    part_mask ignore_part_mask; /* bit i is on if msg from participant i */
                                /* is to be ignored */ 
    Map     map_tree;
    Node    *root; 
    Node    *leaves[MAX_PART]; 
    Msg     orphans_list[MAX_ORPHANS];
    struct cnv_id conv_id;
    unsigned char numpart;    /* no. of participants  */
    PSYNCaddr part_list[MAX_PART];/* list of participants*/
    Node *lastmsg[MAX_PART]; /*last msg by the sender*/
    unsigned char view_leaves; /* Number of leaves in the view */
    Node      *view[MAX_PART]; 
    PSYNCaddr me;
    int MYPARTNUM;
    part_mask MY_MASK;
    part_mask NULL_PART_MASK;
    outstanding_receive *next_msg, *last_msg;
    int loopback;
    int  mid;
    Semaphore Push_exclusion;
    MID pushing_mid;
    int num_orphan_request;
    int rec_sessn;
    int rec_opcode;
#ifdef LOGGING
    Log_info log;
    int status;
    Semaphore Fin_ber;
    Semaphore slogex;
    Semaphore vslogex;
    Semaphore chlogex;
#endif LOGGING
} Sstate;

typedef struct {
    Map       map_openenable;
    Map       map_conv;
    IPaddr    myaddr;
    int       cid;
    Semaphore IPS;
    Semaphore tree;
#ifdef LOGGING
    Map       map_log;
    int       num_sessn;
    P_log     log;
    XObj      log_sessn;
#endif LOGGING
} Pstate

/* some macros */

#define same_mid(h1,h2) ( \
(h1.host.d==h2.host.d) && (h1.host.c==h2.host.c) && (h1.host.b==h2.host.b) \
&& (h1.host.a==h2.host.a) && (h1.id==h2.id) ? 1 : 0)

#define isvalid_msg(mid)  (mid.id)
E 1
