h50506
s 00026/00030/00051
d D 1.2 91/01/10 11:50:44 llp 2 1
c Prepared for 3.1 Distribution
e
s 00081/00000/00000
d D 1.1 90/11/16 10:53:09 menze 1 0
c date and time created 90/11/16 10:53:09 by menze
e
u
U
f e 0
t
T
I 1
/*
 * ip.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#ifndef ip_h
#define ip_h
#ifndef upi_h
#include "upi.h"
#endif

#define	IPADLEN	sizeof(IPaddr)

#define CLASSA(ad) (~((ad).a) & 0x80)
#define CLASSB(ad) (((ad).a & 0x80) && (~((ad).a) & 0x40))
#define CLASSC(ad) (((ad).a & 0xC0) && (~((ad).a) & 0x20))


#define IP_EQUAL(a1,a2) (*(long *)&(a1) == *(long *)&(a2))
#define IP_NETEQ(a1,a2) (((a1).a==(a2).a) && \
			 (CLASSA(a1) || (((a1).b==(a2).b) && \
					 (CLASSB(a1) || ((a1).c==(a2).c)))))

typedef	struct {
  u_char a, b, c, d;
} IPhost;

D 2
typedef struct IPaddr {
E 2
I 2
typedef struct ipaddr {
E 2
  IPhost	host;
D 2
  unsigned char protocolnum;
E 2
I 2
  u_char	protocolnum;
E 2
} IPaddr;

extern ip_getproc();

D 2
/* ip_control() opcodes: (0-2 are MYADDR, PEERADDR, MAXPACKET) */
#define MYNET		(LASTSTANDARDOP+1)
#define MYADDRANDPEERADDR	(LASTSTANDARDOP+2)
#define PEERADDRANDMYADDR	(LASTSTANDARDOP+3)
#define IP_REDIRECT 	(LASTSTANDARDOP+0x10)
#define IP_SHOWSETTINGS 	(LASTSTANDARDOP+0x11)
#define IP_SETV 	(LASTSTANDARDOP+0x12)
#define IP_SETTOS 	(LASTSTANDARDOP+0x13)
#define IP_SETID 	(LASTSTANDARDOP+0x14)
#define IP_SETTTL 	(LASTSTANDARDOP+0x15)
#define IP_SETPROT 	(LASTSTANDARDOP+0x16)
#define IP_SETSRC 	(LASTSTANDARDOP+0x17)
#define IP_SETDEST 	(LASTSTANDARDOP+0x18)
E 2
I 2
/* IP control opcodes */
E 2

D 2
#define IP_SET_SECURITY  	(LASTSTANDARDOP+0x20)
#define IP_SET_LOOSE_RT  	(LASTSTANDARDOP+0x21)
#define IP_SET_STRICT_RT 	(LASTSTANDARDOP+0x22)
#define IP_SET_RECORD_RT 	(LASTSTANDARDOP+0x23)
#define IP_SET_STREAM_ID 	(LASTSTANDARDOP+0x24)
#define IP_SET_TIMESTAMP 	(LASTSTANDARDOP+0x25)

#define IP_CLR_SECURITY  	(LASTSTANDARDOP+0x30)
#define IP_CLR_LOOSE_RT  	(LASTSTANDARDOP+0x31)
#define IP_CLR_STRICT_RT 	(LASTSTANDARDOP+0x32)
#define IP_CLR_RECORD_RT 	(LASTSTANDARDOP+0x33)
#define IP_CLR_STREAM_ID 	(LASTSTANDARDOP+0x34)
#define IP_CLR_TIMESTAMP 	(LASTSTANDARDOP+0x35)
#define IP_GET_PROTO	 	(LASTSTANDARDOP+0x36)
E 2
I 2
#define IP_MYNET		(IP_CTL*MAXOPS+0)
#define IP_REDIRECT 		(IP_CTL*MAXOPS+1)
#define IP_SHOWSETTINGS 	(IP_CTL*MAXOPS+2)
#define IP_SETV 		(IP_CTL*MAXOPS+3)
#define IP_SETTOS 		(IP_CTL*MAXOPS+4)
#define IP_SETID 		(IP_CTL*MAXOPS+5)
#define IP_SETTTL 		(IP_CTL*MAXOPS+6)
#define IP_SETPROT 		(IP_CTL*MAXOPS+7)
#define IP_SETSRC 		(IP_CTL*MAXOPS+8)
#define IP_SETDEST	 	(IP_CTL*MAXOPS+9)
#define IP_SETSECURITY  	(IP_CTL*MAXOPS+10)
#define IP_SETLOOSERT	  	(IP_CTL*MAXOPS+11)
#define IP_SETSTRICTRT	 	(IP_CTL*MAXOPS+12)
#define IP_SETRECORDRT 		(IP_CTL*MAXOPS+13)
#define IP_SETSTREAMID 		(IP_CTL*MAXOPS+14)
#define IP_SETTIMESTAMP 	(IP_CTL*MAXOPS+15)
#define IP_CLRSECURITY  	(IP_CTL*MAXOPS+16)
#define IP_CLRLOOSERT  		(IP_CTL*MAXOPS+17)
#define IP_CLRSTRICTRT 		(IP_CTL*MAXOPS+18)
#define IP_CLRRECORDRT 		(IP_CTL*MAXOPS+19)
#define IP_CLRSTREAMID 		(IP_CTL*MAXOPS+20)
#define IP_CLRTIMESTAMP 	(IP_CTL*MAXOPS+21)
E 2


/* IP option classes */
#define IP_CONTROLOPT   0
#define IP_DEBUGGINGOPT 2

/* IP control option numbers */
#define IP_EOOPT     0
#define IP_NOOPT     1
#define IP_SECURITY  2
#define IP_LOOSE_RT  3
#define IP_STRICT_RT 9
#define IP_RECORD_RT 7
#define IP_STREAM_ID 8

#endif 
E 1
