h51494
s 00018/00017/00214
d D 1.2 91/01/10 11:44:48 llp 2 1
c Prepared for 3.1 Distribution
e
s 00231/00000/00000
d D 1.1 90/11/16 10:53:04 menze 1 0
c date and time created 90/11/16 10:53:04 by menze
e
u
U
f e 0
t
T
I 1
/*
 * icmp.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 *
 *
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
E 2
 * x-kernel Internet Control Message Protocol
 *
 * Correctly handle ALL incoming ICMP packets.
 * Generate outgoing ICMP packets when appropriate.
 * IP is both the server delivery mechanism AND the sole *client* of ICMP.
 * It requests ICMP services to handle exceptions via icmp_control_pop.
 *
 * For our purposes, the important ICMP messages to handle are
 *	redirects, which modify the routing table
 *	info requests, which generate IP addresses at boot time
 *	source quenches, which allow rudimentary congestion control
 */
I 2

E 2
#include "xkernel.h"
#include "ip.h"
#include "ip_internal.h"
#include "icmp.h"
#include "icmp_internal.h"

extern int traceipp;
int traceicmpp;
/* global data of icmp */
static XObj ICMP_SELF = 0;
D 2
static IPaddr icmp_me = { 1 };
E 2
static XObj ip_redirector;

icmp_init(self)
XObj self;
{
  Part	part[3];
D 2
  extern IPhost my_ip_addresses[];
  extern int *checkaddress;
  checkaddress = (int *)&part[3].address;
E 2
I 2
  static IPaddr icmp_me;
E 2

D 2

E 2
  TRACE0(ipp,3, "ICMP init");

  assert(x_is_protocol(self));
  if (ICMP_SELF) {
    Kabort("icmp_init: only one icmp per kernel!");
  }
  ICMP_SELF = self;
  
I 2
  icmp_me.protocolnum = 1;
  x_controlprotl(self->down[0], GETMYADDR,
		 (char *) &icmp_me.host, sizeof(IPhost));
  
E 2
  init_partlist(part, 1, IPaddr);
  set_part(part, 0, icmp_me);
  x_openenable(ICMP_SELF, ICMP_SELF->down[0], part);

  init_partlist(part, 2, IPaddr);
D 2
  icmp_me.host = my_ip_addresses[0];
E 2
  set_part(part, 0, icmp_me);
  set_part(part, 1, icmp_me);
  if((ip_redirector = x_open(ICMP_SELF,ICMP_SELF->down[0], part))== ERR_SESSN) {
    Kabort("ICMP cannot open a private IP session!  Die...die...");
  }
  return(0);
}

/*
 * icmp_open is here to provide user processes with a limited access to
 * icmp functions.  Returns a session upon which control ops may be executed.
 */
XObj icmp_open(self,hlp,p)
XObj  self;
XObj hlp;
Part *p;
{
  Sessn s;
  ICMPState *icmp_state;

  TRACE0(icmpp,3,"ICMP open");
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  
  /* fill in similar to UDP here */
  s = x_createsession(hlp,self,1);
  icmp_state = (ICMPState *)malloc(sizeof(ICMPState));
  icmp_state->down_s = x_open(ICMP_SELF, ICMP_SELF->down[0], p);
  s->state = (char *)icmp_state;

  TRACE1(ipp,3,"ICMP open returns %x",s);
  return s;
}

/*ARGSUSED*/
icmp_control_pop(opcode, msg, buf, len)
int	opcode,len;
D 2
MSG	msg;
E 2
I 2
Msg	msg;
E 2
char *buf;
{
  u_char hdrlen;
  Sessn s;
  Part part[2];

  TRACE1(icmpp, 3, "In icmp_control_pop, opcode %d",opcode);
  hdrlen = (u_char)*buf;
  switch(opcode){
  case ICMP_REDIRECT: {
    ICMPRedirect r;

    (*(u_long *)&(r.icmp_gw)) = htonl(*(u_long *)(buf+1));
    r.hdr.icmp_type = htonb(ICMP_REDIRECT);
    r.hdr.icmp_code = htonb(ICMP_HOST_REDIRECT);
    msg_peek(msg, 0, (int)(hdrlen<<2)+8, (char *)&(r.icmp_badmsg));
    TRACE5(ipp, 7, "hdrlen %d, gwaddress %d.%d.%d.%d", hdrlen,
	   r.icmp_gw.a, r.icmp_gw.b, r.icmp_gw.c, r.icmp_gw.d);
    /*
     * This makes no sense at all.  Part  is uninitialized!!!!
     */
    if((s = x_open(ICMP_SELF,ICMP_SELF->down[0],part))== ERR_SESSN) {
      TRACE1(ipp,1,"icmp cannot open IP session (x_errno=%d)",x_errno);
      return;
    } else {
D 2
      MSG foo;
E 2
I 2
      Msg foo;
E 2
      msg_make_allstack(foo,MSG_SSIZE,(char*)&r,(int)(sizeof(ICMPHeader)+(hdrlen<<2)+8));
D 2
      x_push(s,foo,(MSG *)0);
E 2
I 2
      x_push(s,foo,(Msg *)0);
E 2
      x_close(s);
      return;
    }
  }
  }
}

icmp_demux(self,s, msg)
XObj	self;
XObj	s;
D 2
MSG	msg;
E 2
I 2
Msg	msg;
E 2
{
D 2
  MSG	rep_msg;
E 2
I 2
  Msg	rep_msg;
E 2
  ICMPHeader	*Emsgp;
  ICMPHeader hdr;
  char *data;
  int len;

  msg_peek(msg, 0, sizeof(ICMPHeader), (char *)&hdr);
  assert(x_is_protocol(self));
  assert(x_is_session(s));

  TRACE1(icmpp, 3, "Received an ICMP message with type %d", hdr.icmp_type);

  switch(hdr.icmp_type) {
  case ICMP_ECHO_REQ:
    len = msg_len(msg);
    msg_make_allstack(rep_msg,MSG_SSIZE,(char *)0,0);
    data = msg_push(rep_msg,len);
    msg_peek(msg, 0, len, data);
    Emsgp = (ICMPHeader *)data;
    Emsgp->icmp_type = ICMP_ECHO_REP;
    Emsgp->icmp_cksum = 0;
    Emsgp->icmp_cksum = (0xFFFF & ~ocsum(data, len / 2));    
D 2
    x_push(s,rep_msg,(MSG *)0);
E 2
I 2
    x_push(s,rep_msg,(Msg *)0);
E 2
    /* x_close(s); Rice fix; 7/2/90 */
    break;

  case ICMP_REDIRECT:
    {
      IPhost addrs[2];
      ICMPRedirect rd;
      msg_peek(msg,sizeof(ICMPHeader),sizeof(ICMPRedirect),(char *)&rd);
      addrs[0] = rd.icmp_badmsg.icmp_dest.ip_dest;
      addrs[1] = rd.icmp_gw;
      (void)x_controlsessn(ip_redirector, IP_REDIRECT, (char *)addrs, 2*sizeof(IPhost));
    }
    break;
  case ICMP_INFO_REQ:
    len = msg_len(msg);
    msg_make_allstack(rep_msg,MSG_SSIZE,(char *)0,0);
    data = msg_push(rep_msg,len);
    msg_peek(msg, 0, len, data);
    Emsgp = (ICMPHeader *)data;
    Emsgp->icmp_type = ICMP_INFO_REP;
    Emsgp->icmp_cksum = 0;
    Emsgp->icmp_cksum = (0xFFFF & ~ocsum(data, len / 2));    
D 2
    x_push(s,rep_msg,(MSG *)0);
E 2
I 2
    x_push(s,rep_msg,(Msg *)0);
E 2
    /* x_close(s); Rice fix; 7/2/90 */
    break;
  case ICMP_ECHO_REP:
  case ICMP_DEST_UNRCH:
  case ICMP_SRC_QUENCH:
  case ICMP_TIMEOUT:
  case ICMP_SYNTAX:
  case ICMP_TSTAMP_REQ:
  case ICMP_TSTAMP_REP:
  case ICMP_INFO_REP:
  case ICMP_AMASK_REQ:
  case ICMP_AMASK_REP:
    TRACE1(ipp,3,"I can't handle ICMP packet type %d!\n", hdr.icmp_type);
    /* x_close(s); Rice fix; 7/2/90 */
    break;

  default:
    TRACE1(ipp,3,"ICMP drops nonexistant ICMP message type %d!",
		hdr.icmp_type);
  }
  msg_free(msg);	/* Rice fix; 7/2/90 */
  x_close(s);		/* Rice fix; 7/2/90 */
  return 0;
}

icmp_getproc(p,type)
XObj p;
D 2
XobjType type;
E 2
I 2
XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = icmp_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = noop;
  }
  p->open = (Pfi)icmp_open;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = icmp_demux;
  p->getproc = icmp_getproc;
}

E 1
