h23982
s 00510/00000/00000
d D 1.1 91/01/10 11:48:22 llp 1 0
c date and time created 91/01/10 11:48:22 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * ethernet.c 
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * The xkernel ethernet driver is structured in two layers.
 *
 * The ethernet protocol layer (this file) is independent of any
 * particular ethernet controller hardware.
 * It comprises the usual xkernel protocol functions,
 * e.g. eth_open, eth_push, etc.).
 * It knows about ethernet addresses and "types,"
 * but nothing about the Intel ethernet controller.
 *
 *
 * The interface between the this layer
 * and the ethernet controller (ethCtlr) layer is as follows:
 *
 *	From ethernet to ethCtlr:
 *	  ethCtlrInit( LocalEthAd ) - init controller
 *	  ethCtlrXmit( msgToXmit, destEthAd, msgEthType ) - transmit data
 *
 *	From ethCtlr to ethProtl:
 *		eth_demux()
 */


#include "xkernel.h"
#include "ethernet.h"
#include "ethernet_internal.h"

int traceethp;
static XObj    isPromis = 0;
static ETHhost BcastEthAd = BCAST_ETH_AD;
static ETHhost LocalEthAd;

static boolean EthInitted = FALSE;

static Map ActiveMap;
static Map PassiveMap;
static XObj ETH_SELF = 0;


/*
 * ETH_INIT
 */

eth_init(self)
     XObj self;
{
  
  TRACE0(ethp, 5, "\n\n\n\n\n\n\n\n\n\neth_init");
  assert(x_is_protocol(self));
  if (ETH_SELF) {
    Kabort("eth_init: can't initialize more than one eth");
  }
  ETH_SELF = self;
  
  ActiveMap = map_create(ETH_Sessn_MAP_SZ, sizeof(ActiveId));
  PassiveMap = map_create(ETH_Sessn_MAP_SZ, sizeof(PassiveId));
  
  
  learnLocalEthAd();
  
  ethCtlrInit(LocalEthAd);
  
  EthInitted = TRUE;
  
} /* end eth_init */



/*
 * eth_open
 */

XObj eth_open(self, hlp, part)
     XObj self;
     XObj hlp;
     Part *part;
{
  ActiveId  activeid;
  XObj ethSessn;
  ethState_t *ethStatePtr;
  ETHaddr  localaddr, remoteaddr;
  
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  
  localaddr  = get_part(part, 0, ETHaddr);
  remoteaddr = get_part(part, 1, ETHaddr);
  activeid.type = localaddr.type;
  activeid.host = remoteaddr.host;
  
  /* may not need next 2 lines--not in ../le/ethProtl.c  cliff 071190 */
  /*
    mapKey.ethType = *(ethType_t *) part[0].address;
    mapKey.ad = *(ethAd_t *) part[1].address;
    */
  TRACE4(ethp, 3, "eth_open: destination address = %4x.%4x.%4x:%4x",
	 activeid.host.high, activeid.host.mid, activeid.host.low,
	 activeid.type);
  
  ethSessn = (XObj) map_resolve(ActiveMap, (char *) &activeid);
  
  if (ethSessn != ERR_XOBJ) {
    /* Sessn already exists, just increment reference cnt */
    ethSessn->rcnt++;
  } else {
    /* need build a new Sessn */
    ethSessn = (XObj) x_createsession(hlp, ETH_SELF, 0);
    ethSessn->binding = (Bind)
      map_bind(ActiveMap, (char *) &activeid, (mapVal_t) ethSessn);
    
    ethStatePtr = (ethState_t *) malloc(sizeof(ethState_t));
    *ethStatePtr = activeid;
    ethSessn->state = (statePtr_t) ethStatePtr;
  }
  TRACE1(ethp, 3, "eth_open: returning %X", ethSessn);
  return (ethSessn);
  
} /* end eth_open */


/*
 * eth_openenable
 */

eth_openenable(self, hlp, part)
     XObj self;
     XObj hlp;
     Part *part;
{
  PassiveId  passiveid;
  ETHaddr    localaddr;
  
  localaddr = get_part(part, 0, ETHaddr);
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  TRACE2(ethp, 1, "eth_openenable: hlp=%d, protlNum=%x", hlp, localaddr.type);
  passiveid = localaddr.type;
  map_bind(PassiveMap, (char *) &passiveid, (mapVal_t) hlp);
  return (SUCCESS_RET_VAL);
  
} /* end eth_openenable */


/*
 * eth_opendisable
 */

eth_opendisable(self, hlp, part)
     XObj self;
     XObj hlp;
     Part *part;
{
  PassiveId       passiveid;
  ETHaddr         localaddr;
  
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  
  get_part(part, 0, ETHaddr);
  /* delete the corresponding Sessn from the PassiveMap */
  passiveid = localaddr.type;
  map_unbind(PassiveMap, (char *) &passiveid, (mapVal_t) hlp);
  return (SUCCESS_RET_VAL);
  
} /* end eth_opendisable */


/*
 * eth_demux
 */

eth_demux(incomingMsg, ethType, srcEthAd, destEthAd)
     Msg incomingMsg;
     ethType_t ethType;
     ETHhost srcEthAd, destEthAd;
{
  ActiveId  activeid;
  PassiveId passiveid;
  XObj ethSessn;
  XObj hlp;
  Part part[3];
  static int i=0;
  
  activeid.type = ethType;
  activeid.host = srcEthAd;
  
  if (isPromis) {
    Msg      p;
    ethHdr_t *hdr;
    msg_save(p, incomingMsg);
    hdr = (ethHdr_t *) msg_push(p, sizeof(ethHdr_t));
    hdr->destEthAd = destEthAd;
    hdr->srcEthAd = srcEthAd;
    hdr->ethType = ethType;
    x_demux(isPromis, p);
  }
  /* verify that msg is for this host */
  if (!(ETH_ADS_EQUAL(destEthAd, LocalEthAd) ||
	ETH_ADS_EQUAL(destEthAd, BcastEthAd))) {
    msg_free(incomingMsg);
    return;
  }
  ethSessn = (XObj) map_resolve(ActiveMap, (char *) &activeid);
  if (ethSessn != ERR_XOBJ) {
    /* found the corresponding Sessn */
    /* bypass pop because pop does nothing */
    x_demux(ethSessn, incomingMsg);
  } else {
    /* Sessn doesn't exist; check for openenable */
    passiveid = activeid.type;
    hlp = (XObj) map_resolve(PassiveMap, (char *) &passiveid);
    if (hlp != ERR_XOBJ) {
      /* there is an openenable for this msg */
      ETHaddr         localaddr, remoteaddr;
      
      localaddr.type = remoteaddr.type = ethType;
      localaddr.host = LocalEthAd;
      remoteaddr.host = srcEthAd;
      init_partlist(part, 2, ETHaddr);
      set_part(part, 0, localaddr);
      set_part(part, 1, remoteaddr);
      
      ethSessn = (XObj) x_opendone(hlp, ETH_SELF, part);
      /* skip pop because pop does nothing */
      x_demux(ethSessn, incomingMsg);
    } else {
      /* there is not an openenable for this msg */
      msg_free(incomingMsg);
    }
  }
} /* end eth_demux */


/*
 * eth_close
 */

eth_close(ethSessn)
     XObj ethSessn;
{
  assert(x_is_session(ethSessn));
  
  if (--(ethSessn->rcnt) == 0) {
    map_unbindbinding(ActiveMap, ethSessn->binding);
    x_destroysession(ethSessn);
  }
} /* end eth_close */


/*
 * eth_push
 */

/*ARGSUSED*/
eth_push(ethSessn, downMsg, rmsg)
     XObj ethSessn;
     Msg downMsg, *rmsg;
{
  ethState_t *mapKeyPtr;
  Msg upMsg;
  static int i;
  
  TRACE0(ethp, 5, "eth_push");
  assert(x_is_session(ethSessn));
  
  mapKeyPtr = (ethState_t *) (ethSessn->state);
  
  if (ETH_ADS_EQUAL(mapKeyPtr->host, LocalEthAd)) {
    /*
     * local msg; goes back up only
     */
    TRACE0(ethp, 5, "eth_push: sending msg back up");
    /* create a local process to shepherd the msg */
    if (CreateKernelProcess(eth_demux, 5,
	    (sizeof(downMsg) + 3) / 4 + 1 + 2 * ((sizeof(LocalEthAd) + 4) / 4),
	    downMsg, mapKeyPtr->type,
	    LocalEthAd, LocalEthAd) == 0) {
      msg_free(downMsg);
    }
  } else if (ETH_ADS_EQUAL(mapKeyPtr->host, BcastEthAd)) {
    /*
     * broadcast msg; goes back up as well as out
     */
    TRACE0(ethp, 5, "eth_push: sending msg both out and back up");
    msg_save(upMsg, downMsg);
    ethCtlrXmit(downMsg, mapKeyPtr->host, mapKeyPtr->type);
    /* create a local process to shepherd the upMsg */
    if (CreateKernelProcess(eth_demux, 5,
	    (sizeof(downMsg) + 3) / 4 + 1 + 2 * ((sizeof(LocalEthAd) + 4) / 4),
	    upMsg, mapKeyPtr->type,
	    LocalEthAd, LocalEthAd) == 0) {
      msg_free(upMsg);
    }
  } else {
    /*
     * non-local non-bcast msg; goes out only
     */
    TRACE0(ethp, 5, "eth_push: sending msg out only");
    ethCtlrXmit(downMsg, mapKeyPtr->host, mapKeyPtr->type);
  }
  
  return (SUCCESS_RET_VAL);
  
} /* end eth_push */


/*
 * eth_pop
 */

/*ARGSUSED*/
eth_pop(ethSessn, deliverySessn, inMsg)
     XObj ethSessn, deliverySessn;
     Msg inMsg;
{
  
  assert(x_is_session(ethSessn));
  x_demux(ethSessn, inMsg);
  
} /* end eth_pop */


/*
 * eth_controlSessn
 */

/* ARGSUSED */
eth_controlSessn(ethSessn, opcode, bufPtr, bufLen)
     XObj ethSessn;
     int opcode;
     char *bufPtr;
     int bufLen;
{
  ethState_t *ethStatePtr;
  
  assert(x_is_session(ethSessn));
  
  ethStatePtr = (ethState_t *) ethSessn->state;
  switch (opcode) {
  case GETMYADDR:
    if (bufLen < sizeof(ethAd_t)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      bcopy((char *) &LocalEthAd, bufPtr, sizeof(ethAd_t));
      return (sizeof(ethAd_t));
    }
    
  case GETPEERADDR:
    if (bufLen < sizeof(ethAd_t)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      *(ethAd_t *) bufPtr = ethStatePtr->host;
      return (sizeof(ethAd_t));
    }
    
  case GETMAXPACKET:
  case GETOPTPACKET:
    if (bufLen < sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      *(int *) bufPtr = MAX_ETH_DATA_SZ;
      return (sizeof(int));
    }
    
  case GETPROTO:
    if (bufLen < sizeof(unsigned short)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      *(unsigned short *) bufPtr = ethStatePtr->type;
      return (sizeof(unsigned short));
    }
    
  case ETH_SETPROMISCUOUS:
    if (bufLen < sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      isPromis = ethSessn;
      SetPromiscusous();
      return (sizeof(int));
    }
    
  default:
    x_errno = INVALID_OPCODE;
    return (FAILURE_RET_VAL);
  }
} /* end eth_controlSessn */


/*
 * eth_controlprotl
 */

eth_controlprotl(self, opcode, bufPtr, bufLen)
     XObj self;
     int opcode;
     char *bufPtr;
     int bufLen;
{
  assert(x_is_protocol(self));
  
  switch (opcode) {
  case GETMYADDR:
    if (bufLen < sizeof(ethAd_t)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      bcopy((char *) &LocalEthAd, bufPtr, sizeof(ethAd_t));
      return (sizeof(ethAd_t));
    }
  case GETMAXPACKET:
  case GETOPTPACKET:
    if (bufLen < sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return (FAILURE_RET_VAL);
    } else {
      *(int *) bufPtr = MAX_ETH_DATA_SZ;
      return (sizeof(int));
    }
  default:
    x_errno = INVALID_OPCODE;
    return (FAILURE_RET_VAL);
  }
  
} /* end eth_controlprotl */


/*
 * learnLocalEthAd
 */

learnLocalEthAd()
{
  char *localEthAdPtr;
  int i;
  
  localEthAdPtr = (char *) &LocalEthAd;
  
  /* Read the ethernet address from the SMI prom */
#ifdef SUN3
  for (i = 2; i < 8; i++) {
    *localEthAdPtr++ = Fc3ReadBit8((char *)i);
  }
#else
  for (i = 0x1008; i < 0x4008; i += 0x800) {
    *localEthAdPtr++ = Fc3ReadBit8((char *)i);
  }
#endif
  
} /* end learnLocalEthAd */


/*
 * noop
 */

static noop()
{
}


/*
 * eth_getproc
 */

eth_getproc(p, type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = eth_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = eth_controlprotl;
  } else {
    p->push = eth_push;
    p->pop = eth_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = eth_close;
    p->control = eth_controlSessn;
  }
  p->open = (Pfi) eth_open;
  p->openenable = eth_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  /*
   * eth_demux exist but is not compatable with other demuxs and who exactly
   * calls it?
   */
  p->demux = noop;
  p->getproc = eth_getproc;
}


E 1
