h54746
s 00012/00000/01052
d D 1.3 91/02/11 18:13:30 menze 3 2
c get_boot_id() now works with the simulator. 
e
s 00022/00024/01030
d D 1.2 91/01/10 11:44:35 llp 2 1
c Prepared for 3.1 Distribution
e
s 01054/00000/00000
d D 1.1 90/11/16 10:52:55 menze 1 0
c date and time created 90/11/16 10:52:55 by menze
e
u
U
f e 0
t
T
I 1
/*
 * chan.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#include "xkernel.h"
D 2
#include "unixtime.h"
#include "clock.h"
E 2
#include "ip.h"
#include "udp.h"
#include "chan.h"
#include "chan_internal.h"

I 3
#ifdef XSIMUL
#include <sys/time.h>
#endif

E 3
#define MAX(x,y) ((x)>(y) ? (x) : (y))
#define MIN(x,y) ((x)<(y) ? (x) : (y))

#define sameipaddr(A,B)  (((A)->a==(B)->a) && ((A)->b == (B)->b) && ((A)->c == (B)->c) && ((A)->d == (B)->d))


/* If USE_KILLTICKET is defined, CHAN will inform the lower protocol when it
 * can free a message.  If USE_KILLTICKET is not defined, the lower protocol
 * will free messages based on its timeouts.  
 */
/* #define USE_KILLTICKET */

/* global data for CHAN; need data structure for assigned/free port nums */
Map map_create();
static XObj chan_svc_open();
static server_timeout();
static client_timeout();
static SEQ_STAT check_seq();
static killticket();
static phdr();
static reply();
static get_boot_id();


static XObj IP;
int tracechanp=0;

static chan_instantiateprotl(self) 
XObj self;
{
  self->state = malloc(sizeof(PSTATE));

  return(0);
}


static chan_init(self)
XObj self;
{
  Part part[2];
  PSTATE *pstate = (PSTATE *)self->state;
  
  TRACE0(chanp, 1, "CHAN init");

  IP = x_getprotlbyname("ip");
D 2
  x_controlprotl(IP, MYADDR, (char *)&pstate->myIPaddr.host,
E 2
I 2
  x_controlprotl(IP, GETMYADDR, (char *)&pstate->myIPaddr.host,
E 2
		 sizeof(IPhost));
  pstate->myIPaddr.protocolnum = CHAN_IP_PROTOCOLNUM;
 
  pstate->active_server_map = map_create(100, sizeof(ActiveID));
  pstate->active_client_map = map_create(100, sizeof(ActiveID));
  pstate->passive_map = map_create(50, sizeof(PassiveID));

  pstate->channel_number = 0;
  
  init_partlist(part, 1, IPaddr);
  set_part(part, 0, pstate->myIPaddr);

  return(x_openenable(self,self->down[0], part));
}


static XObj chan_open(self,hlp, p)
XObj   self;
XObj   hlp;
Part    *p;             /* p[0]= CHAN address of sender (client)
			   p[1]= CHAN address of receiver (server)
			*/
{
  XObj   	s;
  CHAN_STATE 	*state;
  Part 		part[3];
  ActiveID 	ext_id;
  CHAN_HDR 	*hdr;
  CHANaddr	local_CHANaddr, remote_CHANaddr;
  IPaddr	remote_IPaddr;
  PSTATE 	*pstate;

  TRACE0(chanp, 3, "CHAN open");

  s = (XObj) NULL;
  pstate = (PSTATE *)self->state;

  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(chanp,9,"chan_open: no participant list!");
    return(ERR_XOBJ);
  }
  
  local_CHANaddr = get_part(p, 0, CHANaddr);
  remote_CHANaddr = get_part(p, 1, CHANaddr);
  
  /* open lower session */
  remote_IPaddr.host = remote_CHANaddr.host;
  remote_IPaddr.protocolnum = pstate->myIPaddr.protocolnum;
  init_partlist(part, 2, IPaddr);
  set_part(part, 0, pstate->myIPaddr);
  set_part(part, 1, remote_IPaddr);
  
  if ((ext_id.down_s = x_open(self,self->down[0], part)) == ERR_XOBJ) {
    TRACE0(chanp, 1, "chan_open: can't open lower session");
    return ERR_XOBJ;
  }
  ext_id.chan = pstate->channel_number++;
  ext_id.prot_id = remote_CHANaddr.prot;
  ext_id.direction = CLIENT;

  TRACE1(chanp,3,"chan_open: chan = %d",ext_id.chan);
  TRACE1(chanp,3,"chan_open: prot_id = %d",ext_id.prot_id);
  TRACE1(chanp,3,"chan_open: down_s = %x",ext_id.down_s);

  /* is there an existing session */
  s=(XObj)map_resolve(pstate->active_client_map, (char *) &ext_id);
  if (s != (XObj)-1) {
      TRACE0(chanp,3,"chan_open: channel exists ");
      x_close(ext_id.down_s);
      return(ERR_XOBJ);
  }

  /* need new session */
  state = (CHAN_STATE *) malloc(sizeof(CHAN_STATE));
  bzero((char *)state,sizeof(CHAN_STATE));

  /* fill in  state */
  state->down_s = ext_id.down_s;
  state->cur_state = CLNT_FREE;
  state->chan = ext_id.chan;
  state->cur_seq = START_SEQ;
  state->boot_id = get_boot_id();
  state->prot_id = ext_id.prot_id;
  state->client = local_CHANaddr.host;
  state->server = remote_CHANaddr.host;
  state->direction = CLIENT;
  state->myCHANaddr = local_CHANaddr;
  state->peerCHANaddr = remote_CHANaddr;
  TRACE1(chanp,3,"chan_open: server = %s",inet_ntoa(state->server));
  TRACE1(chanp,3,"chan_open: client = %s",inet_ntoa(state->client));
  InitSemaphore(&state->reply_sem,0);

  /* fill in header */
  hdr = &state->hdr;
  hdr->chan = state->chan;
  hdr->flags = 0;
  hdr->prot_id = state->prot_id;
  hdr->seq = 0;
  hdr->boot_id = state->boot_id;
  hdr->err = CHAN_OK;

  /* create session and bind to address */
  s = x_createsession(hlp, self,1);
  s->rcnt = 1;
  s->down[s->numdown++]=state->down_s;
  s->state = (char *) state;
  s->binding = (Bind)map_bind(pstate->active_client_map, (char *) &ext_id,s);

  /* just to be paranoid */
  if (s->binding == ERR_BIND) {
    TRACE0(chanp,3,"chan_open: could not bind session");
    x_close(s);
    return((XObj)-1);
  }

  TRACE1(chanp, 3, "chan_open returns %x", s);
  return(s);
}


static XObj chan_svc_open(self, hlp, down_s, chan_num, prot_id)
XObj		self;
XObj   		hlp;
XObj		down_s;
unsigned short	chan_num;
int		prot_id;
{
  XObj   s;
  CHAN_STATE *state;
  ActiveID ext_id;
  CHAN_HDR *hdr;
  PSTATE *pstate = (PSTATE *)self->state;
  char llsaddr[BIGADDR];
  

  TRACE0(chanp, 3, "CHAN svc open");

  s = (XObj) NULL;

  ext_id.down_s = down_s;
  ext_id.chan = chan_num;
  ext_id.prot_id = prot_id;
  ext_id.direction = SERVER;

  TRACE1(chanp,3,"chan_svc_open: down_s = %x",ext_id.down_s);
  TRACE1(chanp,3,"chan_svc_open: chan = %d",ext_id.chan);
  TRACE1(chanp,3,"chan_svc_open: prot_id = %d",ext_id.prot_id);

  /* is there an existing session? */
  s=(XObj)map_resolve(pstate->active_server_map, (char *) &ext_id);
  if (s != (XObj)-1) {
    TRACE0(chanp,3,"chan_svc_open: channel exists ");
    return(ERR_XOBJ);
  }

  /* need new session */
  state = (CHAN_STATE *) malloc(sizeof(CHAN_STATE));
  bzero((char *)state,sizeof(CHAN_STATE));

  /* fill in  state */
  state->cur_state = SVC_NEW; 
  state->chan = ext_id.chan;
  state->prot_id = ext_id.prot_id;
D 2
  if (x_controlsessn(ext_id.down_s, MYADDR, (char *)llsaddr,
E 2
I 2
  if (x_controlsessn(ext_id.down_s, GETMYADDR, (char *)llsaddr,
E 2
		     sizeof(llsaddr)) < 0) {
      TRACE0(chanp, 1, "chan_open: could not get lower session addr");
      return ERR_XOBJ;
  }
  state->server = *(IPhost *)llsaddr;
D 2
  if (x_controlsessn(ext_id.down_s, PEERADDR, (char *)llsaddr,
E 2
I 2
  if (x_controlsessn(ext_id.down_s, GETPEERADDR, (char *)llsaddr,
E 2
		     sizeof(llsaddr)) < 0) {
      TRACE0(chanp, 1, "chan_open: could not get lower session addr");
      return ERR_XOBJ;
  }
  state->client = *(IPhost *)llsaddr;
  state->down_s = ext_id.down_s;
  state->direction = SERVER;
  state->myCHANaddr.host = state->server;
  state->myCHANaddr.prot = state->prot_id;
  state->peerCHANaddr.host = state->client;
  state->peerCHANaddr.prot = state->prot_id;
  TRACE1(chanp,3,"chan_open: server = %s",inet_ntoa(state->server));
  TRACE1(chanp,3,"chan_open: client = %s",inet_ntoa(state->client));


  /* fill in header */
  hdr = &state->hdr;
  hdr->chan = state->chan;
  hdr->flags = 0;
  hdr->prot_id = state->prot_id;
  hdr->seq = 0;
  hdr->err = CHAN_OK;

  /* create session and bind to address */
  s = x_createsession(hlp, self,1);
  s->rcnt = 1;
  s->down[s->numdown++] = state->down_s;
  s->state = (char *) state;

  s->binding = (Bind)map_bind(pstate->active_server_map, (char *) &ext_id,
			      (int)s);
  /* just to be paranoid */
  if (s->binding == ERR_BIND) {
      TRACE0(chanp, 1, "chan_svc_open: could not bind session"); 
      TRACE3(chanp, 1, "chan_svc_open: down_s = %x, chan = %d, prot_id = %d",
	     ext_id.down_s, (int)ext_id.chan, ext_id.prot_id);
      x_close(s);
      return ERR_XOBJ;
  }

  TRACE1(chanp, 3, "chan_svc_open returns %x", s);
  return s;
}


static chan_openenable(self,hlp, p)
XObj  self;
XObj   hlp;
Part    *p;
			/* p[0] == CHANaddr of client */
{
  PassiveID key;
  CHANaddr local_CHANaddr;
  PSTATE *pstate = (PSTATE *)self->state;

  TRACE0(chanp, 3, "CHAN open enable");

  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(chanp,9,"chan_openenable: no particpant list!");
    return(-1);
  }

  local_CHANaddr = get_part(p, 0, CHANaddr);

  key = local_CHANaddr.prot;

  TRACE1(chanp, 3, "chan_openenable: prot_id = %d", key);

  /* bind server to high level protocol */
  if ((map_bind(pstate->passive_map, (char *) &key, hlp) == ERR_BIND)) {
      x_errno = ALREADY_OPEN;
      TRACE0(chanp,9,"chan_openenable: already openenabled");
      return(-1);
  }

  return(0);
}


static chan_close(s)
    XObj   s;
{
    CHAN_STATE	*sstate;
    PSTATE 	*pstate;
    
    TRACE1(chanp, 3, "chan_close of session %x", s);
    
    if (!s) return(0); 
    assert(x_is_session(s));
    
    pstate = (PSTATE *)s->myprotl->state;
    sstate = (CHAN_STATE *) s->state;
    s->rcnt = s->rcnt - 1;
    TRACE1(chanp,9,"chan_close: ref count = %d",s->rcnt);
    if (s->rcnt > 0) {
	return(0);
    } else {
	if (s->binding && sstate) {
	    if (sstate->direction == CLIENT) {
		map_unbindbinding(pstate->active_client_map, s->binding);
	    } else {
		map_unbindbinding(pstate->active_server_map, s->binding);
	    }
	    /* free chan state */
	    if (sstate) {
		flush_msg(sstate->saved_msg);
		flush_msg(sstate->answer);
		if (sstate->down_s)
		  x_close(sstate->down_s);
	    }
	    x_destroysession(s);
	}
    }
    return(0);
}

static chan_push(s, msg, rmsg_ptr)
XObj   s;
D 2
MSG     msg;
MSG     *rmsg_ptr;
E 2
I 2
Msg     msg;
Msg     *rmsg_ptr;
E 2
{
  CHAN_STATE   *state;
  CHAN_HDR *hdr;
  CHAN_HDR *top;
D 2
  MSG packet;
E 2
I 2
  Msg packet;
E 2
  int packet_len;
 

  TRACE0(chanp, 3, "in chan_push");
  assert(msg.stack->ref.ref > 0);
  msg_clear(packet);

  state = (CHAN_STATE *) s->state;
  TRACE1(chanp, 4, "chan_push: state = %x",state);

  TRACE1(chanp, 4, "chan_push: outgoing length (no chan hdr): %d",
	 msg_len(msg));
  
  if ((state->cur_state != SVC_EXECUTE) && (state->cur_state != CLNT_FREE)) {
    TRACE0(chanp,0,"chan_push: incorrect initial state");
    return(-1);
  }

  flush_msg(state->saved_msg);
  state->saved_msg = msg;
  msg_clear(msg);
    
  /* fill in header */
  hdr = &state->hdr;
  hdr->seq = state->cur_seq;
  if (state->cur_state == SVC_EXECUTE) {
    hdr->flags = REPLY;
  } else {
    hdr->flags = REQUEST;
  }
  hdr->err = CHAN_OK;
  hdr->len = msg_len(state->saved_msg); 

  IFTRACE(chanp,4) { 
    phdr(hdr);
  } 

  /* save both header and data for retransmit */
  msg_save(packet,state->saved_msg);
  top = (CHAN_HDR *)msg_push(packet,CHANHLEN);
  *top = *hdr;
  

  TRACE1(chanp,4,"chan_push: s->push  = %x",state->down_s->push); 
  TRACE1(chanp,4,"chan_push: packet len %d",msg_len(packet)); 
  TRACE1(chanp,4,"chan_push: length field: %d", hdr->len);
  TRACE2(chanp,4,"chan_push: down_s %x packet = %x",state->down_s,packet); 
  /* send message */
  packet_len = msg_len(packet);
D 2
  state->ticket = x_push(state->down_s,packet,(MSG *)0);
E 2
I 2
  state->ticket = x_push(state->down_s,packet,(Msg *)0);
E 2
  if (state->ticket < 0) {
    TRACE0(chanp,0,"chan_push: can't send message");
    flush_msg(packet);
    return(-1);
  }
  
  if (state->cur_state == SVC_EXECUTE) {
    state->cur_state = SVC_WAIT;
    state->wait = CHAN_SVC_DELAY(packet_len);
    TRACE1(chanp,9,"chan_push: server_wait = %d",state->wait);
    state->event = event_register(server_timeout,(int)state,state->wait,EV_ONCE | EV_CREATEPROCESS);
    return(0);
  } else if (state->cur_state == CLNT_FREE) {
    state->cur_state = CLNT_WAIT;
    state->wait =  CHAN_CLNT_DELAY(packet_len);
    state->tries =  CLIENT_TRIES;
    TRACE2(chanp,9,"chan_push: client_wait = %d client_tries =%d",state->wait,state->tries);
    state->event = event_register(client_timeout,(int)state,state->wait,EV_ONCE | EV_CREATEPROCESS);
  
    flush_msg(state->answer);
    /* wait for reply */
    P(&state->reply_sem);


    packet = state->answer;
    msg_clear(state->answer);
    if (!msg_isnull(packet))  {
      assert(packet.stack->ref.ref > 0);
      TRACE1(chanp, 4, "chan_push copying reply to rmsg_ptr %x", rmsg_ptr);
      *rmsg_ptr = packet;
       msg_clear(packet);
      return(0);
    } else {
      return(-1);
    }

  }

  TRACE1(chanp,1,"chan_push: illegal state %d",state->cur_state);
  return(-1);
}



static chan_demux(self, s, dg)
XObj self;
XObj   s;
D 2
MSG     dg;
E 2
I 2
Msg     dg;
E 2
{
  CHAN_HDR 	*hdr;
  CHAN_STATE 	*state;
  XObj   	chan_s;
  XObj    	hlp;
  ActiveID 	ext_id;
  PassiveID 	passive_key;
  PSTATE 	*pstate;
  Map		relevant_map;


  TRACE0(chanp,3,"chan_demux: called");

  assert(dg.stack->ref.ref > 0);
  assert(x_is_protocol(self));

  pstate = (PSTATE *)self->state;
  hdr = (CHAN_HDR *)msg_top(dg,CHANHLEN);

  IFTRACE(chanp,4) { 
    phdr(hdr);
  } 

  /* check of active sessions */
  ext_id.chan = hdr->chan;
  ext_id.prot_id = hdr->prot_id;
  ext_id.down_s = s;

  /* check for active channel */
  if ((hdr->flags & REQUEST) || hdr->flags & EXPLICIT_ACK) {
      relevant_map = pstate->active_server_map;
      ext_id.direction = SERVER;
  } else {
      relevant_map = pstate->active_client_map;
      ext_id.direction = CLIENT;
  }
  chan_s = (XObj) map_resolve(relevant_map, (char *) &ext_id);
  TRACE1(chanp,4,"chan_demux: chan_s = %d",chan_s);
 
  /* pop to active channel */
  if (chan_s != ERR_XOBJ) { 
    TRACE0(chanp,4,"chan_demux: existing channel");
    x_pop(chan_s,s,dg);
    return(0);
  } 

  /* new server channel needs to be created */

  /* The message type should be a request.  If not, a reply is coming to a
   * session which no longer exists.
   */
  if (hdr->flags & REQUEST) {
    /* find openenable */
    passive_key = ext_id.prot_id;
    hlp = (XObj) map_resolve(pstate->passive_map, (char *) &passive_key);
    if (hlp == (XObj) -1) {
      TRACE1(chanp, 4, "chan_demux could not find openenable for prot %d",
	     passive_key);
      TRACE0(chanp,4,"chan_demux: no open enable, dropping message");
      flush_msg(dg);
      return(0);
     }
 
    chan_s = chan_svc_open(self, hlp, s, hdr->chan, hdr->prot_id);

    if (chan_s == ERR_XOBJ) {
      TRACE0(chanp,4,"chan_demux: can't create session ");
      flush_msg(dg);
      return(0);
    }

    state = (CHAN_STATE *) chan_s->state;
    state->down_s = s;

    /* might wish to force channel to start at zero but 
       that would kill server restarts. 
       pop treats reqeusts as acks hence the minus 1 */

    /* handle message */
    x_pop(chan_s,s,dg);
    return(0);
  }

  /* This might be a message for a channel session which has been closed */ 
  TRACE0(chanp,5,"chan_demux: unknown message type!");
  flush_msg(dg);
  return(0);
}

static pstatus( stat)
SEQ_STAT stat;
{
  if (stat == old) printf("status: old\n");
  if (stat == current) printf("status: current\n");
  if (stat == new) printf("status: new\n");
}

static pstate(state)
int state;
{
  if (state == SVC_EXECUTE) printf("state: SVC_EXECUTE\n");
  if (state == SVC_WAIT) printf("state: SVC_WAIT\n");
  if (state == SVC_NEW) printf("state: SVC_NEW\n");
  if (state == SVC_ZERO) printf("state: SVC_ZERO\n");
  if (state == CLNT_FREE) printf("state: CLNT_FREE\n");
  if (state == CLNT_WAIT) printf("state: CLNT_WAIT\n");
}

static chan_pop(s,lls, dg)
XObj   s;
D 2
MSG     dg;
E 2
I 2
Msg     dg;
E 2
{
  CHAN_STATE 	*state;
  CHAN_HDR 	*hdr;
  unsigned int 	seq;
  SEQ_STAT 	status;
D 2
  MSG 		packet;
E 2
I 2
  Msg 		packet;
E 2
  CHAN_HDR 	*top;
  unsigned int	data_len;

  TRACE0(chanp, 3, "CHAN_pop");
  assert(dg.stack->ref.ref > 0);
  
  hdr = (CHAN_HDR *)msg_top(dg,CHANHLEN);
  state = (CHAN_STATE *)s->state;
  seq = hdr->seq;
  status = check_seq(state->cur_seq,seq);
  IFTRACE(chanp, 4) {
    printf("chan_pop:\n");
    pstate((int)state->cur_state);
    printf("cur_seq = %d",state->cur_seq);
    printf("hdr->seq = %d",hdr->seq);
    pstatus(status);
  }

  /* Check for proper length.  The header is still on the msg */
  data_len = msg_len(dg) - CHANHLEN;
  TRACE2(chanp,4,"chan_pop: hdr->len = %d msg_len = %d",hdr->len,data_len);
  if (hdr->len < data_len) {
      TRACE0(chanp, 4, "chan_pop: truncating msg");
      dg = msg_truncateright(dg, hdr->len + CHANHLEN);
  } else if (hdr->len > data_len) {
      TRACE0(chanp, 0, "chan_pop: message too short!");
      return -1;
  }

  assert(hdr->chan == state->chan);
  switch(state->cur_state) {
  case SVC_NEW: 
    if (hdr->flags & REQUEST) {
      /* new state */
      state->cur_state = SVC_EXECUTE;

      /* intialize state */ 
      state->boot_id = hdr->boot_id;
      state->cur_seq = hdr->seq;
      state->hdr.boot_id = hdr->boot_id;

      /* fire up server */
      msg_pop(dg,CHANHLEN);
      TRACE1(chanp, 4, "chan_pop: incoming length (no chan hdr): %d",
	     msg_len(dg));
      x_demux(s,dg);
      
      /* send ack if requested */
      if (hdr->flags & ACK_REQUESTED) {
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }
      return(0);
    }
    TRACE1(chanp,1,"chan_pop: SVC_NEW: wrong message type %x",hdr->flags);
    return(0);
    break;
  case SVC_WAIT:
    if (hdr->boot_id == 0) {
      state->cur_state = SVC_ZERO;
      flush_msg(state->saved_msg);
      flush_event(state->event);
      TRACE0(chanp,4,"chan_pop: SVC_WAIT: zero");
      chan_pop(s,lls,dg);
      return(0);
    }
    if (hdr->boot_id > state->boot_id) {
      state->cur_state = SVC_NEW;
      flush_msg(state->saved_msg);
      flush_event(state->event);
      TRACE0(chanp,4,"chan_pop: SVC_WAIT: new bootid");
      chan_pop(s,lls,dg);
      return(0);
    }
    if (status == old) {
      TRACE0(chanp,4,"chan_pop: SVC_WAIT: wrong seqence number");
      flush_msg(dg); 
      return(0);
    }

    /* new call */
    if ((hdr->flags & REQUEST)  && (status == new)){
      /* new state */
      state->cur_state = SVC_EXECUTE;

      /* perform ack */
      killticket(state->down_s,&state->ticket);
      flush_event(state->event);
      state->cur_seq = hdr->seq;
      flush_msg(state->saved_msg);
      flush_event(state->event);

      /* fire up server */
      msg_pop(dg,CHANHLEN);
      TRACE1(chanp, 4, "chan_pop: incoming length (no chan hdr): %d",
	     msg_len(dg));
      x_demux(s,dg);
      
      /* send ack if requested */
      if (hdr->flags & ACK_REQUESTED) {
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }

      return(0);
    }

    /* lost reply message */
    if ((hdr->flags & REQUEST)  && (status == current)){
      /* retransmit */
      if (!msg_isnull(state->saved_msg)) {
        state->hdr.flags = REPLY;
        msg_save(packet,state->saved_msg);
        top = (CHAN_HDR *) msg_push(packet,CHANHLEN);
        *top = state->hdr;
D 2
        state->ticket = x_push(state->down_s,packet,(MSG *)0);
E 2
I 2
        state->ticket = x_push(state->down_s,packet,(Msg *)0);
E 2
      }
      /* send ack if requested */
      if (hdr->flags & ACK_REQUESTED) {
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }

      return(0);
    }


    if (hdr->flags & EXPLICIT_ACK) {
      /* perform partial ack */
      TRACE0(chanp, 5, "Server received explicit ACK.  Freeing message");
      killticket(state->down_s,&state->ticket);
      flush_event(state->event);
      flush_msg(state->saved_msg);
      flush_msg(dg);
      return(0);
    }

  case SVC_EXECUTE:
    if (hdr->boot_id != state->boot_id) {
      TRACE0(chanp,4,"chan_pop: SVC_EXECUTE: wrong bootid number");
      flush_msg(dg); 
      return(0);
    }
    if (status != current) {
      TRACE0(chanp,4,"chan_pop: SVC_EXECUTE: wrong seqence number");
      flush_msg(dg); 
      return(0);
    }
    if (hdr->flags & REQUEST) {
      /* send ack if requested */
      if (hdr->flags & ACK_REQUESTED) {
        flush_msg(dg);
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }
      return(0);
    }
      
    TRACE1(chanp,4,"chan_pop: SVC_EXECUTE wrong message type %x",hdr->flags);
    return(0);
    break;

  case SVC_ZERO:
    if (hdr->flags & REQUEST) {
      /* new state */
      state->cur_state = SVC_EXECUTE;

      /* new seqence number */
      state->cur_seq = hdr->seq;
      flush_msg(state->saved_msg);
      flush_event(state->event);
      killticket(state->down_s,&state->ticket);

      /* fire up server */
      msg_pop(dg,CHANHLEN);
      TRACE1(chanp, 4, "chan_pop: incoming length (no chan hdr): %d",
	     msg_len(dg));
      x_demux(s,dg);
      
      /* send ack if requested */
      if (hdr->flags & ACK_REQUESTED) {
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }
      return(0);
    }  
    TRACE1(chanp,4,"chan_pop: SVC_ZERO wrong message type %x",hdr->flags);
    return(0);
    break;

  case CLNT_WAIT:
    if (hdr->boot_id != state->boot_id) {
      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: wrong boot_id");
      flush_msg(dg); 
      return(0);
    }
    TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 1");
    if (status != current) {
      TRACE0(chanp,4,"chan_pop: SVC_EXECUTE: wrong seqence number");
      flush_msg(dg); 
      return(0);
    }
   TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 2");
    if (hdr->flags & REPLY) {
      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 3");

      /* new state */
      state->cur_state = CLNT_FREE;

      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 4");
      /* perform ack */
      IFTRACE(chanp,9) msg_display(state->saved_msg);
      flush_msg(state->saved_msg);
      killticket(state->down_s,&state->ticket);
      flush_event(state->event);
      state->cur_seq++;

      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 5");
      /* return results */
      flush_msg(state->answer);
      state->answer=dg;
      msg_clear(dg);
      msg_pop(state->answer,CHANHLEN);
      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 6");
      V(&state->reply_sem);
      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: 7");
      return(0);
    }

    TRACE1(chanp,1,"chan_pop: CLNT_WAIT wrong message type %x",hdr->flags);
    return(0);
    break;

  case CLNT_FREE:
    if (hdr->boot_id != state->boot_id) {
      TRACE0(chanp,4,"chan_pop: CLNT_WAIT: wrong boot_id");
      flush_msg(dg);
      return(0);
    }
   
    if (hdr->flags & PROBE) {
      if (hdr->flags & ACK_REQUESTED) {
        /* perform partial ack */
        flush_msg(state->saved_msg);
        flush_event(state->event);

        /* message is about to die anyway. */
        hdr->seq = state->cur_seq;
	TRACE0(chanp, 5, "Client sending explicit ACK");
        reply(state->down_s,hdr,EXPLICIT_ACK);
      }
      flush_msg(dg);
      return(0);
    }

    TRACE1(chanp,1,"chan_pop: CLNT_FREE wrong message type %x",hdr->flags);
    return(0);
    break;

  default:
    TRACE1(chanp,1,"chan_pop: invalid state  %d",state->cur_state);
    return(0);
    break;
 } 
 return(0);
}

/* killticket: get rid of any dangling fragments */
static killticket(s,t_ptr)
XObj s;
int *t_ptr;
{
#ifdef USE_KILLTICKET
  if (*t_ptr) {
D 2
    x_controlsessn(s,KILLTICKET,(char *)t_ptr,sizeof(int));
E 2
I 2
    x_controlsessn(s, FREERESOURCES, (char *)t_ptr, sizeof(int));
E 2
    *t_ptr = 0;
  }
#endif
}

static chan_controlprotl(self,opcode, buf, len)
XObj    self;
int     opcode;
char    *buf;
int     len;
{
  switch (opcode) {
    default:
        x_errno = INVALID_OPCODE;
        return(-1);
   } 
}
  
static chan_controlsessn(s, opcode, buf, len)
XObj   s;
int     opcode;
char    *buf;
int     len;
{
  CHAN_STATE *sstate;

  TRACE1(chanp, 3, "in chan_control with session=%x", s); 

  sstate = (CHAN_STATE *) s->state;

  switch (opcode) {

    /* copy my CHAN address to buf */
D 2
    case MYADDR:
E 2
I 2
    case GETMYADDR:
E 2
        checkLen(len, sizeof(CHANaddr));
	(*(CHANaddr *)buf) = sstate->myCHANaddr;
	return sizeof(CHANaddr);

    /* copy PEER's CHAN address to buf */
D 2
    case PEERADDR:
E 2
I 2
    case GETPEERADDR:
E 2
        checkLen(len, sizeof(CHANaddr));
	(*(CHANaddr *)buf) = sstate->peerCHANaddr;
	return sizeof(CHANaddr);

    default:
        x_errno = INVALID_OPCODE;
        return(-1);
  }
}

static phdr(hdr)
CHAN_HDR *hdr;
{
  printf("\n");
  printf("CHAN header for channel %d:\n",hdr->chan);
  printf("msg_type: ");
  if (hdr->flags & REQUEST) {
    printf("REQUEST,");
  }
  if (hdr->flags & REPLY) {
    printf("REPLY,");
  }
  if (hdr->flags & EXPLICIT_ACK) {
    printf("EPLICIT_ACK,");
  }
  if (hdr->flags & PROBE) {
    printf("PROBE,");
  }
  printf("\n");
  printf("flags: ");
  if (hdr->flags & ACK_REQUESTED) {
    printf("ACK_REQUESTED,");
  }
  if (hdr->flags & SRVR_ERR) {
    printf("SRVER_ERR,");
  }
  if (hdr->flags & FOR_SRVR) {
    printf("FOR_SRVER,");
  }
  printf("seq: %d\n",hdr->seq);
  printf("prot_id: %d\n",hdr->prot_id);
  printf("boot_id: %d\n",hdr->boot_id);
  printf("err: %d\n",hdr->err);
  printf("\n");
}

/* exponential backoff retry */
static client_timeout(state)
CHAN_STATE *state;
{
D 2
  MSG packet;
E 2
I 2
  Msg packet;
E 2
  CHAN_HDR *top;
  
  TRACE0(chanp, 2, "chan: client_timeout called!");
  if (state->cur_state != CLNT_WAIT) {
    TRACE0(chanp,2,"client_timeout: spurious timeout");
    return(0);
  }


  if (--state->tries == 0) {
    /* call fails */
    TRACE0(chanp, 2, "client_timeout: call fails!");
    /* perform ack  */
    state->cur_state = CLNT_FREE;
    state->cur_seq++;
    flush_msg(state->answer);
    
    /* notify client of bad news */
    flush_msg(state->answer);
    V(&state->reply_sem);
    return(0);
  }

  /* retry  */
  state->hdr.flags = REQUEST | ACK_REQUESTED; 
  msg_save(packet,state->saved_msg);
  top = (CHAN_HDR *) msg_push(packet,CHANHLEN);
  *top = state->hdr;

  /* send message */
D 2
  state->ticket = x_push(state->down_s,packet,(MSG *)0);
E 2
I 2
  state->ticket = x_push(state->down_s,packet,(Msg *)0);
E 2

  /* expontial backoff */
  state->wait = state->wait*2;
  state->event = event_register(client_timeout,(int)state,state->wait,EV_ONCE | EV_CREATEPROCESS);
  return(0);
}
    

/* server timout detects inactive channels and asks for ack */
static server_timeout(state)
CHAN_STATE *state;
{
D 2
  MSG msg;
E 2
I 2
  Msg msg;
E 2
  
  TRACE0(chanp, 2, "CHAN: server_timeout: timeout!");

  if (state->cur_state == SVC_WAIT) {
    state->hdr.flags = PROBE | ACK_REQUESTED; 
    state->hdr.len = 0;
    state->wait = MIN(2*state->wait,MAX_SERVER_WAIT);
    
    msg_make_allstack(msg,128,(char *)&state->hdr,CHANHLEN);
D 2
    x_push(state->down_s,msg,(MSG *)0);
E 2
I 2
    x_push(state->down_s,msg,(Msg *)0);
E 2
    state->event = event_register(server_timeout,(int)state,state->wait,EV_ONCE | EV_CREATEPROCESS);
  }
}


static reply(s,hdr,flags)
CHAN_HDR *hdr;
XObj s;
unsigned short flags;
{
  CHAN_HDR hdr_copy;
D 2
  MSG msg;
E 2
I 2
  Msg msg;
E 2

  hdr_copy = *hdr;
  hdr_copy.flags = flags;
  hdr_copy.len = 0;
  msg_make_allstack(msg,128,(char *)&hdr_copy,CHANHLEN);
D 2
  x_push(s,msg,(MSG *)0);
E 2
I 2
  x_push(s,msg,(Msg *)0);
E 2
}

static SEQ_STAT check_seq(cur_seq,new_seq)
unsigned int cur_seq,new_seq;
{
  if (cur_seq == new_seq) return(current);
  if (cur_seq > new_seq) return(old);
  return(new);
}

static get_boot_id()
{
I 3
#ifdef XSIMUL
  struct timeval tv;

  gettimeofday(&tv, (struct timezone *)NULL);
  return tv.tv_sec;
#else
E 3
  UnixTime time;
I 3

E 3
  unsigned char buffer[8];
  ReadTime(buffer);
  ConvertTimeToUnix(buffer,&time);
  return(time.sec);
I 3
#endif  
E 3
}

chan_getproc(p,type)
XObj p;
D 2
XobjType type;
E 2
I 2
XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = chan_instantiateprotl;
    p->init = chan_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = chan_controlprotl;
  } else {
    p->push = chan_push;
    p->pop = chan_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = chan_controlsessn;
    p->close = chan_close;
  }
  p->open = (Pfi) chan_open;
  p->openenable = chan_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = chan_demux;
  p->getproc = chan_getproc;
}

E 1
