/* 
 * printf.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#undef EXCLUSIVEPRINTF
/* These routines will print on anything, provided you define putchar
 * appropriately.  This version is for the kernel, and uses a separately
 * compiled putchar routine.  Note: putchar should convert \n to \r\n
 * for nice results.
 */


/*#include "process.h"*/
#include "ms_screen.h"

#undef putchar
putchar(c)
char c;
{
  Ms_putchar(c);
}
#define putchar  Ms_putchar

print(s)
register char *s;
{
  while (*s) putchar(*s++);
}

printstring(w, s)
register unsigned w;
register unsigned char *s;
{
  register unsigned c;
  while (w-- > 0) {
    c = *s++;
    switch (c) {
      case '\t':
	print("\\t");
	break;
      case '\r':
	print("\\r");
	break;
      case '\n':
	print("\\n");
	break;
      default:
	if (c < ' ' || c > '~') {
	  putchar('\\');
	  octprint(c, 0);
	} else {
	  putchar((char)c);
	}
	break;
    }
  }
}

/*VARARGS1*/
printf(string)
char *string;
{
#ifdef EXCLUSIVEPRINTF
  register int sw;
#endif
  register unsigned *argp = (unsigned *) &string;
  register char *s = string;
  register int c, width = 0;
  char pad = ' ';
#ifdef EXCLUSIVEPRINTF
  sw = spl7();
#endif
  
  argp++;
  while(*s) {
    if (*s == '%') {
      s++;
      if (*s == '-') {
	pad = '0';
	s++;
      } else {
	pad = ' ';
      }
      if ('0' <= *s && *s <= '9') {
	width = *s - '0';
	s++;
      } else {
	width = 0;
      }
      switch(*s++) {
	case 's': print((char *)(*argp++));  break;
	case 'S': 
	  c = *argp++;
	  printstring((unsigned)c, (unsigned char *)(*argp++));
	  break;
	case 'x': hexprint(*argp++, width);  break;
	case 'X': hexprint(*argp++, 8);  break;
	case 'd': decprint((int)(*argp++), width, pad);  break;
	case 'o': octprint(*argp++, width);  break;
	case 'c': 
	  c = *argp++;
	  putchar(c);
	  break;
	default:
	  if (width != 0) putchar(*(s-3));
	  putchar(*(s-2));
	  putchar(*(s-1));
      }
    } else {
      putchar(*s++);
    }
  }
#ifdef EXCLUSIVEPRINTF
  splx(sw);
#endif
}

InitScreen()
{
  Ms_InitScreen();
}

/* unsigned hexadecimal print */
hexprint(n, width)
register unsigned n;
int width;
{
  register unsigned i, digit, pflag = 0;
  if (width <= 0) width = 1;
  for (i=0; i<8; i++) {
    digit = (n >> 28);
    if (digit != 0 || i == 8 - width) pflag = 1;
    if (pflag) {
      if (digit > 9) digit += 'a'-10;
      else digit += '0';
      putchar((char)digit);
    }
    n <<= 4;
  }
}


/* Unsigned octal print.  We build the character string backwards. */
octprint(n, width)
register unsigned n;
int width;
{
  register unsigned digit;
  static char octbuf[14];
  register char *p = octbuf+13;
  if (width == 0) width = 1;
  *p-- = 0;
  while (n != 0) {
    digit = n & 07;
    n >>= 3;
    *p-- = digit + '0';
  }
  while (p > octbuf + 12 - width) *p-- = '0';
  p++;
  print(p);
}


/* Signed decimal print.  We build the character string backwards. */
decprint(n, width, pad)
register int n, width, pad;
{
  register unsigned digit, nflag=0;
  static char decbuf[12];
  register char *p = decbuf+11;

  *p-- = 0;
  if (n<0)   { n = -n; nflag++; }
  if (width == 0) width = 1;
  if (n == 0) {
    *p-- = '0';
  }
  while (n != 0) {
    digit = n % 10;
    n = n / 10;
    *p-- = digit + '0';
  }
  while (p > decbuf + 10 - width) *p-- = pad;
  if (nflag) *p-- = '-';
  p++;
  print(p);
}
