/* 
 * @(#)printf.c	1.1  1/10/91
 */
/* printx.c: simple debugging-output functions */

/* These routines will print on anything, provided you define putchar
 * appropriately.  This version is for the kernel, and uses a separately
 * compiled putchar routine.  Note: putchar should convert \n to \r\n
 * for nice results.
 *
 *
 * checked for compatibility with xkernel v3.1 no changes made 072090 cliff
 */

#ifndef XSIMUL
#define putchar xputchar
char *hexprint(), *octprint(), *decprint();

static print(s)
register char *s;
{
  while (*s) putchar(*s++);
}

static printstring(w, s)
register unsigned w;
register unsigned char *s;
{
  register unsigned c;
  while (w-- > 0) {
    c = *s++;
    switch (c) {
      case '\t':
	print("\\t");
	break;
      case '\r':
	print("\\r");
	break;
      case '\n':
	print("\\n");
	break;
      default:
	if (c < ' ' || c > '~') {
	  putchar('\\');
	  octprint(c, 0);
	} else {
	  putchar((char)c);
	}
	break;
    }
  }
}

/*VARARGS1*/
printf(string)
char *string;
{
  register unsigned *argp = (unsigned *) &string;
  register char *s = string;
  register int c, width = 0;
  int pad = ' ';
  char lb[20];

  argp++;
  while(*s) {
    if (*s == '%') {
      s++;
      if (*s == '-') {
	pad = '0';
	s++;
      } else {
	pad = ' ';
      }
      if ('0' <= *s && *s <= '9') {
	width = *s - '0';
	s++;
      } else {
	width = 0;
      }
      switch(*s++) {
	case 's': print((char *)(*argp++));  break;
	case 'S': 
	  c = *argp++;
	  printstring((unsigned)c, (unsigned char *)(*argp++));
	  break;
	case 'x': print(hexprint(lb, *argp++, width)); break;
	case 'X': print(hexprint(lb, *argp++, 8)); break;
	case 'd': print(decprint(lb, (int)(*argp++), width, pad)); break;
	case 'o': print(octprint(lb, *argp++, width)); break;
	case 'c': 
	  c = *argp++;
	  putchar(c);
	  break;
	default:
	  if (width != 0) putchar(*(s-3));
	  putchar(*(s-2));
	  putchar(*(s-1));
      }
    } else {
      putchar(*s++);
    }
  }
}


/* unsigned hexadecimal print */
char *hexprint(buf, n, width)
char *buf;
register unsigned n;
int width;
{
  register unsigned i, digit, pflag = 0;
  register char *b = buf;
  if (width <= 0) width = 1;
  for (i=0; i<8; i++) {
    digit = (n >> 28);
    if (digit != 0 || i == 8 - width) pflag = 1;
    if (pflag) {
      if (digit > 9) digit += 'a'-10;
      else digit += '0';
      *b++ = (char)digit;
    }
    n <<= 4;
  }
  *b = '\0';
  return(buf);
}


/* Unsigned octal print.  We build the character string backwards. */
char *octprint(octbuf, n, width)
char *octbuf;
register unsigned n;
int width;
{
  register unsigned digit;
  register char *p = octbuf+13;
  if (width == 0) width = 1;
  *p-- = 0;
  while (n != 0) {
    digit = n & 07;
    n >>= 3;
    *p-- = digit + '0';
  }
  while (p > octbuf + 12 - width) *p-- = '0';
  p++;
  return(p);
}


/* Signed decimal print.  We build the character string backwards. */
char *decprint(decbuf, n, width, pad)
char *decbuf;
register int n, width, pad;
{
  register unsigned digit, nflag=0;
  register char *p = decbuf+11;

  *p-- = 0;
  if (n<0)   { n = -n; nflag++; }
  if (width == 0) width = 1;
  if (n == 0) {
    *p-- = '0';
  }
  while (n != 0) {
    digit = n % 10;
    n = n / 10;
    *p-- = digit + '0';
  }
  while (p > decbuf + 10 - width) *p-- = pad;
  if (nflag) *p-- = '-';
  p++;
  return(p);
}

fprintf(x, s)
int x;
char *s;
{
  printf("Somebody did a fprintf with \"%s\"\n", s);
}

int _iob;
#endif
