/* 
 * intelEthType.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


#ifndef upi_h
#	include "upi.h"
#endif


/*
 * The Intel controller uses 2 kinds of "addresses."
 * Byte orders are reverse of Sun (VAX?).
 * (Maybe swap is machine-dependent and knows whether it needs to swap?).
 */


/*
 * ieOffset_t:
 * 16 bit offsets from IeSharedMemPtr, bytes reversed
 */
typedef u_short ieOffset_t;


#ifndef __STDC__
extern u_short swap2();
extern u_long swap4();
#endif

#define NULL_IE_OFFSET	0xffff

#define IE_OFFSET_FROM_AD(ad)		( (ieOffset_t) swap2( (u_short)\
										((char*) ad - (char*) IeSharedMemPtr)) )

#define AD_FROM_IE_OFFSET(ieOffset)	(swap2( ieOffset ) + (char*) IeSharedMemPtr)


/*
 * ieAd_t:
 * 24 bit addresses, bytes reversed
 */
typedef u_long ieAd_t;

#define IE_AD_FROM_AD(ad)			( (ieAd_t)swap4( (u_long)ad ) )
#define AD_FROM_IE_AD(ieAd)			swap4( ieAd )

