/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class PackageCmd
implements Command {
    private static final String[] validCmds = new String[]{"forget", "ifneeded", "names", "provide", "require", "unknown", "vcompare", "versions", "vsatisfies"};
    private static final int OPT_FORGET = 0;
    private static final int OPT_IFNEEDED = 1;
    private static final int OPT_NAMES = 2;
    private static final int OPT_PROVIDE = 3;
    private static final int OPT_REQUIRE = 4;
    private static final int OPT_UNKNOWN = 5;
    private static final int OPT_VCOMPARE = 6;
    private static final int OPT_VERSIONS = 7;
    private static final int OPT_VSATISFIES = 8;

    static void pkgProvide(Interp interp, String pkgName, String version) throws TclException {
        PackageCmd.checkVersion(interp, version);
        Package pkg = PackageCmd.findPackage(interp, pkgName);
        if (pkg.version == null) {
            pkg.version = version;
            return;
        }
        if (PackageCmd.compareVersions(pkg.version, version, null) != 0) {
            throw new TclException(interp, "conflicting versions provided for package \"" + pkgName + "\": " + pkg.version + ", then " + version);
        }
    }

    static String pkgRequire(Interp interp, String pkgName, String version, boolean exact) throws TclException {
        StringBuffer sbuf;
        int result;
        Package pkg;
        if (version == null && exact) {
            throw new TclException(interp, "conflicting arguments : version == null and exact == true");
        }
        if (version != null) {
            PackageCmd.checkVersion(interp, version);
        }
        VersionSatisfiesResult vsres = new VersionSatisfiesResult();
        int pass = 1;
        while (true) {
            String script;
            pkg = PackageCmd.findPackage(interp, pkgName);
            if (pkg.version != null) break;
            PkgAvail best = null;
            PkgAvail avail = pkg.avail;
            while (avail != null) {
                if (!(best != null && PackageCmd.compareVersions(avail.version, best.version, null) <= 0 || version != null && ((result = PackageCmd.compareVersions(avail.version, version, vsres)) != 0 && exact || !vsres.satisfies))) {
                    best = avail;
                }
                avail = avail.next;
            }
            if (best != null) {
                script = best.script;
                try {
                    interp.eval(script, 1);
                }
                catch (TclException e) {
                    interp.addErrorInfo("\n    (\"package ifneeded\" script)");
                    throw e;
                }
                interp.resetResult();
                pkg = PackageCmd.findPackage(interp, pkgName);
                break;
            }
            if (pass > true) break;
            script = interp.packageUnknown;
            if (script != null) {
                sbuf = new StringBuffer();
                try {
                    Util.appendElement(interp, sbuf, script);
                    Util.appendElement(interp, sbuf, pkgName);
                    if (version == null) {
                        Util.appendElement(interp, sbuf, "");
                    } else {
                        Util.appendElement(interp, sbuf, version);
                    }
                    if (exact) {
                        Util.appendElement(interp, sbuf, "-exact");
                    }
                }
                catch (TclException e) {
                    throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
                }
                try {
                    interp.eval(sbuf.toString(), 1);
                }
                catch (TclException e) {
                    interp.addErrorInfo("\n    (\"package unknown\" script)");
                    throw e;
                }
                interp.resetResult();
            }
            ++pass;
        }
        if (pkg.version == null) {
            sbuf = new StringBuffer();
            sbuf.append("can't find package " + pkgName);
            if (version != null) {
                sbuf.append(" " + version);
            }
            throw new TclException(interp, sbuf.toString());
        }
        if (version == null) {
            return pkg.version;
        }
        result = PackageCmd.compareVersions(pkg.version, version, vsres);
        if (vsres.satisfies && !exact || result == 0) {
            return pkg.version;
        }
        throw new TclException(interp, "version conflict for package \"" + pkgName + "\": have " + pkg.version + ", need " + version);
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        switch (opt) {
            case 0: {
                int i = 2;
                while (i < argv.length) {
                    String pkgName = argv[i].toString();
                    Package pkg = (Package)interp.packageTable.get(pkgName);
                    if (pkg != null) {
                        interp.packageTable.remove(pkgName);
                        while (pkg.avail != null) {
                            PkgAvail avail = pkg.avail;
                            pkg.avail = avail.next;
                            avail = null;
                        }
                        pkg = null;
                    }
                    ++i;
                }
                return;
            }
            case 1: {
                Package pkg;
                if (argv.length < 4 || argv.length > 5) {
                    throw new TclNumArgsException(interp, 1, argv, "ifneeded package version ?script?");
                }
                String pkgName = argv[2].toString();
                String version = argv[3].toString();
                PackageCmd.checkVersion(interp, version);
                if (argv.length == 4) {
                    pkg = (Package)interp.packageTable.get(pkgName);
                    if (pkg == null) {
                        return;
                    }
                } else {
                    pkg = PackageCmd.findPackage(interp, pkgName);
                }
                PkgAvail avail = pkg.avail;
                PkgAvail prev = null;
                while (avail != null) {
                    if (PackageCmd.compareVersions(avail.version, version, null) == 0) {
                        if (argv.length != 4) break;
                        interp.setResult(avail.script);
                        return;
                    }
                    prev = avail;
                    avail = avail.next;
                }
                if (argv.length == 4) {
                    return;
                }
                if (avail == null) {
                    avail = new PkgAvail();
                    avail.version = version;
                    if (prev == null) {
                        avail.next = pkg.avail;
                        pkg.avail = avail;
                    } else {
                        avail.next = prev.next;
                        prev.next = avail;
                    }
                }
                avail.script = argv[4].toString();
                return;
            }
            case 2: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 1, argv, "names");
                }
                try {
                    StringBuffer sbuf = new StringBuffer();
                    Enumeration enumeration = interp.packageTable.keys();
                    boolean once = false;
                    while (enumeration.hasMoreElements()) {
                        once = true;
                        String key = (String)enumeration.nextElement();
                        Package pkg = (Package)interp.packageTable.get(key);
                        if (pkg.version == null && pkg.avail == null) continue;
                        Util.appendElement(interp, sbuf, key);
                    }
                    if (once) {
                        interp.setResult(sbuf.toString());
                    }
                }
                catch (TclException e) {
                    throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
                }
                return;
            }
            case 3: {
                if (argv.length < 3 || argv.length > 4) {
                    throw new TclNumArgsException(interp, 1, argv, "provide package ?version?");
                }
                if (argv.length == 3) {
                    Package pkg = (Package)interp.packageTable.get(argv[2].toString());
                    if (pkg != null && pkg.version != null) {
                        interp.setResult(pkg.version);
                    }
                    return;
                }
                PackageCmd.pkgProvide(interp, argv[2].toString(), argv[3].toString());
                return;
            }
            case 4: {
                if (argv.length < 3 || argv.length > 5) {
                    throw new TclNumArgsException(interp, 1, argv, "require ?-exact? package ?version?");
                }
                int exact = argv[2].toString().equals("-exact") ? 1 : 0;
                String version = null;
                if (argv.length == 4 + exact) {
                    version = argv[3 + exact].toString();
                } else if (argv.length != 3 || exact == 1) {
                    throw new TclNumArgsException(interp, 1, argv, "require ?-exact? package ?version?");
                }
                version = exact == 1 ? PackageCmd.pkgRequire(interp, argv[3].toString(), version, true) : PackageCmd.pkgRequire(interp, argv[2].toString(), version, false);
                interp.setResult(version);
                return;
            }
            case 5: {
                if (argv.length > 3) {
                    throw new TclNumArgsException(interp, 1, argv, "unknown ?command?");
                }
                if (argv.length == 2) {
                    if (interp.packageUnknown != null) {
                        interp.setResult(interp.packageUnknown);
                    }
                } else if (argv.length == 3) {
                    interp.packageUnknown = null;
                    String cmd = argv[2].toString();
                    if (cmd.length() > 0) {
                        interp.packageUnknown = cmd;
                    }
                }
                return;
            }
            case 6: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "vcompare version1 version2");
                }
                String ver1 = argv[2].toString();
                String ver2 = argv[3].toString();
                PackageCmd.checkVersion(interp, ver1);
                PackageCmd.checkVersion(interp, ver2);
                interp.setResult(PackageCmd.compareVersions(ver1, ver2, null));
                return;
            }
            case 7: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "versions package");
                }
                Package pkg = (Package)interp.packageTable.get(argv[2].toString());
                if (pkg != null) {
                    try {
                        StringBuffer sbuf = new StringBuffer();
                        boolean once = false;
                        PkgAvail avail = pkg.avail;
                        while (avail != null) {
                            once = true;
                            Util.appendElement(interp, sbuf, avail.version);
                            avail = avail.next;
                        }
                        if (once) {
                            interp.setResult(sbuf.toString());
                        }
                    }
                    catch (TclException e) {
                        throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
                    }
                }
                return;
            }
            case 8: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "vsatisfies version1 version2");
                }
                String ver1 = argv[2].toString();
                String ver2 = argv[3].toString();
                PackageCmd.checkVersion(interp, ver1);
                PackageCmd.checkVersion(interp, ver2);
                VersionSatisfiesResult vsres = new VersionSatisfiesResult();
                PackageCmd.compareVersions(ver1, ver2, vsres);
                interp.setResult(vsres.satisfies);
                return;
            }
        }
        throw new TclRuntimeError("TclIndex.get() error");
    }

    private static Package findPackage(Interp interp, String pkgName) throws TclException {
        if (pkgName == null || pkgName.length() == 0) {
            throw new TclException(interp, "expected package name but got \"\"");
        }
        Package pkg = (Package)interp.packageTable.get(pkgName);
        if (pkg == null) {
            pkg = new Package();
            interp.packageTable.put(pkgName, pkg);
        }
        return pkg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkVersion(Interp interp, String version) throws TclException {
        boolean error;
        block10: {
            block11: {
                block9: {
                    error = true;
                    try {
                        if (version == null || version.length() == 0) {
                            version = "";
                            Object var7_3 = null;
                            if (!error) return;
                            throw new TclException(interp, "expected version number but got \"" + version + "\"");
                        }
                        if (!Character.isDigit(version.charAt(0))) {
                            break block9;
                        }
                        int len = version.length();
                        int i = 1;
                        while (true) {
                            if (i >= len) {
                                if (version.charAt(len - 1) != '.') {
                                    return;
                                }
                                break block10;
                            }
                            char c = version.charAt(i);
                            if (!Character.isDigit(c) && c != '.') {
                                break block11;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (!error) throw throwable;
                        throw new TclException(interp, "expected version number but got \"" + version + "\"");
                    }
                }
                Object var7_4 = null;
                if (!error) return;
                throw new TclException(interp, "expected version number but got \"" + version + "\"");
            }
            Object var7_5 = null;
            if (!error) return;
            throw new TclException(interp, "expected version number but got \"" + version + "\"");
        }
        Object var7_6 = null;
        if (!error) return;
        throw new TclException(interp, "expected version number but got \"" + version + "\"");
    }

    private static int compareVersions(String v1, String v2, VersionSatisfiesResult vsres) {
        int n1 = 0;
        int n2 = 0;
        boolean thisIsMajor = true;
        if (v1 == null || v2 == null) {
            throw new TclRuntimeError("null version in package version compare");
        }
        String[] v1ns = PackageCmd.split(v1, '.');
        String[] v2ns = PackageCmd.split(v2, '.');
        if (v1ns.length == 0 || v2ns.length == 0) {
            throw new TclRuntimeError("version length is 0");
        }
        int max = v1ns.length > v2ns.length ? v1ns.length : v2ns.length;
        int i = 0;
        while (i < max) {
            n2 = 0;
            n1 = 0;
            try {
                if (i < v1ns.length) {
                    n1 = Integer.parseInt(v1ns[i]);
                }
                if (i < v2ns.length) {
                    n2 = Integer.parseInt(v2ns[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TclRuntimeError("NumberFormatException for package versions \"" + v1 + "\" or \"" + v2 + "\"");
            }
            if (n1 != n2) break;
            thisIsMajor = false;
            ++i;
        }
        if (vsres != null) {
            boolean bl = vsres.satisfies = n1 == n2 || n1 > n2 && !thisIsMajor;
        }
        if (n1 > n2) {
            return 1;
        }
        if (n1 == n2) {
            return 0;
        }
        return -1;
    }

    static String[] split(String in, char splitchar) {
        int wordstart = 0;
        int len = in.length();
        char[] str = new char[len + 1];
        in.getChars(0, len, str, 0);
        str[len++] = splitchar;
        Vector<String> words = new Vector<String>(5);
        int i = 0;
        while (i < len) {
            if (str[i] == splitchar) {
                if (wordstart <= i - 1) {
                    words.addElement(new String(str, wordstart, i - wordstart));
                }
                wordstart = i + 1;
            }
            ++i;
        }
        Object[] ret = new String[words.size()];
        words.copyInto(ret);
        return ret;
    }

    PackageCmd() {
    }

    static class VersionSatisfiesResult {
        boolean satisfies = false;

        VersionSatisfiesResult() {
        }
    }

    static class PkgAvail {
        String version;
        String script;
        PkgAvail next;

        PkgAvail() {
        }
    }

    static class Package {
        String version;
        PkgAvail avail;

        Package() {
        }
    }
}

