/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.ArrayObject;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.JavaNullCmd;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class ReflectObject
extends InternalRep
implements CommandWithDispose {
    Object javaObj;
    Class javaClass;
    Interp ownerInterp;
    String refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;
    protected static final String NULL_REP = JavaNullCmd.getNullString();
    protected static final String NOCONVERT = "-noconvert";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    private static ReflectObject makeReflectObject(Interp interp, Class cl, Object obj) throws TclException {
        if (obj == null) {
            return ReflectObject.initReflectObject(interp, null, null, null, null);
        }
        if (cl == null) {
            throw new TclException(interp, "non null reflect object with null class is not valid");
        }
        if (cl == Integer.TYPE) {
            cl = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ReflectObject.class$("java.lang.Integer"));
        } else if (cl == Boolean.TYPE) {
            cl = class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ReflectObject.class$("java.lang.Boolean"));
        } else if (cl == Long.TYPE) {
            cl = class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ReflectObject.class$("java.lang.Long"));
        } else if (cl == Float.TYPE) {
            cl = class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ReflectObject.class$("java.lang.Float"));
        } else if (cl == Double.TYPE) {
            cl = class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ReflectObject.class$("java.lang.Double"));
        } else if (cl == Byte.TYPE) {
            cl = class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ReflectObject.class$("java.lang.Byte"));
        } else if (cl == Short.TYPE) {
            cl = class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ReflectObject.class$("java.lang.Short"));
        } else if (cl == Character.TYPE) {
            cl = class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ReflectObject.class$("java.lang.Character"));
        } else if (cl == Void.TYPE) {
            throw new TclException(interp, "void object type can not be reflected");
        }
        ReflectObject roRep = null;
        Object refOrTable = interp.reflectObjTable.get(obj);
        if (refOrTable == null) {
            return ReflectObject.initReflectObject(interp, cl, obj, interp.reflectObjTable, obj);
        }
        if (refOrTable instanceof ReflectObject) {
            roRep = (ReflectObject)refOrTable;
            if (roRep.javaClass == cl) {
                ++roRep.useCount;
                return roRep;
            }
            Hashtable<Class, ReflectObject> h = new Hashtable<Class, ReflectObject>(3);
            interp.reflectObjTable.put(obj, h);
            h.put(roRep.javaClass, roRep);
            return ReflectObject.initReflectObject(interp, cl, obj, h, cl);
        }
        Hashtable h = (Hashtable)refOrTable;
        roRep = (ReflectObject)h.get(cl);
        if (roRep == null) {
            return ReflectObject.initReflectObject(interp, cl, obj, h, cl);
        }
        ++roRep.useCount;
        return roRep;
    }

    private static ReflectObject initReflectObject(Interp interp, Class cl, Object obj, Hashtable addTable, Object addKey) throws TclException {
        ReflectObject roRep = cl != null && cl.isArray() ? new ArrayObject() : new ReflectObject();
        roRep.ownerInterp = interp;
        roRep.javaObj = obj;
        roRep.javaClass = cl;
        if (roRep.javaObj != null) {
            Class<?> obj_class = roRep.javaObj.getClass();
            if (!roRep.javaClass.isAssignableFrom(obj_class)) {
                throw new TclException(interp, "object of type " + obj_class.getName() + " can not be referenced as type " + roRep.javaClass.getName());
            }
            ++interp.reflectObjCount;
            roRep.refID = "java0x" + Long.toHexString(interp.reflectObjCount);
            interp.createCommand(roRep.refID, (Command)roRep);
            interp.reflectIDTable.put(roRep.refID, roRep);
            addTable.put(addKey, roRep);
        } else {
            roRep.refID = NULL_REP;
        }
        roRep.useCount = 1;
        roRep.isValid = true;
        return roRep;
    }

    protected void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != NULL_REP) {
            this.ownerInterp.deleteCommand(this.refID);
            this.ownerInterp.reflectIDTable.remove(this.refID);
            this.disposeOfTableRefrences();
            this.ownerInterp = null;
            this.javaObj = null;
            this.javaClass = null;
            this.bindings = null;
            this.refID = NULL_REP;
        }
    }

    private void disposeOfTableRefrences() {
        Object refOrTable = this.ownerInterp.reflectObjTable.get(this.javaObj);
        if (refOrTable instanceof ReflectObject) {
            this.ownerInterp.reflectObjTable.remove(this.javaObj);
        } else {
            Hashtable h = (Hashtable)refOrTable;
            h.remove(this.javaClass);
            if (h.size() == 1) {
                Object value = h.elements().nextElement();
                this.ownerInterp.reflectObjTable.put(this.javaObj, value);
            }
        }
    }

    protected InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tobj) throws TclException {
        String s;
        ReflectObject roRep;
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof ReflectObject) {
            roRep = (ReflectObject)rep;
            if (roRep.isValid && roRep.ownerInterp == interp) {
                return;
            }
        }
        if ((s = tobj.toString()).startsWith("java")) {
            if (s.equals(NULL_REP)) {
                tobj.setInternalRep(ReflectObject.makeReflectObject(interp, null, null));
                return;
            }
            roRep = (ReflectObject)interp.reflectIDTable.get(s);
            if (roRep != null && roRep.isValid) {
                ++roRep.useCount;
                tobj.setInternalRep(roRep);
                return;
            }
        }
        throw new TclException(interp, "unknown java object \"" + tobj + "\"");
    }

    public static TclObject newInstance(Interp interp, Class cl, Object obj) throws TclException {
        return new TclObject(ReflectObject.makeReflectObject(interp, cl, obj));
    }

    public static Object get(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaObj;
    }

    public static Class getClass(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaClass;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        return (ReflectObject)tobj.getInternalRep();
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int sigIdx;
        boolean convert;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        String arg1 = argv[1].toString();
        if (arg1.length() >= 2 && NOCONVERT.startsWith(arg1)) {
            convert = false;
            sigIdx = 2;
        } else {
            convert = true;
            sigIdx = 1;
        }
        if (argv.length < sigIdx + 1) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        int startIdx = sigIdx + 1;
        int count = argv.length - startIdx;
        interp.setResult(JavaInvoke.callMethod(interp, argv[0], argv[sigIdx], argv, startIdx, count, convert));
    }

    public void disposeCmd() {
        this.isValid = false;
    }

    public String toString() {
        return this.refID;
    }

    static void init(Interp interp) {
        interp.reflectIDTable = new Hashtable();
        interp.reflectObjTable = new Hashtable();
        interp.reflectObjCount = 0L;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

