/*
 * Decompiled with CFR 0.152.
 */
package tcl.regex;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class OroRegexpCmd
implements Command {
    private static final String[] validCmds = new String[]{"-indices", "-nocase", "--"};
    private static final int OPT_INDICES = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String origStringArg;
        int objc = argv.length - 1;
        boolean noCase = false;
        boolean indices = false;
        boolean last = false;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        int currentObjIndex = 1;
        while (objc > 0 && !last) {
            if (!argv[currentObjIndex].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)1);
            switch (opt) {
                case 0: {
                    indices = true;
                    break;
                }
                case 1: {
                    noCase = true;
                    break;
                }
                case 2: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "RegexpCmd.cmdProc: bad option " + opt + " index to validCmds");
                }
            }
            --objc;
            ++currentObjIndex;
        }
        if (objc < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        String patternArg = argv[currentObjIndex].toString();
        String stringArg = origStringArg = argv[currentObjIndex + 1].toString();
        currentObjIndex += 2;
        if (noCase) {
            patternArg = patternArg.toLowerCase();
            stringArg = origStringArg.toLowerCase();
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternArg);
        }
        catch (MalformedPatternException e) {
            throw new TclException(interp, "couldn't compile regular expression pattern:  " + e.getMessage());
        }
        if (matcher.contains(stringArg, pattern)) {
            MatchResult result = matcher.getMatch();
            interp.setResult(1);
            int g = 0;
            while (objc > 2 && g < result.groups()) {
                int start = result.beginOffset(g);
                if (start == -1) {
                    if (indices) {
                        OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), -1, -1);
                    } else {
                        OroRegexpCmd.setEmptyStringVar(interp, argv[currentObjIndex].toString());
                    }
                } else {
                    int end = result.endOffset(g);
                    if (indices) {
                        OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), start, end - 1);
                    } else {
                        OroRegexpCmd.setMatchStringVar(interp, argv[currentObjIndex].toString(), start, end, origStringArg);
                    }
                }
                ++g;
                --objc;
                ++currentObjIndex;
            }
        } else {
            interp.setResult(0);
        }
        while (objc > 2) {
            if (indices) {
                OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), -1, -1);
            } else {
                OroRegexpCmd.setEmptyStringVar(interp, argv[currentObjIndex].toString());
            }
            --objc;
            ++currentObjIndex;
        }
    }

    public static boolean match(Interp interp, String stringArg, String patternArg) throws TclException {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternArg);
        }
        catch (MalformedPatternException e) {
            throw new TclException(interp, "couldn't compile regular expression pattern:  " + e.getMessage());
        }
        if (patternArg.length() > 0 && patternArg.charAt(0) == '^') {
            return matcher.contains(stringArg, pattern) && matcher.getMatch().beginOffset(0) == 0;
        }
        return matcher.matches(stringArg, pattern);
    }

    private static void setMatchVar(Interp interp, String varName, int start, int end) throws TclException {
        try {
            TclObject indexPairObj = TclList.newInstance();
            TclList.append(interp, indexPairObj, TclInteger.newInstance((int)start));
            TclList.append(interp, indexPairObj, TclInteger.newInstance((int)end));
            interp.setVar(varName, indexPairObj, 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }

    private static void setMatchStringVar(Interp interp, String varName, int start, int end, String valueString) throws TclException {
        TclObject valueObj = start == -1 ? TclString.newInstance((String)"") : TclString.newInstance((String)valueString.substring(start, end));
        try {
            interp.setVar(varName, valueObj, 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }

    private static void setEmptyStringVar(Interp interp, String varName) throws TclException {
        try {
            interp.setVar(varName, TclString.newInstance((String)""), 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }
}

