
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#include <stream.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <strings.h>
#include "compile.h"

char* concat_strings(char* s1, char* s2)
{
  int strlen(...);
  char* strcat(...);
  char* buf = new char[strlen(s1) + strlen(s2) + 2];
  buf[0] = '\0';
  strcat(buf, s1);
  strcat(buf, s2);
  return buf;
}

istream* open_input_file(char* filename)
{
  filebuf* f1 = new filebuf;
  return (f1->open(filename, input) == 0) ? 0 : new istream(f1);
}

void compile(char* name)
{
  int vfork();
  int execl(...);
  int wait(...);
  int pid;
  switch (pid = vfork()) {
  case 0:
    execl("compiler", "compiler", name, 0);
    break;
  default:
    if (pid == -1) {
      cout << "can't fork another process\n";
    }
    wait(0);
    break;
  }
}

istream* get_loadable_file(char* name, int mode)
{
  istream* new_cinp;
  char* full_name = concat_strings(name, ".w");
  new_cinp = open_input_file(full_name);
  if (new_cinp == 0 || mode == COMPILE_MODE)
    compile(name);
  new_cinp = open_input_file(full_name);
  return new_cinp;
}  
