
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

main :-
	e(X),
	t_vars_calls(X),
	write(X), nl, fail.

%t_vars_calls(X) :-
%	t_vars([[[[1,H_26|-]|fac],H_26|*],1,[0,H_26|=]|cond],X).
t_vars_calls(X) :- t_vars([0,Z|a],X).
%t_vars_calls(X) :- t_vars([[1,Z|-],Z|a],X).

e(_).

t_vars(_v, [[_v]]) :- var(_v), !.
t_vars(_a, [[]]) :- atomic(_a), !.
t_vars([_func], [[]]) :- atomic(_func), !.
t_vars([_arg|_func], [_g,[_g1|_af1],[_g2|_af2]]) :-
	t_vars(_arg, [_g1|_af1]),
	t_vars(_func, [_g2|_af2]),
	unionv(_g1, _g2, _g). 

unionv(S1, S2, S1) :- S1==S2.
unionv([X|S1], S2, Res) :-
	memberv(X, S2), !,
	unionv(S1, S2, Res).
unionv([X|S1], S2, [X|Res]) :-
	unionv(S1, S2, Res).
unionv([], S, S).

memberv(X, [Y|_]) :- X==Y, !.
memberv(X, [_|L]) :- memberv(X, L).
