(* Evaluate a topdec *)

(*
$File: Common/EVALTOPDEC.sml $
$Date: 1992/03/09 15:01:13 $
$Revision: 1.9 $
$Locker: birkedal $
*)

(*$EVALTOPDEC*)

signature EVALTOPDEC =
  sig
    type topdec
    type DynamicBasis
    type Pack

    val RE_RAISE: Pack -> unit		(* Needed by the top-level interpret
					   loop to re-raise exceptions into
					   contexts nested by `use'. *)
    exception UNCAUGHT of Pack
    val pr_Pack: Pack -> string

    val eval: DynamicBasis * topdec -> DynamicBasis
					(* can raise UNCAUGHT(p). *)
    val FAIL_USE: unit -> unit		(* see APPLY. Needed by Interpreter. *)

    type StringTree
    val layoutDynamicBasis: DynamicBasis -> StringTree
  end;
