#!/bin/sh
## Copyright (C) 1989,1990,1991,1992 by
#	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
#	Wolfgang Obst and Ulrich Pralle 
# 
# This file is part of shapeTools.
#
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with shapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# $Header: vdiff.sh[2.5] Mon Feb 10 17:59:31 1992 axel@cs.tu-berlin.de accessed $

perror () {
  echo 1>&2 $*
}

match () {
  echo $1 | egrep "$2" > /dev/null
}

cleanup () {
  rm -f $rmlist
}

trapexit () {
  cleanup
  exit $estat
}

afterburner=false
makepatch=false
base=`pwd`/
estat=0
argc=$#

trap trapexit 1 2 3 4 5 6 7 8 10 11 12 13 14 15 

if [ $argc -lt 1 ]
then
  perror usage: vdiff [ options ] [ -base '<path>' ] file1 [ file2 ]
  exit 1
fi
while [ $argc -gt 0 ]
do
  i=$1
  shift
  argc=`expr $argc - 1`
  case $i in
    -trace) 
	set -x;;
    -ttrace)
	set -v
	set -x;;
    -base)
	if [ $afterburner = true ]
	then
	  if [ $argc -gt 0 ] 
	  then
	    base=$1/
	    shift
	    argc=`expr $argc - 1`
	  else
	    perror usage: vdiff -base requires an argument.
	    exit 1
	  fi
	fi;;
    -c)
	afterburner=true
	options="$options $i";;
    -P)
	makepatch=true;;
    -version)
	echo This is 'vdiff-2.5 (Fri Apr 24 18:22:44 1992 by axel@cs.tu-berlin.de).'
	exit 0;;
    -*)
	options="$options $i";;
    *)
	if [ -z "$fn1" ]
	then
	  fn1=$i
	  fn1t=/tmp/`basename $fn1`
	elif [ -z "$fn2" ]
	then
	  fn2=$i
	  fn2t=/tmp/`basename $fn2`
	else
	  perror usage: vdiff [ options ] [ -base '<path>' ] file1 [ file2 ]
	  exit 1
	fi;;
  esac
done

if [ -z "$fn2" ]
then
# only one filename argument
  if match $fn1 '..*\[.*\]'
  then
  # first and only filename object in bound version notation
    mt1=`pattr -uda mtime $fn1 2> /dev/null`
    fn2=`echo $fn1 | sed -e 's/\[.*\]//'`
    mt2=`pattr -uda mtime -s busy $fn2 2> /dev/null`

    if [ "$mt1" = "$mt2" ]
    then
      exit 0;
    fi

    vcat -q $fn1 > $fn1t          

    if [ $? -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      rm -f $fn1t
      cleanup
      exit 1
    fi

    rmlist="$rmlist $fn1t"

    if [ "$afterburner" = true ]
    then
      diff $options $fn1t $fn2 | \
	sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=$?
    else
      diff $options $fn1t $fn2
      estat=$?
    fi

  else
  # only filename of busy version given
    fn2=`vl -y $fn1`
    estat=$?
    mt1=`pattr -uda mtime -s busy $fn1 2> /dev/null`
    estat=`expr $estat \| $?`
    mt2=`pattr -uda mtime $fn2 2> /dev/null`
    estat=`expr $estat \| $?`
  
    if [ "$mt1" = "$mt2" ]
    then
      exit 0;
    fi
  
    if [ "$estat" -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      estat=1
      cleanup
      exit $estat
    else
      fn2t=/tmp/`basename $fn2`
    fi
  
    vcat -q $fn2 > $fn2t 2> /dev/null
  
    if [ $? -gt 0 ]
    then
      perror ${fn2}: No such file or version.
      rm -f $fn2t
      cleanup
      exit $estat
    fi
  
    rmlist="$rmlist $fn2t"
  
    if [ "$afterburner" = true ]
    then
      diff $options $fn1 $fn2t | \
	  sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=`expr $estat \| $?`
    else
      diff $options $fn1 $fn2t
      estat=`expr $estat \| $?`
    fi
  
  fi

else                             
# two filename-objects specified

  if match $fn1 '..*\[.*\]'
  then
  # first fn-object in bound version notation
    mt1=`pattr -uda mtime $fn1 2> /dev/null`
    rmlist="$rmlist $fn1t"
    vcat -q $fn1 > $fn1t 2> /dev/null

    if [ $? -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      if [ "$makepatch" != true ]
      then
        rm -f $fn1t
        cleanup
        exit 1
      fi
    fi

    fn1=$fn1t
  else
    mt1=`pattr -uda mtime -s busy $fn1 2> /dev/null`
  fi

  if match $fn2 '..*\[.*\]'
  then
  # second fn-object in bound version notation
    mt2=`pattr -uda mtime $fn2 2> /dev/null`
    rmlist="$rmlist $fn2t"
    vcat -q $fn2 > $fn2t 2> /dev/null

    if [ $? -gt 0 ]
    then
      perror ${fn2}: No such file or version.
      if [ "$makepatch" != true ]
      then
        rm -f $fn2t
        cleanup
        exit 1
      fi
    fi

    fn2=$fn2t
  else
    mt2=`pattr -uda mtime -s busy $fn2 2> /dev/null`
  fi

  if [ "$mt1" = "$mt2" ]
  then
    estat=0
  else
    if [ "$afterburner" = true ]
    then
      diff $options $fn1 $fn2 | \
	sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=`expr $estat \| $?`
    else
      diff $options $fn1 $fn2
      estat=`expr $estat \| $?`
    fi
  fi
fi

rm -f $rmlist
exit $estat

