/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

 *
 * $Header: out.c[1.12] Wed Mar 11 14:44:58 1992 nickel@cs.tu-berlin.de accessed $
 * output module for rcs2atfs
 */

#include "rcs2atfs.h"
#include "functions.h"


/* convert a single revision */

void convert_revision(out, wkfile, branches, rev, initial, comment_leader)
FILE *out ;			/* to shell script to write into */
char *wkfile ;			/* name of working file */
bool branches ;			/* branches exist */
struct RCSREV *rev ;		/* revision struct */
bool initial ;			/* this is the initial revision,
				 * no locking required */
char *comment_leader ;		/* comment leader string */
{
    struct SYMNAME *sym ;

    (void) fprintf(out, "\n\n# %s[%s]\n\n", wkfile, rev->number) ;
    if (!keep_quiet) {
	fprintf(out, "echo -n '[%s] '\n", rev->number) ;
    }

    /* check out appropriate revision */
    fprintf(out, "co -q -%s %s\n", rev->number, wkfile) ;

    /* set atime and mtime */
    fprintf(out, "utime %ld %ld %s\n", rev->date, rev->date, wkfile) ;

    /* lock previous version */
    if (! initial) {
	fprintf(out, "vadm -q -lock %s \n", wkfile) ;
    }
    
    /* save as AtFS version with log message */
    if (! branches) {
	/* we can only keep version numbers if no branches exist */
	fprintf(out, "save -q -f -m \"%s\" %s[%s]\n",
		rev->log_message ? rev->log_message : "",
		wkfile, rev->number + 1) ;
    } else {
	fprintf(out, "save -q -f -m \"%s\" %s\n", rev->log_message, wkfile) ;
    }

    /* set comment leader */
    fprintf(out, "vadm -q -setc \"%s\" %s\n",
	    comment_leader, wkfile) ;

    /* set author */
    fprintf(out, "vadm -q -chaut %s %s\n", rev->author, wkfile) ;

    /* set symbolic names */
    for (sym = rev->symbolic_names; sym != NULL; sym = sym->next) {
	(void) fprintf(out, "vadm -q -symbolic %s %s\n",
		       sym->symname, wkfile) ;
    }

    /* set state as AtFS-UDA */
    fprintf(out, "vadm -q -setuda RCSstate='%s' %s\n",
	    rev->state ? rev->state : "", wkfile) ;
    /* set RCS revision number as symbolic name */
    fprintf(out, "vadm -q -symbolic %s %s\n",
	    rev->number, wkfile) ;

    /* set AtFS state if RCS state is something known */
    if (! strcmp(rev->state, "Stab")) {
	/* set state to proposed */
	fprintf(out, "vadm -q -promote %s\n", wkfile) ;
    } else if (! strcmp(rev->state, "Rel")) {
	/* set state to published */
	fprintf(out, "vadm -q -promote %s\n", wkfile) ;
	fprintf(out, "vadm -q -promote %s\n", wkfile) ;
    }
}

/* build shell script for converting the archive */

void make_shell_script(directory, rcsfile, out)
char *directory ;
struct RCSFILE *rcsfile ;
FILE *out ;
{
    struct RCSREV *rev ;
    char *wkfile = rcsfile->working_file ;

    /* change working directory */
    if (directory != NULL) {
	fprintf(out, "(cd %s\n\n", directory) ;
    }

    /* insert messages */
    if (!keep_quiet) {
	fprintf(out, "echo %s:\n\n", rcsfile->rcs_file) ;
    }

    /* create AtFS directory, don't complain if it exists */
    fprintf(out, "mkdir %s 2> /dev/null\n", AtFSDIR) ;

    /* convert first revision (without locking) */
    rev = rcsfile->revisions ;
    convert_revision(out, wkfile, rcsfile->branches, rev, true,
		     rcsfile->comment_leader) ;

    /* other revisions */
    for (rev = rev->next ; rev != NULL; rev = rev->next) {
	convert_revision(out, wkfile, rcsfile->branches, rev, false,
			 rcsfile->comment_leader) ;
    }

    if (!keep_quiet) {
	fprintf(out, "echo\n") ;
    }
    if (directory != NULL) {
	fprintf(out, ")\n") ;
    }
}

/*EOF*/
