%{
/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Scanner for SHAPE
 */

#ifndef lint
static char *AtFSid = "$Header: shape.l[1.15] Thu Feb 15 13:24:57 1990 wolfgang@coma published $";
#endif

#include <stdio.h>
#include <ctype.h>
#include "shape.h"

extern char *malloc();

extern char *sel_rule_name;
extern Bool synterrflg;
extern Bool Oldsuffs;
extern Bool Newsuffs;
extern char *shaperules;
extern char *stdsuff;
extern char *expandmacro();

extern int macrodef();
extern int ruledef();
extern int rulecont();
extern int ruleend();
extern void selruledef_name();
extern void selruledef_preds();
extern int vclassdef();
extern int errexit();
#undef YYLMAX
#define YYLMAX 2048 /* Scheiss LEX */

/*
 * The following redefines the ECHO macro, which, being the default action
 * in lex(1), is executed whenever an unrecognized string is encountered.
 * Thus, we catch syntax errors this way.
 */
#undef	ECHO
#define	ECHO	{ synterrflg = TRUE; errexit(14,yytext); }

char *ppp;
extern char *suffs;
Bool suffs_deleted = FALSE;
%}
%a 10000
%o 10000
%s RULEDEF RULESEC VARSEC
Layout		[ \t\014]
Blank		" "
Colon		":"
Tab		\t
NotRulecont	[^\t]
NC1		"\\\n"
NC2		[^#\n]
NC4		[^\n]
Nocomment	({NC1}|{NC2})*
Nocomment2	({NC1}|{NC4})*
Macroname	[0-9a-zA-Z._-]
Vclass		"vclass"{Layout}*{Ruledef}{Nocomment}
Macrodef	{Layout}*{Macroname}+{Layout}*("+="|"="){Layout}*.*
Rulesecstart	"#%"{Layout}*"RULE-SECTION"{Layout}*
Rulesecend	"#%"{Layout}*"END-RULE-SECTION"{Layout}*
Varsecstart	"#%"{Layout}*"VARIANT-SECTION"{Layout}*
Varsecend	"#%"{Layout}*"END-VARIANT-SECTION"{Layout}*
Depstart	[@%0-9a-zA-Z.\-/$("{""}")_~,+]
Depcont		[@%0-9a-zA-Z.\-/\t $("{""}")_~,+]
Ruledef		{Depstart}+{Depcont}*{Colon}+{Colon}*{Depcont}*{Nocomment}
Rulecont	{Tab}+{Nocomment2}
%%
%{
/*
 * The following two pattern/actions are here so that they are
 * matched (rather than others) in cases of ambiguity.
 */
%}
\n		{
#ifdef DEBUG_LEX
fprintf(stderr, "Newline: \n");
#endif
		;
		}

^{Layout}*$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Layoutline: \n");
#endif
		;
		}

%{
/*
 * Pattern/actions when inside a production rule:
 */
%}
<RULEDEF>^{Rulecont}$	{
		rulecont(yytext);		
#ifdef DEBUG_LEX
fprintf(stderr, "Ruledef Cont: %s\n", yytext);
#endif
		}

<RULEDEF>^{NotRulecont}	{
#ifdef DEBUG_LEX
fprintf(stderr, "Ruledef NotRulecont: %s\n", yytext);
#endif
		ruleend();
		yyless(yyleng-1);
		BEGIN 0;
		}

%{
/*
 * Pattern/actions when inside the rule section of a Shapefile:
 */
%}
<RULESEC>^{Ruledef}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Selrule name: %s\n", yytext);
#endif
		selruledef_name(yytext);
		}

<RULESEC>^{Tab}.*$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Predicate found: %s\n", yytext);
#endif
		selruledef_preds(yytext);
		}

<RULESEC>^{Rulesecend}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Rulesec end found: %s\n", yytext);
#endif
		;
		BEGIN 0;
		}

%{
/*
 * Pattern/actions when inside the variant section of a
 * Shapefile:
 */
%}
<VARSEC>^{Tab}{Macrodef}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Varsec Macro: %s\n", yytext);
#endif
		varmacrodef(yytext);
		}

%{
/*
 * The following "variant-class" pattern/action must be before
 * the "variant-name" pattern/action in order to take
 * precedence.
 */
%}
<VARSEC>^{Vclass}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Varsec Vclass: %s\n", yytext);
#endif
		vclassdef(yytext);		
		}

%{
/*
 * The following "variant-name" pattern/action must be after
 * the "variant-class" pattern/action in order to yield
 * precedence.
 */
%}
<VARSEC>^{Ruledef}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Varsec Name: %s\n", yytext);
#endif
		varsec_name(yytext);
		}

<VARSEC>^{Varsecend}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Varsec End: %s\n", yytext);
#endif
		;
		BEGIN 0;
		}

%{
/*
 * Macro-definition pattern/action.  Always ignored.
 */
%}
^{Macrodef}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Macrodef: %s\n", yytext);
#endif
		;
		}

%{
/*
 * Pattern/action for the start of a production-rule:
 */
%}
^{Ruledef}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Ruledef: %s\n",yytext);
#endif
		ruleend();
		if ((strncmp(yytext,".SUFFIXES:",10) == 0)) {
		    if((ppp = index(yytext,'%')) == NIL) {
			/* old style suffix list */
			Oldsuffs = TRUE;
			ppp = &yytext[0] + 10;
			if (index(ppp,'.') != NIL) {
			    if ((suffs = malloc((unsigned)(strlen(yytext) +
				strlen(stdsuff) + 3))) == NIL) {

				errexit(10,"malloc");
			    }
			    suffs[0] = '\0';
				(void) strcat(suffs,".SUFFIXES: ");
			    if (!suffs_deleted)
				(void) strcat(suffs,stdsuff);
			    (void) strcat(suffs,ppp);
			    suffs_deleted = FALSE;
			} else {
			    suffs_deleted = TRUE;
			}
		    } else {
			/* new style suffixes */
			Newsuffs = TRUE;
			ppp = &yytext[0] + 10;
			if ((suffs = malloc((unsigned)(strlen(yytext) + 
			    strlen(shaperules) + 3))) == NIL) {

			    errexit(10,"malloc");
			}
			suffs[0] = '\0';
			    (void) strcat(suffs,".SUFFIXES");
			if (!suffs_deleted)
			    (void) strcat(suffs,shaperules);
			(void) strcat(suffs,ppp);
			suffs_deleted = FALSE;
		    }
		} else	{
		    ruledef(yytext);		
		}
		BEGIN RULEDEF;
		}

%{
/*
 * Pattern/action for start of a rule section:
 */
%}
^{Rulesecstart}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Rulesec start found: %s\n", yytext);
#endif
		;
		BEGIN RULESEC;
		}

%{
/*
 * Pattern/action for the start of a variant section:
 */
%}
^{Varsecstart}$	{
#ifdef DEBUG_LEX
fprintf(stderr, "Varcec Start: %s\n", yytext);
#endif
		;
		BEGIN VARSEC;
		}

%%

