/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * vc_lock.c
 *
 * $Header: vc_lock.c[3.19] Wed Feb  5 18:11:24 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: vc_lock.c[3.19] Wed Feb  5 18:11:24 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

/*LINTLIBRARY*/
#define _VC_LOCK_
#include <stdio.h>
#include <atfs.h>
#include "atfsapp.h"

Af_user *vc_testlock (key) Af_key *key; {
  return af_testlock (key, VC_UNUSED);
}

Af_user *vc_lock (key, uid) Af_key *key; Uid_t uid; {
  static Af_user alock;
  struct passwd *pw;
  char domainname[MAXDOMAIN+1], *domain;

  pw = getpwuid ((int)uid);
  if (pw) {
    (void)strcpy (alock.af_username, pw->pw_name);
    (void)gethostname (alock.af_userhost, MAXHOSTNAMELEN);
    (void)getdomainname (domainname, MAXDOMAIN);
    if (domainname[0] == '\0')
      domain = alock.af_userhost;
    else
      {
	if (domainname[0] == '.')
	  domain = &domainname[1];
	else
	  domain = domainname;
      }
    (void) strcpy (alock.af_userdomain, domain);
    return af_lock (key, &alock, VC_UNUSED);
  }
  else {
    return NULL;
  }
}

Af_user *vc_unlock (key) Af_key *key; {
  Af_user *waslocker;
  
  waslocker = af_unlock (key, VC_UNUSED);
  if (waslocker) {
    if (af_rstate (key) == AF_BUSY)
      af_sudattr (key, AF_REMOVE, INTENT);
  }
  return waslocker;
}

char *lockerid (lock) Af_user *lock; {
  static char rst[MAXHOSTNAMELEN+MAXUSERNAMELEN+2];

  rst[0] = '\0';
  if (lock) {
    (void)sprintf (rst, "%s%s%s%s%s", lock->af_username, 
		   lock->af_userhost ? "@" : "", 
		   lock->af_userhost, 
		   ((lock->af_userhost) && (lock->af_userdomain[0] != '.')) ?
		   "." : "", lock->af_userdomain);
  }
  return rst;
}

Uid_t lockeruid (lock) Af_user *lock; {
  char domainname[MAXDOMAIN+1], *domain;
  struct passwd *pw;

  if (!lock) return -1;

  (void)getdomainname (domainname, MAXDOMAIN);
  if (domainname[0] == '\0')
    {
      (void) gethostname (domainname, MAXHOSTNAMELEN);
      domain = domainname;
    }
  else
    {
      if (domainname[0] == '.')
	domain = &domainname[1];
      else
	domain = domainname;
    }

  if (strcmp (domain, lock->af_userdomain) == 0) {
    pw = getpwnam (lock->af_username);
    if (pw)
      return pw->pw_uid;
    else 
      return -1;
  }
  else 
    return -1;
}

int locked (lock) Af_user *lock; {
  if (!lock) return 1;
  return lock->af_username[0];
}

char *getintent (prompt, oldintent, fromstdin, curname)
     char *prompt, *oldintent, *curname;
     int fromstdin;		/* read from stdin */
{
  char *tmpname, *mktemp(), *edname, cmd[128], *getenv(), 
       tmpfnam[MAXPATHLEN+1], messg[MAXPATHLEN+80], *malloc();
  static char *notetxt;
  FILE *tmpfil;
  struct stat statbuf;
  static int firsttime = TRUE;
  extern char *get_from_stdin();

  if (fromstdin) {
    if (feof(stdin)) {	/* if eof reached and 2nd time */
      if (notetxt) return notetxt;
      else return oldintent ? oldintent : EMPTYINTENT;
    }
    else {
      if (notetxt) (void) free(notetxt);
      notetxt = get_from_stdin('.');
      return notetxt;
    }
  }

  if (!(isatty(fileno(stdin)))) 
    return oldintent ? oldintent : EMPTYINTENT;

  if ((!firsttime) && notetxt) {
    if (curname) 
      (void) sprintf (messg, "Same intent as before for %s ?", curname);
    else 
      (void) strcpy (messg, "Same intent as before ?");
    if (ask_confirm (messg, "yes")) {
      return notetxt;
    }
    else {
      free (notetxt);
    }
  }
  firsttime = FALSE;
  if (!ask_confirm (prompt, "yes"))
    return oldintent ? oldintent : EMPTYINTENT;

  (void) strcpy (tmpfnam, "/tmp/atfsXXXXXX");
  tmpname = mktemp (tmpfnam);
  Register (tmpname, TYPEF);
  if (oldintent) {
    FILE *t = fopen (tmpname, "w");
    if (fwrite (oldintent, sizeof (char), (Size_t)strlen (oldintent), t) !=
	strlen (oldintent)) {
      logerr ("write failure on tmp-file");
    }
    (void)fclose (t);
  }

  if (!(edname = getenv ("EDITOR")))
    edname = DEFAULT_EDITOR;

  (void)sprintf (cmd, "%s %s", edname, tmpname);
  (void)sprintf (messg, "starting up %s ...", edname);
  logmsg (messg);
  if (system (cmd) == NOSHELL) {
    logerr ("couldn't execute shell");
  }
  else {
    if ((tmpfil = fopen (tmpname, "r")) == NULL) {
      logerr ("empty intent description");
      return EMPTYINTENT;
    }
    else {
      if (fstat (fileno(tmpfil), &statbuf) == -1) {
	perror ("couldn't stat");
      }
      else {
	notetxt = malloc ((unsigned)(statbuf.st_size+1));
	if (!notetxt) {
	  logerr ("not enough memory for intent text.");
	}
	(void)fread (notetxt, sizeof (char), (Size_t)statbuf.st_size, tmpfil);
	(void)fclose (tmpfil);
	(void)unlink (tmpname);
	UnRegister (tmpname, TYPEF);
	notetxt[statbuf.st_size] = '\0';
	return notetxt;
      }
    }
  }
  logerr 
   ("Couldn't start editor. Please check EDITOR environment variable.");
  return EMPTYINTENT;   /* maybe we should try to read from stdin */
}
