/* LINTLIBRARY */
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * at_misc.c
 *
 * $Header: at_misc.c[1.16] Wed Feb  5 18:09:46 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: at_misc.c[1.16] Wed Feb  5 18:09:46 1992 axel@cs.tu-berlin.de accessed $";
static char *Objfile = "at_misc.c[1.16] accessed";
#ifdef CFFLGS
  static char *Cflags = CFFLGS;
#endif
#endif

#include <atfs.h>
#include "atfsapp.h"

extern char *ctime();
extern char *malloc();
extern char *re_comp();

char *at_getmode (attr)
     Af_attrs *attr;
{
  /* This function should return a capital 'L' in the file-class field */
  /* to indicate a *locked* version. Maybe optional. Instead of Ownername */
  /* the name of the locker is to be printed. */
  static char at_filemode[12];
  ushort mode;

  mode = attr->af_mode;
  (void) sprintf(at_filemode, " %c%c%c%c%c%c%c%c%c",
		 (mode & S_IREAD) ? 'r' : '-',
		 (mode & S_IWRITE) ? 'w' : '-',
		 (mode & S_IEXEC) ? 'x' : '-',
		 (mode & (S_IREAD >> 3)) ? 'r' : '-',
		 (mode & (S_IWRITE >> 3)) ? 'w' : '-',
		 (mode & (S_IEXEC >> 3)) ? 'x' : '-',
		 (mode & (S_IREAD >> 6)) ? 'r' : '-',
		 (mode & (S_IWRITE >> 6)) ? 'w' : '-',
		 (mode & (S_IEXEC >> 6)) ? 'x' : '-'
		 );

  switch (mode & S_IFMT) {
  case S_IFDIR:
    at_filemode[0] =  'd';
    break;
  case S_IFCHR:
    at_filemode[0] = 'c';
    break;
  case S_IFBLK:
    at_filemode[0] = 'b';
    break;
  case S_IFREG:
    at_filemode[0] = '-';
    break;
#ifdef S_IFLNK
  case S_IFLNK:
    at_filemode[0] = 'l';
    break;
#endif
#ifdef S_IFSOCK
  case S_IFSOCK:
    at_filemode[0] = 's';
    break;
#endif
  }
  
  if (mode & S_ISUID)
    at_filemode[3] = 's';
  if (mode & S_ISGID)
    at_filemode[6] = 's';
  if (mode & S_ISVTX)
    at_filemode[9] = 't';

  return at_filemode;
}

char *at_symbfiletype (attr)
     Af_attrs *attr;
{
  static char symb[2];
  char locksymb = '^';
  
  if (attr->af_state == AF_NOSTATE) return "$"; /* derived object */
  switch (attr->af_mode & S_IFMT) {
  case S_IFDIR:
    symb[0] = '/';
    break;
#ifdef S_IFLNK
  case S_IFLNK:
    symb[0] = '@';
    break;
#endif
#ifdef S_IFSOCK
  case S_IFSOCK:
    symb[0] = '=';
#endif
  default:
    if ((attr->af_mode & S_IEXEC) ||
	(attr->af_mode & (S_IEXEC >> 3)) ||
	(attr->af_mode & (S_IEXEC >> 6)))
      symb[0] = '*';
    else
      symb[0] = '\0';
    break;
  }

  if (attr->af_locker.af_username[0])
    if (symb[0]) {
      symb[1] = locksymb;
      symb[2] = '\0';
    }
    else {
      symb[0] = locksymb;
      symb[1] = '\0';
    }

  return symb;
}

int at_string2state (string)
     char *string;
{
  if (!strcmp(string, "busy"))
    return AF_BUSY;
  else if (!strcmp(string, "save"))
    return AF_SAVED;
  else if (!strcmp(string, "proposed"))
    return AF_PROPOSED;
  else if (!strcmp(string, "published"))
    return AF_PUBLISHED;
  else if (!strcmp(string, "accessed"))
    return AF_ACCESSED;
  else if (!strcmp(string, "frozen"))
    return AF_FROZEN;
  else return AF_NOSTATE;
}

int at_isDerived (attr)
     Af_attrs *attr;
{
  switch (attr->af_state) {
  case AF_BUSY:
  case AF_SAVED:
  case AF_PROPOSED:
  case AF_PUBLISHED:
  case AF_ACCESSED:
  case AF_FROZEN:
    return 0;
  default:
    return 1;
  }
}

char *at_getversstate (attr, verbose) Af_attrs *attr; int verbose;
{
  switch (attr->af_state) {
  case AF_BUSY:
    return verbose ? "[busy]" : "b";
  case AF_SAVED:
    return verbose ? "[save]" : "s";
  case AF_PROPOSED:
    return verbose ? "[prop]" : "p";
  case AF_PUBLISHED:
    return verbose ? "[publ]" : "P";
  case AF_ACCESSED:
    return verbose ? "[acce]" : "a";
  case AF_FROZEN:
    return verbose ? "[froz]" : "f";
  default:
    return verbose ? "[drvd]" : "$"; /* binary pool ? */
  }
}

char *at_getbndvers (attr, nopath)
     Af_attrs *attr;
     int nopath;
{
  static char boundversion[MAXPATHLEN+MAXNAMLEN+MAXTYPLEN];
  char *path, *name, *type;
  int generation, revision;
  
  if (!nopath) {
    char cwd[MAXPATHLEN], *getwd();
    int l1, l2;

    path = attr->af_syspath;
    (void) getwd (cwd);
    l1 = strlen (cwd); l2 = strlen (path);
    if (l2 > l1) {
      register int i = 0;
      while ((i < l1) && (path[i] == cwd[i])) {
	i++;
      }
      if ((i > 0) && (path[i] == '/'))
	path = path+i+1;
    }
  }
  else
    path = "";
  name = attr->af_name;
  type = attr->af_type;
  generation = attr->af_gen;
  revision = attr->af_rev;
  
  if (generation == AF_BUSYVERS && revision == AF_BUSYVERS) {
    (void) sprintf(boundversion, "%s%s%s%s%s",
		   (path[0]) ? path : "",
		   (path[0]) ? "/" : "",
		   name,
		   (type[0]) ? "." : "",
		   (type[0]) ? type : "");
  }
  else {
    (void) sprintf(boundversion, "%s%s%s%s%s[%d.%d]",
		   (path[0]) ? path : "",
		   (path[0]) ? "/" : "",
		   name,
		   (type[0]) ? "." : "",
		   (type[0]) ? type : "",
		   generation, revision);
  }

  return boundversion;
}

char *at_keygetbndvers (key, nopath)
     Af_key *key;
     int nopath;
{
  Af_attrs attr;

  if (af_gattrs(key, &attr) == -1) {
    af_perror("at_keygetbndvers");
    exit(1);
  }

  return at_getbndvers(&attr, nopath);
}

char *at_getfilename (attr)
     Af_attrs *attr;     
{
  static char at_filename[MAXNAMLEN+1];

  (void) sprintf(at_filename, "%s%s%s", attr->af_name,
		 attr->af_type[0] ? "." : "",
		 attr->af_type[0] ? attr->af_type : "" );
  
  return at_filename;
}

char *at_getasoname (attr, path)
     Af_attrs *attr;
     int path;
{
  static char at_asoname[MAXPATHLEN+MAXNAMLEN+MAXTYPLEN+1];
  
  (void) sprintf(at_asoname, "%s%s%s%s%s",
		 path && attr->af_syspath[0] ? attr->af_syspath : "",
		 path && attr->af_syspath[0] ? "/" : "",
		 attr->af_name,
		 attr->af_type[0] ? "." : "",
		 attr->af_type[0] ? attr->af_type : "");
  return at_asoname;
}

static char* getdate  (date)
     time_t *date;
{
  char *ttime;

  ttime = ctime(date);
  ttime = ttime + 4;
  ttime[20] = '\0';
  return ttime;
}

char *at_getdate (attr)
     Af_attrs *attr;
{
  time_t date;

  date = (attr->af_state == AF_BUSY ? attr->af_mtime : attr->af_stime);
  return getdate(&date);
}

char *at_getmoddate (attr)
     Af_attrs *attr;
{
  time_t date = attr->af_mtime;
  
  return getdate(&date);
}

char *at_getaccdate (attr)
     Af_attrs *attr;
{
  time_t date = attr->af_atime;
  return getdate(&date);
}

char *at_getcreatdate (attr)
     Af_attrs *attr;
{
  time_t date = attr->af_ctime;
  
  return getdate(&date);
}

char *at_getsavedate (attr)
     Af_attrs *attr;
{
  time_t date = attr->af_stime;
  
  return getdate(&date);
}

char *at_getlockdate (attr)
     Af_attrs *attr;
{
  time_t date = attr->af_ltime;
  
  return getdate(&date);
}

char *at_getuser(user) 
     Af_user *user;
{
  static char at_userandhost[21];
  char tmp[MAXUSERNAMELEN+MAXDOMAIN+2], *dptr;
  
  at_userandhost[0] = tmp[0] = '\0';
  (void) strcat(tmp, user->af_username);
  if (user->af_username && *user->af_username)
    (void) strcat(tmp, "@");
  (void) strcat(tmp, user->af_userdomain);
  (void) sprintf(at_userandhost, "%-20.20s", tmp);
  return at_userandhost;
}

void at_mkuser(user, userspec)
     Af_user *user;
     char *userspec;
{
  char *cp;
  
  if (userspec && *userspec) {
    (void) strncpy(user->af_username, userspec, MAXUSERNAMELEN);
    if (cp = rindex(user->af_username, '@')) {
      *(cp++) = '\0';
      (void) strncpy(user->af_userdomain, cp, MAXDOMAIN);
      (void) strcpy(user->af_userhost, cp);
      return;
    }

    (void) strcpy(user->af_userdomain, "");
    (void) strcpy(user->af_userhost, "");
    return;
  }

  (void) strcpy(user->af_userdomain, "");
  (void) strcpy(user->af_username, "");
  (void) strcpy(user->af_userhost, "");
}

char *at_revision (attr)
     Af_attrs *attr;
{
  static char revision[MSGLEN];

  if (attr->af_state == AF_BUSY)
    return "busy";
  else {
    (void) sprintf(revision, "%d.%d", attr->af_gen, attr->af_rev);
    return revision;
  }
}

char **at_flatten_uda (uda)
     char *uda;
{
  char *udaname, *udaval, *endval, *cp;
  int i, nlen, vlen, totlen;
  static char *flatted[AF_MAXUDAS + 1];

  /* free previously allocated memory */
  for (i = 0; i < AF_MAXUDAS; i++) {
    if (flatted[i] == (char *) NULL)
      break;
    else {
      (void) free(flatted[i]);
      flatted[i] = (char *) NULL;
    }
  }

  if ((cp = malloc((unsigned) (strlen(uda) + 1))) == (char *) NULL) {
    (void) fprintf(stderr, "Out of memory.\n");
    exit(1);
  }

  (void) strcpy(cp,uda);
  udaname = cp;

  udaval = (udaval = index(cp, AF_UDANAMDEL)) ? udaval : (char *) NULL;
  if (udaval) {
    nlen = udaval - udaname + 1;
    udaval++;
  }
  else {
    flatted[0] = cp;
    flatted[1] = (char *) NULL;
    return flatted;
  }
    
  for (i = 0; udaval; i++) {
    endval = index(udaval, '\n');
    if (endval) {
      *endval = '\0';
      endval++;
    }
    
    vlen = strlen(udaval);

    totlen = nlen + vlen + 1;
    flatted[i] = malloc((unsigned) (sizeof(char) * totlen));
    if (flatted[i] == (char *) NULL) {
      (void) fprintf(stderr, "Out of memory.\n");
      exit(1);
    }
    (void) bzero(flatted[i], totlen);
    
    (void) strncpy(flatted[i], udaname, nlen);
    (void) strncat(flatted[i], udaval, vlen);
    udaval = endval;
  }

  flatted[i] = (char *) NULL;
  (void) free(cp);
  return flatted;
}

char *at_mkedpat(pat) char *pat; {
  char pattern[2048];
  char *cp;
  int i, len;

  if ((len = strlen(pat)) == 0)
    return "";

  if (len >= 1024) {
    (void) fprintf(stderr, "at_mkedpat: pattern to long.\n");
    exit(1);
  }

  cp = pat;
  pattern[0] = '^';
  for (i = 1; *cp; cp++) {
    switch (*cp) {
    case '[':
    case ']':
    case '.':
      pattern[i++] = '\\'; pattern[i++] = *cp;
      break;
    case '?':
      pattern[i++] = '.';
      break;
    case '*':
      pattern[i++] = '.'; pattern[i++] = '*';
      break;
    case '=':
      if (i == len) {
	pattern[i++] = '='; pattern[i++] = '.'; pattern[i++] = '*';
	break;
      } /* fall through */
    default:
      pattern[i++] = *cp;
      break;
    }
  }
  pattern[i++] = '$'; pattern[i] = '\0';
  
  if ((cp = malloc ((unsigned) (strlen(pattern) + 1))) == (char *) NULL) {
    (void) fprintf(stderr, "Out of memory.\n");
    exit(1);
  }
  
  return strcpy(cp, pattern);
}


int at_matchuda (attrbuf, uda)
     Af_attrs *attrbuf;
     char *uda;
{
  /* Returns 1 if attrbuf has an uda uda, otherwise 0. */

  char *cp, *pattern = at_mkedpat(uda);
  char **flatted;
  int i, j;

  if (cp = re_comp(pattern)) {
    (void) fprintf(stderr, "%s\n", cp);
    exit(1);
  }

  for (j = 0; attrbuf->af_udattrs[j]; j++) {
    flatted = at_flatten_uda(attrbuf->af_udattrs[j]);
    for (i = 0; flatted[i]; i++) {
      if (re_exec(flatted[i])) {
	free(pattern);
	return 1;
      }
    }
  }
  free(pattern);
  return 0;
}

int at_matchregex (regexs, nregexs, attrs)
     char *regexs[];
     int nregexs;
     Af_attrs *attrs;
{
  int i, j, k, matched;
  char *cp;
  char **flatted;
  
  for (i = 0; i < nregexs; i++) {

    if (cp = re_comp(regexs[i])) {
      (void) fprintf(stderr, "%s\n", cp);
      exit(1);
    }

    for (matched = 1, j = 0; matched && attrs->af_udattrs[j] != NULL; ++j) {

      flatted = at_flatten_uda(attrs->af_udattrs[j]);
      
      matched = 0;

      for (k = 0; flatted[k]; k++)
	if (re_exec(flatted[k])) {
	  matched = 1;
	  break;
	}
    }

    if (! matched )
      return 0;
  }

  return 1;
}
