/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS-test -- type definitions for archive repair tool
 *
 *	Author:	Andreas Lampen (andy@coma.UUCP
 *				andy@db0tui62.BITNET)
 *
 *	$Header: atfsrepair.h[1.6] Tue Feb  4 17:49:52 1992 andy@cs.tu-berlin.de accessed $
 */

/*** levels ***/
#define SILENT  0
#define NOASK   1
#define NORMAL  2
#define EDIT	3

#define MAXREVS 256
#define MAXUDAS 256

typedef struct {
  char    *string;
  int     curPos;
  int     length;
} Input;

typedef struct {
  off_t   datasize;
  int     noOfRevisions;
  char    *host;
  char    *syspath;
  char    *name;
  char    *type;
  char    *ownerName;
  char    *ownerHost;
  char    *ownerDomain;
} ConstAttrs;

typedef struct {
  int     generation;
  int     revision;
  int     state;
  u_short mode;
  char    *authorName;
  char    *authorHost;
  char    *authorDomain;
  char    *lockerName;
  char    *lockerHost;
  char    *lockerDomain;
  time_t  lockTime;
  time_t  modTime;
  time_t  accessTime;
  time_t  statChangeTime;
  time_t  saveTime;
  int     representation;
  off_t   fileSize;
  off_t   deltaSize;
  int     succGen;
  int     succRev;
  int     predGen;
  int     predRev;
} Revision;

typedef struct {
  int     generation;
  int     revision;
  int     size;
  char    *uda[MAXUDAS];
} Udas;

typedef struct {
  int     generation;
  int     revision;
  off_t   size;
  char    *contents;
} Note;

typedef struct {
  int     generation;
  int     revision;
  int     representation;
  off_t   size;
  char    *contents;
} Data;


