/*
 *       Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

 *
 *	Shape/AtFS
 *
 *	atfs.h - Type and Constant-Definitions for the 
 *		 Attribute-Filesystem
 *
 *	Author:	Andreas Lampen (andy@coma.UUCP
 *				andy@db0tui62.BITNET)
 *
 *	$Header: atfs.h[1.12] Fri Apr  3 19:59:20 1992 andy@cs.tu-berlin.de accessed $
 */

#ifndef _ATFSHDR_
#define _ATFSHDR_

/*=========================================================================
 * Installation dependent constants 
 *=========================================================================*/

#include <stdio.h>
#include "config.h"

#define MAXUSERNAMELEN 64

/*=========================================================================
 * External Type Definitions
 *=========================================================================*/

#include "afsys.h"

/**** filekey ****/
typedef struct {
		Af_revlist *af_ldes;		/* ptr to revlist descriptor */
		int        af_lpos;             /* position in revlist */
	       } Af_key;

/**** Set descriptor ****/
typedef struct {
		int	af_nkeys;
		int	af_setlen;
		Af_key	*af_klist;
	       } Af_set;

/**** User Identification ****/
typedef struct {
                char	af_username[MAXUSERNAMELEN];
		char	af_userhost[MAXHOSTNAMELEN];
		char	af_userdomain[MAXDOMAIN];
	       } Af_user;

/**** Attribute buffer ****/

#define AF_MAXUDAS 255

typedef struct {
		char	af_host[MAXHOSTNAMELEN]; /* hostname */
		char	af_syspath[MAXPATHLEN+1]; /* system path */
		char	af_name[MAXNAMLEN+1];	/* filename */
		char	af_type[MAXTYPLEN];	/* filename extension (type) */
		int	af_gen;			/* generation number */
		int	af_rev;			/* revision number */
		int	af_state;		/* version state (see below) */
		Af_user af_owner;		/* owner */
		Af_user af_author;		/* author */
		off_t   af_size;                /* size of file */
		u_short af_mode;		/* protection (from inode) */
		Af_user af_locker;              /* locker */
		time_t	af_mtime;		/* date of last modification */
		time_t	af_atime;		/* date of last access */
		time_t	af_ctime;		/* date of last status change*/
		time_t	af_stime;		/* save date */
		time_t  af_ltime;               /* date of last lock change */
		char	*af_udattrs[AF_MAXUDAS+1]; /* user def. attributes */
	       } Af_attrs;

/*=========================================================================
 * Constant Definitions
 *=========================================================================*/

/**** Version states ****/

#define AF_NOSTATE     -1
#define	AF_BUSY		0
#define AF_SAVED	1
#define AF_PROPOSED	2
#define AF_PUBLISHED	3
#define AF_ACCESSED	4
#define AF_FROZEN	5

/**** Settings for Attrbuf ****/

#define AF_NONAME       "\0"
#define AF_NOTYPE       "\0"
#define AF_NOVNUM	-1
#define AF_NOSIZE	-1
#define AF_NOMODE	0
#define AF_NOUSER	{ "\01$\0", "\0", "\0" }
#define AF_NOTIME       -1

/**** Modes ****/

#define AF_ADD          1   /* user-defined attributes */
#define AF_REMOVE       2   /* " */
#define AF_REPLACE      3   /* " */

#define AF_BUSYVERS     -2   /* version identification */
#define AF_FIRSTVERS    -3   /* " */
#define AF_LASTVERS     -4   /* " */

#define AF_LOGICAL_SUCC  1   /* logical successor */
#define AF_LOGICAL_PRED  2   /* logical predecessor */
#define AF_PHYSICAL_SUCC 3   /* physical successor */
#define AF_PHYSICAL_PRED 4   /* physical predecessor */

#define AF_LASTPOS      -4   /* set position */

/**** Object classes ****/

#define AF_SOURCE       00
#define AF_DERIVED      01
#define AF_VALID        02

/*=========================================================================
 * Attribute names
 *=========================================================================*/

#define AF_UDANAMLEN    128       /* maximum length of uda name */
#define AF_ATTNUM       19        /* number of attrributes in attrbuf */

#define AF_ATTHOST	"af_host"
#define AF_ATTSPATH	"af_syspath"
#define AF_ATTNAME      "af_name"
#define AF_ATTTYPE      "af_type"
#define AF_ATTUNIXNAME  "af_unixname" /* not for sorting */
#define AF_ATTGEN	"af_gen"
#define AF_ATTREV	"af_rev"
#define AF_ATTVERSION	"af_version" /* compound attribute: gen.rev */
#define AF_ATTHUMAN     "af_human"   /* compound name, type, gen, rev */
#define AF_ATTSTATE	"af_state"
#define AF_ATTOWNER	"af_owner"
#define AF_ATTAUTHOR	"af_author"
#define AF_ATTDSIZE     "af_dsize"   /* not for sorting */
#define AF_ATTSIZE      "af_size"
#define AF_ATTMODE      "af_mode"
#define AF_ATTLOCKER    "af_locker"
#define AF_ATTMTIME	"af_mtime"
#define AF_ATTATIME	"af_atime"
#define AF_ATTCTIME	"af_ctime"
#define AF_ATTSTIME	"af_stime"
#define AF_ATTLTIME	"af_ltime"



/*=========================================================================
 * Errorcodes
 *=========================================================================*/

/* General */
#define AF_OK		 0

#define AF_ESYSERR	 -2	/* Error during execution of Syslib-command */
#define AF_EACCES        -3     /* permission denied */
#define AF_EARCHANGED    -4     /* archive has changed since last read */
#define AF_EARLOCKED     -5     /* archive is locked for writing */
#define AF_EBPFULL       -6     /* no additional place in binary pool */
#define AF_EBUSY         -7     /* spec. revision must not be a busy version */
#define AF_EDERIVED      -8     /* spec. revision is a derived object */
#define AF_EINVKEY 	 -9	/* invalid key */
#define AF_EINVSET	-10 	/* invalid set */
#define AF_EINVUSER     -11     /* invalid user */
#define AF_EINVVNUM     -12     /* bad version number */
#define AF_ELOC		-13	/* invalid location of archive */
#define AF_EMEMORY      -14     /* application exceeds memory limit */
#define AF_EMISC        -15     /* miscellaneous errors */
#define AF_EMODE        -16     /* invalid mode */
#define AF_ENOATFSDIR   -17     /* no AtFS subdirectory */
#define AF_ENOKEY       -18     /* key does not exist in set */
#define AF_ENOPOS       -19     /* invalid position in set */
#define AF_ENOREV       -20     /* specified revision does not exist */
#define AF_ENOTBUSY     -21     /* specified object is no busy version */
#define AF_ENOTDERIVED  -22     /* specified object is no derived object */
#define AF_ENOTLOCKED   -23     /* version is not locked or - by another user*/
#define AF_ENOTREGULAR  -24     /* specified object is no regular file */
#define AF_ENOTVERS     -25     /* specified object has no versions */
#define AF_ENOUDA       -26     /* user defined attribute does not exist */
#define AF_ESAVED       -27     /* saved versions cannot be modified */
#define AF_ESTATE	-28	/* invalid state transition */
#define AF_ETOOLONG     -29     /* string too long */
#define AF_EUDASNUM     -30     /* too many user defined attributes */
#define AF_EWRONGSTATE  -31     /* wrong state */

/* codes for really serious errors */
#define AF_EDELTA       -32     /* error during delta operation */
#define AF_EINCONSIST	-33	/* Archive file inconsistent */
#define AF_EINTERNAL	-34	/* internal error */
#define AF_ENOATFSFILE  -35     /* no AtFS file */

/* System V specific Errors */
#define AF_ENAMETOOLONG -36     /* cannot build archive file name */

/*=========================================================================
 * Declarations (ordered alphabetically)
 *=========================================================================*/

char	*af_afname();
char	*af_afpath();
char	*af_aftype();
Af_user *af_afuser();
Af_user	*af_lock();
FILE	*af_open();
void	af_perror();
Af_user	*af_rauthor();
char	*af_rname();
char	*af_rnote();
Af_user	*af_rowner();
char	*af_rsyspath();
char	*af_rtype();
char	*af_rudattr();
char	*af_setarchpath();
Af_user	*af_testlock();
Af_user	*af_unlock();

#endif /* __ATFSHDR__ */

