/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	afstates.c - operations on version states
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP
 *					   andy@db0tui62.BITNET)
 *
 *	$Header: afstates.c[1.8] Fri Jan 31 18:06:24 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *	af_rstate -- return version state
 *	af_sstate -- set revision state
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"

/*====================================================================
 *    af_rstate -- return version state
 *
 *====================================================================*/

EXPORT af_rstate (key)
     Af_key *key;
{
  if (afAccessAso (key, AF_ATTRS))
    SFAIL ("rstate", "", AF_EINVKEY, ERROR);

  if (VATTR(key).af_class & AF_DERIVED)
    SFAIL ("rstate", "", AF_EDERIVED, ERROR);

  return ((int) VATTR(key).af_state);
}

/*====================================================================
 *    af_sstate -- set version state
 *
 *====================================================================*/

EXPORT af_sstate (key, state)
     Af_key 	*key;
     int        state;
{
  if (afAccessAso (key, AF_ATTRS))
    SFAIL ("sstate", "", AF_EINVKEY, ERROR);
  if (VATTR(key).af_class & AF_DERIVED)
    SFAIL ("sstate", "", AF_EDERIVED, ERROR);

  if (af_checkperm (key, AF_OWNER | AF_AUTHOR | AF_LOCKHOLDER) == ERROR)
    return (ERROR);

  if ((state < AF_SAVED) || (state > AF_FROZEN))
    SFAIL ("sstate", "", AF_ESTATE, ERROR);

  VATTR(key).af_state = state;

  /* save changes */
  if (afUpdateAso (key, AF_CHANGE) == ERROR)
    return (ERROR);
  return (AF_OK);
} /* af_sstate */
