/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	afreadname.c -- read filename from archive
 *                      Only for System V
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: afreadname.c[1.5] Fri Jan 31 18:05:48 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *      afReadName -- read object name from archive
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"
#include "afarchive.h"

/*==========================================================================
 *	firstitem, nextitem -- isolate items in input line
 *==========================================================================*/

LOCAL char *xfirstitem (line)
     char *line;
{
  register char *sptr;

  /* skip leading blank */
  if ((sptr = index (&line[1], ' ')) == (char *)0)
    sptr = index (&line[1], '\n');

  *sptr = '\0';
  return (&line[1]);
}

LOCAL char *xnextitem (line)
     char *line;
{
  register char *sptr, *finptr;

  sptr = &line[strlen(line)]+1; /* move to next entry */
  if ((finptr = index (sptr, ' ')) == (char *)0)
    finptr = index (sptr, '\n');
  *finptr = '\0';

  return (sptr);
}
  
EXPORT char *afReadName (archname)
     char *archname;
{
  register FILE *archfile;
  register char *itemptr;
  char          newarname[MAXPATHLEN+1], line[AF_LINESIZ];
  static char   name[MAXNAMLEN+1];

  archname[strlen (archname)-1] = AF_ARCHEXT;
  if ((archfile = fopen (archname, "r")) == (FILE *)0)
    {
      (void) strcpy (newarname, af_ardir (af_uniqpath (".")));
      (void) strcat (newarname, "/");
      (void) strcat (newarname, archname);
      if ((archfile = fopen (newarname, "r")) == (FILE *)0)
	{
	  (void) strcpy (name, archname + strlen (AF_ATFSFILEID));
	  name[strlen(name)-1] = '\0';
	  return (name);
	}
    }

  (void) fgets (line, AF_LINESIZ, archfile);
  (void) fgets (line, AF_LINESIZ, archfile);

  itemptr = xfirstitem (line); /* ID string */
  itemptr = xnextitem (itemptr); /* host */
  itemptr = xnextitem (itemptr); /* path */
  itemptr = xnextitem (itemptr); /* name */
  (void) strcpy (name, itemptr);
  itemptr = xnextitem (itemptr); /* type */
  if (strcmp (itemptr, AF_NOSTRING))
    {
      (void) strcat (name, ".");
      (void) strcat (name, itemptr);
    }

  (void) fclose (archfile);
  return (name);
}
