/****************************************************************
 *	Copyright 1986, Gene H. Olson, Quest Research, Burnsville   *
 *	Minnesota.   Permission to copy and distribute this         *
 *	program, all associated code in source and binary form,     *
 *	for any purpose, so long as this notice is preserved.       *
 ****************************************************************/


/**************************************************************
 *          Procedures to read and decode dialinfo            *
 *                   dialer entries.                          *
 **************************************************************/

#include <stdio.h>
#include <ctype.h>

#include "readinfo.h"
#include "dialinfo.h"

#define loop for (;;)

extern void free() ;
extern char *malloc() ;
extern char *strcpy() ;
extern char *getenv() ;


/******
 *	stralloc - Allocate string.
 */

static char *
stralloc(str)
char *str ;							/* String to copy */
{
	register char *p ;

	p = malloc((unsigned) (strlen(str)+1)) ;
	if (p != 0) (void) strcpy(p, str) ;
	return(p) ;
	}



/*****
 *	parseshort - Parse out short.
 *
 *	Returns: advanced ptr=okay, 0=error.
 */

char *
parseshort(cp, num, low, high)
register char *cp ;					/* Start character */
short *num ;						/* Short to fetch */
short low ;							/* Lowest legal value */
short high ;						/* Highest legal value */
{
	register short n ;

	if (!isdigit(*cp)) return(0) ;

	n = 0 ;

	do {
		n = 10 * n + *cp++ - '0' ;
		} while (isdigit(*cp)) ;

	if (n < low || n > high) return(0) ;

	*num = n ;
	return(cp) ;
	}



/*******
 *	buildinfo - Build information entry for key=text string.
 *
 *	Returns: 0=info built, -1=error.
 */

static int
buildinfo(dinfo,key,text)
char *dinfo ;						/* Dialer info structure */
char *key ;							/* Keyword name */
char *text ;						/* Associated text */
{
	register DINFO *di ;
	register char *cp ;
	register char **cpp ;
	short state ;

	di = (DINFO *) dinfo ;

	/*
	 *	Build phone number character replacement strings.
	 */

	if (strcmp(key,"star") == 0) {
		if (di->di_star == 0) di->di_star = stralloc(text) ;
		}

	else if (strcmp(key,"pound") == 0) {
		if (di->di_pound == 0) di->di_pound = stralloc(text) ;
		}

	else if (strcmp(key,"delay") == 0) {
		if (di->di_delay == 0) di->di_delay = stralloc(text) ;
		}

	else if (strcmp(key, "wait") == 0) {
		if (di->di_wait == 0) di->di_wait = stralloc(text) ;
		}

	else if (strcmp(key,"flash") == 0) {
		if (di->di_flash == 0) di->di_flash = stralloc(text) ;
		}

	/*
	 *	Build "retry" count.
	 */

	else if (strcmp(key, "retry") == 0) {
		if (di->di_retry < 0) {
			cp = parseshort(text, &di->di_retry, 0, 1000) ;
			if (cp == 0 || *cp != 0) return(-1) ;
			}
		}

	/*
	 *	Build dial defintions.
	 */

	else if
		(	key[0] == 's'
		&&	(cp = parseshort(key+1, &state, 0, NSTATE-1))
		&&	*cp == 0
		)
	{
		cpp = &di->di_state[state] ;
		if (*cpp == 0) *cpp = stralloc(text) ;
		}

	else return(-1) ;

	return(0) ;
	}



/******
 *	dialinfo - Get dial information for entry "dialer".
 */

int
dialinfo(dinfo, dialer)
DINFO *dinfo ;						/* Retrieved dialer info */
char *dialer ;						/* Dialer name */
{
	register int i ;
	register char *fname ;

	/*
	 *	Initialize dialinfo entry.
	 */

	dinfo->di_star = 0 ;
	dinfo->di_pound = 0 ;
	dinfo->di_delay = 0 ;
	dinfo->di_wait = 0 ;
	dinfo->di_flash = 0 ;
	dinfo->di_retry = -1 ;
	for (i = 0 ; i < NSTATE ; i++) dinfo->di_state[i] = 0 ;

	/*
	 *	Get dialinfo file name from environment if specified.
	 */

	fname = getenv("DIALINFO") ;
	if (fname == 0 || *fname == 0) fname = "/usr/lib/uucp/dialinfo" ;

	/*
	 *	Read the file and return status.
	 */

	return( readinfo(fname, dialer, buildinfo, (char *)dinfo) ) ;
	}


/******
 *	dialfree - Free storage associated with dialinfo entry.
 */

void
dialfree(di)
register DINFO *di ;			/* Dialinfo entry */
{
	register int i ;
	register char **spp ;

	if (di->di_delay) free(di->di_delay) ;
	if (di->di_wait) free(di->di_wait) ;
	if (di->di_star) free(di->di_star) ;
	if (di->di_pound) free(di->di_pound) ;
	if (di->di_flash) free(di->di_flash) ;

	i = 0 ;
	spp = &di->di_state[0] ;

	while (i < NSTATE) {
		if (*spp) free(*spp) ;
		i++ ;
		spp++ ;
		}
	}
