#==============================================================================
# Site specific configuration (OS/2)
#==============================================================================
## [BEGIN]
#
# option switches
# (do not remove the lines starting with "##" !!!)
#
# language: select the language you prefer
##-LANG_GERMAN=Y
#
# BCPP: select this if your compiler don't know the '_System' and '_Optink'
#       directive
##-BCPP=Y
#
# debug mode: select this to enable debugging of the software
##-DEBUG_MODE=Y
#
# dynamic linking: if enabled, linking is dynamic to C compiler
##-DYNAMIC_LINKING=Y
#
# Top of Minerva install tree
##+INSTPATH=/public/mSQL
INSTPATH=/public/mSQL
#
# TCP/IP port number for client-server communication
##+TCPIP_PORT=4333
TCPIP_PORT=4333
#
## [END]

#==============================================================================
# check here if you have a compiler mentioned
#==============================================================================
#
# ENVironment
#   ... OS/2 with IBM C/C++ Set/2 or Visual Age C++ or something else
#   ... OS/2 with Borland C++ compiler, not knowing '_System' and '_Optlink'
!ifndef BCPP
ENV      = /DOS2
!else
ENV      = /DOS2 /DBCPP
!endif

#==============================================================================
# do not change anything below, except you know what you are doing
#==============================================================================
#
# compiler, linker, library tools ...
#
CC       = icc
CPP      = $(CC)
LINK     = $(CC)
LLINK    = link386 /noi /nol /pm:VIO /se:1024 /st:32768
MAKE     = nmake
RANLIB   = lib /nologo /noignorecase /noextdictionary
DLLLIB   = implib /nologo /noignorecase

# compiler-compiler
YACC     = bison
YFLAGS   = -d -o

#
# Specify the language you want for error messages
#
!ifdef LANG_GERMAN
LANG     = GERMAN
!else
LANG     = ENGLISH
!endif

#
# special definitions
#
SIGLIST  =
DIRENT   = /idirect.h
MMAP     =
U_INT    =
ROOT_EXEC=
ROOT     = mSQL

#
# specials for makedep
#
INST_DIR      = $(INSTPATH)
INCLUDEDIR    = ..\\..\\include
OBJSUFFIX     = .obj

# Directory for pid file
PID_DIR  = tmp

# Extra libraries if required
EXTRA_LIB=

# Any other CFlags required
# EXTRA_CFLAGS= $(ENV) /D$(LANG) /DMSQL_PORT=$(TCPIP_PORT)\
#  /DMSQL_UNIX_ADDR="\"$(INST_DIR)\\tmp\\mSQL.sok\""
EXTRA_CFLAGS= $(ENV) /D$(LANG) /DMSQL_PORT=$(TCPIP_PORT)

# dynamic / static linking, default libraries
!ifdef DYNAMIC_LINKING
LINKING  = /DDYNAMIC_LINKED /Gd
!else
LINKING  = /DSTATIC_LINKED
!endif

# default libraries (static, dynamic)
TCPIP_LIBS = so32dll.lib tcp32dll.lib
LDLIBS   = ..\..\lib\mSQL.lib $(TCPIP_LIBS)
DLL_LIBS = ..\..\lib\mSQL_dll.lib

# debug mode on / off
!ifdef DEBUG_MODE
DEBUG    = /Ti+
!else
DEBUG    =
!endif

# flags for compiling, DLL and EXE linking
CFLAGS = /C $(LINKING) /G4 /Gf /Gi /Gm /Q /Se /Ss+ $(DEBUG)\
 /I.. $(EXTRA_CFLAGS)
DFLAGS = /C $(LINKING) /G4 /Ge- /Gf /Gi /Gm /Q /Se /Ss+ $(DEBUG)\
 /I.. $(EXTRA_CFLAGS)
LFLAGS = $(LINKING) /G4 /Ge+ /Gf /Gi /Gm $(DEBUG) /Fe

#
# EXPRIMENTAL - Don't play with this stuff
#
NEW_DB=
NEW_DB_INC=
NEW_DB_LIB=

#==============================================================================
# end of file
#==============================================================================
