/*===========================================================================*/
/* sqlcli_.h                                                                 */
/*---------------------------------------------------------------------------*/
/* SQL Call Level Interface (CLI)                                            */
/*                                                                           */
/* (c) 1996 by Dirk Ohme - all right reserved                                */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* frame                                                                     */
/*---------------------------------------------------------------------------*/
#ifndef __H_SQLCLI_
#define __H_SQLCLI_

/*---------------------------------------------------------------------------*/
/* system dependent data types                                               */
/*---------------------------------------------------------------------------*/
/* ... for OS/2 (BCPP = Borland C++)                                         */
/*---------------------------------------------------------------------------*/
#ifdef OS2
#  ifdef BCPP
#    define _Optlink
#    define _System                    _syscall
#  endif
#  define INCL_PM
#  define INCL_WINDIALOGS
#  include <os2.h>
#  define PASCAL                       _Pascal
#  define SQL_API                      APIENTRY
#  ifdef IBMC
#    define SQL_LOCAL_API              _Optlink
#  else
#    define SQL_LOCAL_API
#  endif

/*---------------------------------------------------------------------------*/
/* ... unknown systems                                                       */
/*---------------------------------------------------------------------------*/
#else
#  ifndef BOOL
#    define BOOL                       int
#  endif
#  ifndef CHAR
#    define CHAR                       char
#  endif
#  ifndef FALSE
#    define FALSE                      0
#  endif
#  ifndef HWND
#    define HWND                       int
#  endif
#  ifndef LONG
#    define LONG                       long
#  endif
#  ifndef PASCAL
#    define PASCAL
#  endif
#  ifndef SHORT
#    define SHORT                      short
#  endif
#  ifndef SQL_API
#    define SQL_API
#  endif
#  ifndef TRUE
#    define TRUE                       1
#  endif
typedef unsigned char                  UCHAR;
typedef unsigned int                   UINT;
typedef unsigned long                  ULONG;
typedef unsigned short                 USHORT;
#endif

/*---------------------------------------------------------------------------*/
/* ... common                                                                */
/*---------------------------------------------------------------------------*/
#ifndef FAR
#  define                              FAR
#endif

#ifndef HANDLE
  typedef int                          HANDLE;
#endif

#ifndef MAX
# define MAX(x,y)                      ((x > y) ? x : y)
#endif

#ifndef MIN
# define MIN(x,y)                      ((x < y) ? x : y)
#endif

#ifndef NEAR
#  define NEAR
#endif

#ifndef RETCODE
#  define RETCODE                      long
#endif

/*---------------------------------------------------------------------------*/
/* ... for non-Windows systems                                               */
/*---------------------------------------------------------------------------*/
#ifndef WIN
typedef long                           DWORD;
typedef void *                         PTR;
typedef signed long                    SDWORD;
typedef signed short                   SWORD;
typedef unsigned long                  UDWORD;
typedef unsigned short                 UWORD;
typedef short                          WORD;
#endif

/*---------------------------------------------------------------------------*/
/* ... mSQL                                                                  */
/*---------------------------------------------------------------------------*/
#include <msql.h>

/*---------------------------------------------------------------------------*/
/* SQL data types                                                            */
/*---------------------------------------------------------------------------*/
/* ... definitions about data structures (length)                            */
/*---------------------------------------------------------------------------*/
#define SQL_DATE_LEN                    10
#define SQL_MAX_ID_LENGTH               18
#define SQL_MAX_MESSAGE_LENGTH         255
#define SQL_SQLSTATE_SIZE                8
#define SQL_TIME_LEN                     8
#define SQL_TIMESTAMP_LEN               19

/*---------------------------------------------------------------------------*/
/* ... simple data types                                                     */
/*---------------------------------------------------------------------------*/
#define SQLPOINTER                     PTR
#define SQLRETURN                      RETCODE SQL_API
#define SQLUINTEGER                    UINT
#define SQLUSMALLINT                   USHORT

typedef unsigned char                  SQLCHAR;
typedef long                           SQLINTEGER;
typedef short                          SQLSMALLINT;
typedef double                         SQLDOUBLE;
typedef float                          SQLREAL;
typedef unsigned char                  SQLDECIMAL;
typedef unsigned char                  SQLNUMERIC;

/*---------------------------------------------------------------------------*/
/* ... extended data types                                                   */
/*---------------------------------------------------------------------------*/
typedef unsigned char                  SQLBINARY;
typedef BOOL                           SQLBIT;
typedef long                           SQLBLOBLOCATOR;
typedef long                           SQLCLOBLOCATOR;
typedef unsigned char                  SQLDBCHAR;
typedef long                           SQLDBCLOBLOCATOR;
typedef signed char                    SQLSCHAR;

#define SQLSHORT                       SQLTINYINT
#define SQLTINYINT                     SQLSCHAR

/*---------------------------------------------------------------------------*/
/* ... environment information for "SQLAllocEnv"                             */
/*---------------------------------------------------------------------------*/
typedef struct     tagENV                        /*--------------------------*/
  { UCHAR     szSqlState[SQL_SQLSTATE_SIZE];     /* status code              */
    UCHAR    *pszSqlMsg;                         /* status message           */
    UINT      ciConnections;                     /* number of DBC blocks     */
  } ENV, *HENV, *LPENV;                          /*--------------------------*/
typedef HENV                           SQLHENV;

/*---------------------------------------------------------------------------*/
/* ... environment information for "SQLAllocConnect"                         */
/*---------------------------------------------------------------------------*/
typedef struct     tagDBC                        /*--------------------------*/
  { BOOL      fConnect;                          /* TRUE on open connection  */
    int       ciActive;                          /* counter for open trans.  */
    UCHAR    *szSqlState;                        /* status code              */
    UCHAR    *pszSqlMsg;                         /* status message           */
    LPENV     pSqlEnv;                           /* pointer to ENV structure */
    int       hDbSocket;                         /* communication socket     */
    char      szMsqlErrorMsg[256];               /* mSQL error message       */
  } DBC, *HDBC, *LPDBC;                          /*--------------------------*/
typedef HDBC                           SQLHDBC;

/*---------------------------------------------------------------------------*/
/* ... environment information for "SQLAllocStmt"                            */
/*---------------------------------------------------------------------------*/
typedef struct     tagSTMT                       /*--------------------------*/
  { char     *pszQuery;                          /* query string             */
    LPDBC     pSqlDbc;                           /* pointer to DB context    */
    UCHAR    *szSqlState;                        /* status code              */
    UCHAR    *pszSqlMsg;                         /* status message           */
    char     *szMsqlErrorMsg;                    /* mSQL error message       */
    m_result *pMsqlResult;                       /* mSQL results handle      */
  } STMT, *HSTMT, *LPSTMT;                       /*--------------------------*/
typedef HSTMT                          SQLHSTMT;

/*---------------------------------------------------------------------------*/
/* ... environment information for "???"                                     */
/*---------------------------------------------------------------------------*/
typedef struct     tagDESC                       /*--------------------------*/
  { short     DummyEntry;                        /* <unused>                 */
  } DESC, *HDESC, *LPDESC;                       /*--------------------------*/
typedef HDESC                          SQLHDESC;

/*---------------------------------------------------------------------------*/
/* ... data structure for SQL_DATE                                           */
/*---------------------------------------------------------------------------*/
typedef struct tagDATE_STRUCT
  {
    SQLSMALLINT         year;
    SQLUSMALLINT        month;
    SQLUSMALLINT        day;
  }                                    DATE_STRUCT,
                                       SQLDATE;

/*---------------------------------------------------------------------------*/
/* ... data structure for SQL_TIME                                           */
/*---------------------------------------------------------------------------*/
typedef struct tagTIME_STRUCT
  {
    SQLUSMALLINT        hour;
    SQLUSMALLINT        minute;
    SQLUSMALLINT        second;
  }                                    TIME_STRUCT,
                                       SQLTIME;

/*---------------------------------------------------------------------------*/
/* ... data structure for SQL_TIMESTAMP                                      */
/*---------------------------------------------------------------------------*/
typedef struct tagTIMESTAMP_STRUCT
  {
    SQLSMALLINT         year;
    SQLUSMALLINT        month;
    SQLUSMALLINT        day;
    SQLUSMALLINT        hour;
    SQLUSMALLINT        minute;
    SQLUSMALLINT        second;
    SQLINTEGER          fraction;
  }                                    TIMESTAMP_STRUCT,
                                       SQLTIMESTAMP;

/*---------------------------------------------------------------------------*/
/* common definitions                                                        */
/*---------------------------------------------------------------------------*/
/* ... about NULL pointers                                                   */
/*---------------------------------------------------------------------------*/
#define SQL_NULL_HENV                  NULL
#define SQL_NULL_HDBC                  NULL
#define SQL_NULL_HSTMT                 NULL
#define SQL_NULL_HDESC                 NULL
#define SQL_NULL_HANDLE                NULL

/*---------------------------------------------------------------------------*/
/* ... about NULL values                                                     */
/*---------------------------------------------------------------------------*/
#define SQL_NULL_DATA                     -1
#define SQL_NTS                           -3
#define SQL_NTSL                          -3L
#define SQL_NO_NULLS                       0
#define SQL_NULLABLE                       1


/*---------------------------------------------------------------------------*/
/* ... about handle identifiers                                              */
/*---------------------------------------------------------------------------*/
#define SQL_HANDLE_ENV                     1
#define SQL_HANDLE_DBC                     2
#define SQL_HANDLE_STMT                    3
#define SQL_HANDLE_DESC                    4

/*---------------------------------------------------------------------------*/
/* ... about attributes                                                      */
/*---------------------------------------------------------------------------*/
#define SQL_ATTR_OUTPUT_NTS            10001
#define SQL_ATTR_AUTO_IPD              10001
#define SQL_ATTR_APP_ROW_DESC          10010
#define SQL_ATTR_APP_PARAM_DESC        10011
#define SQL_ATTR_IMP_ROW_DESC          10012
#define SQL_ATTR_IMP_PARAM_DESC        10013

/*---------------------------------------------------------------------------*/
/* ... about descriptors                                                     */
/*---------------------------------------------------------------------------*/
#define SQL_DESC_COUNT                     1
#define SQL_DESC_TYPE                      2
#define SQL_DESC_LENGTH                    3
#define SQL_DESC_LENGTH_PTR                4
#define SQL_DESC_PRECISION                 5
#define SQL_DESC_SCALE                     6
#define SQL_DESC_DATETIME_INTERVAL_CODE    7
#define SQL_DESC_NULLABLE                  8
#define SQL_DESC_INDICATOR_PTR             9
#define SQL_DESC_DATA_PTR                 10
#define SQL_DESC_NAME                     11
#define SQL_DESC_UNNAMED                  12
#define SQL_DESC_ALLOC_TYPE               99

/*---------------------------------------------------------------------------*/
/* ... about the diagnostic area                                             */
/*---------------------------------------------------------------------------*/
#define SQL_DIAG_RETURNCODE                1
#define SQL_DIAG_NUMBER                    2
#define SQL_DIAG_ROW_COUNT                 3
#define SQL_DIAG_SQLSTATE                  4
#define SQL_DIAG_NATIVE                    5
#define SQL_DIAG_MESSAGE_TEXT              6
#define SQL_DIAG_DYNAMIC_FUNCTION          7
#define SQL_DIAG_CLASS_ORIGIN              8
#define SQL_DIAG_SUBCLASS_ORIGIN           9
#define SQL_DIAG_CONNECTION_NAME          10
#define SQL_DIAG_SERVER_NAME              11
#define SQL_DIAG_DYNAMIC_FUNCTION_CODE    12

/*---------------------------------------------------------------------------*/
/* ... about dynamic function codes                                          */
/*---------------------------------------------------------------------------*/
#define SQL_ALTER_DOMAIN                   3
#define SQL_ALTER_TABLE                    4
#define SQL_CREATE_ASSERTION               6
#define SQL_CREATE_CHARACTER_SET           8
#define SQL_CREATE_COLLATION              10
#define SQL_CREATE_DOMAIN                 23
#define SQL_CREATE_SCHEMA                 64
#define SQL_CREATE_TABLE                  77
#define SQL_CREATE_TRANSLATION            79
#define SQL_CREATE_VIEW                   84
#define SQL_DELETE_WHERE                  19
#define SQL_DROP_ASSERTION                24
#define SQL_DROP_CHARACTER_SET            25
#define SQL_DROP_COLLATION                26
#define SQL_DROP_DOMAIN                   27
#define SQL_DROP_SCHEMA                   31
#define SQL_DROP_TABLE                    32
#define SQL_DROP_TRANSLATION              33
#define SQL_DROP_VIEW                     36
#define SQL_DYNAMIC_DELETE_CURSOR         54
#define SQL_DYNAMIC_UPDATE_CURSOR         55
#define SQL_GRANT                         48
#define SQL_INSERT                        50
#define SQL_REVOKE                        59
#define SQL_SELECT                        41
#define SQL_SELECT_CURSOR                 85
#define SQL_SET_CATALOG                   66
#define SQL_SET_CONSTRAINT                68
#define SQL_SET_NAMES                     72
#define SQL_SET_SCHEMA                    74
#define SQL_SET_SESSION_AUTHORIZATION     76
#define SQL_SET_TIME_ZONE                 71
#define SQL_SET_TRANSACTION               75
#define SQL_UNKNOWN_STATEMENT              0
#define SQL_UPDATE_WHERE                  82

/*---------------------------------------------------------------------------*/
/* ... about data type codes (CLI)                                           */
/*---------------------------------------------------------------------------*/
#define SQL_CHAR                           1
#define SQL_C_CHAR                         1
#define SQL_TINYINT                        1
#define SQL_C_TINYINT                      1
#define SQL_NUMERIC                        2
#define SQL_C_NUMERIC                      2
#define SQL_DECIMAL                        3
#define SQL_C_DECIMAL                      3
#define SQL_INTEGER                        4
#define SQL_C_INTEGER                      4
#define SQL_C_LONG                         4
#define SQL_SMALLINT                       5
#define SQL_C_SHORT                        5
#define SQL_C_SMALLINT                     5
#define SQL_FLOAT                          6
#define SQL_C_FLOAT                        6
#define SQL_REAL                           7
#define SQL_C_REAL                         7
#define SQL_DOUBLE                         8
#define SQL_C_DOUBLE                       8
#define SQL_DATETIME                       9
#define SQL_C_DATETIME                     9
#define SQL_INTERVAL                      10
#define SQL_C_INTERVAL                    10
#define SQL_VARCHAR                       12
#define SQL_C_VARCHAR                     12
#define SQL_BIT                           14
#define SQL_C_BIT                         14
#define SQL_BIT_VARYING                   15
#define SQL_C_BIT_VARYING                 15
#define SQL_DBCHAR                        16
#define SQL_C_DBCHAR                      16
#define SQL_DATE                          17
#define SQL_C_DATE                        17
#define SQL_TIME                          18
#define SQL_C_TIME                        18
#define SQL_TIMESTAMP                     19
#define SQL_C_TIMESTAMP                   19

/*---------------------------------------------------------------------------*/
/* ... about data type codes (ODBC)                                          */
/*---------------------------------------------------------------------------*/
#define SQL_BINARY                        20
#define SQL_C_BINARY                      20
#define SQL_BLOB                          21
#define SQL_C_BLOB                        21
#define SQL_BLOB_LOCATOR                  22
#define SQL_C_BLOB_LOCATOR                22
#define SQL_CLOB                          23
#define SQL_C_CLOB                        23
#define SQL_CLOB_LOCATOR                  24
#define SQL_C_CLOB_LOCATOR                24
#define SQL_DBCLOB                        25
#define SQL_C_DBCLOB                      25
#define SQL_DBCLOB_LOCATOR                26
#define SQL_C_DBCLOB_LOCATOR              26
#define SQL_GRAPHIC                       27
#define SQL_C_GRAPHIC                     27
#define SQL_LONGVARCHAR                   28
#define SQL_C_LONGVARCHAR                 28
#define SQL_LONGVARBINARY                 29
#define SQL_C_LONGVARBINARY               29
#define SQL_LONGVARGRAPHIC                30
#define SQL_C_LONGVARGRAPHIC              30
#define SQL_VARBINARY                     31
#define SQL_C_VARBINARY                   31
#define SQL_VARGRAPHIC                    32
#define SQL_C_VARGRAPHIC                  32

/*---------------------------------------------------------------------------*/
/* ... about bindery conversion code                                         */
/*---------------------------------------------------------------------------*/
#define SQL_DEFAULT                       99
#define SQL_C_DEFAULT                     99

/*---------------------------------------------------------------------------*/
/* ... about date/time sub-codes                                             */
/*---------------------------------------------------------------------------*/
#define SQL_CODE_DATE                      1
#define SQL_CODE_TIME                      2
#define SQL_CODE_TIMESTAMP                 3
#define SQL_CODE_TIME_ZONE                 4
#define SQL_CODE_TIMESTAMP_ZONE            5

/*---------------------------------------------------------------------------*/
/* ... about intervals                                                       */
/*---------------------------------------------------------------------------*/
#define SQL_DAY                            1
#define SQL_DAY_TO_HOUR                    2
#define SQL_DAY_TO_MINUTE                  3
#define SQL_DAY_TO_SECOND                  4
#define SQL_HOUR                           5
#define SQL_HOUR_TO_MINUTE                 6
#define SQL_HOUR_TO_SECOND                 7
#define SQL_MINUTE                         8
#define SQL_MINUTE_TO_SECOND               9
#define SQL_MONTH                         10
#define SQL_SECOND                        11
#define SQL_YEAR                          12
#define SQL_YEAR_TO_MONTH                 13

/*---------------------------------------------------------------------------*/
/* ... about option values                                                   */
/*---------------------------------------------------------------------------*/
#define SQL_FALSE                      FALSE
#define SQL_TRUE                       TRUE

#define SQL_CLOSE            0                   /*--------------------------*/
#define SQL_DROP             1                   /* SQLFreeStmt              */
#define SQL_UNBIND           2                   /*--------------------------*/
#define SQL_RESET_PARAMS     3

#define SQL_NAMED            0
#define SQL_UNNAMED          1
#define SQL_DESC_ALLOC_AUTO  1
#define SQL_DESC_ALLOC_USER  2

#define SQL_AUTOCOMMIT       0
#define SQL_AUTOCOMMIT_ON    SQL_TRUE
#define SQL_AUTOCOMMIT_OFF   SQL_FALSE

#define SQL_COMMIT           SQL_TRUE
#define SQL_ROLLBACK         SQL_FALSE

/*---------------------------------------------------------------------------*/
/* ... about return codes                                                    */
/*---------------------------------------------------------------------------*/
#define SQL_SUCCESS                        0
#define SQL_SUCCESS_WITH_INFO              1
#define SQL_NEED_DATA                    100
#define SQL_NO_DATA                      100
#define SQL_NO_DATA_FOUND                100
#define SQL_ERROR                         -1
#define SQL_INVALID_HANDLE                -2
#define SQL_SUCCEEDED(rc)              (((rc)&(~1))==0)

/*---------------------------------------------------------------------------*/
/* function prototypes "CLI"                                                 */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLAllocHandle(
                             SQLSMALLINT         HandleType,
                             SQLINTEGER          InputHandle,
                             SQLINTEGER         *OutputHandle
                              );

SQLRETURN  SQLBindParam(
                             SQLHSTMT            StatementHandle,
                             SQLSMALLINT         ParamNumber,
                             SQLSMALLINT         BufferType,
                             SQLSMALLINT         ParamType,
                             SQLINTEGER          ParamLength,
                             SQLSMALLINT         Scale,
                             SQLPOINTER          Data,
                             SQLINTEGER         *DataLength
                       );

SQLRETURN  SQLCloseCursor(   SQLHSTMT            StatementHandle );

SQLRETURN  SQLCopyDesc(
                             SQLHDESC            SourceDescHandle,
                             SQLHDESC            TargetDescHandle
                      );

SQLRETURN  SQLEndTran(
                             SQLSMALLINT         HandleType,
                             SQLHENV             Handle,
                             SQLSMALLINT         CompletionType
                     );

SQLRETURN  SQLFreeHandle(
                             SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle
                        );

SQLRETURN  SQLGetCol(
                             SQLHSTMT            StatementHandle,
                             SQLSMALLINT         ColumnNumber,
                             SQLPOINTER          TargetValue,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength,
                             SQLINTEGER         *IndicatorValue
                    );

SQLRETURN  SQLGetConnectAttr(
                             SQLHDBC             ConnectionHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                            );

SQLRETURN  SQLGetDescField(
                             SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         FieldIdentifier,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                          );

SQLRETURN  SQLGetDescRec(
                             SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLCHAR            *Name,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength,
                             SQLSMALLINT        *Type,
                             SQLSMALLINT        *SubType,
                             SQLINTEGER         *Length,
                             SQLSMALLINT        *Precision,
                             SQLSMALLINT        *Scale,
                             SQLSMALLINT        *Nullable
                        );

SQLRETURN  SQLGetDiagField(
                             SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         DiagIdentifier,
                             SQLPOINTER          DiagInfo,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength
                          );

SQLRETURN  SQLGetDiagRec(
                             SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle,
                             SQLSMALLINT         RecordNumber,
                             SQLCHAR            *Sqlstate,
                             SQLINTEGER         *NativeError,
                             SQLCHAR            *MessageText,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength
                        );

SQLRETURN  SQLGetEnvAttr(
                             SQLHENV             EnvironmentHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                        );

SQLRETURN  SQLGetStmtAttr(
                             SQLHSTMT            StatementHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                         );

SQLRETURN  SQLLanguages(     SQLHSTMT            StatementHandle );

SQLRETURN  SQLReleaseEnv(    SQLHENV             EnvironmentHandle );

SQLRETURN  SQLServerInfo(
                             SQLHSTMT            StatementHandle,
                             SQLCHAR            *ServerAttribute,
                             SQLSMALLINT         AttributeLength
                        );

SQLRETURN  SQLSetDescField(
                             SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         FieldIdentifier,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength
                          );

SQLRETURN  SQLSetDescRec(
                             SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         Type,
                             SQLSMALLINT         SubType,
                             SQLINTEGER          Length,
                             SQLSMALLINT         Precision,
                             SQLSMALLINT         Scale,
                             SQLPOINTER          Data,
                             SQLINTEGER         *StringLength,
                             SQLSMALLINT *Indicator
                        );

SQLRETURN  SQLSetEnvAttr(
                             SQLHENV             EnvironmentHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          StringLength
                        );

SQLRETURN  SQLSetStmtAttr(
                             SQLHSTMT            StatementHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          StringLength
                         );

/*---------------------------------------------------------------------------*/
/* function prototypes "ODBC"                                                */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLAllocConnect(
                             LPENV               lpenv,
                             HDBC FAR           *phdbc
                               );

RETCODE SQL_API SQLAllocEnv( HENV FAR           *phenv );

RETCODE SQL_API SQLAllocStmt(
                             LPDBC               lpdbc,
                             HSTMT FAR          *phstmt
                           );

RETCODE SQL_API SQLBindCol(
                             LPSTMT              lpstmt,
                             UWORD               icol,
                             SWORD               fCType,
                             PTR                 rgbValue,
                             SDWORD              cbValueMax,
                             SDWORD FAR         *pcbValue
                           );

RETCODE SQL_API SQLBrowseConnect(
                             LPDBC               lpdbc,
                             UCHAR FAR          *szConnStrIn,
                             SWORD               cbConnStrIn,
                             UCHAR FAR          *szConnStrOut,
                             SWORD               cbConnStrOutMax,
                             SWORD FAR          *pcbConnStrOut
                           );

RETCODE SQL_API SQLCancel(   LPSTMT              lpstmt );

RETCODE SQL_API SQLColAttributes(
                             LPSTMT              lpstmt,
                             UWORD               icol,
                             UWORD               fDescType,
                             UCHAR FAR          *rgbDesc,
                             SWORD               cbDescMax,
                             SWORD FAR          *pcbDesc,
                             SDWORD FAR         *pfDesc
                           );

RETCODE SQL_API SQLColumnPrivileges(
                             HSTMT               hstmt,
                             UCHAR FAR          *szTableQualifier,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName,
                             UCHAR FAR          *szColumnName,
                             SWORD               cbColumnName
                           );

RETCODE SQL_API SQLColumns(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szTableQualifier,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName,
                             UCHAR FAR          *szColumnName,
                             SWORD               cbColumnName
                           );

RETCODE SQL_API SQLConnect(
                             LPDBC               lpdbc,
                             UCHAR FAR          *szDSN,
                             SWORD               cbDSN,
                             UCHAR FAR          *szUID,
                             SWORD               cbUID,
                             UCHAR FAR          *szAuthStr,
                             SWORD               cbAuthStr
                           );

RETCODE SQL_API SQLDescribeCol(
                             LPSTMT              lpstmt,
                             UWORD               icol,
                             UCHAR FAR          *szColName,
                             SWORD               cbColNameMax,
                             SWORD FAR          *pcbColName,
                             SWORD FAR          *pfSqlType,
                             UDWORD FAR         *pcbColDef,
                             SWORD FAR          *pibScale,
                             SWORD FAR          *pfNullable
                           );

RETCODE SQL_API SQLDescribeParam(
                             LPSTMT              lpstmt,
                             UWORD               ipar,
                             SWORD FAR          *pfSqlType,
                             UDWORD FAR         *pcbColDef,
                             SWORD FAR          *pibScale,
                             SWORD FAR          *pfNullable
                           );

RETCODE SQL_API SQLDisconnect( LPDBC             lpdbc );

RETCODE SQL_API SQLDriverConnect(
                             LPDBC               lpdbc,
                             HWND                hwnd,
                             UCHAR FAR          *szConnStrIn,
                             SWORD               cbConnStrIn,
                             UCHAR FAR          *szConnStrOut,
                             SWORD               cbConnStrOutMax,
                             SWORD FAR          *pcbConnStrOutMax,
                             UWORD               fDriverCompletion
                           );

RETCODE SQL_API SQLError(
                             LPENV               lpenv,
                             LPDBC               lpdbc,
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szSqlState,
                             SDWORD FAR         *pfNativeError,
                             UCHAR FAR          *szErrorMsg,
                             SWORD               cbErrorMsgMax,
                             SWORD FAR          *pcbErrorMsg
                           );

RETCODE SQL_API SQLExecDirect(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szSqlStr,
                             SDWORD              cbSqlStr
                           );

RETCODE SQL_API SQLExecute(  LPSTMT              lpstmt );

RETCODE SQL_API SQLExtendedFetch(
                             LPSTMT              lpstmt,
                             UWORD               fFetchType,
                             SDWORD              irow,
                             UDWORD FAR         *pcrow,
                             UWORD FAR          *rgfRowStatus
                           );

RETCODE SQL_API SQLFetch(    LPSTMT              lpstmt );

RETCODE SQL_API SQLFreeConnect( LPDBC            lpdbc );

RETCODE SQL_API SQLFreeEnv(  LPENV               lpenv );

RETCODE SQL_API SQLForeignKeys(
                             HSTMT               hstmt,
                             UCHAR FAR          *szPkTableQualifier,
                             SWORD               cbPkTableQualifier,
                             UCHAR FAR          *szPkTableOwner,
                             SWORD               cbPkTableOwner,
                             UCHAR FAR          *szPkTableName,
                             SWORD               cbPkTableName,
                             UCHAR FAR          *szFkTableQualifier,
                             SWORD               cbFkTableQualifier,
                             UCHAR FAR          *szFkTableOwner,
                             SWORD               cbFkTableOwner,
                             UCHAR FAR          *szFkTableName,
                             SWORD               cbFkTableName
                           );

RETCODE SQL_API SQLFreeStmt(
                             LPSTMT              lpstmt,
                             UWORD               fOption
                           );

RETCODE SQL_API SQLGetConnectOption(
                             LPDBC               lpdbc,
                             UWORD               fOption,
                             PTR                 pvParam
                           );

RETCODE SQL_API SQLGetCursorName(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szCursor,
                             SWORD               cbCursorMax,
                             SWORD FAR          *pcbCursor
                           );

RETCODE SQL_API SQLGetData(
                             LPSTMT              lpstmt,
                             UWORD               icol,
                             SWORD               fCType,
                             PTR                 rgbValue,
                             SDWORD              cbValueMax,
                             SDWORD FAR         *pcbValue
                           );

RETCODE SQL_API SQLGetInfo(
                             LPDBC               lpdbc,
                             UWORD               fInfoType,
                             PTR                 rgbInfoValue,
                             SWORD               cbInfoValueMax,
                             SWORD FAR          *pcbInfoValue
                           );

RETCODE SQL_API SQLGetStmtOption(
                             LPSTMT              lpstmt,
                             UWORD               fOption,
                             PTR                 pvParam
                           );

RETCODE SQL_API SQLGetTypeInfo(
                             LPSTMT              lpstmt,
                             SWORD               fSqlType
                           );

RETCODE SQL_API SQLMoreResults( LPSTMT           lpstmt );

RETCODE SQL_API SQLNativeSql(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szSqlStrIn,
                             SDWORD              cbSqlStrIn,
                             UCHAR FAR          *szSqlStr,
                             SDWORD              cbSqlStrMax,
                             SDWORD FAR         *pcbSqlStr
                           );

RETCODE SQL_API SQLNumParams(
                             LPSTMT              lpstmt,
                             SWORD FAR          *pcpar
                           );

RETCODE SQL_API SQLNumResultCols(
                             LPSTMT              lpstmt,
                             SDWORD FAR         *pccol
                           );

RETCODE SQL_API SQLParamData(
                             LPSTMT              lpstmt,
                             PTR FAR            *prbgValue
                           );

RETCODE SQL_API SQLParamOptions(
                             LPSTMT              lpstmt,
                             UDWORD              crow,
                             UDWORD FAR         *pirow
                           );

RETCODE SQL_API SQLPrepare(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szSqlStr,
                             SDWORD              cbSqlStr
                           );

RETCODE SQL_API SQLPrimaryKeys(
                             HSTMT               hstmt,
                             UCHAR FAR          *szTableQualifer,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName
                           );

RETCODE SQL_API SQLProcedureColumns(
                             HSTMT               hstmt,
                             UCHAR FAR          *szProcQualifier,
                             SWORD               cbProcQualifier,
                             UCHAR FAR          *szProcOwner,
                             SWORD               cbProcOwner,
                             UCHAR FAR          *szProcName,
                             SWORD               cbProcName,
                             UCHAR FAR          *szColumnName,
                             SWORD               cbColumnName
                           );

RETCODE SQL_API SQLProcedures(
                             HSTMT               hstmt,
                             UCHAR FAR          *szProcQualifier,
                             SWORD               cbProcQualifier,
                             UCHAR FAR          *szProcOwner,
                             SWORD               cbProcOwner,
                             UCHAR FAR          *szProcName,
                             SWORD               cbProcName
                           );

RETCODE SQL_API SQLPutData(
                             LPSTMT              lpstmt,
                             PTR                 rgbValue,
                             SDWORD              cbValue
                           );

RETCODE SQL_API SQLRowCount(
                             LPSTMT              lpstmt,
                             SDWORD FAR         *pcrow
                           );

RETCODE SQL_API SQLSetConnectOption(
                             LPDBC               lpdbc,
                             UWORD               fOption,
                             UDWORD              vParam
                           );

RETCODE SQL_API SQLSetCursorName(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szCursor,
                             SWORD               cbCursor
                           );

RETCODE SQL_API SQLSetParam(
                             LPSTMT              lpstmt,
                             UWORD               ipar,
                             SWORD               fCType,
                             SWORD               fSqlType,
                             UDWORD              cbColDef,
                             SWORD               ibScale,
                             PTR                 rgbValue,
                             SDWORD FAR         *pcbValue
                           );

RETCODE SQL_API SQLSetPos(
                             LPSTMT              lpstmt,
                             UWORD               irow,
                             BOOL                fRefresh,
                             BOOL                fLock
                           );

RETCODE SQL_API SQLSetScrollOptions(
                             LPSTMT              lpstmt,
                             UWORD               fConcurrency,
                             SDWORD              crowKeyset,
                             UWORD               crowRowset
                           );

RETCODE SQL_API SQLSetStmtOption(
                             LPSTMT              lpstmt,
                             UWORD               fOption,
                             UDWORD              vParam
                           );

RETCODE SQL_API SQLSpecialColumns(
                             HSTMT               hstmt,
                             UWORD               fColType,
                             UCHAR FAR          *szTableQualifer,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName,
                             UWORD               fScope,
                             UWORD               fNullable
                           );

RETCODE SQL_API SQLStatistics(
                             HSTMT               hstmt,
                             UCHAR FAR          *szTableQualifier,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName,
                             UWORD               fUnique,
                             UWORD               fAccuracy
                           );

RETCODE SQL_API SQLTablePrivileges(
                             HSTMT               hstmt,
                             UCHAR FAR          *szTableQualifier,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName
                           );

RETCODE SQL_API SQLTables(
                             LPSTMT              lpstmt,
                             UCHAR FAR          *szTableQualifier,
                             SWORD               cbTableQualifier,
                             UCHAR FAR          *szTableOwner,
                             SWORD               cbTableOwner,
                             UCHAR FAR          *szTableName,
                             SWORD               cbTableName,
                             UCHAR FAR          *szTableType,
                             SWORD               cbTableType
                           );

RETCODE SQL_API SQLTransact(
                             LPENV               lpenv,
                             LPDBC               lpdbc,
                             UWORD               fType
                           );

/*---------------------------------------------------------------------------*/
/* frame                                                                     */
/*---------------------------------------------------------------------------*/
#endif

/*===| end of file |=========================================================*/
