#ifndef __ZWINDOW_H
#define __ZWINDOW_H

#define  STRICT
#include <windows.h>
#pragma hdrstop
#include <stdlib.h>
#include <string.h>

#define CM_FILEEXIT	24338

LRESULT CALLBACK _export WndProc( HWND hWnd, UINT iMessage,
											WPARAM wParam, LPARAM lParam );

class Main
{
public:
  static HINSTANCE hInstance;
  static HINSTANCE hPrevInstance;
  static int nCmdShow;
  static int MessageLoop( void );
};

class Window
{
protected:
	 HWND hWnd;
public:
	 // Provide (read) access to the window's handle in case it is needed
	 // elsewhere.
	 HWND GetHandle( void ) { return hWnd; }

	 BOOL Show( int nCmdShow ) { return ShowWindow( hWnd, nCmdShow ); }
	 void Update( void ) { UpdateWindow( hWnd ); }
	 // Pure virtual function makes Window an abstract class.
	 virtual LRESULT WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam ) = 0;
};

class ZWindow : public Window
{
private:
	 static char szClassName[14];
	 HMENU hMenu;
	 HICON hIcon;

public:
	 // Register the class only AFTER WinMain assigns appropriate
	 // values to static members of Main and only if no previous
	 // instances of the program exist (a previous instance would
	 // have already performed the registration).
	 static void Register( void )
	 {
		  WNDCLASS wndclass;   // Structure used to register Windows class.

		  wndclass.style         = CS_HREDRAW | CS_VREDRAW;
		  wndclass.lpfnWndProc   = ::WndProc;
		  wndclass.cbClsExtra    = 0;
		  // Reserve extra bytes for each instance of the window;
		  // we will use these bytes to store a pointer to the C++
		  // (ZWindow) object corresponding to the window.
		  // the size of a 'this' pointer depends on the memory model.
		  wndclass.cbWndExtra    = sizeof( ZWindow * );
		  wndclass.hInstance     = Main::hInstance;
		  wndclass.hIcon         = LoadIcon( Main::hInstance, "whello" );
		  wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
		  wndclass.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
		  wndclass.lpszMenuName  = NULL;
		  wndclass.lpszClassName = szClassName;

		  if ( ! RegisterClass( &wndclass ) )
				exit( FALSE );
	 }

	 // Do not create unless previously registered.
	 ZWindow( void )
	 {
		  // Pass 'this' pointer in lpParam of CreateWindow().
		  hWnd = CreateWindow( szClassName,szClassName,
				WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
				0,CW_USEDEFAULT,0,NULL,NULL,Main::hInstance,
				(LPSTR) this );
		  if ( ! hWnd )
				exit( FALSE );
		  Show( Main::nCmdShow );
		  Update();
	 }
	 virtual LRESULT WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );
	 virtual BOOL SetMenu(char*);
	 void MBox(char* mess,char* title){MessageBox(hWnd ? hWnd : NULL,mess,title,MB_OK);}
	 void SetIcon(char*);
	 void SetTitle(char* x){SetWindowText(hWnd,x);}
};

#endif

