.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ping.8	6.2 (Berkeley) 5/23/86
.\"
.\".TH PING 8 "May 23, 1986"
.TH PING 8 "Nov 23, 1992"
.UC 6
.SH NAME
ping \- send ICMP ECHO_REQUEST packets to network hosts
.SH SYNOPSIS
.B X_PINGLOCATION_X/ping
[
.B \-r
] [
.B \-v
] [
.B \-o
]
.I host
[
.I packetsize
] [
.I count
]

.B X_PINGLOCATION_X/ping -c
[
.B \-r
] [
.B \-v
] [
.B \-o
]
.I host
[
.I packetsize
] [
.I count
] [
.I timeout
]

.B X_PINGLOCATION_X/ping -s
[
.B \-r
] [
.B \-o
]
.I host
[ [
.I packetsize
]
.I timeout
]
.SH DESCRIPTION
The DARPA Internet is a large and complex aggregation of
network hardware, connected together by gateways.
Tracking a single-point hardware or software failure
can often be difficult.
.I Ping
utilizes the
ICMP protocol's mandatory ECHO_REQUEST datagram to elicit an
ICMP ECHO_RESPONSE from a host or gateway.
ECHO_REQUEST datagrams (``pings'') have an IP and ICMP header,
followed by a \fBstruct timeval\fR, and then an arbitrary number
of ``pad'' bytes used to fill out the packet.
Default datagram length is 64 bytes, but this may be changed
using the command-line option.
Other options are:
.TP
.B \-c
Use cisco style packet sending; that is, spew packets as fast as
possible, but don't send packet N+1 until an reply or timeout has been
registered for packet N.
.TP
.B \-r
Bypass the normal routing tables and send directly to a host on an attached
network.
If the host is not on a directly-attached network,
an error is returned.
This option can be used to ping a local host through an interface
that has no route through it (e.g., after the interface was dropped by
.IR routed (8C)).
.TP
.B \-v
Verbose output.  ICMP packets other than ECHO RESPONSE that are received
are listed.
.TP
.B \-o
Insert "record route" IP option in outgoing packets, summarizing
routes taken when program exits.
.TP
.B \-s
Only check if the other end responds to ping packets and
report whether it is alive or not. This makes ping work
like /usr/etc/ping on Suns. No route information,
cisco style dots and bangs or anything will be printed
on screen except the report whether the other end
responded or not.
.PP
When using \fIping\fR for fault isolation,
it should first be run on the local
host, to verify that the local network interface is up and
running.
Then, hosts and gateways further and further away
should be ``pinged''.
\fIPing\fR sends one datagram per second, and
prints one line of output for every ECHO_RESPONSE returned.
No output is produced if there is no response.
If an optional
.I count
is given, only that number of requests is sent.
Round-trip times and packet loss statistics are computed.
When all responses have been received or the program times out (with a
.I count
specified),
or if the program is terminated with a SIGINT, a brief
summary is displayed.
.PP
This program is intended for use in network testing, measurement
and management.
It should be used primarily for manual fault isolation.
Because of the load it could impose on the network,
it is unwise to use
.I ping
during normal operations or from automated scripts.
.SH AUTHOR
Mike Muuss
.SH CO-CONSPIRATORS
Ron Natalie, David Paul Zimmerman
.SH SOME MINOR CHANGES
Jukka Ukkonen, Centre for Scientific Computing, Finland (1992)
.SH SEE ALSO
netstat(1),
ifconfig(8C)
